/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.service.impl.ContractsGrantsInvoiceCreateDocumentService;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAgency;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAwardAccount;
import org.kuali.kfs.integration.cg.ContractsAndGrantsFundManager;
import org.kuali.kfs.integration.cg.ContractsAndGrantsOrganization;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.batch.service.VerifyBillingFrequencyService;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsInvoiceDocumentErrorLog;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsBillingAwardVerificationService;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsInvoiceDocumentService;
import org.kuali.kfs.module.ar.fixture.ARAgencyMockFixture;
import org.kuali.kfs.module.ar.fixture.ARAwardAccountMockFixture;
import org.kuali.kfs.module.ar.fixture.ARAwardFundManagerMockFixture;
import org.kuali.kfs.module.ar.fixture.ARAwardMockFixture;
import org.kuali.kfs.module.ar.fixture.ARAwardOrganizationMockFixture;
import org.kuali.kfs.module.ar.service.impl.ContractsGrantsInvoiceCreateDocumentServiceImpl;
import org.kuali.kfs.sys.businessobject.SystemOptions;
import org.kuali.kfs.sys.document.service.FinancialSystemDocumentService;
import org.kuali.kfs.sys.service.OptionsService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class ValidateAwardsTest {
    private ContractsGrantsInvoiceCreateDocumentServiceImpl cut;
    @Mock
    private ContractsGrantsBillingAwardVerificationService cgbAwardVerificationSvcMock;
    @Mock
    private ContractsGrantsInvoiceDocumentService cgInvoiceDocSvcMock;
    @Mock
    private VerifyBillingFrequencyService verifyBillingFrequencySvcMock;
    @Mock
    private FinancialSystemDocumentService financialSystemDocSvcMock;
    @Mock
    private BusinessObjectService boServiceMock;
    @Mock
    private ConfigurationService configSvcMock;
    @Mock
    private OptionsService optionsSvcMock;
    @Mock
    private DateTimeService dateTimeSvcMock;
    private Set<String> pendingDocumentStatuses = new HashSet<String>(Arrays.asList("I", "S", "R", "E"));

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        this.cut = new ContractsGrantsInvoiceCreateDocumentServiceImpl();
        this.cut.setContractsGrantsBillingAwardVerificationService(this.cgbAwardVerificationSvcMock);
        this.cut.setContractsGrantsInvoiceDocumentService(this.cgInvoiceDocSvcMock);
        this.cut.setVerifyBillingFrequencyService(this.verifyBillingFrequencySvcMock);
        this.cut.setFinancialSystemDocumentService(this.financialSystemDocSvcMock);
        this.cut.setBusinessObjectService(this.boServiceMock);
        this.cut.setConfigurationService(this.configSvcMock);
        this.cut.setOptionsService(this.optionsSvcMock);
        this.cut.setDateTimeService(this.dateTimeSvcMock);
    }

    @Test
    public void validateManualAwards_OneValidAward() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwardMocks(ARAwardAccountMockFixture.AWD_ACCT_WITH_CCA_1);
        this.prepareOtherMocks();
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection validAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
        Assert.assertEquals((String)"contractsGrantsInvoiceDocumentErrorLogs should be empty.", (long)0L, (long)contractsGrantsInvoiceDocumentErrorLogs.size());
        Assert.assertEquals((String)"validAwards should contain one award.", (long)1L, (long)validAwards.size());
        Assert.assertTrue((String)"validAwards should contain our initial award.", (boolean)validAwards.contains(awards.get(0)));
    }

    @Test
    public void validateManualAwards_OneInvalidAward() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwardMocks(ARAwardAccountMockFixture.AWD_ACCT_WITH_CCA_1);
        this.expectError("error.cginvoice.award.excluded.from.invoicing");
        this.prepareOtherMocks();
        Mockito.when((Object)awards.get(0).isExcludedFromInvoicing()).thenReturn((Object)true);
        ArrayList<ContractsGrantsInvoiceDocumentErrorLog> contractsGrantsInvoiceDocumentErrorLogs = new ArrayList<ContractsGrantsInvoiceDocumentErrorLog>();
        Collection validAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
        Assert.assertEquals((String)"contractsGrantsInvoiceDocumentErrorLogs should contain one award.", (long)1L, (long)contractsGrantsInvoiceDocumentErrorLogs.size());
        Assert.assertEquals((String)"validAwards should be empty.", (long)0L, (long)validAwards.size());
        Assert.assertTrue((String)"contractsGrantsInvoiceDocumentErrorLogs should contain our initial award.", (boolean)this.errorLogContainsAward(contractsGrantsInvoiceDocumentErrorLogs, awards.get(0)));
    }

    @Test
    public void validateManualAwards_TwoValidAwards() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwardMocks(ARAwardAccountMockFixture.AWD_ACCT_WITH_CCA_1);
        List<ContractsAndGrantsBillingAward> awards2 = this.setupAwardMocks(ARAwardAccountMockFixture.AWD_ACCT_WITH_CCA_2);
        awards.addAll(awards2);
        this.prepareOtherMocks();
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection validAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
        Assert.assertEquals((String)"contractsGrantsInvoiceDocumentErrorLogs should be empty.", (long)0L, (long)contractsGrantsInvoiceDocumentErrorLogs.size());
        Assert.assertEquals((String)"validAwards should contain one award.", (long)2L, (long)validAwards.size());
        Assert.assertTrue((String)"validAwards should contain our first award.", (boolean)validAwards.contains(awards.get(0)));
        Assert.assertTrue((String)"validAwards should contain our second award.", (boolean)validAwards.contains(awards.get(1)));
    }

    @Test
    public void validateManualAwards_TwoInvalidAwards() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwardMocks(ARAwardAccountMockFixture.AWD_ACCT_WITH_CCA_1);
        Mockito.when((Object)awards.get(0).isExcludedFromInvoicing()).thenReturn((Object)true);
        List<ContractsAndGrantsBillingAward> awards2 = this.setupAwardMocks(ARAwardAccountMockFixture.AWD_ACCT_WITH_CCA_2);
        Mockito.when((Object)awards2.get(0).isExcludedFromInvoicing()).thenReturn((Object)true);
        awards.addAll(awards2);
        this.expectError("error.cginvoice.award.excluded.from.invoicing");
        this.expectError("error.cginvoice.award.excluded.from.invoicing");
        this.prepareOtherMocks();
        ArrayList<ContractsGrantsInvoiceDocumentErrorLog> contractsGrantsInvoiceDocumentErrorLogs = new ArrayList<ContractsGrantsInvoiceDocumentErrorLog>();
        Collection validAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
        Assert.assertEquals((String)"contractsGrantsInvoiceDocumentErrorLogs should contain two awards.", (long)2L, (long)contractsGrantsInvoiceDocumentErrorLogs.size());
        Assert.assertEquals((String)"validAwards should be empty.", (long)0L, (long)validAwards.size());
        Assert.assertTrue((String)"contractsGrantsInvoiceDocumentErrorLogs should contain our first award.", (boolean)this.errorLogContainsAward(contractsGrantsInvoiceDocumentErrorLogs, awards.get(0)));
        Assert.assertTrue((String)"contractsGrantsInvoiceDocumentErrorLogs should contain our second award.", (boolean)this.errorLogContainsAward(contractsGrantsInvoiceDocumentErrorLogs, awards.get(1)));
    }

    @Test
    public void validateManualAwards_OneValidOneInvalidAwards() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwardMocks(ARAwardAccountMockFixture.AWD_ACCT_WITH_CCA_1);
        List<ContractsAndGrantsBillingAward> awards2 = this.setupAwardMocks(ARAwardAccountMockFixture.AWD_ACCT_WITH_CCA_2);
        Mockito.when((Object)awards2.get(0).isExcludedFromInvoicing()).thenReturn((Object)true);
        awards.addAll(awards2);
        this.expectError("error.cginvoice.award.excluded.from.invoicing");
        this.prepareOtherMocks();
        ArrayList<ContractsGrantsInvoiceDocumentErrorLog> contractsGrantsInvoiceDocumentErrorLogs = new ArrayList<ContractsGrantsInvoiceDocumentErrorLog>();
        Collection validAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
        Assert.assertEquals((String)"contractsGrantsInvoiceDocumentErrorLogs should contain one award.", (long)1L, (long)contractsGrantsInvoiceDocumentErrorLogs.size());
        Assert.assertEquals((String)"validAwards should contain one award.", (long)1L, (long)validAwards.size());
        Assert.assertTrue((String)"validAwards should contain our first award.", (boolean)validAwards.contains(awards.get(0)));
        Assert.assertTrue((String)"contractsGrantsInvoiceDocumentErrorLogs should contain our second award.", (boolean)this.errorLogContainsAward(contractsGrantsInvoiceDocumentErrorLogs, awards.get(1)));
    }

    @Test
    public void validateBatchAwards_OneValidAward() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwardMocks(ARAwardAccountMockFixture.AWD_ACCT_WITH_CCA_1);
        this.prepareOtherMocks();
        Collection validAwards = this.cut.validateAwards(awards, null, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.BATCH.getCode());
        Assert.assertEquals((String)"validAwards should contain one award.", (long)1L, (long)validAwards.size());
        Assert.assertTrue((String)"validAwards should contain our initial award.", (boolean)validAwards.contains(awards.get(0)));
    }

    @Test
    public void validateBatchAwards_OneInvalidAward() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwardMocks(ARAwardAccountMockFixture.AWD_ACCT_WITH_CCA_1);
        Mockito.when((Object)awards.get(0).isExcludedFromInvoicing()).thenReturn((Object)true);
        this.expectError("error.cginvoice.award.excluded.from.invoicing");
        this.prepareOtherMocks();
        Collection validAwards = this.cut.validateAwards(awards, null, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.BATCH.getCode());
        Assert.assertEquals((String)"validAwards should be empty.", (long)0L, (long)validAwards.size());
    }

    @Test
    public void validateBatchAwards_TwoValidAwards() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwardMocks(ARAwardAccountMockFixture.AWD_ACCT_WITH_CCA_1);
        List<ContractsAndGrantsBillingAward> awards2 = this.setupAwardMocks(ARAwardAccountMockFixture.AWD_ACCT_WITH_CCA_2);
        awards.addAll(awards2);
        this.prepareOtherMocks();
        Collection validAwards = this.cut.validateAwards(awards, null, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.BATCH.getCode());
        Assert.assertEquals((String)"validAwards should contain one award.", (long)2L, (long)validAwards.size());
        Assert.assertTrue((String)"validAwards should contain our first award.", (boolean)validAwards.contains(awards.get(0)));
        Assert.assertTrue((String)"validAwards should contain our second award.", (boolean)validAwards.contains(awards.get(1)));
    }

    @Test
    public void validateBatchAwards_TwoInvalidAwards() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwardMocks(ARAwardAccountMockFixture.AWD_ACCT_WITH_CCA_1);
        Mockito.when((Object)awards.get(0).isExcludedFromInvoicing()).thenReturn((Object)true);
        List<ContractsAndGrantsBillingAward> awards2 = this.setupAwardMocks(ARAwardAccountMockFixture.AWD_ACCT_WITH_CCA_2);
        Mockito.when((Object)awards2.get(0).isExcludedFromInvoicing()).thenReturn((Object)true);
        awards.addAll(awards2);
        this.expectError("error.cginvoice.award.excluded.from.invoicing");
        this.expectError("error.cginvoice.award.excluded.from.invoicing");
        this.prepareOtherMocks();
        Collection validAwards = this.cut.validateAwards(awards, null, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.BATCH.getCode());
        Assert.assertEquals((String)"validAwards should be empty.", (long)0L, (long)validAwards.size());
    }

    @Test
    public void validateBatchAwards_OneValidOneInvalidAwards() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwardMocks(ARAwardAccountMockFixture.AWD_ACCT_WITH_CCA_1);
        List<ContractsAndGrantsBillingAward> awards2 = this.setupAwardMocks(ARAwardAccountMockFixture.AWD_ACCT_WITH_CCA_2);
        Mockito.when((Object)awards2.get(0).isExcludedFromInvoicing()).thenReturn((Object)true);
        awards.addAll(awards2);
        this.expectError("error.cginvoice.award.excluded.from.invoicing");
        this.prepareOtherMocks();
        Collection validAwards = this.cut.validateAwards(awards, null, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.BATCH.getCode());
        Assert.assertEquals((String)"validAwards should contain one award.", (long)1L, (long)validAwards.size());
        Assert.assertTrue((String)"validAwards should contain our first award.", (boolean)validAwards.contains(awards.get(0)));
    }

    @Test
    public void validate_DuplicateAccount() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwardMocks(ARAwardAccountMockFixture.AWD_ACCT_WITH_CCA_1);
        List<ContractsAndGrantsBillingAward> awards2 = this.setupAwardMocks(ARAwardAccountMockFixture.AWD_ACCT_WITH_CCA_1);
        awards.addAll(awards2);
        this.expectError("error.cginvoice.account.on.multiple.awards");
        this.expectError("error.cginvoice.account.on.multiple.awards");
        this.prepareOtherMocks();
        Collection validAwards = this.cut.validateAwards(awards, null, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.BATCH.getCode());
        Assert.assertEquals((String)"validAwards should be empty.", (long)0L, (long)validAwards.size());
    }

    private List<ContractsAndGrantsBillingAward> setupAwardMocks(ARAwardAccountMockFixture awardAccountFixture) {
        ArrayList<ContractsAndGrantsBillingAward> awards = new ArrayList<ContractsAndGrantsBillingAward>();
        ContractsAndGrantsBillingAward awardMock = ARAwardMockFixture.CG_AWARD_MONTHLY_BILLED_DATE_VALID.createAwardMock();
        ContractsAndGrantsBillingAgency agencyMock = ARAgencyMockFixture.CG_AGENCY1.createAgencyMock();
        Mockito.when((Object)awardMock.getAgency()).thenReturn((Object)agencyMock);
        String agencyNumber = agencyMock.getAgencyNumber();
        Mockito.when((Object)awardMock.getAgencyNumber()).thenReturn((Object)agencyNumber);
        ContractsAndGrantsBillingAwardAccount awardAccountMock = awardAccountFixture.createAwardAccountMock();
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks.add(awardAccountMock);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(awardAccountMocks);
        ContractsAndGrantsOrganization awardOrganizationMock = ARAwardOrganizationMockFixture.AWD_ORG1.createAwardOrganizationMock();
        Mockito.when((Object)awardMock.getPrimaryAwardOrganization()).thenReturn((Object)awardOrganizationMock);
        ContractsAndGrantsFundManager awardFundManagerMock = ARAwardFundManagerMockFixture.AWD_FND_MGR1.createAwardFundManagerMock();
        Mockito.when((Object)awardMock.getAwardPrimaryFundManager()).thenReturn((Object)awardFundManagerMock);
        Mockito.when((Object)awardMock.getAwardTotalAmount()).thenReturn((Object)KualiDecimal.ZERO);
        this.prepareMocks(awardMock);
        awards.add(awardMock);
        return awards;
    }

    private void prepareMocks(ContractsAndGrantsBillingAward award) {
        Mockito.when((Object)this.cgbAwardVerificationSvcMock.isValueOfBillingFrequencyValid(award)).thenReturn((Object)true);
        Mockito.when((Object)this.verifyBillingFrequencySvcMock.validateBillingFrequency(award)).thenReturn((Object)true);
        Mockito.when((Object)this.cgbAwardVerificationSvcMock.isAwardFinalInvoiceAlreadyBuilt(award)).thenReturn((Object)false);
        Mockito.when((Object)this.cgbAwardVerificationSvcMock.owningAgencyHasCustomerRecord(award)).thenReturn((Object)true);
        Mockito.when((Object)this.cgInvoiceDocSvcMock.checkAwardContractControlAccounts(award)).thenReturn(null);
        Mockito.when((Object)this.cgbAwardVerificationSvcMock.isChartAndOrgSetupForInvoicing(award)).thenReturn((Object)true);
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("invoiceGeneralDetail.proposalNumber", award.getProposalNumber());
        fieldValues.put("documentHeader.workflowDocumentStatusCode", this.pendingDocumentStatuses);
        Mockito.when((Object)this.boServiceMock.findMatching(ContractsGrantsInvoiceDocument.class, fieldValues)).thenReturn(new ArrayList());
        for (ContractsAndGrantsBillingAwardAccount awardAccount : award.getActiveAwardAccounts()) {
            Mockito.when((Object)this.verifyBillingFrequencySvcMock.validateBillingFrequency(award, awardAccount)).thenReturn((Object)true);
        }
    }

    private void expectError(String errorKey) {
        Mockito.when((Object)this.configSvcMock.getPropertyValueAsString(errorKey)).thenReturn((Object)"Error");
        Mockito.when((Object)this.cgInvoiceDocSvcMock.getBudgetAndActualsForAwardAccount((ContractsAndGrantsBillingAwardAccount)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)KualiDecimal.ZERO);
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentTimestamp()).thenReturn(null);
        Mockito.when((Object)this.boServiceMock.save((PersistableBusinessObject)ArgumentMatchers.isA(ContractsGrantsInvoiceDocumentErrorLog.class))).thenReturn(null);
    }

    private void prepareOtherMocks() {
        Mockito.when((Object)this.optionsSvcMock.getCurrentYearOptions()).thenReturn((Object)new SystemOptions());
        Mockito.when((Object)this.financialSystemDocSvcMock.getPendingDocumentStatuses()).thenReturn(this.pendingDocumentStatuses);
    }

    private boolean errorLogContainsAward(Collection<ContractsGrantsInvoiceDocumentErrorLog> contractsGrantsInvoiceDocumentErrorLogs, ContractsAndGrantsBillingAward award) {
        for (ContractsGrantsInvoiceDocumentErrorLog contractsGrantsInvoiceDocumentErrorLog : contractsGrantsInvoiceDocumentErrorLogs) {
            if (!contractsGrantsInvoiceDocumentErrorLog.getProposalNumber().equals(award.getProposalNumber())) continue;
            return true;
        }
        return false;
    }
}

