/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.service.impl;

import java.util.Random;
import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.module.ar.businessobject.CustomerAddress;
import org.kuali.kfs.module.ar.service.impl.CustomerDocumentServiceImpl;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class CustomerDocumentServiceImplTest {
    private static final int CUSTOMER_ADDRESS_NAME_LENGTH = 40;
    protected CustomerDocumentServiceImpl cut;
    @Mock
    private DataDictionaryService dataDictionarySvcMock;
    private char[] characters = null;
    private Random rand;

    @Before
    public void setUp() {
        int i;
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeMaxLength(CustomerAddress.class, "customerAddressName")).thenReturn((Object)40);
        this.cut = new CustomerDocumentServiceImpl();
        this.cut.setDataDictionaryService(this.dataDictionarySvcMock);
        this.characters = new char[52];
        int count = 0;
        for (i = 65; i <= 90; i = (int)((char)(i + 1))) {
            this.characters[count] = i;
            ++count;
        }
        for (i = 97; i <= 122; i = (int)((char)(i + 1))) {
            this.characters[count] = i;
            ++count;
        }
        this.rand = new Random();
    }

    @Test
    public void truncateField() {
        String customerAddressNameShort = this.randomString(37);
        String customerAddressNameLong = this.randomString(47);
        String customerAddressNameBabyBear = this.randomString(40);
        String customerAddressNameShortTruncated = this.cut.truncateField(CustomerAddress.class, "customerAddressName", customerAddressNameShort);
        String customerAddressNameLongTruncated = this.cut.truncateField(CustomerAddress.class, "customerAddressName", customerAddressNameLong);
        String customerAddressNameBabyBearTruncated = this.cut.truncateField(CustomerAddress.class, "customerAddressName", customerAddressNameBabyBear);
        Assert.assertEquals((String)"Customer Address Name Short should have the same length as truncated version", (long)customerAddressNameShort.length(), (long)customerAddressNameShortTruncated.length());
        Assert.assertEquals((String)"Customer Address Name Short should be the same String as the truncated version", (Object)customerAddressNameShort, (Object)customerAddressNameShortTruncated);
        Assert.assertEquals((String)"Customer Address Name Long should have the max length of the customer address name field", (long)40L, (long)customerAddressNameLongTruncated.length());
        TestCase.assertTrue((String)"Customer Address Name Long should start with the truncated version", (boolean)customerAddressNameLong.startsWith(customerAddressNameLongTruncated));
        Assert.assertEquals((String)"Customer Address Name Baby Bear should have the same length as the truncated version", (long)customerAddressNameBabyBear.length(), (long)customerAddressNameBabyBearTruncated.length());
        Assert.assertEquals((String)"Customer Address Name Baby Bear should have the same length as the customer address name field", (long)40L, (long)customerAddressNameBabyBearTruncated.length());
        Assert.assertEquals((String)"Customer Address Name Baby Bear should be the exact same string as the truncated version", (Object)customerAddressNameBabyBear, (Object)customerAddressNameBabyBearTruncated);
    }

    private String randomString(int size) {
        StringBuilder s = new StringBuilder();
        for (int count = 0; count < size; ++count) {
            int idx = this.rand.nextInt(this.characters.length);
            s.append(this.characters[idx]);
        }
        return s.toString();
    }
}

