/**
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2019 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.businessobject;

import org.kuali.kfs.integration.ar.AccountsReceivableCustomerAddressType;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.rice.core.api.mo.common.active.MutableInactivatable;

public class CustomerAddressType extends PersistableBusinessObjectBase implements MutableInactivatable,
        AccountsReceivableCustomerAddressType {

    private String customerAddressTypeCode;
    private String customerAddressTypeDescription;
    private boolean active;

    @Override
    public String getCustomerAddressTypeCode() {
        return customerAddressTypeCode;
    }

    @Override
    public void setCustomerAddressTypeCode(String customerAddressTypeCode) {
        this.customerAddressTypeCode = customerAddressTypeCode;
    }

    @Override
    public String getCustomerAddressTypeDescription() {
        return customerAddressTypeDescription;
    }

    @Override
    public void setCustomerAddressTypeDescription(String customerAddressTypeDescription) {
        this.customerAddressTypeDescription = customerAddressTypeDescription;
    }

    @Override
    public boolean isActive() {
        return active;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

}
