/**
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2019 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.businessobject;

import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.Chart;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.sys.ObjectUtil;
import org.kuali.rice.core.api.util.type.KualiDecimal;

import java.util.Arrays;

/**
 * This class represents a invoice detail on the customer invoice document.
 */
public class InvoiceDetailAccountObjectCode extends PersistableBusinessObjectBase {

    private String documentNumber;
    private String proposalNumber;
    private String accountNumber;
    private String chartOfAccountsCode;
    private String financialObjectCode;
    private String categoryCode;
    private KualiDecimal currentExpenditures = KualiDecimal.ZERO;

    private KualiDecimal cumulativeExpenditures = KualiDecimal.ZERO;

    private KualiDecimal totalBilled = KualiDecimal.ZERO;

    private Account account;
    private Chart chartOfAccounts;

    public String getDocumentNumber() {
        return documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public String getProposalNumber() {
        return proposalNumber;
    }

    public void setProposalNumber(String proposalNumber) {
        this.proposalNumber = proposalNumber;
    }

    public String getAccountNumber() {
        return accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public String getChartOfAccountsCode() {
        return chartOfAccountsCode;
    }

    public void setChartOfAccountsCode(String chartOfAccountsCode) {
        this.chartOfAccountsCode = chartOfAccountsCode;
    }

    public String getFinancialObjectCode() {
        return financialObjectCode;
    }

    public void setFinancialObjectCode(String financialObjectCode) {
        this.financialObjectCode = financialObjectCode;
    }

    public String getCategoryCode() {
        return categoryCode;
    }

    public void setCategoryCode(String categoryCode) {
        this.categoryCode = categoryCode;
    }

    public KualiDecimal getCurrentExpenditures() {
        return currentExpenditures;
    }

    public void setCurrentExpenditures(KualiDecimal currentExpenditures) {
        this.currentExpenditures = currentExpenditures;
    }

    public KualiDecimal getCumulativeExpenditures() {
        return cumulativeExpenditures;
    }

    public void setCumulativeExpenditures(KualiDecimal cumulativeExpenditures) {
        this.cumulativeExpenditures = cumulativeExpenditures;
    }

    public KualiDecimal getTotalBilled() {
        return totalBilled;
    }

    public void setTotalBilled(KualiDecimal totalBilled) {
        this.totalBilled = totalBilled;
    }

    public Account getAccount() {
        return account;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public Chart getChartOfAccounts() {
        return chartOfAccounts;
    }

    public void setChartOfAccounts(Chart chartOfAccounts) {
        this.chartOfAccounts = chartOfAccounts;
    }

    /**
     * Negates current expenditures and sets document number to null.
     */
    public void correctInvoiceDetailAccountObjectCodeExpenditureAmount() {
        this.setCurrentExpenditures(getCurrentExpenditures().negated());
        this.setDocumentNumber(null);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            if (this.getClass().equals(obj.getClass())) {
                InvoiceDetailAccountObjectCode other = (InvoiceDetailAccountObjectCode) obj;
                if (StringUtils.equalsIgnoreCase(this.documentNumber, other.documentNumber)) {
                    if (this.proposalNumber.equals(other.proposalNumber)) {
                        if (StringUtils.equalsIgnoreCase(this.accountNumber, other.accountNumber)) {
                            if (StringUtils.equalsIgnoreCase(this.chartOfAccountsCode, other.chartOfAccountsCode)) {
                                if (StringUtils.equalsIgnoreCase(this.financialObjectCode, other.financialObjectCode)) {
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        return ObjectUtil.generateHashCode(this,
                Arrays.asList("documentNumber", "proposalNumber", "accountNumber", "chartOfAccountsCode",
                        "financialObjectCode"));
    }

}
