/**
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2019 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.businessobject.options;

import org.kuali.kfs.kns.util.KNSGlobalVariables;
import org.kuali.kfs.kns.web.struts.form.KualiForm;
import org.kuali.kfs.krad.keyvalues.KeyValuesBase;
import org.kuali.kfs.krad.service.KeyValuesService;
import org.kuali.kfs.module.ar.businessobject.InvoiceTemplate;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsInvoiceDocumentService;
import org.kuali.kfs.module.ar.document.web.struts.ContractsGrantsInvoiceDocumentForm;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;

import java.util.ArrayList;
import java.util.List;

public class InvoiceTemplateValuesFinder extends KeyValuesBase {

    private ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentService;
    private KeyValuesService keyValuesService;

    @Override
    public List<KeyValue> getKeyValues() {
        List<KeyValue> keyValues = new ArrayList<>();

        List<InvoiceTemplate> boList = (List<InvoiceTemplate>) getKeyValuesService().findAll(InvoiceTemplate.class);
        for (InvoiceTemplate element : boList) {
            if (element.isActive()) {
                if (!element.isRestrictUseByChartOrg()) {
                    keyValues.add(new ConcreteKeyValue(element.getInvoiceTemplateCode(),
                            element.getInvoiceTemplateDescription()));
                } else {
                    ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument = null;
                    KualiForm kualiForm = KNSGlobalVariables.getKualiForm();
                    if (kualiForm instanceof ContractsGrantsInvoiceDocumentForm) {
                        contractsGrantsInvoiceDocument = ((ContractsGrantsInvoiceDocumentForm) kualiForm)
                                .getContractsGrantsInvoiceDocument();
                    }
                    if (getContractsGrantsInvoiceDocumentService()
                            .isTemplateValidForContractsGrantsInvoiceDocument(element, contractsGrantsInvoiceDocument)) {
                        keyValues.add(new ConcreteKeyValue(element.getInvoiceTemplateCode(),
                                element.getInvoiceTemplateDescription()));
                    }
                }
            }
        }
        return keyValues;
    }

    public ContractsGrantsInvoiceDocumentService getContractsGrantsInvoiceDocumentService() {
        if (contractsGrantsInvoiceDocumentService == null) {
            contractsGrantsInvoiceDocumentService = SpringContext.getBean(ContractsGrantsInvoiceDocumentService.class);
        }
        return contractsGrantsInvoiceDocumentService;
    }

    public void setContractsGrantsInvoiceDocumentService(
            ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentService) {
        this.contractsGrantsInvoiceDocumentService = contractsGrantsInvoiceDocumentService;
    }

    public KeyValuesService getKeyValuesService() {
        // This values finder is referenced in a JSP tag, so injection doesn't work. However, injection does work
        // for the child of this values finder so it is wired up that way in the spring config file. Hopefully, the tag
        // can get refactored at some point and this SpringContext call can be eliminated.
        if (keyValuesService == null) {
            keyValuesService = SpringContext.getBean(KeyValuesService.class);
        }
        return keyValuesService;
    }

    public void setKeyValuesService(KeyValuesService keyValuesService) {
        this.keyValuesService = keyValuesService;
    }

}
