/**
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2019 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.service;

import org.kuali.kfs.module.ar.businessobject.Bill;
import org.kuali.kfs.module.ar.businessobject.CustomerAddress;
import org.kuali.kfs.module.ar.businessobject.Milestone;
import org.kuali.rice.core.api.util.type.KualiDecimal;

import java.util.List;
import java.util.Map;


/**
 * Defines utility methods used by CGB.
 */
public interface ContractsGrantsBillingUtilityService {

    /**
     * @param amount
     * @return a proper String Value. Also returns proper value for currency (USD)
     */
    String formatForCurrency(KualiDecimal amount);

    /**
     * @param address
     * @return a full address string from a CustomerAddress
     */
    String buildFullAddress(CustomerAddress address);

    /**
     * Places a value into a Map, but if that value is null, it places an empty String into the Map instead
     *
     * @param map   the Map to place the key into
     * @param key   the key
     * @param value the value
     */
    void putValueOrEmptyString(Map<String, String> map, String key, String value);

    /**
     * Retrieves all active bills associated with the given award and account.
     *
     * @param proposalNumber the proposal number used to search for active bills
     * @param chartOfAccountsCode the chart of accounts code used to search for active bills
     * @param accountNumber the account number used to search for active bills
     * @return a List of active bills, or an empty List if naught could be found
     */
    List<Bill> getActiveBillsForAwardAccount(String proposalNumber, String chartOfAccountsCode,
            String accountNumber);

    /**
     * Retrieves all active milestones associated with the given award and account.
     *
     * @param proposalNumber the proposal number to retrieve milestones for
     * @param chartOfAccountsCode
     * @param accountNumber
     * @return a List of active milestones, or an empty List if BusinessObjectService couldn't turn any up
     */
    List<Milestone> getActiveMilestonesForProposalNumber(String proposalNumber, String chartOfAccountsCode,
            String accountNumber);

}
