/**
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2019 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.businessobject;

import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.integration.ar.AccountsReceivableCustomer;
import org.kuali.kfs.integration.ar.AccountsReceivableCustomerAddress;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.module.ar.document.service.CustomerAddressService;
import org.kuali.kfs.module.ar.document.service.CustomerService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.mo.common.active.MutableInactivatable;
import org.kuali.rice.core.api.util.type.KualiDecimal;

import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

public class Customer extends PersistableBusinessObjectBase implements MutableInactivatable, AccountsReceivableCustomer {

    private String customerNumber;
    private String customerName;
    private String customerParentCompanyNumber;
    private String customerTypeCode;
    private String customerTypeDescription;
    private Date customerAddressChangeDate;
    private Date customerRecordAddDate;
    private Date customerLastActivityDate;
    private String customerTaxTypeCode;
    private String customerTaxNbr;
    private boolean active;
    private String customerPhoneNumber;
    private String customer800PhoneNumber;
    private String customerContactName;
    private String customerContactPhoneNumber;
    private String customerFaxNumber;
    private Date customerBirthDate;
    private boolean customerTaxExemptIndicator;
    private KualiDecimal customerCreditLimitAmount;
    private String customerCreditApprovedByName;
    private String customerEmailAddress;

    private Customer customerParentCompany;
    private CustomerType customerType;
    private List boNotes;

    private List<CustomerAddress> customerAddresses;

    private String bankruptcyType;
    private Date bankruptcyDate;
    private Date bankruptcyReviewDate;
    private boolean stopWorkIndicator;
    private String stopWorkReason;

    // Invoice Types link

    private String customerInvoiceTemplateCode;
    private InvoiceTemplate customerInvoiceTemplate;

    public Customer() {
        customerAddresses = new ArrayList<>();
    }

    @Override
    public String getCustomerNumber() {
        return customerNumber;
    }

    @Override
    public void setCustomerNumber(String customerNumber) {
        this.customerNumber = customerNumber;
    }

    @Override
    public String getCustomerName() {
        return customerName;
    }

    @Override
    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    @Override
    public String getCustomerParentCompanyNumber() {
        return customerParentCompanyNumber;
    }

    @Override
    public void setCustomerParentCompanyNumber(String customerParentCompanyNumber) {
        this.customerParentCompanyNumber = customerParentCompanyNumber;
    }

    @Override
    public String getCustomerTypeCode() {
        return customerTypeCode;
    }

    @Override
    public void setCustomerTypeCode(String customerTypeCode) {
        this.customerTypeCode = customerTypeCode;
    }

    @Override
    public String getCustomerTypeDescription() {
        return customerTypeDescription;
    }

    public void setCustomerTypeDescription(String customerTypeDescription) {
        this.customerTypeDescription = customerTypeDescription;
    }

    @Override
    public Date getCustomerAddressChangeDate() {
        return customerAddressChangeDate;
    }

    @Override
    public void setCustomerAddressChangeDate(Date customerAddressChangeDate) {
        this.customerAddressChangeDate = customerAddressChangeDate;
    }

    @Override
    public Date getCustomerRecordAddDate() {
        return customerRecordAddDate;
    }

    @Override
    public void setCustomerRecordAddDate(Date customerRecordAddDate) {
        this.customerRecordAddDate = customerRecordAddDate;
    }

    @Override
    public Date getCustomerLastActivityDate() {
        return customerLastActivityDate;
    }

    @Override
    public void setCustomerLastActivityDate(Date customerLastActivityDate) {
        this.customerLastActivityDate = customerLastActivityDate;
    }

    @Override
    public boolean isActive() {
        return active;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public String getCustomerPhoneNumber() {
        return customerPhoneNumber;
    }

    @Override
    public void setCustomerPhoneNumber(String customerPhoneNumber) {
        this.customerPhoneNumber = customerPhoneNumber;
    }

    @Override
    public String getCustomer800PhoneNumber() {
        return customer800PhoneNumber;
    }

    public void setCustomer800PhoneNumber(String customer800PhoneNumber) {
        this.customer800PhoneNumber = customer800PhoneNumber;
    }

    @Override
    public String getCustomerContactName() {
        return customerContactName;
    }

    public void setCustomerContactName(String customerContactName) {
        this.customerContactName = customerContactName;
    }

    @Override
    public String getCustomerContactPhoneNumber() {
        return customerContactPhoneNumber;
    }

    public void setCustomerContactPhoneNumber(String customerContactPhoneNumber) {
        this.customerContactPhoneNumber = customerContactPhoneNumber;
    }

    @Override
    public String getCustomerFaxNumber() {
        return customerFaxNumber;
    }

    public void setCustomerFaxNumber(String customerFaxNumber) {
        this.customerFaxNumber = customerFaxNumber;
    }

    @Override
    public Date getCustomerBirthDate() {
        return customerBirthDate;
    }

    @Override
    public void setCustomerBirthDate(Date customerBirthDate) {
        this.customerBirthDate = customerBirthDate;
    }

    @Override
    public KualiDecimal getCustomerCreditLimitAmount() {
        return customerCreditLimitAmount;
    }

    public void setCustomerCreditLimitAmount(KualiDecimal customerCreditLimitAmount) {
        this.customerCreditLimitAmount = customerCreditLimitAmount;
    }

    @Override
    public String getCustomerCreditApprovedByName() {
        return customerCreditApprovedByName;
    }

    public void setCustomerCreditApprovedByName(String customerCreditApprovedByName) {
        this.customerCreditApprovedByName = customerCreditApprovedByName;
    }

    @Override
    public String getCustomerEmailAddress() {
        return customerEmailAddress;
    }

    @Override
    public void setCustomerEmailAddress(String customerEmailAddress) {
        this.customerEmailAddress = customerEmailAddress;
    }

    public Customer getCustomerParentCompany() {
        return customerParentCompany;
    }

    @Deprecated
    public void setCustomerParentCompany(Customer customerParentCompany) {
        this.customerParentCompany = customerParentCompany;
    }

    public CustomerType getCustomerType() {
        return customerType;
    }

    @Deprecated
    public void setCustomerType(CustomerType customerType) {
        this.customerType = customerType;
    }

    @Override
    public boolean isCustomerTaxExemptIndicator() {
        return customerTaxExemptIndicator;
    }

    public void setCustomerTaxExemptIndicator(boolean customerTaxExemptIndicator) {
        this.customerTaxExemptIndicator = customerTaxExemptIndicator;
    }

    public List<CustomerAddress> getCustomerAddresses() {
        return customerAddresses;
    }

    public void setCustomerAddresses(List<CustomerAddress> customerAddresses) {
        this.customerAddresses = customerAddresses;
    }

    @Override
    public String getCustomerTaxNbr() {
        return customerTaxNbr;
    }

    public void setCustomerTaxNbr(String customerTaxNbr) {
        this.customerTaxNbr = customerTaxNbr;
    }

    @Override
    public String getCustomerTaxTypeCode() {
        return customerTaxTypeCode;
    }

    public void setCustomerTaxTypeCode(String customerTaxTypeCode) {
        this.customerTaxTypeCode = customerTaxTypeCode;
    }

    public List<Note> getBoNotes() {
        if (StringUtils.isEmpty(customerNumber)) {
            return new ArrayList<>();
        }
        CustomerService customerService = SpringContext.getBean(CustomerService.class);
        return customerService.getCustomerNotes(customerNumber);
    }

    public void setBoNotes(List boNotes) {
        this.boNotes = boNotes;
    }

    public String getBankruptcyType() {
        return bankruptcyType;
    }

    public void setBankruptcyType(String bankruptcyType) {
        this.bankruptcyType = bankruptcyType;
    }

    public Date getBankruptcyDate() {
        return bankruptcyDate;
    }

    public void setBankruptcyDate(Date bankruptcyDate) {
        this.bankruptcyDate = bankruptcyDate;
    }

    public Date getBankruptcyReviewDate() {
        return bankruptcyReviewDate;
    }

    public void setBankruptcyReviewDate(Date bankruptcyReviewDate) {
        this.bankruptcyReviewDate = bankruptcyReviewDate;
    }

    @Override
    public boolean isStopWorkIndicator() {
        return stopWorkIndicator;
    }

    public void setStopWorkIndicator(boolean stopWorkIndicator) {
        this.stopWorkIndicator = stopWorkIndicator;
    }

    public String getStopWorkReason() {
        return stopWorkReason;
    }

    public void setStopWorkReason(String stopWorkReason) {
        this.stopWorkReason = stopWorkReason;
    }

    @Override
    public AccountsReceivableCustomerAddress getPrimaryAddress() {
        return SpringContext.getBean(CustomerAddressService.class).getPrimaryAddress(getCustomerNumber());
    }

    @Override
    public List<AccountsReceivableCustomerAddress> getAccountsReceivableCustomerAddresses() {
        List<AccountsReceivableCustomerAddress> accountsReceivableCustomerAddresses = new ArrayList<>();
        if (this.customerAddresses != null && !this.customerAddresses.isEmpty()) {
            accountsReceivableCustomerAddresses.addAll(customerAddresses);
        }

        return accountsReceivableCustomerAddresses;
    }

    @Override
    public void setAccountsReceivableCustomerAddresses(List<AccountsReceivableCustomerAddress> customerAddresses) {
        if (this.customerAddresses != null && customerAddresses != null) {
            this.customerAddresses.clear();

            for (AccountsReceivableCustomerAddress arca : customerAddresses) {
                this.customerAddresses.add((CustomerAddress) arca);
            }
        }
    }

    @Override
    public String getCustomerInvoiceTemplateCode() {
        return customerInvoiceTemplateCode;
    }

    public void setCustomerInvoiceTemplateCode(String customerInvoiceTemplateCode) {
        this.customerInvoiceTemplateCode = customerInvoiceTemplateCode;
    }

    public InvoiceTemplate getCustomerInvoiceTemplate() {
        return customerInvoiceTemplate;
    }

    public void setCustomerInvoiceTemplate(InvoiceTemplate customerInvoiceTemplate) {
        this.customerInvoiceTemplate = customerInvoiceTemplate;
    }
}

