/**
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2019 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.businessobject;

import org.kuali.kfs.module.ar.ArPropertyConstants;
import org.kuali.kfs.sys.KFSPropertyConstants;
import org.kuali.kfs.sys.businessobject.AccountingLineParserBase;

public class CustomerInvoiceAccountingLineParser extends AccountingLineParserBase {

    protected static final String[] CUSTOMER_INVOICE_FORMAT = {
        KFSPropertyConstants.CHART_OF_ACCOUNTS_CODE,
        KFSPropertyConstants.ACCOUNT_NUMBER,
        KFSPropertyConstants.SUB_ACCOUNT_NUMBER,
        KFSPropertyConstants.FINANCIAL_OBJECT_CODE,
        KFSPropertyConstants.FINANCIAL_SUB_OBJECT_CODE,
        KFSPropertyConstants.PROJECT_CODE,
        KFSPropertyConstants.ORGANIZATION_REFERENCE_ID,
        ArPropertyConstants.CustomerInvoiceDocumentFields.INVOICE_ITEM_CODE,
        ArPropertyConstants.CustomerInvoiceDocumentFields.INVOICE_ITEM_QUANTITY,
        ArPropertyConstants.CustomerInvoiceDocumentFields.INVOICE_ITEM_DESCRIPTION,
        ArPropertyConstants.CustomerInvoiceDocumentFields.INVOICE_ITEM_SERVICE_DATE,
        ArPropertyConstants.CustomerInvoiceDocumentFields.UNIT_OF_MEASURE_CODE,
        ArPropertyConstants.CustomerInvoiceDocumentFields.INVOICE_ITEM_UNIT_PRICE,
        ArPropertyConstants.CustomerInvoiceDocumentFields.INVOICE_ITEM_TAXABLE_INDICATOR};

    @Override
    public String[] getSourceAccountingLineFormat() {
        return removeChartFromFormatIfNeeded(CUSTOMER_INVOICE_FORMAT);
    }

}
