/**
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2019 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.businessobject.options;

import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.keyvalues.KeyValuesBase;
import org.kuali.kfs.module.ar.ArParameterConstants;
import org.kuali.kfs.module.ar.businessobject.InvoiceRecurrence;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;

import java.util.ArrayList;
import java.util.List;

public class InvoiceRecurrenceIntervalCodeValuesFinder extends KeyValuesBase {

    private ParameterService parameterService;

    public List<KeyValue> getKeyValues() {
        List<KeyValue> keyLabels = new ArrayList<>();
        List<String> parameterValues = new ArrayList<>(parameterService.getParameterValuesAsString(
                InvoiceRecurrence.class, ArParameterConstants.INVOICE_RECURRENCE_INTERVALS));
        keyLabels.add(new ConcreteKeyValue("", ""));

        for (String parameterValue : parameterValues) {
            keyLabels.add(new ConcreteKeyValue(StringUtils.substringBefore(parameterValue, "="),
                StringUtils.substringBefore(parameterValue, "=") + " - "
                        + StringUtils.substringAfter(parameterValue, "=")));
        }
        return keyLabels;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}
