/**
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2019 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.document.authorization;

import org.kuali.kfs.kns.datadictionary.MaintainableCollectionDefinition;
import org.kuali.kfs.kns.document.authorization.MaintenanceDocumentAuthorizerBase;
import org.kuali.kfs.kns.service.MaintenanceDocumentDictionaryService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.KRADConstants;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.ArPropertyConstants;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.kim.api.KimConstants;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class PredeterminedBillingScheduleMaintenanceDocumentAuthorizer extends MaintenanceDocumentAuthorizerBase {

    public static final String BILL = "Bill";

    @Override
    public Set<String> getSecurePotentiallyReadOnlySectionIds() {
        Set<String> readOnlySectionIds = super.getSecurePotentiallyReadOnlySectionIds();
        String principalId = GlobalVariables.getUserSession().getPrincipalId();
        MaintainableCollectionDefinition maintCollDef = getMaintainableCollection();
        conditionallyHideBillCollectionEditing(principalId, maintCollDef);
        return readOnlySectionIds;
    }

    protected void conditionallyHideBillCollectionEditing(String principalId,
            MaintainableCollectionDefinition maintCollDef) {
        Map<String, String> permissionDetails = new HashMap<>();
        permissionDetails.put(KRADConstants.COMPONENT_NAME, BILL);
        permissionDetails.put(KimConstants.AttributeConstants.SECTION_ID, ArConstants.BILL_SECTION);

        Map<String, String> qualificationDetails = new HashMap<>();
        if (getPermissionService().isAuthorizedByTemplate(principalId,
                KRADConstants.KNS_NAMESPACE, KFSConstants.SysKimApiConstants.ADD_LINE_PERM_TMPL, permissionDetails,
                qualificationDetails)) {
            maintCollDef.setIncludeAddLine(true);
            maintCollDef.setIncludeMultipleLookupLine(true);
        } else {
            maintCollDef.setIncludeAddLine(false);
            maintCollDef.setIncludeMultipleLookupLine(false);
        }
    }

    private MaintainableCollectionDefinition getMaintainableCollection() {
        return SpringContext.getBean(MaintenanceDocumentDictionaryService.class).
                getMaintainableCollection(ArConstants.ArDocumentTypeCodes.PREDETERMINED_BILLING_SCHEDULE,
                        ArPropertyConstants.PredeterminedBillingScheduleFields.BILLS);
    }
}
