/**
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2019 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.service;

import org.kuali.kfs.kns.web.ui.Section;

import java.util.List;

/**
 * Service with shared methods for Customer Maintainable & Inquirable
 */
public interface CustomerViewService {

    /**
     * If CGB is disabled, remove CGB-only fields/sections from the list of sections so they are not displayed
     * on the Customer inquiry or maintenance screen.
     *
     * @param sections List of Sections to process
     * @return List of sections with fields/sections removed as necessary
     */
    List getSections(List<Section> sections);

}
