/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.batch;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.module.ar.batch.CustomerLoadInputFileType;
import org.kuali.kfs.module.ar.batch.vo.CustomerAddressDigesterVO;
import org.kuali.kfs.module.ar.batch.vo.CustomerDigesterVO;
import org.kuali.kfs.sys.batch.BatchInputFileType;
import org.kuali.kfs.sys.batch.service.impl.BatchInputFileServiceImpl;
import org.kuali.kfs.sys.exception.XmlErrorHandler;
import org.mockito.Mockito;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

@Execution(value=ExecutionMode.SAME_THREAD)
public class CustomerLoadInputTypeTest {
    private static final String XML_SAMPLE_FILE = "org/kuali/kfs/module/ar/batch/sample/CustomerLoad-Sample.xml";
    private static final String SCHEMA_FILE = "org/kuali/kfs/module/ar/batch/customer.xsd";
    private static final String DIGESTER_RULE_FILE = "org/kuali/kfs/module/ar/batch/digester/customerLoadDigesterRules.xml";

    @Test
    public void validateSampleAgainstSchema() throws SAXException, IOException {
        InputStream sampleInputStream = ClassLoader.getSystemResourceAsStream(XML_SAMPLE_FILE);
        StreamSource sampleSource = new StreamSource(sampleInputStream);
        URL schemaUrl = this.getClass().getClassLoader().getResource(SCHEMA_FILE);
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(schemaUrl);
        Validator validator = schema.newValidator();
        validator.setErrorHandler((ErrorHandler)new XmlErrorHandler());
        validator.validate(sampleSource);
    }

    @Test
    public void testCustomerLoadInputFileType() throws Exception {
        CustomerLoadInputFileType cut = (CustomerLoadInputFileType)Mockito.spy((Object)new CustomerLoadInputFileType());
        BatchInputFileServiceImpl batchInputFileService = new BatchInputFileServiceImpl();
        cut.setDigestorRulesFileName(DIGESTER_RULE_FILE);
        cut.setSchemaLocation(SCHEMA_FILE);
        URL schemaUrl = this.getClass().getClassLoader().getResource(SCHEMA_FILE);
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(schemaUrl);
        ((CustomerLoadInputFileType)Mockito.doReturn((Object)schema).when((Object)cut)).getSchema(SCHEMA_FILE);
        InputStream sampleFileStream = ClassLoader.getSystemResourceAsStream(XML_SAMPLE_FILE);
        byte[] fileByteContent = IOUtils.toByteArray((InputStream)sampleFileStream);
        List parsedCustomerList = (List)batchInputFileService.parse((BatchInputFileType)cut, fileByteContent);
        Assert.assertEquals((long)2L, (long)parsedCustomerList.size());
        Assert.assertEquals((Object)"Sample Customer One", (Object)((CustomerDigesterVO)parsedCustomerList.get(0)).getCustomerName());
        Assert.assertEquals((Object)"johndoe@samplecustomerone.com", (Object)((CustomerDigesterVO)parsedCustomerList.get(0)).getCustomerEmailAddress());
        Assert.assertEquals((Object)"121231234", (Object)((CustomerDigesterVO)parsedCustomerList.get(0)).getCustomerTaxNbr());
        Assert.assertEquals((Object)"8005551212", (Object)((CustomerDigesterVO)parsedCustomerList.get(0)).getCustomer800PhoneNumber());
        Assert.assertEquals((Object)"Y", (Object)((CustomerDigesterVO)parsedCustomerList.get(0)).getCustomerActiveIndicator());
        Assert.assertEquals((Object)"John Doe", (Object)((CustomerDigesterVO)parsedCustomerList.get(0)).getCustomerContactName());
        Assert.assertEquals((Object)"5205551212", (Object)((CustomerDigesterVO)parsedCustomerList.get(0)).getCustomerContactPhoneNumber());
        Assert.assertEquals((Object)"", (Object)((CustomerDigesterVO)parsedCustomerList.get(0)).getCustomerCreditApprovedByName());
        Assert.assertNull((Object)((CustomerDigesterVO)parsedCustomerList.get(0)).getCustomerFaxNumber());
        Assert.assertEquals((Object)"", (Object)((CustomerDigesterVO)parsedCustomerList.get(0)).getCustomerParentCompanyNumber());
        Assert.assertEquals((Object)"5205551212", (Object)((CustomerDigesterVO)parsedCustomerList.get(0)).getCustomerPhoneNumber());
        Assert.assertEquals((Object)"Y", (Object)((CustomerDigesterVO)parsedCustomerList.get(0)).getCustomerTaxExemptIndicator());
        Assert.assertEquals((Object)"FEIN", (Object)((CustomerDigesterVO)parsedCustomerList.get(0)).getCustomerTaxTypeCode());
        Assert.assertEquals((Object)"05", (Object)((CustomerDigesterVO)parsedCustomerList.get(0)).getCustomerTypeCode());
        Assert.assertEquals((Object)"2008-06-01", (Object)((CustomerDigesterVO)parsedCustomerList.get(0)).getCustomerLastActivityDate());
        Assert.assertEquals((long)2L, (long)((CustomerDigesterVO)parsedCustomerList.get(0)).getCustomerAddresses().size());
        Assert.assertEquals((Object)"Headquarters", (Object)((CustomerAddressDigesterVO)((CustomerDigesterVO)parsedCustomerList.get(0)).getCustomerAddresses().get(0)).getCustomerAddressName());
        Assert.assertEquals((Object)"1234 N Any St", (Object)((CustomerAddressDigesterVO)((CustomerDigesterVO)parsedCustomerList.get(0)).getCustomerAddresses().get(0)).getCustomerLine1StreetAddress());
        Assert.assertEquals((Object)"Suite 440", (Object)((CustomerAddressDigesterVO)((CustomerDigesterVO)parsedCustomerList.get(0)).getCustomerAddresses().get(0)).getCustomerLine2StreetAddress());
        Assert.assertEquals((Object)"Phoenix", (Object)((CustomerAddressDigesterVO)((CustomerDigesterVO)parsedCustomerList.get(0)).getCustomerAddresses().get(0)).getCustomerCityName());
        Assert.assertEquals((Object)"AZ", (Object)((CustomerAddressDigesterVO)((CustomerDigesterVO)parsedCustomerList.get(0)).getCustomerAddresses().get(0)).getCustomerStateCode());
        Assert.assertEquals((Object)"85828", (Object)((CustomerAddressDigesterVO)((CustomerDigesterVO)parsedCustomerList.get(0)).getCustomerAddresses().get(0)).getCustomerZipCode());
        Assert.assertEquals((Object)"US", (Object)((CustomerAddressDigesterVO)((CustomerDigesterVO)parsedCustomerList.get(0)).getCustomerAddresses().get(0)).getCustomerCountryCode());
        Assert.assertEquals((Object)"", (Object)((CustomerAddressDigesterVO)((CustomerDigesterVO)parsedCustomerList.get(0)).getCustomerAddresses().get(0)).getCustomerInternationalMailCode());
        Assert.assertEquals((Object)"", (Object)((CustomerAddressDigesterVO)((CustomerDigesterVO)parsedCustomerList.get(0)).getCustomerAddresses().get(0)).getCustomerAddressInternationalProvinceName());
        Assert.assertEquals((Object)"support@samplecustomerone.com", (Object)((CustomerAddressDigesterVO)((CustomerDigesterVO)parsedCustomerList.get(0)).getCustomerAddresses().get(0)).getCustomerEmailAddress());
        Assert.assertEquals((Object)"P", (Object)((CustomerAddressDigesterVO)((CustomerDigesterVO)parsedCustomerList.get(0)).getCustomerAddresses().get(0)).getCustomerAddressTypeCode());
        Assert.assertEquals((Object)"2099-01-01", (Object)((CustomerAddressDigesterVO)((CustomerDigesterVO)parsedCustomerList.get(0)).getCustomerAddresses().get(0)).getCustomerAddressEndDate());
        Assert.assertEquals((Object)"Sales Office", (Object)((CustomerAddressDigesterVO)((CustomerDigesterVO)parsedCustomerList.get(0)).getCustomerAddresses().get(1)).getCustomerAddressName());
        Assert.assertEquals((Object)"4983 N Another St", (Object)((CustomerAddressDigesterVO)((CustomerDigesterVO)parsedCustomerList.get(0)).getCustomerAddresses().get(1)).getCustomerLine1StreetAddress());
        Assert.assertEquals((Object)"", (Object)((CustomerAddressDigesterVO)((CustomerDigesterVO)parsedCustomerList.get(0)).getCustomerAddresses().get(1)).getCustomerLine2StreetAddress());
        Assert.assertEquals((Object)"New York", (Object)((CustomerAddressDigesterVO)((CustomerDigesterVO)parsedCustomerList.get(0)).getCustomerAddresses().get(1)).getCustomerCityName());
        Assert.assertEquals((Object)"NY", (Object)((CustomerAddressDigesterVO)((CustomerDigesterVO)parsedCustomerList.get(0)).getCustomerAddresses().get(1)).getCustomerStateCode());
        Assert.assertEquals((Object)"01298", (Object)((CustomerAddressDigesterVO)((CustomerDigesterVO)parsedCustomerList.get(0)).getCustomerAddresses().get(1)).getCustomerZipCode());
        Assert.assertEquals((Object)"US", (Object)((CustomerAddressDigesterVO)((CustomerDigesterVO)parsedCustomerList.get(0)).getCustomerAddresses().get(1)).getCustomerCountryCode());
        Assert.assertEquals((Object)"", (Object)((CustomerAddressDigesterVO)((CustomerDigesterVO)parsedCustomerList.get(0)).getCustomerAddresses().get(1)).getCustomerInternationalMailCode());
        Assert.assertEquals((Object)"", (Object)((CustomerAddressDigesterVO)((CustomerDigesterVO)parsedCustomerList.get(0)).getCustomerAddresses().get(1)).getCustomerAddressInternationalProvinceName());
        Assert.assertEquals((Object)"sales@samplecustomerone.com", (Object)((CustomerAddressDigesterVO)((CustomerDigesterVO)parsedCustomerList.get(0)).getCustomerAddresses().get(1)).getCustomerEmailAddress());
        Assert.assertEquals((Object)"A", (Object)((CustomerAddressDigesterVO)((CustomerDigesterVO)parsedCustomerList.get(0)).getCustomerAddresses().get(1)).getCustomerAddressTypeCode());
        Assert.assertEquals((Object)"2099-01-01", (Object)((CustomerAddressDigesterVO)((CustomerDigesterVO)parsedCustomerList.get(0)).getCustomerAddresses().get(1)).getCustomerAddressEndDate());
        Assert.assertEquals((Object)"Jack Brown", (Object)((CustomerDigesterVO)parsedCustomerList.get(1)).getCustomerName());
        Assert.assertEquals((Object)"jackbrown@aol.com", (Object)((CustomerDigesterVO)parsedCustomerList.get(1)).getCustomerEmailAddress());
        Assert.assertEquals((Object)"111223333", (Object)((CustomerDigesterVO)parsedCustomerList.get(1)).getCustomerTaxNbr());
        Assert.assertEquals((Object)"", (Object)((CustomerDigesterVO)parsedCustomerList.get(1)).getCustomer800PhoneNumber());
        Assert.assertEquals((Object)"Y", (Object)((CustomerDigesterVO)parsedCustomerList.get(1)).getCustomerActiveIndicator());
        Assert.assertEquals((Object)"Jack Brown", (Object)((CustomerDigesterVO)parsedCustomerList.get(1)).getCustomerContactName());
        Assert.assertEquals((Object)"5205551212", (Object)((CustomerDigesterVO)parsedCustomerList.get(1)).getCustomerContactPhoneNumber());
        Assert.assertEquals((Object)"", (Object)((CustomerDigesterVO)parsedCustomerList.get(1)).getCustomerCreditApprovedByName());
        Assert.assertNull((Object)((CustomerDigesterVO)parsedCustomerList.get(1)).getCustomerFaxNumber());
        Assert.assertEquals((Object)"", (Object)((CustomerDigesterVO)parsedCustomerList.get(1)).getCustomerParentCompanyNumber());
        Assert.assertEquals((Object)"5205551212", (Object)((CustomerDigesterVO)parsedCustomerList.get(1)).getCustomerPhoneNumber());
        Assert.assertEquals((Object)"N", (Object)((CustomerDigesterVO)parsedCustomerList.get(1)).getCustomerTaxExemptIndicator());
        Assert.assertEquals((Object)"SSN", (Object)((CustomerDigesterVO)parsedCustomerList.get(1)).getCustomerTaxTypeCode());
        Assert.assertEquals((Object)"08", (Object)((CustomerDigesterVO)parsedCustomerList.get(1)).getCustomerTypeCode());
        Assert.assertEquals((Object)"2008-09-16", (Object)((CustomerDigesterVO)parsedCustomerList.get(1)).getCustomerLastActivityDate());
        Assert.assertEquals((long)1L, (long)((CustomerDigesterVO)parsedCustomerList.get(1)).getCustomerAddresses().size());
        Assert.assertEquals((Object)"Home", (Object)((CustomerAddressDigesterVO)((CustomerDigesterVO)parsedCustomerList.get(1)).getCustomerAddresses().get(0)).getCustomerAddressName());
        Assert.assertEquals((Object)"1234 N Any St", (Object)((CustomerAddressDigesterVO)((CustomerDigesterVO)parsedCustomerList.get(1)).getCustomerAddresses().get(0)).getCustomerLine1StreetAddress());
        Assert.assertEquals((Object)"", (Object)((CustomerAddressDigesterVO)((CustomerDigesterVO)parsedCustomerList.get(1)).getCustomerAddresses().get(0)).getCustomerLine2StreetAddress());
        Assert.assertEquals((Object)"Phoenix", (Object)((CustomerAddressDigesterVO)((CustomerDigesterVO)parsedCustomerList.get(1)).getCustomerAddresses().get(0)).getCustomerCityName());
        Assert.assertEquals((Object)"AZ", (Object)((CustomerAddressDigesterVO)((CustomerDigesterVO)parsedCustomerList.get(1)).getCustomerAddresses().get(0)).getCustomerStateCode());
        Assert.assertEquals((Object)"85828", (Object)((CustomerAddressDigesterVO)((CustomerDigesterVO)parsedCustomerList.get(1)).getCustomerAddresses().get(0)).getCustomerZipCode());
        Assert.assertEquals((Object)"US", (Object)((CustomerAddressDigesterVO)((CustomerDigesterVO)parsedCustomerList.get(1)).getCustomerAddresses().get(0)).getCustomerCountryCode());
        Assert.assertEquals((Object)"", (Object)((CustomerAddressDigesterVO)((CustomerDigesterVO)parsedCustomerList.get(1)).getCustomerAddresses().get(0)).getCustomerInternationalMailCode());
        Assert.assertEquals((Object)"", (Object)((CustomerAddressDigesterVO)((CustomerDigesterVO)parsedCustomerList.get(1)).getCustomerAddresses().get(0)).getCustomerAddressInternationalProvinceName());
        Assert.assertEquals((Object)"jackbrown@aol.com", (Object)((CustomerAddressDigesterVO)((CustomerDigesterVO)parsedCustomerList.get(1)).getCustomerAddresses().get(0)).getCustomerEmailAddress());
        Assert.assertEquals((Object)"P", (Object)((CustomerAddressDigesterVO)((CustomerDigesterVO)parsedCustomerList.get(1)).getCustomerAddresses().get(0)).getCustomerAddressTypeCode());
        Assert.assertEquals((Object)"2099-01-01", (Object)((CustomerAddressDigesterVO)((CustomerDigesterVO)parsedCustomerList.get(1)).getCustomerAddresses().get(0)).getCustomerAddressEndDate());
    }
}

