/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.batch.vo;

import java.util.ArrayList;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.kns.service.MaintenanceDocumentDictionaryService;
import org.kuali.kfs.module.ar.batch.report.CustomerLoadBatchErrors;
import org.kuali.kfs.module.ar.batch.vo.CustomerDigesterAdapter;
import org.kuali.kfs.module.ar.batch.vo.CustomerDigesterVO;
import org.kuali.kfs.module.ar.batch.vo.CustomerLoadVOGenerator;
import org.kuali.kfs.module.ar.businessobject.Customer;
import org.kuali.kfs.module.ar.businessobject.CustomerAddress;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.impl.datetime.DateTimeServiceImpl;
import org.mockito.Mockito;

@Execution(value=ExecutionMode.SAME_THREAD)
public class CustomerDigesterAdapterTest {
    private CustomerDigesterAdapter cut;

    @Before
    public void setUp() {
        this.cut = new CustomerDigesterAdapter();
        this.cut.setDateTimeService((DateTimeService)new DateTimeServiceImpl());
        this.cut.setMaintDocDDService((MaintenanceDocumentDictionaryService)Mockito.mock(MaintenanceDocumentDictionaryService.class));
    }

    @Test
    public void convert_ValidBatchFile() {
        ArrayList<Map<String, String>> addresses = new ArrayList<Map<String, String>>();
        addresses.add(CustomerLoadVOGenerator.getValidAddressVO1());
        CustomerDigesterVO customerVO = CustomerLoadVOGenerator.generateCustomerVO(CustomerLoadVOGenerator.getValidCustomerVO1(), addresses);
        CustomerLoadBatchErrors batchErrors = new CustomerLoadBatchErrors();
        Customer customer = this.cut.convert(customerVO, batchErrors);
        Assert.assertTrue((String)"No errors should have occurred on conversion from VO to BO.", (boolean)batchErrors.isEmpty());
        Assert.assertNotNull((String)"Customer object should not be null.", (Object)customer);
        Assert.assertNotNull((String)"Customer name should not be null.", (Object)customer.getCustomerName());
        Assert.assertNotNull((String)"Parent Company Number should be null.", (Object)customer.getCustomerParentCompanyNumber());
        Assert.assertNotNull((String)"Customer Type Code should not be null.", (Object)customer.getCustomerTypeCode());
        Assert.assertNotNull((String)"Customer Last Activity Date should not be null.", (Object)customer.getCustomerLastActivityDate());
        Assert.assertNotNull((String)"Customer Tax Type Code should not be null.", (Object)customer.getCustomerTaxTypeCode());
        Assert.assertNotNull((String)"Customer Tax Number should not be null.", (Object)customer.getCustomerTaxNbr());
        Assert.assertNotNull((String)"Customer Phone Number should not be null.", (Object)customer.getCustomerPhoneNumber());
        Assert.assertNotNull((String)"Customer 800 Phone Number should not be null.", (Object)customer.getCustomer800PhoneNumber());
        Assert.assertNotNull((String)"Customer Contact Name should not be null.", (Object)customer.getCustomerContactName());
        Assert.assertNotNull((String)"Customer Contact Phone Number should not be null.", (Object)customer.getCustomerContactPhoneNumber());
        Assert.assertNotNull((String)"Customer Fax Number should not be null.", (Object)customer.getCustomerFaxNumber());
        Assert.assertNull((String)"Customer Birth Date should be null.", (Object)customer.getCustomerBirthDate());
        Assert.assertNull((String)"Customer Credit Limit Amount should be null.", (Object)customer.getCustomerCreditLimitAmount());
        Assert.assertNotNull((String)"Customer Credit Approved By Name should not be null.", (Object)customer.getCustomerCreditApprovedByName());
        Assert.assertNotNull((String)"Customer Email Address should not be null.", (Object)customer.getCustomerEmailAddress());
        CustomerAddress address = (CustomerAddress)customer.getCustomerAddresses().get(0);
        Assert.assertNotNull((String)"The first address should not be null.", (Object)address);
        Assert.assertNotNull((String)"Customer Address Name should not be null.", (Object)address.getCustomerAddressName());
        Assert.assertNotNull((String)"Customer Line1 Street Address should not be null.", (Object)address.getCustomerLine1StreetAddress());
        Assert.assertNotNull((String)"Customer Line2 Street Address should not be null.", (Object)address.getCustomerLine2StreetAddress());
        Assert.assertNotNull((String)"Customer City Name should not be null.", (Object)address.getCustomerCityName());
        Assert.assertNotNull((String)"Customer State Code should not be null.", (Object)address.getCustomerStateCode());
        Assert.assertNotNull((String)"Customer Zip Code should not be null.", (Object)address.getCustomerZipCode());
        Assert.assertNotNull((String)"Customer Country Code should not be null.", (Object)address.getCustomerCountryCode());
        Assert.assertNotNull((String)"Customer Address International Province Name should be null.", (Object)address.getCustomerAddressInternationalProvinceName());
        Assert.assertEquals((String)"Customer Address International Province Name should be empty string.", (Object)"", (Object)address.getCustomerAddressInternationalProvinceName());
        Assert.assertNotNull((String)"Customer International Mail Code should be null.", (Object)address.getCustomerInternationalMailCode());
        Assert.assertEquals((String)"Customer International Mail Code should be empty string.", (Object)"", (Object)address.getCustomerInternationalMailCode());
        Assert.assertNotNull((String)"Customer Email Address should not be null.", (Object)address.getCustomerEmailAddress());
        Assert.assertNotNull((String)"Customer Address Type Code should not be null.", (Object)address.getCustomerAddressTypeCode());
        Assert.assertNotNull((String)"Customer Address End Date should not be null.", (Object)address.getCustomerAddressEndDate());
    }

    @Test
    public void convert_InvalidDates() {
        ArrayList<Map<String, String>> addresses = new ArrayList<Map<String, String>>();
        addresses.add(CustomerLoadVOGenerator.getBadAddressVO_InvalidDates_01());
        CustomerDigesterVO customerVO = CustomerLoadVOGenerator.generateCustomerVO(CustomerLoadVOGenerator.getBadCustomerVO_InvalidDates_01(), addresses);
        CustomerLoadBatchErrors batchErrors = new CustomerLoadBatchErrors();
        Customer customer = this.cut.convert(customerVO, batchErrors);
        Assert.assertNotNull((String)"Customer object should not be null.", (Object)customer);
        Assert.assertFalse((String)"Batch Errors should not be empty.", (boolean)batchErrors.isEmpty());
        Assert.assertEquals((String)"Should be one companyName with errors.", (long)1L, (long)batchErrors.getCompaniesWithErrors());
        Assert.assertEquals((String)"Should be two errors total.", (long)2L, (long)batchErrors.getTotalErrors());
        Assert.assertNull((String)"The failed customer birthDate should be null.", (Object)customer.getCustomerBirthDate());
        Assert.assertNull((String)"The address should have a null end-date.", (Object)((CustomerAddress)customer.getCustomerAddresses().get(0)).getCustomerAddressEndDate());
    }
}

