/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsInvoiceLookupResultAward;

@Execution(value=ExecutionMode.SAME_THREAD)
public class ContractsGrantsInvoiceLookupResultAwardTest {
    private ContractsGrantsInvoiceLookupResultAward cut;

    @Before
    public void setUp() {
        this.cut = new ContractsGrantsInvoiceLookupResultAward();
        this.cut.setProposalNumber("1");
        this.cut.setChartOfAccountsCode("BL");
        this.cut.setAccountNumber("1234567");
    }

    @Test
    public void getObjectIdMilestone() {
        this.cut.setBillingFrequencyCode(ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        Assert.assertEquals((Object)"1-BL-1234567", (Object)this.cut.getObjectId());
    }

    @Test
    public void getObjectIdPredeterminedBilling() {
        this.cut.setBillingFrequencyCode(ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        Assert.assertEquals((Object)"1-BL-1234567", (Object)this.cut.getObjectId());
    }

    @Test
    public void getObjectIdMonthly() {
        this.cut.setBillingFrequencyCode(ArConstants.BillingFrequencyValues.MONTHLY.getCode());
        Assert.assertEquals((Object)"1-*-*", (Object)this.cut.getObjectId());
    }

    @Test
    public void getObjectIdQuarterly() {
        this.cut.setBillingFrequencyCode(ArConstants.BillingFrequencyValues.QUARTERLY.getCode());
        Assert.assertEquals((Object)"1-*-*", (Object)this.cut.getObjectId());
    }

    @Test
    public void getObjectIdSemiAnnually() {
        this.cut.setBillingFrequencyCode(ArConstants.BillingFrequencyValues.SEMI_ANNUALLY.getCode());
        Assert.assertEquals((Object)"1-*-*", (Object)this.cut.getObjectId());
    }

    @Test
    public void getObjectIdAnnually() {
        this.cut.setBillingFrequencyCode(ArConstants.BillingFrequencyValues.ANNUALLY.getCode());
        Assert.assertEquals((Object)"1-*-*", (Object)this.cut.getObjectId());
    }

    @Test
    public void getObjectIdLetterOfCredit() {
        this.cut.setBillingFrequencyCode(ArConstants.BillingFrequencyValues.LETTER_OF_CREDIT.getCode());
        Assert.assertEquals((Object)"1-*-*", (Object)this.cut.getObjectId());
    }
}

