/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject;

import java.sql.Date;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.coa.service.AccountingPeriodService;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.businessobject.BillingPeriod;
import org.kuali.kfs.module.ar.businessobject.LetterOfCreditBillingPeriod;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

@Execution(value=ExecutionMode.SAME_THREAD)
public class LetterOfCreditBillingPeriodTest {
    @Mock
    private AccountingPeriodService accountingPeriodSvcMock;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void determineBillingPeriodPriorTo_LOC_nullLastBilled_1() {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date currentDate = Date.valueOf("2015-04-20");
        Date expectedBillingPeriodStart = Date.valueOf("2014-07-01");
        Date expectedBillingPeriodEnd = Date.valueOf("2015-04-19");
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, null, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.LETTER_OF_CREDIT, (AccountingPeriodService)this.accountingPeriodSvcMock);
        Assert.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assert.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assert.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    public void determineBillingPeriodPriorTo_LOC_nullLastBilled_2() {
        Date awardStartDate = Date.valueOf("2014-08-01");
        Date currentDate = Date.valueOf("2015-04-20");
        Date expectedBillingPeriodStart = Date.valueOf("2014-08-01");
        Date expectedBillingPeriodEnd = Date.valueOf("2015-04-19");
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, null, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.LETTER_OF_CREDIT, (AccountingPeriodService)this.accountingPeriodSvcMock);
        Assert.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assert.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assert.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    public void determineBillingPeriodPriorTo_LOC_BillSingleDay() {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date currentDate = Date.valueOf("2015-04-21");
        Date lastBilledDate = Date.valueOf("2015-04-19");
        Date expectedBillingPeriodStart = Date.valueOf("2015-04-19");
        Date expectedBillingPeriodEnd = Date.valueOf("2015-04-20");
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, (Date)lastBilledDate, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.LETTER_OF_CREDIT, (AccountingPeriodService)this.accountingPeriodSvcMock);
        Assert.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assert.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assert.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    public void determineBillingPeriodPriorTo_LOC_BillSeveralMonths() {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date currentDate = Date.valueOf("2015-04-21");
        Date lastBilledDate = Date.valueOf("2014-11-15");
        Date expectedBillingPeriodStart = Date.valueOf("2014-11-15");
        Date expectedBillingPeriodEnd = Date.valueOf("2015-04-20");
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, (Date)lastBilledDate, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.LETTER_OF_CREDIT, (AccountingPeriodService)this.accountingPeriodSvcMock);
        Assert.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assert.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assert.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    public void determineBillingPeriodPriorTo_LOC_BillAcrossFiscalYears() {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date currentDate = Date.valueOf("2015-04-21");
        Date lastBilledDate = Date.valueOf("2014-06-15");
        Date expectedBillingPeriodStart = Date.valueOf("2014-06-15");
        Date expectedBillingPeriodEnd = Date.valueOf("2015-04-20");
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, (Date)lastBilledDate, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.LETTER_OF_CREDIT, (AccountingPeriodService)this.accountingPeriodSvcMock);
        Assert.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assert.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assert.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    public void determineBillingPeriodPriorTo_LOC_MayNotBillNow() {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date currentDate = Date.valueOf("2015-04-21");
        Date lastBilledDate = Date.valueOf("2015-04-20");
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, (Date)lastBilledDate, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.LETTER_OF_CREDIT, (AccountingPeriodService)this.accountingPeriodSvcMock);
        Assert.assertNull((Object)priorBillingPeriod.getStartDate());
        Assert.assertNull((Object)priorBillingPeriod.getEndDate());
        Assert.assertFalse((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    public void canThisBeBilledLastBilledDateIsNull() {
        Date awardStartDate = Date.valueOf("2015-01-01");
        Date currentDate = Date.valueOf("2015-04-21");
        LetterOfCreditBillingPeriod billingPeriod = new LetterOfCreditBillingPeriod(ArConstants.BillingFrequencyValues.LETTER_OF_CREDIT, awardStartDate, currentDate, null, this.accountingPeriodSvcMock);
        Assert.assertTrue((boolean)billingPeriod.canThisBeBilled());
    }

    @Test
    public void canThisBeBilledLastBilledDateIsToday() {
        Date awardStartDate = Date.valueOf("2015-01-01");
        Date lastBilledDate = Date.valueOf("2015-04-21");
        Date currentDate = Date.valueOf("2015-04-21");
        LetterOfCreditBillingPeriod billingPeriod = new LetterOfCreditBillingPeriod(ArConstants.BillingFrequencyValues.LETTER_OF_CREDIT, awardStartDate, currentDate, lastBilledDate, this.accountingPeriodSvcMock);
        Assert.assertFalse((boolean)billingPeriod.canThisBeBilled());
    }

    @Test
    public void canThisBeBilledLastBilledDateIsYesterday() {
        Date awardStartDate = Date.valueOf("2015-01-01");
        Date lastBilledDate = Date.valueOf("2015-04-20");
        Date currentDate = Date.valueOf("2015-04-21");
        LetterOfCreditBillingPeriod billingPeriod = new LetterOfCreditBillingPeriod(ArConstants.BillingFrequencyValues.LETTER_OF_CREDIT, awardStartDate, currentDate, lastBilledDate, this.accountingPeriodSvcMock);
        Assert.assertFalse((boolean)billingPeriod.canThisBeBilled());
    }

    @Test
    public void canThisBeBilledLastBilledDateIsBeforeYesterday() {
        Date awardStartDate = Date.valueOf("2015-01-01");
        Date lastBilledDate = Date.valueOf("2015-04-19");
        Date currentDate = Date.valueOf("2015-04-21");
        LetterOfCreditBillingPeriod billingPeriod = new LetterOfCreditBillingPeriod(ArConstants.BillingFrequencyValues.LETTER_OF_CREDIT, awardStartDate, currentDate, lastBilledDate, this.accountingPeriodSvcMock);
        Assert.assertTrue((boolean)billingPeriod.canThisBeBilled());
    }
}

