/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject;

import java.sql.Date;
import java.time.LocalDate;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.rules.ExpectedException;
import org.kuali.kfs.module.ar.businessobject.Milestone;
import org.kuali.rice.core.api.util.type.KualiDecimal;

@Execution(value=ExecutionMode.SAME_THREAD)
public class MilestoneBuilderTest {
    private Milestone.MilestoneBuilder cut;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setUp() {
        this.cut = new Milestone.MilestoneBuilder().setProposalNumber("1").setChartOfAccountsCode("BL").setAccountNumber("1031400").setMilestoneExpectedCompletionDate(Date.valueOf(LocalDate.now().minusDays(1L))).setActive(true).setMilestoneNumber("1").setMilestoneDescription("milestone 1").setMilestoneAmount(new KualiDecimal(100.0)).setMilestoneActualCompletionDate(Date.valueOf(LocalDate.now()));
    }

    @Test
    public void milestoneBuilder_build_allFieldsPopulated_valid() {
        Milestone milestone = this.cut.build();
        Assert.assertNotNull((Object)milestone);
    }

    @Test
    public void milestoneBuilder_build_onlyRequiredFieldsPopulated_valid() {
        this.cut.setMilestoneDescription("");
        this.cut.setMilestoneAmount(null);
        this.cut.setMilestoneActualCompletionDate(null);
        Milestone milestone = this.cut.build();
        Assert.assertNotNull((Object)milestone);
    }

    @Test
    public void milestoneBuilder_build_MissingProposalNumber_validateThrowsException() {
        this.cut.setProposalNumber("");
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("Proposal Number is required.");
        Milestone milestone = this.cut.build();
        Assert.assertNull((Object)milestone);
    }

    @Test
    public void milestoneBuilder_build_MissingChartOfAccountsCode_validateThrowsException() {
        this.cut.setChartOfAccountsCode("");
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("Chart of Accounts Code is required.");
        Milestone milestone = this.cut.build();
        Assert.assertNull((Object)milestone);
    }

    @Test
    public void milestoneBuilder_build_MissingAccountNumber_validateThrowsException() {
        this.cut.setAccountNumber("");
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("Account Number is required.");
        Milestone milestone = this.cut.build();
        Assert.assertNull((Object)milestone);
    }

    @Test
    public void milestoneBuilder_build_MissingMilestoneNumber_validateThrowsException() {
        this.cut.setMilestoneNumber("");
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("Milestone Number is required.");
        Milestone milestone = this.cut.build();
        Assert.assertNull((Object)milestone);
    }

    @Test
    public void milestoneBuilder_build_MissingMilestoneExpectedCompletionDate_validateThrowsException() {
        this.cut.setMilestoneExpectedCompletionDate(null);
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("Milestone Expected Completion Date is required.");
        Milestone milestone = this.cut.build();
        Assert.assertNull((Object)milestone);
    }
}

