/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject;

import java.sql.Date;
import java.time.LocalDate;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.rules.ExpectedException;
import org.kuali.kfs.module.ar.businessobject.Bill;
import org.kuali.kfs.module.ar.businessobject.PredeterminedBillingSchedule;
import org.kuali.rice.core.api.util.type.KualiDecimal;

@Execution(value=ExecutionMode.SAME_THREAD)
public class PredeterminedBillingScheduleBuilderTest {
    private PredeterminedBillingSchedule.PredeterminedBillingScheduleBuilder cut;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setUp() {
        this.cut = new PredeterminedBillingSchedule.PredeterminedBillingScheduleBuilder().setProposalNumber("1").setChartOfAccountsCode("BL").setAccountNumber("1031400");
    }

    @Test
    public void predeterminedBillingScheduleBuilder_build_withoutBills_valid() {
        PredeterminedBillingSchedule predeterminedBillingSchedule = this.cut.build();
        Assert.assertNotNull((Object)predeterminedBillingSchedule);
    }

    @Test
    public void predeterminedBillingScheduleBuilder_build_withOneBill_valid() {
        Bill bill = new Bill.BillBuilder().setProposalNumber("1").setChartOfAccountsCode("BL").setAccountNumber("1031400").setActive(true).setBillNumber("1").setBillDate(Date.valueOf(LocalDate.now())).setEstimatedAmount(new KualiDecimal(100.0)).build();
        this.cut.addBill(bill);
        PredeterminedBillingSchedule predeterminedBillingSchedule = this.cut.build();
        Assert.assertNotNull((Object)predeterminedBillingSchedule);
    }

    @Test
    public void predeterminedBillingScheduleBuilder_build_withMultipleBills_valid() {
        Bill bill1 = new Bill.BillBuilder().setProposalNumber("1").setChartOfAccountsCode("BL").setAccountNumber("1031400").setActive(true).setBillNumber("1").setBillDate(Date.valueOf(LocalDate.now().minusDays(1L))).setEstimatedAmount(new KualiDecimal(100.0)).build();
        Bill bill2 = new Bill.BillBuilder().setProposalNumber("1").setChartOfAccountsCode("BL").setAccountNumber("1031400").setActive(true).setBillNumber("2").setBillDate(Date.valueOf(LocalDate.now().minusDays(1L))).setEstimatedAmount(new KualiDecimal(100.0)).build();
        this.cut.addBill(bill1).addBill(bill2);
        PredeterminedBillingSchedule predeterminedBillingSchedule = this.cut.build();
        Assert.assertNotNull((Object)predeterminedBillingSchedule);
    }

    @Test
    public void predeterminedBillingScheduleBuilder_build_MissingProposalNumber_validateThrowsException() {
        this.cut.setProposalNumber("");
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("Proposal Number is required.");
        PredeterminedBillingSchedule predeterminedBillingSchedule = this.cut.build();
        Assert.assertNull((Object)predeterminedBillingSchedule);
    }

    @Test
    public void predeterminedBillingScheduleBuilder_build_MissingChartOfAccountsCode_validateThrowsException() {
        this.cut.setChartOfAccountsCode("");
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("Chart of Accounts Code is required.");
        PredeterminedBillingSchedule predeterminedBillingSchedule = this.cut.build();
        Assert.assertNull((Object)predeterminedBillingSchedule);
    }

    @Test
    public void predeterminedBillingScheduleBuilder_build_MissingAccountNumber_validateThrowsException() {
        this.cut.setAccountNumber("");
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("Account Number is required.");
        PredeterminedBillingSchedule predeterminedBillingSchedule = this.cut.build();
        Assert.assertNull((Object)predeterminedBillingSchedule);
    }
}

