/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject;

import java.sql.Date;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.coa.businessobject.AccountingPeriod;
import org.kuali.kfs.coa.service.AccountingPeriodService;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.businessobject.BillingPeriod;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@Execution(value=ExecutionMode.SAME_THREAD)
public class TimeBasedBillingPeriodTest {
    @Mock
    private AccountingPeriodService accountingPeriodSvcMock;
    @Mock
    private AccountingPeriod accountingPeriodMock_2013_12;
    @Mock
    private AccountingPeriod accountingPeriodMock_2014_05;
    @Mock
    private AccountingPeriod accountingPeriodMock_2014_09;
    @Mock
    private AccountingPeriod accountingPeriodMock_2014_10;
    @Mock
    private AccountingPeriod accountingPeriodMock_2014_11;
    @Mock
    private AccountingPeriod accountingPeriodMock_2014_12;
    @Mock
    private AccountingPeriod accountingPeriodMock_2015_03;
    @Mock
    private AccountingPeriod accountingPeriodMock_2015_04;
    @Mock
    private AccountingPeriod accountingPeriodMock_2015_05;
    @Mock
    private AccountingPeriod accountingPeriodMock_2015_06;
    @Mock
    private AccountingPeriod accountingPeriodMock_2015_07;
    @Mock
    private AccountingPeriod accountingPeriodMock_2015_08;
    @Mock
    private AccountingPeriod accountingPeriodMock_2015_09;
    @Mock
    private AccountingPeriod accountingPeriodMock_2015_10;
    @Mock
    private AccountingPeriod accountingPeriodMock_2015_12;
    @Mock
    private AccountingPeriod accountingPeriodMock_2016_02;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.setupMockFiscalPeriod(this.accountingPeriodMock_2013_12, "12", 2013, "2013-06-30");
        this.setupMockFiscalPeriod(this.accountingPeriodMock_2014_05, "05", 2014, "2013-11-30");
        this.setupMockFiscalPeriod(this.accountingPeriodMock_2014_09, "09", 2014, "2014-03-31");
        this.setupMockFiscalPeriod(this.accountingPeriodMock_2014_10, "10", 2014, "2014-04-30");
        this.setupMockFiscalPeriod(this.accountingPeriodMock_2014_11, "11", 2014, "2014-05-31");
        this.setupMockFiscalPeriod(this.accountingPeriodMock_2014_12, "12", 2014, "2014-06-30");
        this.setupMockFiscalPeriod(this.accountingPeriodMock_2015_03, "03", 2015, "2014-09-30");
        this.setupMockFiscalPeriod(this.accountingPeriodMock_2015_04, "04", 2015, "2014-10-31");
        this.setupMockFiscalPeriod(this.accountingPeriodMock_2015_05, "05", 2015, "2014-11-30");
        this.setupMockFiscalPeriod(this.accountingPeriodMock_2015_06, "06", 2015, "2014-12-31");
        this.setupMockFiscalPeriod(this.accountingPeriodMock_2015_07, "07", 2015, "2015-01-31");
        this.setupMockFiscalPeriod(this.accountingPeriodMock_2015_08, "08", 2015, "2015-02-28");
        this.setupMockFiscalPeriod(this.accountingPeriodMock_2015_09, "09", 2015, "2015-03-31");
        this.setupMockFiscalPeriod(this.accountingPeriodMock_2015_10, "10", 2015, "2015-04-30");
        this.setupMockFiscalPeriod(this.accountingPeriodMock_2015_12, "12", 2015, "2015-06-30");
        this.setupMockFiscalPeriod(this.accountingPeriodMock_2016_02, "02", 2016, "2015-08-31");
        Mockito.when((Object)this.accountingPeriodSvcMock.getByPeriod("12", Integer.valueOf(2013))).thenReturn((Object)this.accountingPeriodMock_2013_12);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByPeriod("12", Integer.valueOf(2014))).thenReturn((Object)this.accountingPeriodMock_2014_12);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByPeriod("11", Integer.valueOf(2014))).thenReturn((Object)this.accountingPeriodMock_2014_11);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByPeriod("09", Integer.valueOf(2014))).thenReturn((Object)this.accountingPeriodMock_2014_09);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByPeriod("12", Integer.valueOf(2015))).thenReturn((Object)this.accountingPeriodMock_2015_12);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByPeriod("09", Integer.valueOf(2015))).thenReturn((Object)this.accountingPeriodMock_2015_09);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByPeriod("08", Integer.valueOf(2015))).thenReturn((Object)this.accountingPeriodMock_2015_08);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByPeriod("07", Integer.valueOf(2015))).thenReturn((Object)this.accountingPeriodMock_2015_07);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByPeriod("06", Integer.valueOf(2015))).thenReturn((Object)this.accountingPeriodMock_2015_06);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByPeriod("03", Integer.valueOf(2015))).thenReturn((Object)this.accountingPeriodMock_2015_03);
    }

    private void setupMockFiscalPeriod(AccountingPeriod accountingPeriodMock, String fiscalPeriodCode, int fiscalYear, String fiscalPeriodEndDate) {
        Mockito.when((Object)accountingPeriodMock.getUniversityFiscalPeriodCode()).thenReturn((Object)fiscalPeriodCode);
        Mockito.when((Object)accountingPeriodMock.getUniversityFiscalYear()).thenReturn((Object)fiscalYear);
        Mockito.when((Object)accountingPeriodMock.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(fiscalPeriodEndDate));
    }

    @Test
    public void determineBillingPeriodPriorTo_Monthly_nullLastBilled_1() {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date currentDate = Date.valueOf("2015-04-21");
        Date expectedBillingPeriodStart = Date.valueOf("2014-07-01");
        Date expectedBillingPeriodEnd = Date.valueOf("2015-03-31");
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)this.accountingPeriodMock_2015_10);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, null, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.MONTHLY, (AccountingPeriodService)this.accountingPeriodSvcMock);
        Assert.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assert.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assert.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    public void determineBillingPeriodPriorTo_Monthly_nullLastBilled_2() {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date currentDate = Date.valueOf("2015-03-21");
        Date expectedBillingPeriodStart = Date.valueOf("2014-07-01");
        Date expectedBillingPeriodEnd = Date.valueOf("2015-02-28");
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)this.accountingPeriodMock_2015_09);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, null, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.MONTHLY, (AccountingPeriodService)this.accountingPeriodSvcMock);
        Assert.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assert.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assert.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    public void determineBillingPeriodPriorTo_Monthly_LastBilledLastMonth() {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date lastBilledDate = Date.valueOf("2015-03-29");
        Date currentDate = Date.valueOf("2015-04-21");
        Date expectedBillingPeriodStart = Date.valueOf("2015-03-01");
        Date expectedBillingPeriodEnd = Date.valueOf("2015-03-31");
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)this.accountingPeriodMock_2015_10);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(lastBilledDate)).thenReturn((Object)this.accountingPeriodMock_2015_09);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, (Date)lastBilledDate, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.MONTHLY, (AccountingPeriodService)this.accountingPeriodSvcMock);
        Assert.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assert.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assert.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    public void determineBillingPeriodPriorTo_Monthly_LastBilledTwoMonthsAgo() {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date lastBilledDate = Date.valueOf("2015-02-17");
        Date currentDate = Date.valueOf("2015-04-21");
        Date expectedBillingPeriodStart = Date.valueOf("2015-02-01");
        Date expectedBillingPeriodEnd = Date.valueOf("2015-03-31");
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)this.accountingPeriodMock_2015_10);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(lastBilledDate)).thenReturn((Object)this.accountingPeriodMock_2015_08);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, (Date)lastBilledDate, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.MONTHLY, (AccountingPeriodService)this.accountingPeriodSvcMock);
        Assert.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assert.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assert.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    public void determineBillingPeriodPriorTo_Monthly_SpanCalendarYears() {
        Date awardStartDate = Date.valueOf("2013-07-01");
        Date lastBilledDate = Date.valueOf("2014-06-15");
        Date currentDate = Date.valueOf("2015-04-21");
        Date expectedBillingPeriodStart = Date.valueOf("2014-06-01");
        Date expectedBillingPeriodEnd = Date.valueOf("2015-03-31");
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)this.accountingPeriodMock_2015_10);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(lastBilledDate)).thenReturn((Object)this.accountingPeriodMock_2014_12);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, (Date)lastBilledDate, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.MONTHLY, (AccountingPeriodService)this.accountingPeriodSvcMock);
        Assert.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assert.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assert.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    public void determineBillingPeriodPriorTo_Monthly_MayNotBillNow() {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date currentDate = Date.valueOf("2015-04-21");
        Date lastBilledDate = Date.valueOf("2015-04-15");
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)this.accountingPeriodMock_2015_10);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(lastBilledDate)).thenReturn((Object)this.accountingPeriodMock_2015_10);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, (Date)lastBilledDate, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.MONTHLY, (AccountingPeriodService)this.accountingPeriodSvcMock);
        Assert.assertNull((Object)priorBillingPeriod.getStartDate());
        Assert.assertNull((Object)priorBillingPeriod.getEndDate());
        Assert.assertFalse((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    public void determineBillingPeriodPriorTo_Monthly_MayBillNowLastYear() {
        Date awardStartDate = Date.valueOf("2014-03-01");
        Date currentDate = Date.valueOf("2015-04-21");
        Date lastBilledDate = Date.valueOf("2014-04-15");
        Date expectedBillingPeriodStart = Date.valueOf("2014-04-01");
        Date expectedBillingPeriodEnd = Date.valueOf("2015-03-31");
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)this.accountingPeriodMock_2015_10);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(lastBilledDate)).thenReturn((Object)this.accountingPeriodMock_2014_10);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, (Date)lastBilledDate, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.MONTHLY, (AccountingPeriodService)this.accountingPeriodSvcMock);
        Assert.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assert.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assert.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    public void determineBillingPeriodPriorTo_Monthly_BillAwardInFuture() {
        Date awardStartDate = Date.valueOf("2015-07-01");
        Date currentDate = Date.valueOf("2015-04-21");
        Date previousPeriodEndDate = Date.valueOf("2015-03-31");
        Date expectedBillingPeriodStart = Date.valueOf("2015-03-01");
        Date expectedBillingPeriodEnd = Date.valueOf("2015-03-31");
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)this.accountingPeriodMock_2015_10);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(previousPeriodEndDate)).thenReturn((Object)this.accountingPeriodMock_2015_09);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, null, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.MONTHLY, (AccountingPeriodService)this.accountingPeriodSvcMock);
        Assert.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assert.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assert.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    public void determineBillingPeriodPriorTo_Predetermined_nullLastBilled_1() {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date currentDate = Date.valueOf("2015-04-21");
        Date expectedBillingPeriodStart = Date.valueOf("2014-07-01");
        Date expectedBillingPeriodEnd = Date.valueOf("2015-03-31");
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)this.accountingPeriodMock_2015_10);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, null, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING, (AccountingPeriodService)this.accountingPeriodSvcMock);
        Assert.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assert.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assert.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    public void determineBillingPeriodPriorTo_Predetermined_nullLastBilled_2() {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date currentDate = Date.valueOf("2015-03-21");
        Date expectedBillingPeriodStart = Date.valueOf("2014-07-01");
        Date expectedBillingPeriodEnd = Date.valueOf("2015-02-28");
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)this.accountingPeriodMock_2015_09);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, null, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING, (AccountingPeriodService)this.accountingPeriodSvcMock);
        Assert.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assert.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assert.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    public void determineBillingPeriodPriorTo_Predetermined_LastBilledLastMonth() {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date lastBilledDate = Date.valueOf("2015-03-29");
        Date currentDate = Date.valueOf("2015-04-21");
        Date expectedBillingPeriodStart = Date.valueOf("2015-03-01");
        Date expectedBillingPeriodEnd = Date.valueOf("2015-03-31");
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)this.accountingPeriodMock_2015_10);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(lastBilledDate)).thenReturn((Object)this.accountingPeriodMock_2015_09);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, (Date)lastBilledDate, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING, (AccountingPeriodService)this.accountingPeriodSvcMock);
        Assert.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assert.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assert.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    public void determineBillingPeriodPriorTo_Predetermined_LastBilledTwoMonthsAgo() {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date lastBilledDate = Date.valueOf("2015-02-17");
        Date currentDate = Date.valueOf("2015-04-21");
        Date expectedBillingPeriodStart = Date.valueOf("2015-02-01");
        Date expectedBillingPeriodEnd = Date.valueOf("2015-03-31");
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)this.accountingPeriodMock_2015_10);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(lastBilledDate)).thenReturn((Object)this.accountingPeriodMock_2015_08);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, (Date)lastBilledDate, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING, (AccountingPeriodService)this.accountingPeriodSvcMock);
        Assert.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assert.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assert.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    public void determineBillingPeriodPriorTo_Predetermined_SpanCalendarYears() {
        Date awardStartDate = Date.valueOf("2013-07-01");
        Date lastBilledDate = Date.valueOf("2014-06-15");
        Date currentDate = Date.valueOf("2015-04-21");
        Date expectedBillingPeriodStart = Date.valueOf("2014-06-01");
        Date expectedBillingPeriodEnd = Date.valueOf("2015-03-31");
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)this.accountingPeriodMock_2015_10);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(lastBilledDate)).thenReturn((Object)this.accountingPeriodMock_2014_12);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, (Date)lastBilledDate, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING, (AccountingPeriodService)this.accountingPeriodSvcMock);
        Assert.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assert.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assert.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    public void determineBillingPeriodPriorTo_Predetermined_MayNotBillNow() {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date currentDate = Date.valueOf("2015-04-21");
        Date lastBilledDate = Date.valueOf("2015-04-15");
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)this.accountingPeriodMock_2015_10);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(lastBilledDate)).thenReturn((Object)this.accountingPeriodMock_2015_10);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, (Date)lastBilledDate, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING, (AccountingPeriodService)this.accountingPeriodSvcMock);
        Assert.assertNull((Object)priorBillingPeriod.getStartDate());
        Assert.assertNull((Object)priorBillingPeriod.getEndDate());
        Assert.assertFalse((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    public void determineBillingPeriodPriorTo_Predetermined_MayBillNowLastYear() {
        Date awardStartDate = Date.valueOf("2014-03-01");
        Date currentDate = Date.valueOf("2015-04-21");
        Date lastBilledDate = Date.valueOf("2014-04-15");
        Date expectedBillingPeriodStart = Date.valueOf("2014-04-01");
        Date expectedBillingPeriodEnd = Date.valueOf("2015-03-31");
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)this.accountingPeriodMock_2015_10);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(lastBilledDate)).thenReturn((Object)this.accountingPeriodMock_2014_10);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, (Date)lastBilledDate, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING, (AccountingPeriodService)this.accountingPeriodSvcMock);
        Assert.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assert.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assert.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    public void determineBillingPeriodPriorTo_Milestone_nullLastBilled_1() {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date currentDate = Date.valueOf("2015-04-21");
        Date expectedBillingPeriodStart = Date.valueOf("2014-07-01");
        Date expectedBillingPeriodEnd = Date.valueOf("2015-03-31");
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)this.accountingPeriodMock_2015_10);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, null, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.MILESTONE, (AccountingPeriodService)this.accountingPeriodSvcMock);
        Assert.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assert.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assert.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    public void determineBillingPeriodPriorTo_Milestone_nullLastBilled_2() {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date currentDate = Date.valueOf("2015-03-21");
        Date expectedBillingPeriodStart = Date.valueOf("2014-07-01");
        Date expectedBillingPeriodEnd = Date.valueOf("2015-02-28");
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)this.accountingPeriodMock_2015_09);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, null, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.MILESTONE, (AccountingPeriodService)this.accountingPeriodSvcMock);
        Assert.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assert.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assert.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    public void determineBillingPeriodPriorTo_Milestone_LastBilledLastMonth() {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date lastBilledDate = Date.valueOf("2015-03-29");
        Date currentDate = Date.valueOf("2015-04-21");
        Date expectedBillingPeriodStart = Date.valueOf("2015-03-01");
        Date expectedBillingPeriodEnd = Date.valueOf("2015-03-31");
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)this.accountingPeriodMock_2015_10);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(lastBilledDate)).thenReturn((Object)this.accountingPeriodMock_2015_09);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, (Date)lastBilledDate, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.MILESTONE, (AccountingPeriodService)this.accountingPeriodSvcMock);
        Assert.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assert.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assert.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    public void determineBillingPeriodPriorTo_Milestone_LastBilledTwoMonthsAgo() {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date lastBilledDate = Date.valueOf("2015-02-17");
        Date currentDate = Date.valueOf("2015-04-21");
        Date expectedBillingPeriodStart = Date.valueOf("2015-02-01");
        Date expectedBillingPeriodEnd = Date.valueOf("2015-03-31");
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)this.accountingPeriodMock_2015_10);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(lastBilledDate)).thenReturn((Object)this.accountingPeriodMock_2015_08);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, (Date)lastBilledDate, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.MILESTONE, (AccountingPeriodService)this.accountingPeriodSvcMock);
        Assert.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assert.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assert.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    public void determineBillingPeriodPriorTo_Milestone_SpanCalendarYears() {
        Date awardStartDate = Date.valueOf("2013-07-01");
        Date lastBilledDate = Date.valueOf("2014-06-15");
        Date currentDate = Date.valueOf("2015-04-21");
        Date expectedBillingPeriodStart = Date.valueOf("2014-06-01");
        Date expectedBillingPeriodEnd = Date.valueOf("2015-03-31");
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)this.accountingPeriodMock_2015_10);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(lastBilledDate)).thenReturn((Object)this.accountingPeriodMock_2014_12);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, (Date)lastBilledDate, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.MILESTONE, (AccountingPeriodService)this.accountingPeriodSvcMock);
        Assert.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assert.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assert.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    public void determineBillingPeriodPriorTo_Milestone_MayNotBillNow() {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date currentDate = Date.valueOf("2015-04-21");
        Date lastBilledDate = Date.valueOf("2015-04-15");
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)this.accountingPeriodMock_2015_10);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(lastBilledDate)).thenReturn((Object)this.accountingPeriodMock_2015_10);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, (Date)lastBilledDate, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.MILESTONE, (AccountingPeriodService)this.accountingPeriodSvcMock);
        Assert.assertNull((Object)priorBillingPeriod.getStartDate());
        Assert.assertNull((Object)priorBillingPeriod.getEndDate());
        Assert.assertFalse((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    public void determineBillingPeriodPriorTo_Milestone_MayBillNowLastYear() {
        Date awardStartDate = Date.valueOf("2014-03-01");
        Date currentDate = Date.valueOf("2015-04-21");
        Date lastBilledDate = Date.valueOf("2014-04-15");
        Date expectedBillingPeriodStart = Date.valueOf("2014-04-01");
        Date expectedBillingPeriodEnd = Date.valueOf("2015-03-31");
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)this.accountingPeriodMock_2015_10);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(lastBilledDate)).thenReturn((Object)this.accountingPeriodMock_2014_10);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, (Date)lastBilledDate, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.MILESTONE, (AccountingPeriodService)this.accountingPeriodSvcMock);
        Assert.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assert.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assert.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    public void determineBillingPeriodPriorTo_Quarterly_nullLastBilled_1() {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date currentDate = Date.valueOf("2015-04-21");
        Date expectedBillingPeriodStart = Date.valueOf("2014-07-01");
        Date expectedBillingPeriodEnd = Date.valueOf("2015-03-31");
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)this.accountingPeriodMock_2015_10);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, null, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.QUARTERLY, (AccountingPeriodService)this.accountingPeriodSvcMock);
        Assert.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assert.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assert.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    public void determineBillingPeriodPriorTo_Quarterly_nullLastBilled_2() {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date currentDate = Date.valueOf("2015-08-21");
        Date expectedBillingPeriodStart = Date.valueOf("2014-07-01");
        Date expectedBillingPeriodEnd = Date.valueOf("2015-06-30");
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)this.accountingPeriodMock_2016_02);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, null, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.QUARTERLY, (AccountingPeriodService)this.accountingPeriodSvcMock);
        Assert.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assert.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assert.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    public void determineBillingPeriodPriorTo_Quarterly_MayNotBillNow() {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date currentDate = Date.valueOf("2015-04-21");
        Date lastBilledDate = Date.valueOf("2015-04-20");
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)this.accountingPeriodMock_2015_10);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(lastBilledDate)).thenReturn((Object)this.accountingPeriodMock_2015_10);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, (Date)lastBilledDate, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.QUARTERLY, (AccountingPeriodService)this.accountingPeriodSvcMock);
        Assert.assertNull((Object)priorBillingPeriod.getStartDate());
        Assert.assertNull((Object)priorBillingPeriod.getEndDate());
        Assert.assertFalse((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    public void determineBillingPeriodPriorTo_Quarterly_LastBilledEarlierQuarter() {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date currentDate = Date.valueOf("2015-08-21");
        Date lastBilledDate = Date.valueOf("2015-04-20");
        Date expectedBillingPeriodStart = Date.valueOf("2015-04-01");
        Date expectedBillingPeriodEnd = Date.valueOf("2015-06-30");
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)this.accountingPeriodMock_2016_02);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(lastBilledDate)).thenReturn((Object)this.accountingPeriodMock_2015_10);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, (Date)lastBilledDate, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.QUARTERLY, (AccountingPeriodService)this.accountingPeriodSvcMock);
        Assert.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assert.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assert.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    public void determineBillingPeriodPriorTo_Quarterly_LastBilledPreviousQuarter() {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date currentDate = Date.valueOf("2015-04-21");
        Date lastBilledDate = Date.valueOf("2015-03-29");
        Date expectedBillingPeriodStart = Date.valueOf("2015-01-01");
        Date expectedBillingPeriodEnd = Date.valueOf("2015-03-31");
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)this.accountingPeriodMock_2015_10);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(lastBilledDate)).thenReturn((Object)this.accountingPeriodMock_2015_09);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, (Date)lastBilledDate, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.QUARTERLY, (AccountingPeriodService)this.accountingPeriodSvcMock);
        Assert.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assert.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assert.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    public void determineBillingPeriodPriorTo_Quarterly_BillAwardInFuture() {
        Date awardStartDate = Date.valueOf("2015-07-01");
        Date currentDate = Date.valueOf("2015-04-21");
        Date previousPeriodEndDate = Date.valueOf("2015-03-31");
        Date expectedBillingPeriodStart = Date.valueOf("2015-01-01");
        Date expectedBillingPeriodEnd = Date.valueOf("2015-03-31");
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)this.accountingPeriodMock_2015_10);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(previousPeriodEndDate)).thenReturn((Object)this.accountingPeriodMock_2015_09);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, null, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.QUARTERLY, (AccountingPeriodService)this.accountingPeriodSvcMock);
        Assert.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assert.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assert.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    public void determineBillingPeriodPriorTo_Quarterly_BilledLastCalendarYear() {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date currentDate = Date.valueOf("2015-04-21");
        Date lastBilledDate = Date.valueOf("2014-11-15");
        Date expectedBillingPeriodStart = Date.valueOf("2014-10-01");
        Date expectedBillingPeriodEnd = Date.valueOf("2015-03-31");
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)this.accountingPeriodMock_2015_10);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(lastBilledDate)).thenReturn((Object)this.accountingPeriodMock_2015_05);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, (Date)lastBilledDate, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.QUARTERLY, (AccountingPeriodService)this.accountingPeriodSvcMock);
        Assert.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assert.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assert.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    public void determineBillingPeriodPriorTo_Quarterly_BilledLastFiscalYear() {
        Date awardStartDate = Date.valueOf("2013-07-01");
        Date currentDate = Date.valueOf("2015-04-21");
        Date lastBilledDate = Date.valueOf("2014-06-15");
        Date expectedBillingPeriodStart = Date.valueOf("2014-04-01");
        Date expectedBillingPeriodEnd = Date.valueOf("2015-03-31");
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)this.accountingPeriodMock_2015_10);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(lastBilledDate)).thenReturn((Object)this.accountingPeriodMock_2014_12);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, (Date)lastBilledDate, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.QUARTERLY, (AccountingPeriodService)this.accountingPeriodSvcMock);
        Assert.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assert.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assert.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    public void determineBillingPeriodPriorTo_SemiAnnual_nullLastBilled1() {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date currentDate = Date.valueOf("2015-04-21");
        Date expectedBillingPeriodStart = Date.valueOf("2014-07-01");
        Date expectedBillingPeriodEnd = Date.valueOf("2014-12-31");
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)this.accountingPeriodMock_2015_10);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, null, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.SEMI_ANNUALLY, (AccountingPeriodService)this.accountingPeriodSvcMock);
        Assert.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assert.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assert.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    public void determineBillingPeriodPriorTo_SemiAnnual_nullLastBilled2() {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date currentDate = Date.valueOf("2015-08-21");
        Date expectedBillingPeriodStart = Date.valueOf("2014-07-01");
        Date expectedBillingPeriodEnd = Date.valueOf("2015-06-30");
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)this.accountingPeriodMock_2016_02);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, null, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.SEMI_ANNUALLY, (AccountingPeriodService)this.accountingPeriodSvcMock);
        Assert.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assert.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assert.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    public void determineBillingPeriodPriorTo_SemiAnnual_MayNotBillNow() {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date currentDate = Date.valueOf("2015-04-21");
        Date lastBilledDate = Date.valueOf("2015-04-20");
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)this.accountingPeriodMock_2015_10);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(lastBilledDate)).thenReturn((Object)this.accountingPeriodMock_2015_10);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, (Date)lastBilledDate, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.SEMI_ANNUALLY, (AccountingPeriodService)this.accountingPeriodSvcMock);
        Assert.assertNull((Object)priorBillingPeriod.getStartDate());
        Assert.assertNull((Object)priorBillingPeriod.getEndDate());
        Assert.assertFalse((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    public void determineBillingPeriodPriorTo_SemiAnnual_LastBilledPreviousSemiAnnual() {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date currentDate = Date.valueOf("2015-08-21");
        Date lastBilledDate = Date.valueOf("2015-04-20");
        Date expectedBillingPeriodStart = Date.valueOf("2015-01-01");
        Date expectedBillingPeriodEnd = Date.valueOf("2015-06-30");
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)this.accountingPeriodMock_2016_02);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(lastBilledDate)).thenReturn((Object)this.accountingPeriodMock_2015_10);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, (Date)lastBilledDate, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.SEMI_ANNUALLY, (AccountingPeriodService)this.accountingPeriodSvcMock);
        Assert.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assert.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assert.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    public void determineBillingPeriodPriorTo_SemiAnnual_LastBilledEarlierSemiAnnual() {
        Date awardStartDate = Date.valueOf("2013-07-01");
        Date currentDate = Date.valueOf("2015-04-21");
        Date lastBilledDate = Date.valueOf("2014-11-29");
        Date expectedBillingPeriodStart = Date.valueOf("2014-07-01");
        Date expectedBillingPeriodEnd = Date.valueOf("2014-12-31");
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)this.accountingPeriodMock_2015_10);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(lastBilledDate)).thenReturn((Object)this.accountingPeriodMock_2015_05);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, (Date)lastBilledDate, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.SEMI_ANNUALLY, (AccountingPeriodService)this.accountingPeriodSvcMock);
        Assert.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assert.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assert.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    public void determineBillingPeriodPriorTo_SemiAnnual_BillAwardInFuture() {
        Date awardStartDate = Date.valueOf("2015-07-01");
        Date currentDate = Date.valueOf("2015-04-21");
        Date previousPeriodEndDate = Date.valueOf("2014-12-31");
        Date expectedBillingPeriodStart = Date.valueOf("2014-07-01");
        Date expectedBillingPeriodEnd = Date.valueOf("2014-12-31");
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)this.accountingPeriodMock_2015_10);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(previousPeriodEndDate)).thenReturn((Object)this.accountingPeriodMock_2015_06);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, null, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.SEMI_ANNUALLY, (AccountingPeriodService)this.accountingPeriodSvcMock);
        Assert.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assert.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assert.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    public void determineBillingPeriodPriorTo_Annual_nullLastBilled1() {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date currentDate = Date.valueOf("2015-08-21");
        Date expectedBillingPeriodStart = Date.valueOf("2014-07-01");
        Date expectedBillingPeriodEnd = Date.valueOf("2015-06-30");
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)this.accountingPeriodMock_2016_02);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, null, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.ANNUALLY, (AccountingPeriodService)this.accountingPeriodSvcMock);
        Assert.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assert.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assert.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    public void determineBillingPeriodPriorTo_Annual_MayNotBillNow() {
        Date awardStartDate = Date.valueOf("2013-07-01");
        Date currentDate = Date.valueOf("2015-06-21");
        Date lastBilledDate = Date.valueOf("2014-10-20");
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)this.accountingPeriodMock_2015_12);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(lastBilledDate)).thenReturn((Object)this.accountingPeriodMock_2015_04);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, (Date)lastBilledDate, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.ANNUALLY, (AccountingPeriodService)this.accountingPeriodSvcMock);
        Assert.assertNull((Object)priorBillingPeriod.getStartDate());
        Assert.assertNull((Object)priorBillingPeriod.getEndDate());
        Assert.assertFalse((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    public void determineBillingPeriodPriorTo_Annual_LastBilledPreviousAnnual() {
        Date awardStartDate = Date.valueOf("2013-07-01");
        Date currentDate = Date.valueOf("2015-08-21");
        Date lastBilledDate = Date.valueOf("2015-04-20");
        Date expectedBillingPeriodStart = Date.valueOf("2014-07-01");
        Date expectedBillingPeriodEnd = Date.valueOf("2015-06-30");
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)this.accountingPeriodMock_2016_02);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(lastBilledDate)).thenReturn((Object)this.accountingPeriodMock_2015_10);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, (Date)lastBilledDate, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.ANNUALLY, (AccountingPeriodService)this.accountingPeriodSvcMock);
        Assert.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assert.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assert.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    public void determineBillingPeriodPriorTo_Annual_LastBilledEarlierAnnual() {
        Date awardStartDate = Date.valueOf("2012-07-01");
        Date currentDate = Date.valueOf("2015-08-21");
        Date lastBilledDate = Date.valueOf("2013-11-20");
        Date expectedBillingPeriodStart = Date.valueOf("2013-07-01");
        Date expectedBillingPeriodEnd = Date.valueOf("2015-06-30");
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)this.accountingPeriodMock_2016_02);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(lastBilledDate)).thenReturn((Object)this.accountingPeriodMock_2014_05);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, (Date)lastBilledDate, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.ANNUALLY, (AccountingPeriodService)this.accountingPeriodSvcMock);
        Assert.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assert.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assert.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    public void determineBillingPeriodPriorTo_Annual_BillAwardInFuture() {
        Date awardStartDate = Date.valueOf("2015-07-01");
        Date currentDate = Date.valueOf("2015-04-21");
        Date previousPeriodEndDate = Date.valueOf("2014-06-30");
        Date expectedBillingPeriodStart = Date.valueOf("2013-07-01");
        Date expectedBillingPeriodEnd = Date.valueOf("2014-06-30");
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(currentDate)).thenReturn((Object)this.accountingPeriodMock_2015_10);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(previousPeriodEndDate)).thenReturn((Object)this.accountingPeriodMock_2014_12);
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, null, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.ANNUALLY, (AccountingPeriodService)this.accountingPeriodSvcMock);
        Assert.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assert.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assert.assertTrue((boolean)priorBillingPeriod.isBillable());
    }
}

