/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject.admin;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.krad.bo.BusinessObjectBase;
import org.kuali.kfs.module.ar.businessobject.Customer;
import org.kuali.kfs.module.ar.businessobject.admin.CustomerAdminService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@Execution(value=ExecutionMode.SAME_THREAD)
public class CustomerAdminServiceTest {
    private CustomerAdminService cut = new CustomerAdminService();
    @Mock
    private PermissionService permissionServiceMock;
    @Mock
    private Person userMock;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        this.cut.setPermissionService(this.permissionServiceMock);
        Mockito.when((Object)this.userMock.getPrincipalId()).thenReturn((Object)"1234");
    }

    @Test
    public void allowsCopy_returnsFalse() {
        Customer customer = new Customer();
        Assert.assertFalse((boolean)this.cut.allowsCopy((BusinessObjectBase)customer, this.userMock));
    }

    @Test
    public void allowsReport_permissionGranted_returnsTrue() {
        Mockito.when((Object)this.permissionServiceMock.isAuthorized((String)ArgumentMatchers.eq((Object)"1234"), (String)ArgumentMatchers.eq((Object)"KFS-AR"), (String)ArgumentMatchers.eq((Object)"Report"), ArgumentMatchers.anyMap())).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.cut.allowsReport(this.userMock));
    }

    @Test
    public void allowsReport_permissionDenied_returnsFalse() {
        Mockito.when((Object)this.permissionServiceMock.isAuthorized((String)ArgumentMatchers.eq((Object)"1234"), (String)ArgumentMatchers.eq((Object)"KFS-AR"), (String)ArgumentMatchers.eq((Object)"Report"), ArgumentMatchers.anyMap())).thenReturn((Object)false);
        Assert.assertFalse((boolean)this.cut.allowsReport(this.userMock));
    }
}

