/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject.admin;

import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.runner.RunWith;
import org.kuali.kfs.kns.service.MaintenanceDocumentDictionaryService;
import org.kuali.kfs.krad.bo.BusinessObjectBase;
import org.kuali.kfs.krad.service.DocumentDictionaryService;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.module.ar.businessobject.InvoiceTemplate;
import org.kuali.kfs.module.ar.businessobject.OrganizationOptions;
import org.kuali.kfs.module.ar.businessobject.admin.InvoiceTemplateAdminService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={KRADServiceLocatorWeb.class})
@PowerMockIgnore(value={"javax.management.*"})
@Execution(value=ExecutionMode.SAME_THREAD)
public class InvoiceTemplateAdminServiceTest {
    private InvoiceTemplateAdminService cut = new InvoiceTemplateAdminService();
    private InvoiceTemplate invoiceTemplate;
    private Map<String, String> roleQualifications = new HashMap<String, String>();
    @Mock
    private DocumentDictionaryService documentDictionaryServiceMock;
    @Mock
    private MaintenanceDocumentDictionaryService maintenanceDocumentDictionarySvcMock;
    @Mock
    private PermissionService permissionServiceMock;
    @Mock
    private Person personMock;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.cut.setDocumentDictionaryService(this.documentDictionaryServiceMock);
        this.cut.setMaintenanceDocumentDictionaryService(this.maintenanceDocumentDictionarySvcMock);
        this.cut.setPermissionService(this.permissionServiceMock);
        this.setupInvoiceTemplate();
        Mockito.when((Object)this.documentDictionaryServiceMock.getMaintenanceDocumentTypeName(OrganizationOptions.class)).thenReturn((Object)"ITM");
        Mockito.when((Object)this.maintenanceDocumentDictionarySvcMock.getDocumentTypeName(this.invoiceTemplate.getClass())).thenReturn((Object)"ITM");
        Mockito.when((Object)this.maintenanceDocumentDictionarySvcMock.getAllowsNewOrCopy("ITM")).thenReturn((Object)true);
        Mockito.when((Object)this.personMock.getPrincipalId()).thenReturn((Object)"khuntley");
        PowerMockito.mockStatic(KRADServiceLocatorWeb.class, (Class[])new Class[0]);
        KualiModuleService kualiModuleSvcMock = (KualiModuleService)Mockito.mock(KualiModuleService.class);
        Mockito.when((Object)KRADServiceLocatorWeb.getKualiModuleService()).thenReturn((Object)kualiModuleSvcMock);
        this.roleQualifications = this.cut.buildRoleQualifications((Object)this.invoiceTemplate, this.personMock.getPrincipalId());
    }

    private void setupInvoiceTemplate() {
        this.invoiceTemplate = new InvoiceTemplate();
        this.invoiceTemplate.setBillByChartOfAccountCode("BL");
        this.invoiceTemplate.setBilledByOrganizationCode("PSY");
    }

    @Test
    public void allowsCopy_nullBo_returnsFalse() {
        Assert.assertFalse((boolean)this.cut.allowsCopy(null, this.personMock));
    }

    @Test
    public void allowsCopy_nullDocType_returnsFalse() {
        this.isAuthorized();
        Mockito.when((Object)this.maintenanceDocumentDictionarySvcMock.getDocumentTypeName(this.invoiceTemplate.getClass())).thenReturn(null);
        Assert.assertFalse((boolean)this.cut.allowsCopy((BusinessObjectBase)this.invoiceTemplate, this.personMock));
    }

    private void isAuthorized() {
        Mockito.when((Object)this.permissionServiceMock.isAuthorizedByTemplate(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyMap(), (Map)ArgumentMatchers.eq(this.roleQualifications))).thenReturn((Object)true);
    }

    @Test
    public void allowsCopy_allowsNewOrCopyFalse_returnsFalse() {
        this.isAuthorized();
        Mockito.when((Object)this.maintenanceDocumentDictionarySvcMock.getAllowsNewOrCopy("ITM")).thenReturn((Object)false);
        Assert.assertFalse((boolean)this.cut.allowsCopy((BusinessObjectBase)this.invoiceTemplate, this.personMock));
    }

    @Test
    public void allowsCopy_createMaintainPermissionTrue_returnsTrue() {
        this.isAuthorized();
        Assert.assertTrue((boolean)this.cut.allowsCopy((BusinessObjectBase)this.invoiceTemplate, this.personMock));
    }

    @Test
    public void allowsCopy_createMaintainPermissionFalse_returnsFalse() {
        this.defaultAuthorizationToTrue();
        this.isNotAuthorized();
        Assert.assertFalse((boolean)this.cut.allowsCopy((BusinessObjectBase)this.invoiceTemplate, this.personMock));
    }

    private void defaultAuthorizationToTrue() {
        Mockito.when((Object)this.permissionServiceMock.isAuthorizedByTemplate(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyMap(), ArgumentMatchers.anyMap())).thenReturn((Object)true);
    }

    private void isNotAuthorized() {
        Mockito.when((Object)this.permissionServiceMock.isAuthorizedByTemplate(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyMap(), (Map)ArgumentMatchers.eq(this.roleQualifications))).thenReturn((Object)false);
    }

    @Test
    public void allowsEdit_createMaintainPermissionTrue_returnsTrue() {
        this.isAuthorized();
        Assert.assertTrue((boolean)this.cut.allowsEdit((BusinessObjectBase)this.invoiceTemplate, this.personMock));
    }

    @Test
    public void allowsEdit_createMaintainPermissionFalse_returnsFalse() {
        this.defaultAuthorizationToTrue();
        this.isNotAuthorized();
        Assert.assertFalse((boolean)this.cut.allowsEdit((BusinessObjectBase)this.invoiceTemplate, this.personMock));
    }
}

