/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject.admin;

import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.runner.RunWith;
import org.kuali.kfs.krad.bo.BusinessObjectBase;
import org.kuali.kfs.krad.service.DocumentDictionaryService;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.module.ar.businessobject.OrganizationOptions;
import org.kuali.kfs.module.ar.businessobject.admin.OrganizationOptionsAdminService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={KRADServiceLocatorWeb.class})
@PowerMockIgnore(value={"javax.management.*"})
@Execution(value=ExecutionMode.SAME_THREAD)
public class OrganizationOptionsAdminServiceTest {
    private OrganizationOptionsAdminService cut = new OrganizationOptionsAdminService();
    private OrganizationOptions organizationOptions;
    private Map<String, String> roleQualifications = new HashMap<String, String>();
    @Mock
    private DocumentDictionaryService documentDictionaryServiceMock;
    @Mock
    private PermissionService permissionServiceMock;
    @Mock
    private Person personMock;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.cut.setDocumentDictionaryService(this.documentDictionaryServiceMock);
        this.cut.setPermissionService(this.permissionServiceMock);
        Mockito.when((Object)this.documentDictionaryServiceMock.getMaintenanceDocumentTypeName(OrganizationOptions.class)).thenReturn((Object)"OOPT");
        Mockito.when((Object)this.personMock.getPrincipalId()).thenReturn((Object)"khuntley");
        PowerMockito.mockStatic(KRADServiceLocatorWeb.class, (Class[])new Class[0]);
        KualiModuleService kualiModuleSvcMock = (KualiModuleService)Mockito.mock(KualiModuleService.class);
        Mockito.when((Object)KRADServiceLocatorWeb.getKualiModuleService()).thenReturn((Object)kualiModuleSvcMock);
        this.setupOrganizationOptions();
        this.roleQualifications = this.cut.buildRoleQualifications((Object)this.organizationOptions, this.personMock.getPrincipalId());
    }

    private void setupOrganizationOptions() {
        this.organizationOptions = new OrganizationOptions();
        this.organizationOptions.setChartOfAccountsCode("BL");
        this.organizationOptions.setOrganizationCode("PSY");
        this.organizationOptions.setProcessingChartOfAccountCode("UA");
        this.organizationOptions.setProcessingOrganizationCode("VPIT");
    }

    @Test
    public void allowsEdit_createMaintainPermissionTrue_returnsTrue() {
        Mockito.when((Object)this.permissionServiceMock.isAuthorizedByTemplate(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyMap(), ArgumentMatchers.anyMap())).thenReturn((Object)false);
        Mockito.when((Object)this.permissionServiceMock.isAuthorizedByTemplate(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyMap(), (Map)ArgumentMatchers.eq(this.roleQualifications))).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.cut.allowsEdit((BusinessObjectBase)this.organizationOptions, this.personMock));
    }

    @Test
    public void allowsEdit_createMaintainPermissionFalse_returnsFalse() {
        Mockito.when((Object)this.permissionServiceMock.isAuthorizedByTemplate(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyMap(), ArgumentMatchers.anyMap())).thenReturn((Object)true);
        Mockito.when((Object)this.permissionServiceMock.isAuthorizedByTemplate(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyMap(), (Map)ArgumentMatchers.eq(this.roleQualifications))).thenReturn((Object)false);
        Assert.assertFalse((boolean)this.cut.allowsEdit((BusinessObjectBase)this.organizationOptions, this.personMock));
    }
}

