/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.runner.RunWith;
import org.kuali.kfs.kns.document.authorization.BusinessObjectRestrictions;
import org.kuali.kfs.kns.inquiry.Inquirable;
import org.kuali.kfs.kns.inquiry.KualiInquirableImpl;
import org.kuali.kfs.kns.service.BusinessObjectDictionaryService;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.kns.service.KNSServiceLocator;
import org.kuali.kfs.kns.service.SecurityLoggingService;
import org.kuali.kfs.kns.web.ui.ResultRow;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsInvoiceLookupResult;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsInvoiceLookupResultAward;
import org.kuali.kfs.module.ar.businessobject.lookup.ContractsGrantsInvoiceLookupableHelperServiceImpl;
import org.kuali.kfs.module.ar.report.service.ContractsGrantsReportHelperService;
import org.kuali.kfs.module.ar.report.service.impl.ContractsGrantsReportHelperServiceImpl;
import org.kuali.rice.kim.api.services.IdentityManagementService;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={KNSServiceLocator.class})
@Execution(value=ExecutionMode.SAME_THREAD)
public class ContractsGrantsInvoiceLookupableHelperServiceImplTest {
    private static final String PROPOSAL_NUMBER = "1";
    private static final String CHART_OF_ACCOUNTS_CODE = "BL";
    private static final String ACCOUNT_NUMBER = "1234567";
    private static final String ANOTHER_PROPOSAL_NUMBER = "2";
    private static final String ANOTHER_CHART_OF_ACCOUNTS_CODE = "BA";
    private static final String ANOTHER_ACCOUNT_NUMBER = "2345678";
    private static final String CHART_AND_ACCOUNT_FOR_NON_SCHEDULED = "-*-*";
    @Spy
    private ContractsGrantsInvoiceLookupableHelperServiceImpl cut = new ContractsGrantsInvoiceLookupableHelperServiceImpl();
    @Mock
    private BusinessObjectDictionaryService businessObjectDictionarySvcMock;
    @Mock
    private DataDictionaryService dataDictionarySvcMock;
    @Mock
    private IdentityManagementService identityManagementSvcMock;
    @Mock
    private SecurityLoggingService securityLoggingSvcMock;
    private BusinessObjectRestrictions businessObjectRestrictions;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeLabel((Class)ArgumentMatchers.eq(ContractsGrantsInvoiceLookupResult.class), ArgumentMatchers.anyString())).thenReturn((Object)"Attribute Label");
        PowerMockito.mockStatic(KNSServiceLocator.class, (Class[])new Class[0]);
        Mockito.when((Object)KNSServiceLocator.getSecurityLoggingService()).thenReturn((Object)this.securityLoggingSvcMock);
        ((ContractsGrantsInvoiceLookupableHelperServiceImpl)Mockito.doReturn((Object)"khuntley").when((Object)this.cut)).getPrincipalId();
        ((ContractsGrantsInvoiceLookupableHelperServiceImpl)Mockito.doReturn(null).when((Object)this.cut)).getPerson();
        this.cut.setBusinessObjectDictionaryService(this.businessObjectDictionarySvcMock);
        this.cut.setContractsGrantsReportHelperService((ContractsGrantsReportHelperService)new ContractsGrantsReportHelperServiceImpl());
        this.cut.setDataDictionaryService(this.dataDictionarySvcMock);
        this.cut.setIdentityManagementService(this.identityManagementSvcMock);
        this.cut.setKualiInquirable((Inquirable)new KualiInquirableImpl());
        this.businessObjectRestrictions = null;
    }

    @Test
    public void buildSubResultRows_MilestoneSchedule_differentAward_allShouldHaveObjectId() {
        ContractsGrantsInvoiceLookupResult result = new ContractsGrantsInvoiceLookupResult();
        Collection<ContractsGrantsInvoiceLookupResultAward> lookupResultAwards = this.setupLookupResultAwards(ArConstants.BillingFrequencyValues.MILESTONE.getCode(), ANOTHER_PROPOSAL_NUMBER, CHART_OF_ACCOUNTS_CODE, ACCOUNT_NUMBER);
        result.setLookupResultAwards(lookupResultAwards);
        List resultRows = this.cut.buildSubResultRows(result, this.businessObjectRestrictions);
        Assert.assertEquals((long)2L, (long)resultRows.size());
        Assert.assertEquals((Object)"1-BL-1234567", (Object)((ResultRow)resultRows.get(0)).getObjectId());
        Assert.assertEquals((Object)"2-BL-1234567", (Object)((ResultRow)resultRows.get(1)).getObjectId());
    }

    private Collection<ContractsGrantsInvoiceLookupResultAward> setupLookupResultAwards(String billingFrequencyCode, String secondAwardProposalNumber, String secondAwardChartOfAccountsCode, String secondAwardAccountNumber) {
        ArrayList<ContractsGrantsInvoiceLookupResultAward> lookupResultAwards = new ArrayList<ContractsGrantsInvoiceLookupResultAward>();
        ContractsGrantsInvoiceLookupResultAward lookupResultAward = this.setupLookupResultAward(billingFrequencyCode, PROPOSAL_NUMBER, CHART_OF_ACCOUNTS_CODE, ACCOUNT_NUMBER);
        ContractsGrantsInvoiceLookupResultAward lookupResultAward2 = this.setupLookupResultAward(billingFrequencyCode, secondAwardProposalNumber, secondAwardChartOfAccountsCode, secondAwardAccountNumber);
        lookupResultAwards.add(lookupResultAward);
        lookupResultAwards.add(lookupResultAward2);
        return lookupResultAwards;
    }

    private ContractsGrantsInvoiceLookupResultAward setupLookupResultAward(String billingFrequencyCode, String proposalNumber, String chartOfAccountsCode, String accountNumber) {
        ContractsGrantsInvoiceLookupResultAward lookupResultAward = new ContractsGrantsInvoiceLookupResultAward();
        lookupResultAward.setProposalNumber(proposalNumber);
        lookupResultAward.setChartOfAccountsCode(chartOfAccountsCode);
        lookupResultAward.setAccountNumber(accountNumber);
        lookupResultAward.setBillingFrequencyCode(billingFrequencyCode);
        return lookupResultAward;
    }

    @Test
    public void buildSubResultRows_MilestoneSchedule_sameAward_allShouldHaveObjectId() {
        ContractsGrantsInvoiceLookupResult result = new ContractsGrantsInvoiceLookupResult();
        Collection<ContractsGrantsInvoiceLookupResultAward> lookupResultAwards = this.setupLookupResultAwards(ArConstants.BillingFrequencyValues.MILESTONE.getCode(), PROPOSAL_NUMBER, ANOTHER_CHART_OF_ACCOUNTS_CODE, ANOTHER_ACCOUNT_NUMBER);
        result.setLookupResultAwards(lookupResultAwards);
        List resultRows = this.cut.buildSubResultRows(result, this.businessObjectRestrictions);
        Assert.assertEquals((long)2L, (long)resultRows.size());
        Assert.assertEquals((Object)"1-BL-1234567", (Object)((ResultRow)resultRows.get(0)).getObjectId());
        Assert.assertEquals((Object)"1-BA-2345678", (Object)((ResultRow)resultRows.get(1)).getObjectId());
    }

    @Test
    public void buildSubResultRows_PredeterminedBillingSchedule_differentAward_allShouldHaveObjectId() {
        ContractsGrantsInvoiceLookupResult result = new ContractsGrantsInvoiceLookupResult();
        Collection<ContractsGrantsInvoiceLookupResultAward> lookupResultAwards = this.setupLookupResultAwards(ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode(), ANOTHER_PROPOSAL_NUMBER, CHART_OF_ACCOUNTS_CODE, ACCOUNT_NUMBER);
        result.setLookupResultAwards(lookupResultAwards);
        List resultRows = this.cut.buildSubResultRows(result, this.businessObjectRestrictions);
        Assert.assertEquals((long)2L, (long)resultRows.size());
        Assert.assertEquals((Object)"1-BL-1234567", (Object)((ResultRow)resultRows.get(0)).getObjectId());
        Assert.assertEquals((Object)"2-BL-1234567", (Object)((ResultRow)resultRows.get(1)).getObjectId());
    }

    @Test
    public void buildSubResultRows_PredeterminedBillingSchedule_sameAward_allShouldHaveObjectId() {
        ContractsGrantsInvoiceLookupResult result = new ContractsGrantsInvoiceLookupResult();
        Collection<ContractsGrantsInvoiceLookupResultAward> lookupResultAwards = this.setupLookupResultAwards(ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode(), PROPOSAL_NUMBER, ANOTHER_CHART_OF_ACCOUNTS_CODE, ANOTHER_ACCOUNT_NUMBER);
        result.setLookupResultAwards(lookupResultAwards);
        List resultRows = this.cut.buildSubResultRows(result, this.businessObjectRestrictions);
        Assert.assertEquals((long)2L, (long)resultRows.size());
        Assert.assertEquals((Object)"1-BL-1234567", (Object)((ResultRow)resultRows.get(0)).getObjectId());
        Assert.assertEquals((Object)"1-BA-2345678", (Object)((ResultRow)resultRows.get(1)).getObjectId());
    }

    @Test
    public void buildSubResultRows_Monthly_sameAward_onlyFirstShouldHaveObjectId() {
        ContractsGrantsInvoiceLookupResult result = new ContractsGrantsInvoiceLookupResult();
        Collection<ContractsGrantsInvoiceLookupResultAward> lookupResultAwards = this.setupLookupResultAwards(ArConstants.BillingFrequencyValues.MONTHLY.getCode(), PROPOSAL_NUMBER, ANOTHER_CHART_OF_ACCOUNTS_CODE, ANOTHER_ACCOUNT_NUMBER);
        result.setLookupResultAwards(lookupResultAwards);
        List resultRows = this.cut.buildSubResultRows(result, this.businessObjectRestrictions);
        Assert.assertEquals((long)2L, (long)resultRows.size());
        Assert.assertEquals((Object)"1-*-*", (Object)((ResultRow)resultRows.get(0)).getObjectId());
        Assert.assertNull((Object)((ResultRow)resultRows.get(1)).getObjectId());
    }

    @Test
    public void buildSubResultRows_Monthly_differentAward_allShouldHaveObjectId() {
        ContractsGrantsInvoiceLookupResult result = new ContractsGrantsInvoiceLookupResult();
        Collection<ContractsGrantsInvoiceLookupResultAward> lookupResultAwards = this.setupLookupResultAwards(ArConstants.BillingFrequencyValues.MONTHLY.getCode(), ANOTHER_PROPOSAL_NUMBER, CHART_OF_ACCOUNTS_CODE, ACCOUNT_NUMBER);
        result.setLookupResultAwards(lookupResultAwards);
        List resultRows = this.cut.buildSubResultRows(result, this.businessObjectRestrictions);
        Assert.assertEquals((long)2L, (long)resultRows.size());
        Assert.assertEquals((Object)"1-*-*", (Object)((ResultRow)resultRows.get(0)).getObjectId());
        Assert.assertEquals((Object)"2-*-*", (Object)((ResultRow)resultRows.get(1)).getObjectId());
    }

    @Test
    public void buildSubResultRows_Quarterly_sameAward_onlyFirstShouldHaveObjectId() {
        ContractsGrantsInvoiceLookupResult result = new ContractsGrantsInvoiceLookupResult();
        Collection<ContractsGrantsInvoiceLookupResultAward> lookupResultAwards = this.setupLookupResultAwards(ArConstants.BillingFrequencyValues.QUARTERLY.getCode(), PROPOSAL_NUMBER, ANOTHER_CHART_OF_ACCOUNTS_CODE, ANOTHER_ACCOUNT_NUMBER);
        result.setLookupResultAwards(lookupResultAwards);
        List resultRows = this.cut.buildSubResultRows(result, this.businessObjectRestrictions);
        Assert.assertEquals((long)2L, (long)resultRows.size());
        Assert.assertEquals((Object)"1-*-*", (Object)((ResultRow)resultRows.get(0)).getObjectId());
        Assert.assertNull((Object)((ResultRow)resultRows.get(1)).getObjectId());
    }

    @Test
    public void buildSubResultRows_Quarterly_differentAward_allShouldHaveObjectId() {
        ContractsGrantsInvoiceLookupResult result = new ContractsGrantsInvoiceLookupResult();
        Collection<ContractsGrantsInvoiceLookupResultAward> lookupResultAwards = this.setupLookupResultAwards(ArConstants.BillingFrequencyValues.QUARTERLY.getCode(), ANOTHER_PROPOSAL_NUMBER, CHART_OF_ACCOUNTS_CODE, ACCOUNT_NUMBER);
        result.setLookupResultAwards(lookupResultAwards);
        List resultRows = this.cut.buildSubResultRows(result, this.businessObjectRestrictions);
        Assert.assertEquals((long)2L, (long)resultRows.size());
        Assert.assertEquals((Object)"1-*-*", (Object)((ResultRow)resultRows.get(0)).getObjectId());
        Assert.assertEquals((Object)"2-*-*", (Object)((ResultRow)resultRows.get(1)).getObjectId());
    }

    @Test
    public void filterSearchResults_NullAwards() {
        ArrayList<ContractsGrantsInvoiceLookupResult> searchResultsCollection = new ArrayList<ContractsGrantsInvoiceLookupResult>();
        ContractsGrantsInvoiceLookupResult result = new ContractsGrantsInvoiceLookupResult();
        Collection<ContractsGrantsInvoiceLookupResultAward> lookupResultAwards = this.setupLookupResultAwards(ArConstants.BillingFrequencyValues.MONTHLY.getCode(), ANOTHER_PROPOSAL_NUMBER, CHART_OF_ACCOUNTS_CODE, ACCOUNT_NUMBER);
        result.setLookupResultAwards(lookupResultAwards);
        searchResultsCollection.add(result);
        this.cut.filterSearchResults(searchResultsCollection);
        Assert.assertEquals((long)0L, (long)searchResultsCollection.size());
    }

    @Test
    public void filterSearchResults_NoAwards() {
        ArrayList<ContractsGrantsInvoiceLookupResult> searchResultsCollection = new ArrayList<ContractsGrantsInvoiceLookupResult>();
        ContractsGrantsInvoiceLookupResult result = new ContractsGrantsInvoiceLookupResult();
        result.setLookupResultAwards((Collection)Collections.EMPTY_SET);
        searchResultsCollection.add(result);
        this.cut.filterSearchResults(searchResultsCollection);
        Assert.assertEquals((long)0L, (long)searchResultsCollection.size());
    }

    @Test
    public void filterSearchResults_TwoAwards_NoPermission() {
        ArrayList<ContractsGrantsInvoiceLookupResult> searchResultsCollection = new ArrayList<ContractsGrantsInvoiceLookupResult>();
        ContractsGrantsInvoiceLookupResult result = new ContractsGrantsInvoiceLookupResult();
        Collection<ContractsGrantsInvoiceLookupResultAward> lookupResultAwards = this.setupLookupResultAwards(ArConstants.BillingFrequencyValues.MONTHLY.getCode(), ANOTHER_PROPOSAL_NUMBER, CHART_OF_ACCOUNTS_CODE, ACCOUNT_NUMBER);
        result.setLookupResultAwards(lookupResultAwards);
        searchResultsCollection.add(result);
        this.setupInitiateDocumentPermission(PROPOSAL_NUMBER, false);
        this.setupInitiateDocumentPermission(ANOTHER_PROPOSAL_NUMBER, false);
        this.cut.filterSearchResults(searchResultsCollection);
        Assert.assertEquals((long)0L, (long)searchResultsCollection.size());
    }

    private void setupInitiateDocumentPermission(String proposalNumber, boolean hasPermission) {
        HashMap<String, String> permissionDetails = new HashMap<String, String>();
        permissionDetails.put("documentTypeName", "CINV");
        HashMap<String, String> qualificationDetails = new HashMap<String, String>();
        qualificationDetails.put("proposalNumber", proposalNumber);
        Mockito.when((Object)this.identityManagementSvcMock.isAuthorizedByTemplateName("khuntley", "KR-SYS", "Initiate Document", permissionDetails, qualificationDetails)).thenReturn((Object)hasPermission);
    }

    @Test
    public void filterSearchResults_TwoAwards_BothHavePermission() {
        ArrayList<ContractsGrantsInvoiceLookupResult> searchResultsCollection = new ArrayList<ContractsGrantsInvoiceLookupResult>();
        ContractsGrantsInvoiceLookupResult result = new ContractsGrantsInvoiceLookupResult();
        Collection<ContractsGrantsInvoiceLookupResultAward> lookupResultAwards = this.setupLookupResultAwards(ArConstants.BillingFrequencyValues.MONTHLY.getCode(), ANOTHER_PROPOSAL_NUMBER, CHART_OF_ACCOUNTS_CODE, ACCOUNT_NUMBER);
        result.setLookupResultAwards(lookupResultAwards);
        searchResultsCollection.add(result);
        this.setupInitiateDocumentPermission(PROPOSAL_NUMBER, true);
        this.setupInitiateDocumentPermission(ANOTHER_PROPOSAL_NUMBER, true);
        this.cut.filterSearchResults(searchResultsCollection);
        Assert.assertEquals((long)1L, (long)searchResultsCollection.size());
        Assert.assertEquals((long)2L, (long)((ContractsGrantsInvoiceLookupResult)searchResultsCollection.get(0)).getLookupResultAwards().size());
    }

    @Test
    public void filterSearchResults_TwoAwardAccounts_OnlyOneHasPermission() {
        ArrayList<ContractsGrantsInvoiceLookupResult> searchResultsCollection = new ArrayList<ContractsGrantsInvoiceLookupResult>();
        ContractsGrantsInvoiceLookupResult result = new ContractsGrantsInvoiceLookupResult();
        Collection<ContractsGrantsInvoiceLookupResultAward> lookupResultAwards = this.setupLookupResultAwards(ArConstants.BillingFrequencyValues.MONTHLY.getCode(), ANOTHER_PROPOSAL_NUMBER, CHART_OF_ACCOUNTS_CODE, ACCOUNT_NUMBER);
        result.setLookupResultAwards(lookupResultAwards);
        searchResultsCollection.add(result);
        this.setupInitiateDocumentPermission(PROPOSAL_NUMBER, false);
        this.setupInitiateDocumentPermission(ANOTHER_PROPOSAL_NUMBER, true);
        this.cut.filterSearchResults(searchResultsCollection);
        Assert.assertEquals((long)1L, (long)searchResultsCollection.size());
        Assert.assertEquals((long)1L, (long)((ContractsGrantsInvoiceLookupResult)searchResultsCollection.get(0)).getLookupResultAwards().size());
        Assert.assertEquals((Object)ANOTHER_PROPOSAL_NUMBER, (Object)((ContractsGrantsInvoiceLookupResultAward)((ContractsGrantsInvoiceLookupResult)searchResultsCollection.get(0)).getLookupResultAwards().iterator().next()).getProposalNumber());
    }

    @Test
    public void filterSearchResults_TwoResultsWithTwoAwardAccountsEach_OnlyOneHasPermission() {
        ArrayList<ContractsGrantsInvoiceLookupResult> searchResultsCollection = new ArrayList<ContractsGrantsInvoiceLookupResult>();
        ContractsGrantsInvoiceLookupResult result = new ContractsGrantsInvoiceLookupResult();
        Collection<ContractsGrantsInvoiceLookupResultAward> lookupResultAwards = this.setupLookupResultAwards(ArConstants.BillingFrequencyValues.MONTHLY.getCode(), ANOTHER_PROPOSAL_NUMBER, CHART_OF_ACCOUNTS_CODE, ACCOUNT_NUMBER);
        result.setLookupResultAwards(lookupResultAwards);
        searchResultsCollection.add(result);
        ContractsGrantsInvoiceLookupResult anotherResult = new ContractsGrantsInvoiceLookupResult();
        Collection<ContractsGrantsInvoiceLookupResultAward> moreLookupResultAwards = this.setupLookupResultAwards(ArConstants.BillingFrequencyValues.MONTHLY.getCode(), ANOTHER_PROPOSAL_NUMBER, CHART_OF_ACCOUNTS_CODE, ACCOUNT_NUMBER);
        anotherResult.setLookupResultAwards(moreLookupResultAwards);
        searchResultsCollection.add(anotherResult);
        this.setupInitiateDocumentPermission(PROPOSAL_NUMBER, false);
        this.setupInitiateDocumentPermission(ANOTHER_PROPOSAL_NUMBER, true);
        this.cut.filterSearchResults(searchResultsCollection);
        Assert.assertEquals((long)2L, (long)searchResultsCollection.size());
        Assert.assertEquals((long)1L, (long)((ContractsGrantsInvoiceLookupResult)searchResultsCollection.get(0)).getLookupResultAwards().size());
        Assert.assertEquals((Object)ANOTHER_PROPOSAL_NUMBER, (Object)((ContractsGrantsInvoiceLookupResultAward)((ContractsGrantsInvoiceLookupResult)searchResultsCollection.get(0)).getLookupResultAwards().iterator().next()).getProposalNumber());
        Assert.assertEquals((long)1L, (long)((ContractsGrantsInvoiceLookupResult)searchResultsCollection.get(1)).getLookupResultAwards().size());
        Assert.assertEquals((Object)ANOTHER_PROPOSAL_NUMBER, (Object)((ContractsGrantsInvoiceLookupResultAward)((ContractsGrantsInvoiceLookupResult)searchResultsCollection.get(1)).getLookupResultAwards().iterator().next()).getProposalNumber());
    }

    @Test
    public void filterSearchResults_TwoResultsWithTwoAwardAccountsEach_BothHavePermission() {
        ArrayList<ContractsGrantsInvoiceLookupResult> searchResultsCollection = new ArrayList<ContractsGrantsInvoiceLookupResult>();
        ContractsGrantsInvoiceLookupResult result = new ContractsGrantsInvoiceLookupResult();
        Collection<ContractsGrantsInvoiceLookupResultAward> lookupResultAwards = this.setupLookupResultAwards(ArConstants.BillingFrequencyValues.MONTHLY.getCode(), ANOTHER_PROPOSAL_NUMBER, CHART_OF_ACCOUNTS_CODE, ACCOUNT_NUMBER);
        result.setLookupResultAwards(lookupResultAwards);
        searchResultsCollection.add(result);
        ContractsGrantsInvoiceLookupResult anotherResult = new ContractsGrantsInvoiceLookupResult();
        Collection<ContractsGrantsInvoiceLookupResultAward> moreLookupResultAwards = this.setupLookupResultAwards(ArConstants.BillingFrequencyValues.MONTHLY.getCode(), ANOTHER_PROPOSAL_NUMBER, CHART_OF_ACCOUNTS_CODE, ACCOUNT_NUMBER);
        anotherResult.setLookupResultAwards(moreLookupResultAwards);
        searchResultsCollection.add(anotherResult);
        this.setupInitiateDocumentPermission(PROPOSAL_NUMBER, true);
        this.setupInitiateDocumentPermission(ANOTHER_PROPOSAL_NUMBER, true);
        this.cut.filterSearchResults(searchResultsCollection);
        Assert.assertEquals((long)2L, (long)searchResultsCollection.size());
        Assert.assertEquals((long)2L, (long)((ContractsGrantsInvoiceLookupResult)searchResultsCollection.get(0)).getLookupResultAwards().size());
        Assert.assertEquals((long)2L, (long)((ContractsGrantsInvoiceLookupResult)searchResultsCollection.get(1)).getLookupResultAwards().size());
    }
}

