/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.runner.RunWith;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentHeaderService;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.module.ar.businessobject.CashControlDetail;
import org.kuali.kfs.module.ar.document.PaymentApplicationDocument;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.GeneralLedgerPendingEntryService;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={KRADServiceLocatorWeb.class, SpringContext.class})
@Execution(value=ExecutionMode.SAME_THREAD)
public class PaymentApplicationDocumentTest {
    private PaymentApplicationDocument cut;
    @Mock
    private BusinessObjectService businessObjectSvcMock;
    @Mock
    private FinancialSystemDocumentHeader financialSystemDocumentHeaderMock;
    @Mock
    private GeneralLedgerPendingEntryService glpeSvcMock;
    @Mock
    private WorkflowDocument workflowDocMock;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        PowerMockito.mockStatic(KRADServiceLocatorWeb.class, (Class[])new Class[0]);
        DocumentHeaderService docHeaderSvcMock = (DocumentHeaderService)Mockito.mock(DocumentHeaderService.class);
        Mockito.when((Object)KRADServiceLocatorWeb.getDocumentHeaderService()).thenReturn((Object)docHeaderSvcMock);
        Class<FinancialSystemDocumentHeader> clazz = FinancialSystemDocumentHeader.class;
        Mockito.when((Object)docHeaderSvcMock.getDocumentHeaderBaseClass()).thenReturn(clazz);
        Mockito.when((Object)this.financialSystemDocumentHeaderMock.getWorkflowDocument()).thenReturn((Object)this.workflowDocMock);
        this.cut = new PaymentApplicationDocument();
        this.cut.setBusinessObjectService(this.businessObjectSvcMock);
        this.cut.setDocumentHeader((DocumentHeader)this.financialSystemDocumentHeaderMock);
        this.cut.setGlpeService(this.glpeSvcMock);
    }

    @Test
    public void doRouteStatusChange_Disapproved_CashControlUpdatedAndSaved() {
        Mockito.when((Object)this.workflowDocMock.isDisapproved()).thenReturn((Object)true);
        Mockito.when((Object)this.workflowDocMock.getStatus()).thenReturn((Object)DocumentStatus.DISAPPROVED);
        CashControlDetail cashControlDetail = new CashControlDetail();
        cashControlDetail.setFinancialDocumentLineAmount(new KualiDecimal(1000.0));
        this.cut.setCashControlDetail(cashControlDetail);
        DocumentRouteStatusChange statusChangeEvent = new DocumentRouteStatusChange(null, null, DocumentStatus.ENROUTE.getCode(), DocumentStatus.DISAPPROVED.getCode());
        this.cut.doRouteStatusChange(statusChangeEvent);
        Assert.assertEquals((Object)KualiDecimal.ZERO, (Object)cashControlDetail.getFinancialDocumentLineAmount());
        ((BusinessObjectService)Mockito.verify((Object)this.businessObjectSvcMock)).save((PersistableBusinessObject)cashControlDetail);
    }

    @Test
    public void doRouteStatusChange_Enroute_CashControlUnchanged() {
        Mockito.when((Object)this.workflowDocMock.isEnroute()).thenReturn((Object)true);
        Mockito.when((Object)this.workflowDocMock.getStatus()).thenReturn((Object)DocumentStatus.ENROUTE);
        CashControlDetail cashControlDetail = new CashControlDetail();
        cashControlDetail.setFinancialDocumentLineAmount(new KualiDecimal(1000.0));
        this.cut.setCashControlDetail(cashControlDetail);
        DocumentRouteStatusChange statusChangeEvent = new DocumentRouteStatusChange(null, null, DocumentStatus.SAVED.getCode(), DocumentStatus.ENROUTE.getCode());
        this.cut.doRouteStatusChange(statusChangeEvent);
        Assert.assertEquals((Object)new KualiDecimal(1000.0), (Object)cashControlDetail.getFinancialDocumentLineAmount());
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.businessObjectSvcMock});
    }
}

