/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.service;

import java.sql.Date;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.runner.RunWith;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAgency;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAwardAccount;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.krad.service.LookupService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.businessobject.AccountsReceivableDocumentHeader;
import org.kuali.kfs.module.ar.businessobject.Customer;
import org.kuali.kfs.module.ar.businessobject.InvoiceAddressDetail;
import org.kuali.kfs.module.ar.businessobject.InvoiceGeneralDetail;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsInvoiceDocumentService;
import org.kuali.kfs.module.ar.fixture.ARAgencyMockFixture;
import org.kuali.kfs.module.ar.fixture.ARAwardAccountMockFixture;
import org.kuali.kfs.module.ar.fixture.ARAwardMockFixture;
import org.kuali.kfs.module.ar.report.service.ContractsGrantsReportHelperService;
import org.kuali.kfs.module.ar.report.service.impl.ContractsGrantsAgingReportServiceImpl;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.kuali.rice.kim.api.identity.Person;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={GlobalVariables.class})
@Execution(value=ExecutionMode.SAME_THREAD)
public class ContractsGrantsAgingReportServiceTest {
    private static final String CUSTOMER_NUMBER = "ABB2";
    private static final String CUSTOMER_NAME = "WOODS CORPORATION";
    private static final String NON_MATCHING_CUSTOMER_NUMBER = "XXXX";
    private ContractsGrantsAgingReportServiceImpl cut;
    @Mock
    private ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentSvcMock;
    @Mock
    private ContractsGrantsReportHelperService contractsGrantsReportHelperSvcMock;
    @Mock
    private LookupService lookupSvcMock;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        PowerMockito.mockStatic(GlobalVariables.class, (Class[])new Class[0]);
        UserSession userSessionMock = (UserSession)Mockito.mock(UserSession.class);
        Mockito.when((Object)GlobalVariables.getUserSession()).thenReturn((Object)userSessionMock);
        Mockito.when((Object)userSessionMock.getPerson()).thenReturn(Mockito.mock(Person.class));
        ContractsAndGrantsBillingAward awardMock = ARAwardMockFixture.CG_AWARD_MONTHLY_BILLED_DATE_NULL.createAwardMock();
        ContractsAndGrantsBillingAwardAccount awardAccountMock = ARAwardAccountMockFixture.AWD_ACCT_1.createAwardAccountMock();
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks.add(awardAccountMock);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(awardAccountMocks);
        ContractsAndGrantsBillingAgency agencyMock = ARAgencyMockFixture.CG_AGENCY1.createAgencyMock();
        Mockito.when((Object)awardMock.getAgency()).thenReturn((Object)agencyMock);
        String agencyNumber = agencyMock.getAgencyNumber();
        Mockito.when((Object)awardMock.getAgencyNumber()).thenReturn((Object)agencyNumber);
        ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock = (ContractsGrantsInvoiceDocument)Mockito.mock(ContractsGrantsInvoiceDocument.class);
        FinancialSystemDocumentHeader documentHeader = new FinancialSystemDocumentHeader();
        documentHeader.setFinancialDocumentStatusCode("A");
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getFinancialSystemDocumentHeader()).thenReturn((Object)documentHeader);
        AccountsReceivableDocumentHeader accountsReceivableDocumentHeader = new AccountsReceivableDocumentHeader();
        accountsReceivableDocumentHeader.setCustomerNumber(CUSTOMER_NUMBER);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getAccountsReceivableDocumentHeader()).thenReturn((Object)accountsReceivableDocumentHeader);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getDocumentNumber()).thenReturn((Object)"12345");
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getBillingDate()).thenReturn((Object)new Date(new java.util.Date().getTime()));
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.isOpenInvoiceIndicator()).thenReturn((Object)true);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getCustomerName()).thenReturn((Object)CUSTOMER_NAME);
        Customer customerMock = (Customer)Mockito.mock(Customer.class);
        Mockito.when((Object)customerMock.getCustomerNumber()).thenReturn((Object)CUSTOMER_NUMBER);
        Mockito.when((Object)customerMock.getCustomerName()).thenReturn((Object)CUSTOMER_NAME);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getCustomer()).thenReturn((Object)customerMock);
        InvoiceGeneralDetail invoiceGeneralDetailMock = (InvoiceGeneralDetail)Mockito.mock(InvoiceGeneralDetail.class);
        Mockito.when((Object)invoiceGeneralDetailMock.getAward()).thenReturn((Object)awardMock);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail()).thenReturn((Object)invoiceGeneralDetailMock);
        ArrayList<InvoiceAddressDetail> invoiceAddressDetails = new ArrayList<InvoiceAddressDetail>();
        InvoiceAddressDetail invoiceAddressDetail = new InvoiceAddressDetail();
        invoiceAddressDetail.setCustomerInvoiceTemplateCode("STD");
        invoiceAddressDetail.setInvoiceTransmissionMethodCode("MAIL");
        invoiceAddressDetails.add(invoiceAddressDetail);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getInvoiceAddressDetails()).thenReturn(invoiceAddressDetails);
        HashMap<String, String> formProps = new HashMap<String, String>();
        formProps.put("accountsReceivableDocumentHeader.customerNumber", CUSTOMER_NUMBER);
        formProps.put("documentHeader.workflowDocumentTypeName", "CINV");
        formProps.put("openInvoiceIndicator", "true");
        ArrayList<ContractsGrantsInvoiceDocument> invoices = new ArrayList<ContractsGrantsInvoiceDocument>();
        invoices.add(contractsGrantsInvoiceDocumentMock);
        Mockito.when((Object)this.lookupSvcMock.findCollectionBySearch(ContractsGrantsInvoiceDocument.class, formProps)).thenReturn(invoices);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentSvcMock.canViewInvoice(contractsGrantsInvoiceDocumentMock, null)).thenReturn((Object)true);
        this.cut = new ContractsGrantsAgingReportServiceImpl();
        this.cut.setContractsGrantsInvoiceDocumentService(this.contractsGrantsInvoiceDocumentSvcMock);
        this.cut.setContractsGrantsReportHelperService(this.contractsGrantsReportHelperSvcMock);
        this.cut.setLookupService(this.lookupSvcMock);
    }

    @Test
    public void filterContractsGrantsAgingReport() throws ParseException {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("customerNumber", CUSTOMER_NUMBER);
        Map customerMap = this.cut.filterContractsGrantsAgingReport(fieldValues, null, null);
        Assert.assertNotNull((Object)customerMap);
        List invoices = (List)customerMap.get("ABB2-WOODS CORPORATION");
        Assert.assertNotNull((Object)invoices);
        Assert.assertEquals((long)1L, (long)invoices.size());
        ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument = (ContractsGrantsInvoiceDocument)invoices.get(0);
        Assert.assertNotNull((Object)contractsGrantsInvoiceDocument);
        Assert.assertEquals((Object)"12345", (Object)contractsGrantsInvoiceDocument.getDocumentNumber());
    }

    @Test
    public void filterContractsGrantsAgingReport_NoMatchingCustomers() throws ParseException {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("customerNumber", NON_MATCHING_CUSTOMER_NUMBER);
        Map customerMap = this.cut.filterContractsGrantsAgingReport(fieldValues, null, null);
        Assert.assertNull((Object)customerMap);
    }
}

