/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.service;

import java.sql.Date;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAwardAccount;
import org.kuali.kfs.integration.cg.ContractsAndGrantsFundManager;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.businessobject.Bill;
import org.kuali.kfs.module.ar.businessobject.InvoiceAccountDetail;
import org.kuali.kfs.module.ar.businessobject.Milestone;
import org.kuali.kfs.module.ar.businessobject.OrganizationAccountingDefault;
import org.kuali.kfs.module.ar.businessobject.SystemInformation;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsInvoiceDocumentService;
import org.kuali.kfs.module.ar.document.service.impl.ContractsGrantsBillingAwardVerificationServiceImpl;
import org.kuali.kfs.sys.businessobject.ChartOrgHolderImpl;
import org.kuali.kfs.sys.document.service.FinancialSystemDocumentService;
import org.kuali.kfs.sys.document.service.impl.FinancialSystemDocumentServiceImpl;
import org.kuali.kfs.sys.service.FinancialSystemUserService;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kim.api.identity.Person;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@Execution(value=ExecutionMode.SAME_THREAD)
public class ContractsGrantsBillingAwardVerificationServiceTest {
    private static final String ACCOUNT_NUMBER = "1234567";
    private static final String ANOTHER_ACCOUNT_NUMBER = "2345678";
    private static final String PROPOSAL_NUMBER = "1";
    private ContractsGrantsBillingAwardVerificationServiceImpl cut;
    @Mock
    private BusinessObjectService businessObjectSvcMock;
    @Mock
    private ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocSvcMock;
    @Mock
    private UniversityDateService universityDateSvcMock;
    @Mock
    private FinancialSystemUserService financialSystemUserServiceMock;
    @Mock
    private ContractsAndGrantsFundManager awardFundManagerMock;
    @Mock
    private ContractsAndGrantsBillingAward awardMock;
    @Mock
    private Person fundManagerMock;
    private FinancialSystemDocumentServiceImpl financialSystemDocumentService;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.awardMock.getProposalNumber()).thenReturn((Object)PROPOSAL_NUMBER);
        this.financialSystemDocumentService = new FinancialSystemDocumentServiceImpl();
        this.cut = new ContractsGrantsBillingAwardVerificationServiceImpl();
        this.cut.setBusinessObjectService(this.businessObjectSvcMock);
        this.cut.setContractsGrantsInvoiceDocumentService(this.contractsGrantsInvoiceDocSvcMock);
        this.cut.setUniversityDateService(this.universityDateSvcMock);
        this.cut.setFinancialSystemUserService(this.financialSystemUserServiceMock);
        this.cut.setFinancialSystemDocumentService((FinancialSystemDocumentService)this.financialSystemDocumentService);
    }

    private void executeIsChartAndOrgSetupForInvoicingTest(boolean hasPrimaryAwardOrganization, boolean hasProcessing, boolean hasOrganizationAccountingDefault, boolean hasSystemInformation, boolean expectedResult) {
        ContractsAndGrantsBillingAward award = (ContractsAndGrantsBillingAward)Mockito.mock(ContractsAndGrantsBillingAward.class);
        if (hasPrimaryAwardOrganization) {
            String FUND_MANAGER_PRINCIPAL_ID = "012345678";
            Mockito.when((Object)this.fundManagerMock.getPrincipalId()).thenReturn((Object)"012345678");
            Mockito.when((Object)this.awardFundManagerMock.getFundManager()).thenReturn((Object)this.fundManagerMock);
            Mockito.when((Object)award.getAwardPrimaryFundManager()).thenReturn((Object)this.awardFundManagerMock);
            ChartOrgHolderImpl chartOrgHolder = new ChartOrgHolderImpl("C1", "11111");
            Mockito.when((Object)this.financialSystemUserServiceMock.getPrimaryOrganization("012345678", "KFS-AR")).thenReturn((Object)chartOrgHolder);
        }
        Mockito.when((Object)this.universityDateSvcMock.getCurrentFiscalYear()).thenReturn((Object)2015);
        if (hasProcessing) {
            Mockito.when((Object)this.contractsGrantsInvoiceDocSvcMock.getProcessingFromBillingCodes("C1", "11111")).thenReturn(Arrays.asList("C2", "22222"));
        } else {
            Mockito.when((Object)this.contractsGrantsInvoiceDocSvcMock.getProcessingFromBillingCodes("C1", "11111")).thenReturn(new ArrayList());
        }
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        criteria.put("universityFiscalYear", 2015);
        criteria.put("chartOfAccountsCode", "C1");
        criteria.put("organizationCode", "11111");
        if (hasOrganizationAccountingDefault) {
            Mockito.when((Object)this.businessObjectSvcMock.findByPrimaryKey(OrganizationAccountingDefault.class, criteria)).thenReturn((Object)new OrganizationAccountingDefault());
        } else {
            Mockito.when((Object)this.businessObjectSvcMock.findByPrimaryKey(OrganizationAccountingDefault.class, criteria)).thenReturn(null);
        }
        HashMap<String, Object> sysCriteria = new HashMap<String, Object>();
        sysCriteria.put("universityFiscalYear", 2015);
        sysCriteria.put("processingChartOfAccountCode", "C2");
        sysCriteria.put("processingOrganizationCode", "22222");
        if (hasSystemInformation) {
            Mockito.when((Object)this.businessObjectSvcMock.findByPrimaryKey(SystemInformation.class, sysCriteria)).thenReturn((Object)new SystemInformation());
        } else {
            Mockito.when((Object)this.businessObjectSvcMock.findByPrimaryKey(SystemInformation.class, sysCriteria)).thenReturn(null);
        }
        boolean result = this.cut.isChartAndOrgSetupForInvoicing(award);
        Assert.assertEquals((Object)expectedResult, (Object)result);
    }

    @Test
    public void executeIsChartAndOrgSetupForInvoicingTest_ChartAndOrgValid() {
        this.executeIsChartAndOrgSetupForInvoicingTest(true, true, true, true, true);
    }

    @Test
    public void executeIsChartAndOrgSetupForInvoicingTest_NoAwardPrimaryFundManager() {
        this.executeIsChartAndOrgSetupForInvoicingTest(false, true, true, true, false);
    }

    @Test
    public void executeIsChartAndOrgSetupForInvoicingTest_NoProcessingFromBillingCodes() {
        this.executeIsChartAndOrgSetupForInvoicingTest(true, false, true, true, false);
    }

    @Test
    public void executeIsChartAndOrgSetupForInvoicingTest_NoOrganizationAccountingDefault() {
        this.executeIsChartAndOrgSetupForInvoicingTest(true, true, false, true, false);
    }

    @Test
    public void executeIsChartAndOrgSetupForInvoicingTest_NoSystemInformation() {
        this.executeIsChartAndOrgSetupForInvoicingTest(true, true, true, false, false);
    }

    @Test
    public void hasBillsToInvoice_NotPredeterminedBilling() {
        Mockito.when((Object)this.awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        Assert.assertFalse((boolean)this.cut.hasBillsToInvoice(this.awardMock));
    }

    @Test
    public void hasBillsToInvoice_NoBills() {
        Mockito.when((Object)this.awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        Assert.assertFalse((boolean)this.cut.hasBillsToInvoice(this.awardMock));
    }

    @Test
    public void hasBillsToInvoice_NoUnbilledBills() {
        Mockito.when((Object)this.awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        this.setupBills(null, true, 1000.0, ACCOUNT_NUMBER);
        Assert.assertFalse((boolean)this.cut.hasBillsToInvoice(this.awardMock));
    }

    @Test
    public void hasBillsToInvoice_OneUnbilledBillsDueLastMonth() {
        List<ContractsAndGrantsBillingAwardAccount> activeAwardAccounts = this.setupAwardAccounts();
        Mockito.when((Object)this.awardMock.getActiveAwardAccounts()).thenReturn(activeAwardAccounts);
        Mockito.when((Object)this.awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        this.setupBills(LocalDate.now().minusMonths(1L), false, 1000.0, ACCOUNT_NUMBER);
        this.setupBills(LocalDate.now().minusMonths(1L), false, 1000.0, ANOTHER_ACCOUNT_NUMBER);
        Assert.assertTrue((boolean)this.cut.hasBillsToInvoice(this.awardMock));
    }

    private List<ContractsAndGrantsBillingAwardAccount> setupAwardAccounts() {
        ArrayList<ContractsAndGrantsBillingAwardAccount> activeAwardAccounts = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        ContractsAndGrantsBillingAwardAccount awardAccountMock = (ContractsAndGrantsBillingAwardAccount)Mockito.mock(ContractsAndGrantsBillingAwardAccount.class);
        Mockito.when((Object)awardAccountMock.getProposalNumber()).thenReturn((Object)PROPOSAL_NUMBER);
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)ACCOUNT_NUMBER);
        activeAwardAccounts.add(awardAccountMock);
        return activeAwardAccounts;
    }

    @Test
    public void hasBillsToInvoice_OneUnbilledBillsDueNextMonth() {
        List<ContractsAndGrantsBillingAwardAccount> activeAwardAccounts = this.setupAwardAccounts();
        Mockito.when((Object)this.awardMock.getActiveAwardAccounts()).thenReturn(activeAwardAccounts);
        Mockito.when((Object)this.awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        this.setupBills(LocalDate.now().plusMonths(1L), false, 1000.0, ACCOUNT_NUMBER);
        this.setupBills(LocalDate.now().plusMonths(1L), false, 1000.0, ANOTHER_ACCOUNT_NUMBER);
        Assert.assertFalse((boolean)this.cut.hasBillsToInvoice(this.awardMock));
    }

    @Test
    public void hasBillsToInvoice_OneUnbilledBillsDueToday() {
        List<ContractsAndGrantsBillingAwardAccount> activeAwardAccounts = this.setupAwardAccounts();
        Mockito.when((Object)this.awardMock.getActiveAwardAccounts()).thenReturn(activeAwardAccounts);
        Mockito.when((Object)this.awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        this.setupBills(LocalDate.now(), false, 1000.0, ACCOUNT_NUMBER);
        this.setupBills(LocalDate.now(), false, 1000.0, ANOTHER_ACCOUNT_NUMBER);
        Assert.assertTrue((boolean)this.cut.hasBillsToInvoice(this.awardMock));
    }

    @Test
    public void hasBillsToInvoice_OneUnbilledBillsDueToday_ZeroAmount() {
        List<ContractsAndGrantsBillingAwardAccount> activeAwardAccounts = this.setupAwardAccounts();
        Mockito.when((Object)this.awardMock.getActiveAwardAccounts()).thenReturn(activeAwardAccounts);
        Mockito.when((Object)this.awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        this.setupBills(LocalDate.now(), false, 0.0, ACCOUNT_NUMBER);
        this.setupBills(LocalDate.now(), false, 0.0, ANOTHER_ACCOUNT_NUMBER);
        Assert.assertFalse((boolean)this.cut.hasBillsToInvoice(this.awardMock));
    }

    private void setupBills(LocalDate billDate, boolean hasSecondBillBeenBilled, double secondBillEstimatedAmount, String accountNumber) {
        ArrayList<Bill> bills = new ArrayList<Bill>();
        Bill bill = new Bill();
        bill.setBilled(true);
        Bill anotherBill = new Bill();
        anotherBill.setBilled(hasSecondBillBeenBilled);
        if (billDate != null) {
            anotherBill.setBillDate(Date.valueOf(billDate));
        }
        anotherBill.setEstimatedAmount(new KualiDecimal(secondBillEstimatedAmount));
        bills.add(bill);
        bills.add(anotherBill);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("proposalNumber", this.awardMock.getProposalNumber());
        map.put("chartOfAccountsCode", "BL");
        map.put("accountNumber", accountNumber);
        map.put("active", true);
        Mockito.when((Object)this.businessObjectSvcMock.findMatching(Bill.class, map)).thenReturn(bills);
    }

    @Test
    public void hasMilestonesToInvoice_NotMilestoneBilling() {
        Mockito.when((Object)this.awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        Assert.assertFalse((boolean)this.cut.hasMilestonesToInvoice(this.awardMock));
    }

    @Test
    public void hasMilestonesToInvoice_NoBills() {
        Mockito.when((Object)this.awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        Assert.assertFalse((boolean)this.cut.hasMilestonesToInvoice(this.awardMock));
    }

    @Test
    public void hasMilestonesToInvoice_NoUnbilledBills() {
        List<ContractsAndGrantsBillingAwardAccount> activeAwardAccounts = this.setupAwardAccounts();
        Mockito.when((Object)this.awardMock.getActiveAwardAccounts()).thenReturn(activeAwardAccounts);
        Mockito.when((Object)this.awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        this.setupMilestones(null, true, 1000.0, ACCOUNT_NUMBER);
        this.setupMilestones(null, true, 1000.0, ANOTHER_ACCOUNT_NUMBER);
        Assert.assertFalse((boolean)this.cut.hasMilestonesToInvoice(this.awardMock));
    }

    @Test
    public void hasMilestonesToInvoice_OneUnbilledBillsDueLastMonth() {
        List<ContractsAndGrantsBillingAwardAccount> activeAwardAccounts = this.setupAwardAccounts();
        Mockito.when((Object)this.awardMock.getActiveAwardAccounts()).thenReturn(activeAwardAccounts);
        Mockito.when((Object)this.awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        this.setupMilestones(LocalDate.now().minusMonths(1L), false, 1000.0, ACCOUNT_NUMBER);
        this.setupMilestones(LocalDate.now().minusMonths(1L), false, 1000.0, ANOTHER_ACCOUNT_NUMBER);
        Assert.assertTrue((boolean)this.cut.hasMilestonesToInvoice(this.awardMock));
    }

    @Test
    public void hasMilestonesToInvoice_OneUnbilledBillsDueNextMonth() {
        List<ContractsAndGrantsBillingAwardAccount> activeAwardAccounts = this.setupAwardAccounts();
        Mockito.when((Object)this.awardMock.getActiveAwardAccounts()).thenReturn(activeAwardAccounts);
        Mockito.when((Object)this.awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        this.setupMilestones(LocalDate.now().plusMonths(1L), false, 1000.0, ACCOUNT_NUMBER);
        this.setupMilestones(LocalDate.now().plusMonths(1L), false, 1000.0, ANOTHER_ACCOUNT_NUMBER);
        Assert.assertFalse((boolean)this.cut.hasMilestonesToInvoice(this.awardMock));
    }

    @Test
    public void hasMilestonesToInvoice_OneUnbilledBillsDueToday() {
        List<ContractsAndGrantsBillingAwardAccount> activeAwardAccounts = this.setupAwardAccounts();
        Mockito.when((Object)this.awardMock.getActiveAwardAccounts()).thenReturn(activeAwardAccounts);
        Mockito.when((Object)this.awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        this.setupMilestones(LocalDate.now(), false, 1000.0, ACCOUNT_NUMBER);
        this.setupMilestones(LocalDate.now(), false, 1000.0, ANOTHER_ACCOUNT_NUMBER);
        Assert.assertTrue((boolean)this.cut.hasMilestonesToInvoice(this.awardMock));
    }

    @Test
    public void hasMilestonesToInvoice_OneUnbilledBillsDueToday_ZeroAmount() {
        List<ContractsAndGrantsBillingAwardAccount> activeAwardAccounts = this.setupAwardAccounts();
        Mockito.when((Object)this.awardMock.getActiveAwardAccounts()).thenReturn(activeAwardAccounts);
        Mockito.when((Object)this.awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        this.setupMilestones(LocalDate.now(), false, 0.0, ACCOUNT_NUMBER);
        this.setupMilestones(LocalDate.now(), false, 0.0, ANOTHER_ACCOUNT_NUMBER);
        Assert.assertFalse((boolean)this.cut.hasMilestonesToInvoice(this.awardMock));
    }

    private void setupMilestones(LocalDate milestoneCompletionDate, boolean hasSecondMilestoneBeenBilled, double secondMilestoneAmount, String accountNumber) {
        ArrayList<Milestone> milestones = new ArrayList<Milestone>();
        Milestone milestone = new Milestone();
        milestone.setBilled(true);
        Milestone anotherMilestone = new Milestone();
        anotherMilestone.setBilled(hasSecondMilestoneBeenBilled);
        if (milestoneCompletionDate != null) {
            anotherMilestone.setMilestoneActualCompletionDate(Date.valueOf(milestoneCompletionDate));
        }
        anotherMilestone.setMilestoneAmount(new KualiDecimal(secondMilestoneAmount));
        milestones.add(milestone);
        milestones.add(anotherMilestone);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("proposalNumber", this.awardMock.getProposalNumber());
        map.put("chartOfAccountsCode", "BL");
        map.put("accountNumber", accountNumber);
        map.put("active", true);
        Mockito.when((Object)this.businessObjectSvcMock.findMatching(Milestone.class, map)).thenReturn(milestones);
    }

    @Test
    public void isInvoiceInProgress_NoInvoices() {
        List<ContractsAndGrantsBillingAwardAccount> activeAwardAccounts = this.setupAwardAccounts();
        Mockito.when((Object)this.awardMock.getActiveAwardAccounts()).thenReturn(activeAwardAccounts);
        Mockito.when((Object)this.awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        Assert.assertFalse((boolean)this.cut.isInvoiceInProgress(this.awardMock));
    }

    @Test
    public void isInvoiceInProgress_InvoicesInProgressForDifferentAwardAccount() {
        List<ContractsAndGrantsBillingAwardAccount> activeAwardAccounts = this.setupAwardAccounts();
        Mockito.when((Object)this.awardMock.getActiveAwardAccounts()).thenReturn(activeAwardAccounts);
        Mockito.when((Object)this.awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        Assert.assertFalse((boolean)this.cut.isInvoiceInProgress(this.awardMock));
    }

    @Test
    public void isInvoiceInProgress_HasInvoices() {
        List<ContractsAndGrantsBillingAwardAccount> activeAwardAccounts = this.setupAwardAccounts();
        Mockito.when((Object)this.awardMock.getActiveAwardAccounts()).thenReturn(activeAwardAccounts);
        Mockito.when((Object)this.awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        List<String> accountNumbers = Arrays.asList(ACCOUNT_NUMBER, ANOTHER_ACCOUNT_NUMBER);
        this.setupInvoicesInProgress(accountNumbers);
        Assert.assertTrue((boolean)this.cut.isInvoiceInProgress(this.awardMock));
    }

    private void setupInvoicesInProgress(List<String> accountNumbers) {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("invoiceGeneralDetail.proposalNumber", this.awardMock.getProposalNumber());
        fieldValues.put("documentHeader.workflowDocumentStatusCode", this.financialSystemDocumentService.getPendingDocumentStatuses());
        ArrayList<ContractsGrantsInvoiceDocument> invoiceDocuments = new ArrayList<ContractsGrantsInvoiceDocument>();
        for (String accountNumber : accountNumbers) {
            ContractsGrantsInvoiceDocument invoiceDocumentMock = (ContractsGrantsInvoiceDocument)Mockito.mock(ContractsGrantsInvoiceDocument.class);
            ArrayList<InvoiceAccountDetail> accountDetails = new ArrayList<InvoiceAccountDetail>();
            InvoiceAccountDetail invoiceAccountDetail = new InvoiceAccountDetail();
            invoiceAccountDetail.setChartOfAccountsCode("BL");
            invoiceAccountDetail.setAccountNumber(accountNumber);
            accountDetails.add(invoiceAccountDetail);
            Mockito.when((Object)invoiceDocumentMock.getAccountDetails()).thenReturn(accountDetails);
            invoiceDocuments.add(invoiceDocumentMock);
        }
        Mockito.when((Object)this.businessObjectSvcMock.findMatching(ContractsGrantsInvoiceDocument.class, fieldValues)).thenReturn(invoiceDocuments);
    }
}

