/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.service.impl;

import java.sql.Date;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.runner.RunWith;
import org.kuali.kfs.coa.businessobject.A21SubAccount;
import org.kuali.kfs.coa.businessobject.ObjectType;
import org.kuali.kfs.coa.businessobject.SubAccount;
import org.kuali.kfs.coa.service.AccountService;
import org.kuali.kfs.gl.businessobject.Balance;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAwardAccount;
import org.kuali.kfs.integration.cg.ContractsAndGrantsModuleBillingService;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.service.ModuleService;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.businessobject.Bill;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.InvoiceAccountDetail;
import org.kuali.kfs.module.ar.businessobject.InvoiceAddressDetail;
import org.kuali.kfs.module.ar.businessobject.InvoiceBill;
import org.kuali.kfs.module.ar.businessobject.InvoiceDetailAccountObjectCode;
import org.kuali.kfs.module.ar.businessobject.InvoiceGeneralDetail;
import org.kuali.kfs.module.ar.businessobject.InvoiceMilestone;
import org.kuali.kfs.module.ar.businessobject.Milestone;
import org.kuali.kfs.module.ar.businessobject.OrganizationAccountingDefault;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.dataaccess.ContractsGrantsInvoiceDocumentDao;
import org.kuali.kfs.module.ar.document.service.AccountsReceivablePendingEntryService;
import org.kuali.kfs.module.ar.document.service.impl.ContractsGrantsInvoiceDocumentServiceImpl;
import org.kuali.kfs.module.ar.fixture.ARAwardMockFixture;
import org.kuali.kfs.module.ar.fixture.InvoiceAccountDetailFixture;
import org.kuali.kfs.module.ar.fixture.InvoiceBillFixture;
import org.kuali.kfs.module.ar.fixture.InvoiceDetailAccountObjectCodeFixture;
import org.kuali.kfs.module.ar.fixture.InvoiceMilestoneFixture;
import org.kuali.kfs.sys.businessobject.SystemOptions;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.service.FinancialSystemDocumentService;
import org.kuali.kfs.sys.document.service.impl.FinancialSystemDocumentServiceImpl;
import org.kuali.kfs.sys.service.OptionsService;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.rice.core.api.search.SearchOperator;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.krad.bo.BusinessObject;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={SpringContext.class})
@Execution(value=ExecutionMode.SAME_THREAD)
public class ContractsGrantsInvoiceDocumentServiceImplTest {
    private static final String DOCUMENT_NUMBER = "1";
    private static final String PROPOSAL_NUMBER = "1";
    private ContractsGrantsInvoiceDocumentServiceImpl cut;
    @Mock
    private AccountsReceivablePendingEntryService accountsReceivablePendingEntrySvcMock;
    @Mock
    private AccountService accountSvcMock;
    @Mock
    private BusinessObjectService businessObjectSvcMock;
    @Mock
    private ContractsAndGrantsModuleBillingService contractsAndGrantsModuleBillingSvcMock;
    @Mock
    private ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock;
    @Mock
    private ContractsGrantsInvoiceDocumentDao contractsGrantsInvoiceDocumentDaoMock;
    @Spy
    private InvoiceGeneralDetail invoiceGeneralDetailMock = new InvoiceGeneralDetail();
    @Mock
    private KualiModuleService kualiModuleSvcMock;
    @Mock
    private OptionsService optionsSvcMock;
    @Mock
    private ObjectType objectTypeExpMock;
    @Mock
    private UniversityDateService universityDateSvcMock;
    @Mock
    private SystemOptions systemOptionsMock;
    private ContractsGrantsInvoiceDetail contractsGrantsInvoiceDetail;
    private FinancialSystemDocumentServiceImpl financialSystemDocumentService;
    private InvoiceAccountDetail invoiceAccountDetail1;
    private InvoiceAccountDetail invoiceAccountDetail2;
    private Date lastBilledDate;
    private String proposalNumber;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        PowerMockito.mockStatic(SpringContext.class, (Class[])new Class[0]);
        Mockito.when((Object)SpringContext.getBean(AccountService.class)).thenReturn((Object)this.accountSvcMock);
        Mockito.when((Object)this.universityDateSvcMock.getCurrentFiscalYear()).thenReturn((Object)2019);
        Mockito.when((Object)this.objectTypeExpMock.getCode()).thenReturn((Object)"EX");
        Mockito.when((Object)this.systemOptionsMock.getFinObjTypeExpenditureexp()).thenReturn((Object)this.objectTypeExpMock);
        Mockito.when((Object)this.optionsSvcMock.getCurrentYearOptions()).thenReturn((Object)this.systemOptionsMock);
        this.setupFiscalYearMocking();
        this.setupGlBalanceMocks();
        this.setupDocumentAndBusinessObjectMocks();
        this.setupMilestoneMocks();
        this.setupPredeterminedBillingMocks();
        this.financialSystemDocumentService = new FinancialSystemDocumentServiceImpl();
        this.cut = new ContractsGrantsInvoiceDocumentServiceImpl();
        this.cut.setAccountsReceivablePendingEntryService(this.accountsReceivablePendingEntrySvcMock);
        this.cut.setBusinessObjectService(this.businessObjectSvcMock);
        this.cut.setContractsAndGrantsModuleBillingService(this.contractsAndGrantsModuleBillingSvcMock);
        this.cut.setContractsGrantsInvoiceDocumentDao(this.contractsGrantsInvoiceDocumentDaoMock);
        this.cut.setFinancialSystemDocumentService((FinancialSystemDocumentService)this.financialSystemDocumentService);
        this.cut.setKualiModuleService(this.kualiModuleSvcMock);
        this.cut.setOptionsService(this.optionsSvcMock);
        this.cut.setUniversityDateService(this.universityDateSvcMock);
    }

    private void setupFiscalYearMocking() {
        java.util.Date startDate2001 = java.util.Date.from(LocalDate.of(2001, 1, 1).atStartOfDay(ZoneId.systemDefault()).toInstant());
        Mockito.when((Object)this.universityDateSvcMock.getFiscalYear(startDate2001)).thenReturn(null);
        java.util.Date startDate2002 = java.util.Date.from(LocalDate.of(2002, 1, 1).atStartOfDay(ZoneId.systemDefault()).toInstant());
        Mockito.when((Object)this.universityDateSvcMock.getFiscalYear(startDate2002)).thenReturn(null);
        java.util.Date startDate2003 = java.util.Date.from(LocalDate.of(2003, 1, 1).atStartOfDay(ZoneId.systemDefault()).toInstant());
        Mockito.when((Object)this.universityDateSvcMock.getFiscalYear(startDate2003)).thenReturn(null);
        java.util.Date startDate2004 = java.util.Date.from(LocalDate.of(2004, 1, 1).atStartOfDay(ZoneId.systemDefault()).toInstant());
        Mockito.when((Object)this.universityDateSvcMock.getFiscalYear(startDate2004)).thenReturn(null);
        java.util.Date startDate2005 = java.util.Date.from(LocalDate.of(2005, 1, 1).atStartOfDay(ZoneId.systemDefault()).toInstant());
        Mockito.when((Object)this.universityDateSvcMock.getFiscalYear(startDate2005)).thenReturn(null);
        java.util.Date startDate2006 = java.util.Date.from(LocalDate.of(2006, 1, 1).atStartOfDay(ZoneId.systemDefault()).toInstant());
        Mockito.when((Object)this.universityDateSvcMock.getFiscalYear(startDate2006)).thenReturn(null);
        java.util.Date startDate2007 = java.util.Date.from(LocalDate.of(2007, 1, 1).atStartOfDay(ZoneId.systemDefault()).toInstant());
        Mockito.when((Object)this.universityDateSvcMock.getFiscalYear(startDate2007)).thenReturn((Object)2007);
        java.util.Date startDate2008 = java.util.Date.from(LocalDate.of(2008, 1, 1).atStartOfDay(ZoneId.systemDefault()).toInstant());
        Mockito.when((Object)this.universityDateSvcMock.getFiscalYear(startDate2008)).thenReturn((Object)2008);
        java.util.Date startDate2009 = java.util.Date.from(LocalDate.of(2009, 1, 1).atStartOfDay(ZoneId.systemDefault()).toInstant());
        Mockito.when((Object)this.universityDateSvcMock.getFiscalYear(startDate2009)).thenReturn((Object)2009);
        java.util.Date startDate2010 = java.util.Date.from(LocalDate.of(2010, 1, 1).atStartOfDay(ZoneId.systemDefault()).toInstant());
        Mockito.when((Object)this.universityDateSvcMock.getFiscalYear(startDate2010)).thenReturn((Object)2010);
        java.util.Date startDate2011 = java.util.Date.from(LocalDate.of(2011, 1, 1).atStartOfDay(ZoneId.systemDefault()).toInstant());
        Mockito.when((Object)this.universityDateSvcMock.getFiscalYear(startDate2011)).thenReturn((Object)2011);
        java.util.Date startDate2012 = java.util.Date.from(LocalDate.of(2012, 1, 1).atStartOfDay(ZoneId.systemDefault()).toInstant());
        Mockito.when((Object)this.universityDateSvcMock.getFiscalYear(startDate2012)).thenReturn((Object)2012);
        java.util.Date startDate2013 = java.util.Date.from(LocalDate.of(2013, 1, 1).atStartOfDay(ZoneId.systemDefault()).toInstant());
        Mockito.when((Object)this.universityDateSvcMock.getFiscalYear(startDate2013)).thenReturn((Object)2013);
        java.util.Date startDate2014 = java.util.Date.from(LocalDate.of(2014, 1, 1).atStartOfDay(ZoneId.systemDefault()).toInstant());
        Mockito.when((Object)this.universityDateSvcMock.getFiscalYear(startDate2014)).thenReturn((Object)2014);
        java.util.Date startDate2015 = java.util.Date.from(LocalDate.of(2015, 1, 1).atStartOfDay(ZoneId.systemDefault()).toInstant());
        Mockito.when((Object)this.universityDateSvcMock.getFiscalYear(startDate2015)).thenReturn((Object)2015);
        java.util.Date startDate2016 = java.util.Date.from(LocalDate.of(2016, 1, 1).atStartOfDay(ZoneId.systemDefault()).toInstant());
        Mockito.when((Object)this.universityDateSvcMock.getFiscalYear(startDate2016)).thenReturn((Object)2016);
        java.util.Date startDate2017 = java.util.Date.from(LocalDate.of(2017, 1, 1).atStartOfDay(ZoneId.systemDefault()).toInstant());
        Mockito.when((Object)this.universityDateSvcMock.getFiscalYear(startDate2017)).thenReturn((Object)2017);
        java.util.Date startDate2018 = java.util.Date.from(LocalDate.of(2018, 1, 1).atStartOfDay(ZoneId.systemDefault()).toInstant());
        Mockito.when((Object)this.universityDateSvcMock.getFiscalYear(startDate2018)).thenReturn((Object)2018);
        java.util.Date startDate2019 = java.util.Date.from(LocalDate.of(2018, 1, 1).atStartOfDay(ZoneId.systemDefault()).toInstant());
        Mockito.when((Object)this.universityDateSvcMock.getFiscalYear(startDate2019)).thenReturn((Object)2019);
    }

    private void setupGlBalanceMocks() {
        ArrayList<Balance> balancesFY09 = new ArrayList<Balance>();
        balancesFY09.add(this.setupBalanceMock(new KualiDecimal(101.0), new KualiDecimal(0.0), false));
        balancesFY09.add(this.setupBalanceMock(new KualiDecimal(102.0), new KualiDecimal(0.0), false));
        balancesFY09.add(this.setupBalanceMock(new KualiDecimal(103.0), new KualiDecimal(0.0), true));
        this.setupGlBalanceMockQuery(2009, balancesFY09);
        ArrayList<Balance> balancesFY15 = new ArrayList<Balance>();
        balancesFY15.add(this.setupBalanceMock(new KualiDecimal(120.0), new KualiDecimal(20.0), false));
        balancesFY15.add(this.setupBalanceMock(new KualiDecimal(121.0), new KualiDecimal(22.0), false));
        balancesFY15.add(this.setupBalanceMock(new KualiDecimal(130.0), new KualiDecimal(30.0), true));
        this.setupGlBalanceMockQuery(2015, balancesFY15);
        ArrayList<Balance> balancesFY19 = new ArrayList<Balance>();
        balancesFY19.add(this.setupBalanceMock(new KualiDecimal(220.0), new KualiDecimal(30.0), false));
        balancesFY19.add(this.setupBalanceMock(new KualiDecimal(221.0), new KualiDecimal(32.0), false));
        balancesFY19.add(this.setupBalanceMock(new KualiDecimal(230.0), new KualiDecimal(40.0), true));
        this.setupGlBalanceMockQuery(2019, balancesFY19);
    }

    private void setupGlBalanceMockQuery(int fiscalYear, List<Balance> balances) {
        HashMap<String, Object> balanceKeys = new HashMap<String, Object>();
        balanceKeys.put("chartOfAccountsCode", "BL");
        balanceKeys.put("accountNumber", "0211401");
        balanceKeys.put("universityFiscalYear", fiscalYear);
        balanceKeys.put("balanceTypeCode", "AC");
        balanceKeys.put("objectTypeCode", "EX");
        Mockito.when((Object)this.businessObjectSvcMock.findMatching(Balance.class, balanceKeys)).thenReturn(balances);
    }

    private Balance setupBalanceMock(KualiDecimal cgBeginningBalanceAmount, KualiDecimal annualBalanceAmount, boolean isCostShare) {
        Balance balanceMock = (Balance)Mockito.mock(Balance.class);
        Mockito.when((Object)balanceMock.getContractsGrantsBeginningBalanceAmount()).thenReturn((Object)cgBeginningBalanceAmount);
        Mockito.when((Object)balanceMock.getAccountLineAnnualBalanceAmount()).thenReturn((Object)annualBalanceAmount);
        if (isCostShare) {
            SubAccount subAccountMock = (SubAccount)Mockito.mock(SubAccount.class);
            A21SubAccount a21SubAccountMock = (A21SubAccount)Mockito.mock(A21SubAccount.class);
            Mockito.when((Object)a21SubAccountMock.getSubAccountTypeCode()).thenReturn((Object)"CS");
            Mockito.when((Object)subAccountMock.getA21SubAccount()).thenReturn((Object)a21SubAccountMock);
            Mockito.when((Object)balanceMock.getSubAccount()).thenReturn((Object)subAccountMock);
        }
        return balanceMock;
    }

    private void setupDocumentAndBusinessObjectMocks() {
        ContractsAndGrantsBillingAward awardMock = ARAwardMockFixture.CG_AWARD_INV_AWARD.createAwardMock();
        this.proposalNumber = awardMock.getProposalNumber();
        this.lastBilledDate = awardMock.getLastBilledDate();
        Mockito.when((Object)this.invoiceGeneralDetailMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MONTHLY.getCode());
        Mockito.when((Object)this.invoiceGeneralDetailMock.getProposalNumber()).thenReturn((Object)this.proposalNumber);
        Mockito.when((Object)this.invoiceGeneralDetailMock.isFinalBillIndicator()).thenReturn((Object)true);
        Mockito.when((Object)this.invoiceGeneralDetailMock.getLastBilledDate()).thenReturn((Object)this.lastBilledDate);
        this.invoiceGeneralDetailMock.setTotalAmountBilledToDate(new KualiDecimal(0.0));
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail()).thenReturn((Object)this.invoiceGeneralDetailMock);
        this.invoiceAccountDetail1 = InvoiceAccountDetailFixture.INV_ACCT_DTL1.createInvoiceAccountDetail();
        this.invoiceAccountDetail2 = InvoiceAccountDetailFixture.INV_ACCT_DTL2.createInvoiceAccountDetail();
        ArrayList<InvoiceAccountDetail> accountDetails = new ArrayList<InvoiceAccountDetail>();
        accountDetails.add(this.invoiceAccountDetail1);
        accountDetails.add(this.invoiceAccountDetail2);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getAccountDetails()).thenReturn(accountDetails);
        ArrayList<InvoiceAddressDetail> invoiceAddressDetails = new ArrayList<InvoiceAddressDetail>();
        InvoiceAddressDetail invoiceAddressDetail = new InvoiceAddressDetail();
        invoiceAddressDetail.setCustomerInvoiceTemplateCode("STD");
        invoiceAddressDetail.setInvoiceTransmissionMethodCode("MAIL");
        invoiceAddressDetail.setInitialTransmissionDate(Date.valueOf(LocalDate.now()));
        invoiceAddressDetails.add(invoiceAddressDetail);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getInvoiceAddressDetails()).thenReturn(invoiceAddressDetails);
        this.contractsGrantsInvoiceDetail = new ContractsGrantsInvoiceDetail();
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getTotalCostInvoiceDetail()).thenReturn((Object)this.contractsGrantsInvoiceDetail);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getDocumentNumber()).thenReturn((Object)"1");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("proposalNumber", this.proposalNumber);
        ModuleService moduleSvcMock = (ModuleService)Mockito.mock(ModuleService.class);
        Mockito.when((Object)moduleSvcMock.getExternalizableBusinessObject(ContractsAndGrantsBillingAward.class, map)).thenReturn((Object)awardMock);
        Mockito.when((Object)this.kualiModuleSvcMock.getResponsibleModuleService(ContractsAndGrantsBillingAward.class)).thenReturn((Object)moduleSvcMock);
    }

    private void setupMilestoneMocks() {
        ArrayList<Milestone> allMilestonesProposal1 = new ArrayList<Milestone>();
        Milestone milestoneProposal1ChartBlAccount0211401a = this.setupMilestoneMock("1", "BL", "0211401", new KualiDecimal(100.0), true);
        allMilestonesProposal1.add(milestoneProposal1ChartBlAccount0211401a);
        Milestone milestoneProposal1ChartBlAccount0211401b = this.setupMilestoneMock("1", "BL", "0211401", new KualiDecimal(150.0), true);
        allMilestonesProposal1.add(milestoneProposal1ChartBlAccount0211401b);
        Milestone milestoneProposal1ChartBlAccount0211401c = this.setupMilestoneMock("1", "BL", "0211401", new KualiDecimal(1200.0), false);
        allMilestonesProposal1.add(milestoneProposal1ChartBlAccount0211401c);
        Milestone milestoneProposal1ChartBlAccount0211402 = this.setupMilestoneMock("1", "BL", "0211402", new KualiDecimal(2500.0), false);
        allMilestonesProposal1.add(milestoneProposal1ChartBlAccount0211402);
        Milestone milestoneProposal1ChartBaAccount0211401 = this.setupMilestoneMock("1", "BA", "0211401", new KualiDecimal(100.0), true);
        allMilestonesProposal1.add(milestoneProposal1ChartBaAccount0211401);
        this.setupBusinessObjectServiceFindMatchingMocking("1", null, null, Milestone.class, allMilestonesProposal1);
        ArrayList<Milestone> unbilledMilestonesProposal3 = new ArrayList<Milestone>();
        Milestone milestoneProposal3ChartBlAccount0211401 = this.setupMilestoneMock("3", "BL", "0211401", new KualiDecimal(1200.0), false);
        unbilledMilestonesProposal3.add(milestoneProposal3ChartBlAccount0211401);
        Milestone milestoneProposal3ChartBlAccount0211402 = this.setupMilestoneMock("3", "BL", "0211402", new KualiDecimal(2500.0), false);
        unbilledMilestonesProposal3.add(milestoneProposal3ChartBlAccount0211402);
        this.setupBusinessObjectServiceFindMatchingMocking("3", null, null, Milestone.class, unbilledMilestonesProposal3);
        ArrayList<Milestone> milestonesByChartAccount = new ArrayList<Milestone>();
        milestonesByChartAccount.add(milestoneProposal1ChartBlAccount0211401a);
        milestonesByChartAccount.add(milestoneProposal1ChartBlAccount0211401b);
        milestonesByChartAccount.add(milestoneProposal1ChartBlAccount0211401c);
        this.setupBusinessObjectServiceFindMatchingMocking("1", "BL", "0211401", Milestone.class, milestonesByChartAccount);
        ArrayList<Milestone> milestonesByChartAccount2 = new ArrayList<Milestone>();
        milestonesByChartAccount2.add(milestoneProposal1ChartBaAccount0211401);
        this.setupBusinessObjectServiceFindMatchingMocking("1", "BA", "0211401", Milestone.class, milestonesByChartAccount2);
        ArrayList<Milestone> nonBilledMilestonesByChart = new ArrayList<Milestone>();
        nonBilledMilestonesByChart.add(milestoneProposal1ChartBlAccount0211402);
        this.setupBusinessObjectServiceFindMatchingMocking("1", "BL", "0211402", Milestone.class, nonBilledMilestonesByChart);
        ArrayList<Milestone> milestonesWithNullAmount = new ArrayList<Milestone>();
        Milestone milestoneWithNullAmount = this.setupMilestoneMock("4", "BL", "0211401", null, true);
        milestonesWithNullAmount.add(milestoneWithNullAmount);
        this.setupBusinessObjectServiceFindMatchingMocking("4", "BL", "0211403", Milestone.class, milestonesWithNullAmount);
    }

    private Milestone setupMilestoneMock(String proposalNumber, String chartOfAccountsCode, String accountNumber, KualiDecimal amount, Boolean isBilled) {
        Milestone milestoneMock = (Milestone)Mockito.mock(Milestone.class);
        Mockito.when((Object)milestoneMock.getProposalNumber()).thenReturn((Object)proposalNumber);
        Mockito.when((Object)milestoneMock.getChartOfAccountsCode()).thenReturn((Object)chartOfAccountsCode);
        Mockito.when((Object)milestoneMock.getAccountNumber()).thenReturn((Object)accountNumber);
        Mockito.when((Object)milestoneMock.getMilestoneAmount()).thenReturn((Object)amount);
        Mockito.when((Object)milestoneMock.isBilled()).thenReturn((Object)isBilled);
        return milestoneMock;
    }

    private <T extends BusinessObject> void setupBusinessObjectServiceFindMatchingMocking(String proposalNumber, String chartOfAccountsCode, String accountNumber, Class<T> clazz, List<T> listToReturn) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("proposalNumber", proposalNumber);
        if (StringUtils.isNotBlank((CharSequence)chartOfAccountsCode)) {
            fieldValues.put("chartOfAccountsCode", chartOfAccountsCode);
        }
        if (StringUtils.isNotBlank((CharSequence)accountNumber)) {
            fieldValues.put("accountNumber", accountNumber);
        }
        Mockito.when((Object)this.businessObjectSvcMock.findMatching(clazz, fieldValues)).thenReturn(listToReturn);
    }

    private void setupPredeterminedBillingMocks() {
        ArrayList<Bill> allBillsProposal1 = new ArrayList<Bill>();
        Bill billProposal1ChartBlAccount0211401a = this.setupBillMock("2", "BL", "0211401", new KualiDecimal(100.0), true);
        allBillsProposal1.add(billProposal1ChartBlAccount0211401a);
        Bill billProposal1ChartBlAccount0211401b = this.setupBillMock("2", "BL", "0211401", new KualiDecimal(150.0), true);
        allBillsProposal1.add(billProposal1ChartBlAccount0211401b);
        Bill billProposal1ChartBlAccount0211401c = this.setupBillMock("2", "BL", "0211401", new KualiDecimal(1200.0), false);
        allBillsProposal1.add(billProposal1ChartBlAccount0211401c);
        Bill billProposal1ChartBlAccount0211402 = this.setupBillMock("2", "BL", "0211402", new KualiDecimal(2500.0), false);
        allBillsProposal1.add(billProposal1ChartBlAccount0211402);
        Bill billProposal1ChartBaAccount0211401 = this.setupBillMock("2", "BA", "0211401", new KualiDecimal(100.0), true);
        allBillsProposal1.add(billProposal1ChartBaAccount0211401);
        this.setupBusinessObjectServiceFindMatchingMocking("2", null, null, Bill.class, allBillsProposal1);
        ArrayList<Bill> unbilledBillsProposal3 = new ArrayList<Bill>();
        Bill billProposal3ChartBlAccount0211401 = this.setupBillMock("4", "BL", "0211401", new KualiDecimal(1200.0), false);
        unbilledBillsProposal3.add(billProposal3ChartBlAccount0211401);
        Bill billProposal3ChartBlAccount0211402 = this.setupBillMock("4", "BL", "0211402", new KualiDecimal(2500.0), false);
        unbilledBillsProposal3.add(billProposal3ChartBlAccount0211402);
        this.setupBusinessObjectServiceFindMatchingMocking("4", null, null, Bill.class, unbilledBillsProposal3);
        ArrayList<Bill> billsByChartAccount = new ArrayList<Bill>();
        billsByChartAccount.add(billProposal1ChartBlAccount0211401a);
        billsByChartAccount.add(billProposal1ChartBlAccount0211401b);
        billsByChartAccount.add(billProposal1ChartBlAccount0211401c);
        this.setupBusinessObjectServiceFindMatchingMocking("2", "BL", "0211401", Bill.class, billsByChartAccount);
        ArrayList<Bill> billsByChartAccount2 = new ArrayList<Bill>();
        billsByChartAccount2.add(billProposal1ChartBaAccount0211401);
        this.setupBusinessObjectServiceFindMatchingMocking("2", "BA", "0211401", Bill.class, billsByChartAccount2);
        ArrayList<Bill> nonBilledBillsByChart = new ArrayList<Bill>();
        nonBilledBillsByChart.add(billProposal1ChartBlAccount0211402);
        this.setupBusinessObjectServiceFindMatchingMocking("2", "BL", "0211402", Bill.class, nonBilledBillsByChart);
        ArrayList<Bill> billsWithNullAmount = new ArrayList<Bill>();
        Bill billWithNullAmount = this.setupBillMock("5", "BL", "0211401", null, true);
        billsWithNullAmount.add(billWithNullAmount);
        this.setupBusinessObjectServiceFindMatchingMocking("5", "BL", "0211403", Bill.class, billsWithNullAmount);
    }

    private Bill setupBillMock(String proposalNumber, String chartOfAccountsCode, String accountNumber, KualiDecimal amount, Boolean isBilled) {
        Bill billMock = (Bill)Mockito.mock(Bill.class);
        Mockito.when((Object)billMock.getProposalNumber()).thenReturn((Object)proposalNumber);
        Mockito.when((Object)billMock.getChartOfAccountsCode()).thenReturn((Object)chartOfAccountsCode);
        Mockito.when((Object)billMock.getChartOfAccountsCode()).thenReturn((Object)accountNumber);
        Mockito.when((Object)billMock.isBilled()).thenReturn((Object)isBilled);
        Mockito.when((Object)billMock.getEstimatedAmount()).thenReturn((Object)amount);
        return billMock;
    }

    @Test
    public void getBudgetAndActualsForAwardAccount() {
        ContractsAndGrantsBillingAwardAccount awardAccountMock = (ContractsAndGrantsBillingAwardAccount)Mockito.mock(ContractsAndGrantsBillingAwardAccount.class);
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)"0211401");
        String balanceTypeCode = "AC";
        KualiDecimal budgetAndActuals = this.cut.getBudgetAndActualsForAwardAccount(awardAccountMock, balanceTypeCode);
        Assert.assertEquals((Object)new KualiDecimal(503.0), (Object)budgetAndActuals);
    }

    @Test
    public void getMilestonesBilledToDateAmount() {
        String chartOfAccountsCode = "BL";
        String accountNumber = "0211401";
        KualiDecimal billedToDateAmount = this.cut.getMilestonesBilledToDateAmount("1", chartOfAccountsCode, accountNumber);
        Assert.assertEquals((Object)new KualiDecimal(250.0), (Object)billedToDateAmount);
    }

    @Test
    public void getMilestonesBilledToDateAmount_NullAmount_DoesNotThrowException() {
        String proposalNumber = "4";
        String chartOfAccountsCode = "BL";
        String accountNumber = "0211403";
        KualiDecimal billedToDateAmount = this.cut.getMilestonesBilledToDateAmount(proposalNumber, chartOfAccountsCode, accountNumber);
        Assert.assertEquals((Object)new KualiDecimal(0.0), (Object)billedToDateAmount);
    }

    @Test
    public void getMilestonesBilledToDateAmount_NoMilestones() {
        String proposalNumber = "X";
        String chartOfAccountsCode = "BL";
        String accountNumber = "0211401";
        KualiDecimal billedToDateAmount = this.cut.getMilestonesBilledToDateAmount(proposalNumber, chartOfAccountsCode, accountNumber);
        Assert.assertEquals((Object)new KualiDecimal(0.0), (Object)billedToDateAmount);
    }

    @Test
    public void getMilestonesBilledToDateAmount_NoBilledMilestones() {
        String chartOfAccountsCode = "BL";
        String accountNumber = "0211402";
        KualiDecimal billedToDateAmount = this.cut.getMilestonesBilledToDateAmount("1", chartOfAccountsCode, accountNumber);
        Assert.assertEquals((Object)new KualiDecimal(0.0), (Object)billedToDateAmount);
    }

    @Test
    public void getPredeterminedBillingBilledToDateAmount() {
        String proposalNumber = "2";
        String chartOfAccountsCode = "BL";
        String accountNumber = "0211401";
        KualiDecimal billedToDateAmount = this.cut.getPredeterminedBillingBilledToDateAmount(proposalNumber, chartOfAccountsCode, accountNumber);
        Assert.assertEquals((Object)new KualiDecimal(250.0), (Object)billedToDateAmount);
    }

    @Test
    public void getPredeterminedBillingBilledToDateAmount_NullAmount_DoesNotThrowException() {
        String proposalNumber = "5";
        String chartOfAccountsCode = "BL";
        String accountNumber = "0211403";
        KualiDecimal billedToDateAmount = this.cut.getPredeterminedBillingBilledToDateAmount(proposalNumber, chartOfAccountsCode, accountNumber);
        Assert.assertEquals((Object)new KualiDecimal(0.0), (Object)billedToDateAmount);
    }

    @Test
    public void getPredeterminedBillingBilledToDateAmount_NoBills() {
        String proposalNumber = "X";
        String chartOfAccountsCode = "BL";
        String accountNumber = "0211401";
        KualiDecimal billedToDateAmount = this.cut.getPredeterminedBillingBilledToDateAmount(proposalNumber, chartOfAccountsCode, accountNumber);
        Assert.assertEquals((Object)new KualiDecimal(0.0), (Object)billedToDateAmount);
    }

    @Test
    public void getPredeterminedBillingBilledToDateAmount_NoBilledBills() {
        String proposalNumber = "2";
        String chartOfAccountsCode = "BL";
        String accountNumber = "0211402";
        KualiDecimal billedToDateAmount = this.cut.getPredeterminedBillingBilledToDateAmount(proposalNumber, chartOfAccountsCode, accountNumber);
        Assert.assertEquals((Object)new KualiDecimal(0.0), (Object)billedToDateAmount);
    }

    @Test
    public void calculatePreviouslyBilledAmounts_OneAccountMilestoneBilledZeroPreviouslyBilled() {
        ArrayList<InvoiceAccountDetail> invoiceAccountDetails = new ArrayList<InvoiceAccountDetail>();
        InvoiceAccountDetail invoiceAccountDetail = this.setupInvoiceAccountDetail("BL", "0211401", KualiDecimal.ZERO);
        invoiceAccountDetails.add(invoiceAccountDetail);
        ContractsGrantsInvoiceDocument cgInvoiceDocumentMock = this.setupContractsGrantsInvoiceDocumentMock("1", invoiceAccountDetails, KualiDecimal.ZERO, new KualiDecimal(450.0));
        this.cut.calculatePreviouslyBilledAmounts(cgInvoiceDocumentMock);
        Assert.assertEquals((Object)new KualiDecimal(250.0), (Object)cgInvoiceDocumentMock.getPreviouslyBilledTotal());
        Assert.assertEquals((Object)new KualiDecimal(250.0), (Object)cgInvoiceDocumentMock.getPreviouslyBilledInvoiceAmount());
        Assert.assertEquals((Object)new KualiDecimal(200.0), (Object)cgInvoiceDocumentMock.getTotalInvoiceInvoiceAmount());
    }

    private InvoiceAccountDetail setupInvoiceAccountDetail(String chartOfAccountsCode, String accountNumber, KualiDecimal totalPreviouslyBilled) {
        InvoiceAccountDetail invoiceAccountDetail = new InvoiceAccountDetail();
        invoiceAccountDetail.setProposalNumber("1");
        invoiceAccountDetail.setChartOfAccountsCode(chartOfAccountsCode);
        invoiceAccountDetail.setAccountNumber(accountNumber);
        invoiceAccountDetail.setTotalPreviouslyBilled(totalPreviouslyBilled);
        return invoiceAccountDetail;
    }

    private ContractsGrantsInvoiceDocument setupContractsGrantsInvoiceDocumentMock(String proposalNumber, List<InvoiceAccountDetail> invoiceAccountDetails, KualiDecimal totalPreviouslyBilled, KualiDecimal invoiceAmount) {
        ContractsGrantsInvoiceDocument cgInvoiceDocumentMock = (ContractsGrantsInvoiceDocument)Mockito.mock(ContractsGrantsInvoiceDocument.class);
        ((ContractsGrantsInvoiceDocument)Mockito.doCallRealMethod().when((Object)cgInvoiceDocumentMock)).getPreviouslyBilledTotal();
        ((ContractsGrantsInvoiceDocument)Mockito.doCallRealMethod().when((Object)cgInvoiceDocumentMock)).setPreviouslyBilledTotal((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        ((ContractsGrantsInvoiceDocument)Mockito.doCallRealMethod().when((Object)cgInvoiceDocumentMock)).getPreviouslyBilledInvoiceAmount();
        ((ContractsGrantsInvoiceDocument)Mockito.doCallRealMethod().when((Object)cgInvoiceDocumentMock)).setPreviouslyBilledInvoiceAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        ((ContractsGrantsInvoiceDocument)Mockito.doCallRealMethod().when((Object)cgInvoiceDocumentMock)).getTotalInvoiceInvoiceAmount();
        ((ContractsGrantsInvoiceDocument)Mockito.doCallRealMethod().when((Object)cgInvoiceDocumentMock)).setTotalInvoiceInvoiceAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        InvoiceGeneralDetail invoiceGeneralDetailMock = (InvoiceGeneralDetail)Mockito.mock(InvoiceGeneralDetail.class);
        Mockito.when((Object)cgInvoiceDocumentMock.getInvoiceGeneralDetail()).thenReturn((Object)invoiceGeneralDetailMock);
        Mockito.when((Object)invoiceGeneralDetailMock.getProposalNumber()).thenReturn((Object)proposalNumber);
        cgInvoiceDocumentMock.setPreviouslyBilledTotal(KualiDecimal.ZERO);
        cgInvoiceDocumentMock.setPreviouslyBilledInvoiceAmount(KualiDecimal.ZERO);
        cgInvoiceDocumentMock.setTotalInvoiceInvoiceAmount(KualiDecimal.ZERO);
        Mockito.when((Object)cgInvoiceDocumentMock.getAccountDetails()).thenReturn(invoiceAccountDetails);
        ContractsGrantsInvoiceDetail totalCostInvoiceDetail = new ContractsGrantsInvoiceDetail();
        totalCostInvoiceDetail.setTotalPreviouslyBilled(totalPreviouslyBilled);
        totalCostInvoiceDetail.setInvoiceAmount(invoiceAmount);
        Mockito.when((Object)cgInvoiceDocumentMock.getTotalCostInvoiceDetail()).thenReturn((Object)totalCostInvoiceDetail);
        return cgInvoiceDocumentMock;
    }

    @Test
    public void calculatePreviouslyBilledAmounts_OneAccountMilestoneBilledSomePreviouslyBilled() {
        ArrayList<InvoiceAccountDetail> invoiceAccountDetails = new ArrayList<InvoiceAccountDetail>();
        InvoiceAccountDetail invoiceAccountDetail = this.setupInvoiceAccountDetail("BL", "0211401", KualiDecimal.ZERO);
        invoiceAccountDetails.add(invoiceAccountDetail);
        ContractsGrantsInvoiceDocument cgInvoiceDocumentMock = this.setupContractsGrantsInvoiceDocumentMock("1", invoiceAccountDetails, new KualiDecimal(450.0), new KualiDecimal(300.0));
        this.cut.calculatePreviouslyBilledAmounts(cgInvoiceDocumentMock);
        Assert.assertEquals((Object)new KualiDecimal(250.0), (Object)cgInvoiceDocumentMock.getPreviouslyBilledTotal());
        Assert.assertEquals((Object)new KualiDecimal(0.0), (Object)cgInvoiceDocumentMock.getPreviouslyBilledInvoiceAmount());
        Assert.assertEquals((Object)new KualiDecimal(300.0), (Object)cgInvoiceDocumentMock.getTotalInvoiceInvoiceAmount());
    }

    @Test
    public void calculatePreviouslyBilledAmounts_TwoAccountsMilestoneBilledZeroPreviouslyBilled() {
        ArrayList<InvoiceAccountDetail> invoiceAccountDetails = new ArrayList<InvoiceAccountDetail>();
        invoiceAccountDetails.add(this.setupInvoiceAccountDetail("BL", "0211401", KualiDecimal.ZERO));
        invoiceAccountDetails.add(this.setupInvoiceAccountDetail("BA", "0211401", KualiDecimal.ZERO));
        ContractsGrantsInvoiceDocument cgInvoiceDocumentMock = this.setupContractsGrantsInvoiceDocumentMock("1", invoiceAccountDetails, KualiDecimal.ZERO, new KualiDecimal(450.0));
        this.cut.calculatePreviouslyBilledAmounts(cgInvoiceDocumentMock);
        Assert.assertEquals((Object)new KualiDecimal(350.0), (Object)cgInvoiceDocumentMock.getPreviouslyBilledTotal());
        Assert.assertEquals((Object)new KualiDecimal(350.0), (Object)cgInvoiceDocumentMock.getPreviouslyBilledInvoiceAmount());
        Assert.assertEquals((Object)new KualiDecimal(100.0), (Object)cgInvoiceDocumentMock.getTotalInvoiceInvoiceAmount());
    }

    @Test
    public void calculatePreviouslyBilledAmounts_TwoAccountMilestoneBilledSomePreviouslyBilled() {
        ArrayList<InvoiceAccountDetail> invoiceAccountDetails = new ArrayList<InvoiceAccountDetail>();
        invoiceAccountDetails.add(this.setupInvoiceAccountDetail("BL", "0211401", KualiDecimal.ZERO));
        invoiceAccountDetails.add(this.setupInvoiceAccountDetail("BA", "0211401", KualiDecimal.ZERO));
        ContractsGrantsInvoiceDocument cgInvoiceDocumentMock = this.setupContractsGrantsInvoiceDocumentMock("1", invoiceAccountDetails, new KualiDecimal(450.0), new KualiDecimal(300.0));
        this.cut.calculatePreviouslyBilledAmounts(cgInvoiceDocumentMock);
        Assert.assertEquals((Object)new KualiDecimal(350.0), (Object)cgInvoiceDocumentMock.getPreviouslyBilledTotal());
        Assert.assertEquals((Object)new KualiDecimal(0.0), (Object)cgInvoiceDocumentMock.getPreviouslyBilledInvoiceAmount());
        Assert.assertEquals((Object)new KualiDecimal(300.0), (Object)cgInvoiceDocumentMock.getTotalInvoiceInvoiceAmount());
    }

    @Test
    public void calculatePreviouslyBilledAmounts_OneAccountNoMilestonesBilledZeroPreviouslyBilled() {
        ArrayList<InvoiceAccountDetail> invoiceAccountDetails = new ArrayList<InvoiceAccountDetail>();
        InvoiceAccountDetail invoiceAccountDetail = this.setupInvoiceAccountDetail("XX", "0211401", KualiDecimal.ZERO);
        invoiceAccountDetails.add(invoiceAccountDetail);
        ContractsGrantsInvoiceDocument cgInvoiceDocumentMock = this.setupContractsGrantsInvoiceDocumentMock("1", invoiceAccountDetails, KualiDecimal.ZERO, new KualiDecimal(450.0));
        this.cut.calculatePreviouslyBilledAmounts(cgInvoiceDocumentMock);
        Assert.assertEquals((Object)new KualiDecimal(0.0), (Object)cgInvoiceDocumentMock.getPreviouslyBilledTotal());
        Assert.assertEquals((Object)new KualiDecimal(0.0), (Object)cgInvoiceDocumentMock.getPreviouslyBilledInvoiceAmount());
        Assert.assertEquals((Object)new KualiDecimal(450.0), (Object)cgInvoiceDocumentMock.getTotalInvoiceInvoiceAmount());
    }

    @Test
    public void calculatePreviouslyBilledAmounts_OneAccountNoMilestonesBilledSomePreviouslyBilled() {
        ArrayList<InvoiceAccountDetail> invoiceAccountDetails = new ArrayList<InvoiceAccountDetail>();
        InvoiceAccountDetail invoiceAccountDetail = this.setupInvoiceAccountDetail("XX", "0211401", KualiDecimal.ZERO);
        invoiceAccountDetails.add(invoiceAccountDetail);
        ContractsGrantsInvoiceDocument cgInvoiceDocumentMock = this.setupContractsGrantsInvoiceDocumentMock("1", invoiceAccountDetails, new KualiDecimal(450.0), new KualiDecimal(300.0));
        this.cut.calculatePreviouslyBilledAmounts(cgInvoiceDocumentMock);
        Assert.assertEquals((Object)new KualiDecimal(0.0), (Object)cgInvoiceDocumentMock.getPreviouslyBilledTotal());
        Assert.assertEquals((Object)new KualiDecimal(0.0), (Object)cgInvoiceDocumentMock.getPreviouslyBilledInvoiceAmount());
        Assert.assertEquals((Object)new KualiDecimal(300.0), (Object)cgInvoiceDocumentMock.getTotalInvoiceInvoiceAmount());
    }

    @Test
    public void calculatePreviouslyBilledAmounts_OneAccountBillBilledZeroPreviouslyBilled() {
        ArrayList<InvoiceAccountDetail> invoiceAccountDetails = new ArrayList<InvoiceAccountDetail>();
        InvoiceAccountDetail invoiceAccountDetail = this.setupInvoiceAccountDetail("BL", "0211401", KualiDecimal.ZERO);
        invoiceAccountDetails.add(invoiceAccountDetail);
        ContractsGrantsInvoiceDocument cgInvoiceDocumentMock = this.setupContractsGrantsInvoiceDocumentMock("2", invoiceAccountDetails, KualiDecimal.ZERO, new KualiDecimal(450.0));
        this.cut.calculatePreviouslyBilledAmounts(cgInvoiceDocumentMock);
        Assert.assertEquals((Object)new KualiDecimal(250.0), (Object)cgInvoiceDocumentMock.getPreviouslyBilledTotal());
        Assert.assertEquals((Object)new KualiDecimal(250.0), (Object)cgInvoiceDocumentMock.getPreviouslyBilledInvoiceAmount());
        Assert.assertEquals((Object)new KualiDecimal(200.0), (Object)cgInvoiceDocumentMock.getTotalInvoiceInvoiceAmount());
    }

    @Test
    public void calculatePreviouslyBilledAmounts_OneAccountBillBilledSomePreviouslyBilled() {
        ArrayList<InvoiceAccountDetail> invoiceAccountDetails = new ArrayList<InvoiceAccountDetail>();
        InvoiceAccountDetail invoiceAccountDetail = this.setupInvoiceAccountDetail("BL", "0211401", KualiDecimal.ZERO);
        invoiceAccountDetails.add(invoiceAccountDetail);
        ContractsGrantsInvoiceDocument cgInvoiceDocumentMock = this.setupContractsGrantsInvoiceDocumentMock("2", invoiceAccountDetails, new KualiDecimal(450.0), new KualiDecimal(300.0));
        this.cut.calculatePreviouslyBilledAmounts(cgInvoiceDocumentMock);
        Assert.assertEquals((Object)new KualiDecimal(250.0), (Object)cgInvoiceDocumentMock.getPreviouslyBilledTotal());
        Assert.assertEquals((Object)new KualiDecimal(0.0), (Object)cgInvoiceDocumentMock.getPreviouslyBilledInvoiceAmount());
        Assert.assertEquals((Object)new KualiDecimal(300.0), (Object)cgInvoiceDocumentMock.getTotalInvoiceInvoiceAmount());
    }

    @Test
    public void calculatePreviouslyBilledAmounts_TwoAccountsBillBilledZeroPreviouslyBilled() {
        ArrayList<InvoiceAccountDetail> invoiceAccountDetails = new ArrayList<InvoiceAccountDetail>();
        invoiceAccountDetails.add(this.setupInvoiceAccountDetail("BL", "0211401", KualiDecimal.ZERO));
        invoiceAccountDetails.add(this.setupInvoiceAccountDetail("BA", "0211401", KualiDecimal.ZERO));
        ContractsGrantsInvoiceDocument cgInvoiceDocumentMock = this.setupContractsGrantsInvoiceDocumentMock("2", invoiceAccountDetails, KualiDecimal.ZERO, new KualiDecimal(450.0));
        this.cut.calculatePreviouslyBilledAmounts(cgInvoiceDocumentMock);
        Assert.assertEquals((Object)new KualiDecimal(350.0), (Object)cgInvoiceDocumentMock.getPreviouslyBilledTotal());
        Assert.assertEquals((Object)new KualiDecimal(350.0), (Object)cgInvoiceDocumentMock.getPreviouslyBilledInvoiceAmount());
        Assert.assertEquals((Object)new KualiDecimal(100.0), (Object)cgInvoiceDocumentMock.getTotalInvoiceInvoiceAmount());
    }

    @Test
    public void calculatePreviouslyBilledAmounts_TwoAccountBillBilledSomePreviouslyBilled() {
        ArrayList<InvoiceAccountDetail> invoiceAccountDetails = new ArrayList<InvoiceAccountDetail>();
        invoiceAccountDetails.add(this.setupInvoiceAccountDetail("BL", "0211401", KualiDecimal.ZERO));
        invoiceAccountDetails.add(this.setupInvoiceAccountDetail("BA", "0211401", KualiDecimal.ZERO));
        ContractsGrantsInvoiceDocument cgInvoiceDocumentMock = this.setupContractsGrantsInvoiceDocumentMock("2", invoiceAccountDetails, new KualiDecimal(450.0), new KualiDecimal(300.0));
        this.cut.calculatePreviouslyBilledAmounts(cgInvoiceDocumentMock);
        Assert.assertEquals((Object)new KualiDecimal(350.0), (Object)cgInvoiceDocumentMock.getPreviouslyBilledTotal());
        Assert.assertEquals((Object)new KualiDecimal(0.0), (Object)cgInvoiceDocumentMock.getPreviouslyBilledInvoiceAmount());
        Assert.assertEquals((Object)new KualiDecimal(300.0), (Object)cgInvoiceDocumentMock.getTotalInvoiceInvoiceAmount());
    }

    @Test
    public void calculatePreviouslyBilledAmounts_OneAccountNoBillsBilledZeroPreviouslyBilled() {
        ArrayList<InvoiceAccountDetail> invoiceAccountDetails = new ArrayList<InvoiceAccountDetail>();
        invoiceAccountDetails.add(this.setupInvoiceAccountDetail("XX", "0211401", KualiDecimal.ZERO));
        ContractsGrantsInvoiceDocument cgInvoiceDocumentMock = this.setupContractsGrantsInvoiceDocumentMock("2", invoiceAccountDetails, KualiDecimal.ZERO, new KualiDecimal(450.0));
        this.cut.calculatePreviouslyBilledAmounts(cgInvoiceDocumentMock);
        Assert.assertEquals((Object)new KualiDecimal(0.0), (Object)cgInvoiceDocumentMock.getPreviouslyBilledTotal());
        Assert.assertEquals((Object)new KualiDecimal(0.0), (Object)cgInvoiceDocumentMock.getPreviouslyBilledInvoiceAmount());
        Assert.assertEquals((Object)new KualiDecimal(450.0), (Object)cgInvoiceDocumentMock.getTotalInvoiceInvoiceAmount());
    }

    @Test
    public void calculatePreviouslyBilledAmounts_OneAccountNoBillsBilledSomePreviouslyBilled() {
        ArrayList<InvoiceAccountDetail> invoiceAccountDetails = new ArrayList<InvoiceAccountDetail>();
        InvoiceAccountDetail invoiceAccountDetail = this.setupInvoiceAccountDetail("XX", "0211401", KualiDecimal.ZERO);
        invoiceAccountDetails.add(invoiceAccountDetail);
        ContractsGrantsInvoiceDocument cgInvoiceDocumentMock = this.setupContractsGrantsInvoiceDocumentMock("2", invoiceAccountDetails, new KualiDecimal(450.0), new KualiDecimal(300.0));
        this.cut.calculatePreviouslyBilledAmounts(cgInvoiceDocumentMock);
        Assert.assertEquals((Object)new KualiDecimal(0.0), (Object)cgInvoiceDocumentMock.getPreviouslyBilledTotal());
        Assert.assertEquals((Object)new KualiDecimal(0.0), (Object)cgInvoiceDocumentMock.getPreviouslyBilledInvoiceAmount());
        Assert.assertEquals((Object)new KualiDecimal(300.0), (Object)cgInvoiceDocumentMock.getTotalInvoiceInvoiceAmount());
    }

    @Test
    public void calculatePreviouslyBilledAmounts_TwoAccountMilestoneBilledSomePreviouslyBilled_ErrorCorrection() {
        ArrayList<InvoiceAccountDetail> invoiceAccountDetails = new ArrayList<InvoiceAccountDetail>();
        invoiceAccountDetails.add(this.setupInvoiceAccountDetail("BL", "0211401", KualiDecimal.ZERO));
        invoiceAccountDetails.add(this.setupInvoiceAccountDetail("BA", "0211401", KualiDecimal.ZERO));
        ContractsGrantsInvoiceDocument cgInvoiceDocumentMock = this.setupContractsGrantsInvoiceDocumentMock("1", invoiceAccountDetails, new KualiDecimal(450.0), new KualiDecimal(-400.0));
        Mockito.when((Object)cgInvoiceDocumentMock.isCorrectionDocument()).thenReturn((Object)true);
        this.cut.calculatePreviouslyBilledAmounts(cgInvoiceDocumentMock);
        Assert.assertEquals((Object)new KualiDecimal(350.0), (Object)cgInvoiceDocumentMock.getPreviouslyBilledTotal());
        Assert.assertEquals((Object)new KualiDecimal(-350.0), (Object)cgInvoiceDocumentMock.getPreviouslyBilledInvoiceAmount());
        Assert.assertEquals((Object)new KualiDecimal(-50.0), (Object)cgInvoiceDocumentMock.getTotalInvoiceInvoiceAmount());
    }

    @Test
    public void calculatePreviouslyBilledAmounts_TwoAccountBillBilledSomePreviouslyBilled_ErrorCorrection() {
        ArrayList<InvoiceAccountDetail> invoiceAccountDetails = new ArrayList<InvoiceAccountDetail>();
        invoiceAccountDetails.add(this.setupInvoiceAccountDetail("BL", "0211401", KualiDecimal.ZERO));
        invoiceAccountDetails.add(this.setupInvoiceAccountDetail("BA", "0211401", KualiDecimal.ZERO));
        ContractsGrantsInvoiceDocument cgInvoiceDocumentMock = this.setupContractsGrantsInvoiceDocumentMock("2", invoiceAccountDetails, new KualiDecimal(450.0), new KualiDecimal(-400.0));
        Mockito.when((Object)cgInvoiceDocumentMock.isCorrectionDocument()).thenReturn((Object)true);
        this.cut.calculatePreviouslyBilledAmounts(cgInvoiceDocumentMock);
        Assert.assertEquals((Object)new KualiDecimal(350.0), (Object)cgInvoiceDocumentMock.getPreviouslyBilledTotal());
        Assert.assertEquals((Object)new KualiDecimal(-350.0), (Object)cgInvoiceDocumentMock.getPreviouslyBilledInvoiceAmount());
        Assert.assertEquals((Object)new KualiDecimal(-50.0), (Object)cgInvoiceDocumentMock.getTotalInvoiceInvoiceAmount());
    }

    @Test
    public void updateBillsAndMilestones() {
        ArrayList<InvoiceBill> invoiceBills = new ArrayList<InvoiceBill>();
        InvoiceBill invoiceBill = InvoiceBillFixture.INV_BILL_1.createInvoiceBill();
        invoiceBill.setDocumentNumber("1");
        invoiceBills.add(invoiceBill);
        ArrayList<Bill> bills = new ArrayList<Bill>();
        Bill bill = new Bill();
        bill.setBillIdentifier(invoiceBill.getBillIdentifier());
        bill.setBilled(false);
        bills.add(bill);
        HashMap fieldValues = new HashMap();
        ArrayList<Long> billIds = new ArrayList<Long>();
        billIds.add(invoiceBill.getBillIdentifier());
        fieldValues.put("billIdentifier", billIds);
        Mockito.when((Object)this.businessObjectSvcMock.findMatching(Bill.class, fieldValues)).thenReturn(bills);
        ArrayList<InvoiceMilestone> invoiceMilestones = new ArrayList<InvoiceMilestone>();
        InvoiceMilestone invoiceMilestone = InvoiceMilestoneFixture.INV_MLSTN_1.createInvoiceMilestone();
        invoiceMilestone.setDocumentNumber("1");
        invoiceMilestones.add(invoiceMilestone);
        ArrayList<Milestone> milestones = new ArrayList<Milestone>();
        Milestone milestone = new Milestone();
        milestone.setMilestoneIdentifier(invoiceMilestone.getMilestoneIdentifier());
        milestone.setBilled(false);
        milestones.add(milestone);
        fieldValues = new HashMap();
        ArrayList<Long> milestoneIds = new ArrayList<Long>();
        milestoneIds.add(invoiceMilestone.getMilestoneIdentifier());
        fieldValues.put("milestoneIdentifier", milestoneIds);
        Mockito.when((Object)this.businessObjectSvcMock.findMatching(Milestone.class, fieldValues)).thenReturn(milestones);
        this.cut.updateBillsAndMilestones(true, invoiceMilestones, invoiceBills);
        for (Milestone updatedMilestone : milestones) {
            Assert.assertTrue((boolean)updatedMilestone.isBilled());
        }
        for (Bill updatedBill : bills) {
            Assert.assertTrue((boolean)updatedBill.isBilled());
        }
    }

    @Test
    public void updateLastBilledDate_IsFinalBill() {
        this.cut.updateLastBilledDate(this.contractsGrantsInvoiceDocumentMock);
        HashMap<String, String> mapKey = new HashMap<String, String>();
        mapKey.put("accountNumber", this.invoiceAccountDetail1.getAccountNumber());
        mapKey.put("chartOfAccountsCode", this.invoiceAccountDetail1.getChartOfAccountsCode());
        mapKey.put("proposalNumber", this.proposalNumber);
        ((ContractsAndGrantsModuleBillingService)Mockito.verify((Object)this.contractsAndGrantsModuleBillingSvcMock)).setFinalBilledAndLastBilledDateToAwardAccount(mapKey, true, false, this.lastBilledDate);
        mapKey.put("accountNumber", this.invoiceAccountDetail2.getAccountNumber());
        mapKey.put("chartOfAccountsCode", this.invoiceAccountDetail2.getChartOfAccountsCode());
        ((ContractsAndGrantsModuleBillingService)Mockito.verify((Object)this.contractsAndGrantsModuleBillingSvcMock)).setFinalBilledAndLastBilledDateToAwardAccount(mapKey, true, false, this.lastBilledDate);
        ((ContractsAndGrantsModuleBillingService)Mockito.verify((Object)this.contractsAndGrantsModuleBillingSvcMock)).setLastBilledDateToAward(this.proposalNumber, this.lastBilledDate);
    }

    @Test
    public void updateLastBilledDate_NotFinalBill() {
        Mockito.when((Object)this.invoiceGeneralDetailMock.isFinalBillIndicator()).thenReturn((Object)false);
        this.cut.updateLastBilledDate(this.contractsGrantsInvoiceDocumentMock);
        HashMap<String, String> mapKey = new HashMap<String, String>();
        mapKey.put("accountNumber", this.invoiceAccountDetail1.getAccountNumber());
        mapKey.put("chartOfAccountsCode", this.invoiceAccountDetail1.getChartOfAccountsCode());
        mapKey.put("proposalNumber", this.proposalNumber);
        ((ContractsAndGrantsModuleBillingService)Mockito.verify((Object)this.contractsAndGrantsModuleBillingSvcMock)).setLastBilledDateToAwardAccount(mapKey, false, this.lastBilledDate);
        mapKey.put("accountNumber", this.invoiceAccountDetail2.getAccountNumber());
        mapKey.put("chartOfAccountsCode", this.invoiceAccountDetail2.getChartOfAccountsCode());
        ((ContractsAndGrantsModuleBillingService)Mockito.verify((Object)this.contractsAndGrantsModuleBillingSvcMock)).setLastBilledDateToAwardAccount(mapKey, false, this.lastBilledDate);
        ((ContractsAndGrantsModuleBillingService)Mockito.verify((Object)this.contractsAndGrantsModuleBillingSvcMock)).setLastBilledDateToAward(this.proposalNumber, this.lastBilledDate);
    }

    @Test
    public void getLastBilledDate() {
        ContractsAndGrantsBillingAward awardMock = ARAwardMockFixture.CG_AWARD_INV_AWARD.createAwardMock();
        Date expectedLastBilledDate = awardMock.getLastBilledDate();
        Assert.assertEquals((Object)expectedLastBilledDate, (Object)this.cut.getLastBilledDate(awardMock));
    }

    @Test
    public void correctContractsGrantsInvoiceDocument() {
        ArrayList<ContractsGrantsInvoiceDocument> invoiceDocuments = new ArrayList<ContractsGrantsInvoiceDocument>();
        ContractsGrantsInvoiceDocument invoiceDocumentMock = (ContractsGrantsInvoiceDocument)Mockito.mock(ContractsGrantsInvoiceDocument.class);
        InvoiceAccountDetail invoiceAccountDetail = InvoiceAccountDetailFixture.INV_ACCT_DTL3.createInvoiceAccountDetail();
        KualiDecimal invoiceAmount = invoiceAccountDetail.getInvoiceAmount();
        InvoiceGeneralDetail invoiceGeneralDetail = new InvoiceGeneralDetail();
        invoiceGeneralDetail.setBillingFrequencyCode(ArConstants.BillingFrequencyValues.MONTHLY.getCode());
        Mockito.when((Object)invoiceDocumentMock.getInvoiceGeneralDetail()).thenReturn((Object)invoiceGeneralDetail);
        ArrayList<InvoiceAccountDetail> accountDetails = new ArrayList<InvoiceAccountDetail>();
        accountDetails.add(invoiceAccountDetail);
        Mockito.when((Object)invoiceDocumentMock.getAccountDetails()).thenReturn(accountDetails);
        Mockito.when((Object)invoiceDocumentMock.getTotalInvoiceAmount()).thenReturn((Object)invoiceAmount);
        invoiceDocuments.add(invoiceDocumentMock);
        ContractsGrantsInvoiceDocumentDao contractsGrantsInvoiceDocumentDaoMock = (ContractsGrantsInvoiceDocumentDao)Mockito.mock(ContractsGrantsInvoiceDocumentDao.class);
        Mockito.when((Object)contractsGrantsInvoiceDocumentDaoMock.getMatchingInvoicesByCollection(ArgumentMatchers.anyMap())).thenReturn(invoiceDocuments);
        this.cut.setContractsGrantsInvoiceDocumentDao(contractsGrantsInvoiceDocumentDaoMock);
        ArrayList<ContractsGrantsInvoiceDetail> directCostInvoiceDetails = new ArrayList<ContractsGrantsInvoiceDetail>();
        ContractsGrantsInvoiceDetail directCostInvoiceDetail = new ContractsGrantsInvoiceDetail();
        KualiDecimal originalInvoiceAmount = new KualiDecimal(1.0);
        directCostInvoiceDetail.setInvoiceAmount(originalInvoiceAmount);
        directCostInvoiceDetails.add(directCostInvoiceDetail);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getDirectCostInvoiceDetails()).thenReturn(directCostInvoiceDetails);
        InvoiceDetailAccountObjectCode invoiceDetailAccountObjectCode1 = InvoiceDetailAccountObjectCodeFixture.DETAIL_ACC_OBJ_CD1.createInvoiceDetailAccountObjectCode();
        InvoiceDetailAccountObjectCode invoiceDetailAccountObjectCode2 = InvoiceDetailAccountObjectCodeFixture.DETAIL_ACC_OBJ_CD2.createInvoiceDetailAccountObjectCode();
        KualiDecimal originalCurrentExpenditures1 = new KualiDecimal(3.01);
        KualiDecimal originalCurrentExpenditures2 = new KualiDecimal(2.02);
        invoiceDetailAccountObjectCode1.setCurrentExpenditures(originalCurrentExpenditures1);
        invoiceDetailAccountObjectCode2.setCurrentExpenditures(originalCurrentExpenditures2);
        ArrayList<InvoiceDetailAccountObjectCode> invoiceDetailAccountObjectCodes = new ArrayList<InvoiceDetailAccountObjectCode>();
        invoiceDetailAccountObjectCodes.add(invoiceDetailAccountObjectCode1);
        invoiceDetailAccountObjectCodes.add(invoiceDetailAccountObjectCode2);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getInvoiceDetailAccountObjectCodes()).thenReturn(invoiceDetailAccountObjectCodes);
        ArrayList<InvoiceAccountDetail> newAccountDetails = new ArrayList<InvoiceAccountDetail>();
        InvoiceAccountDetail newInvoiceAccountDetail = InvoiceAccountDetailFixture.INV_ACCT_DTL4.createInvoiceAccountDetail();
        newInvoiceAccountDetail.setInvoiceDocument(this.contractsGrantsInvoiceDocumentMock);
        newAccountDetails.add(newInvoiceAccountDetail);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getAccountDetails()).thenReturn(newAccountDetails);
        KualiDecimal originalAccountDetailInvoiceAmount = newInvoiceAccountDetail.getInvoiceAmount();
        this.cut.correctContractsGrantsInvoiceDocument(this.contractsGrantsInvoiceDocumentMock);
        for (Object invoiceAddressDetail : this.contractsGrantsInvoiceDocumentMock.getInvoiceAddressDetails()) {
            Assert.assertNull((Object)invoiceAddressDetail.getInitialTransmissionDate());
        }
        Assert.assertEquals((Object)new KualiDecimal(2.0), (Object)this.contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail().getTotalAmountBilledToDate());
        Assert.assertEquals((Object)originalInvoiceAmount.negated(), (Object)((ContractsGrantsInvoiceDetail)this.contractsGrantsInvoiceDocumentMock.getDirectCostInvoiceDetails().get(0)).getInvoiceAmount());
        List updatedInvoiceDetailAccountObjectCodes = this.contractsGrantsInvoiceDocumentMock.getInvoiceDetailAccountObjectCodes();
        for (InvoiceDetailAccountObjectCode invoiceDetailAccountObjectCode : updatedInvoiceDetailAccountObjectCodes) {
            if (invoiceDetailAccountObjectCode.getAccountNumber().equals(invoiceDetailAccountObjectCode1.getAccountNumber())) {
                Assert.assertEquals((Object)originalCurrentExpenditures1.negated(), (Object)invoiceDetailAccountObjectCode.getCurrentExpenditures());
                continue;
            }
            Assert.assertEquals((Object)originalCurrentExpenditures2.negated(), (Object)invoiceDetailAccountObjectCode.getCurrentExpenditures());
        }
        InvoiceAccountDetail accountDetail = (InvoiceAccountDetail)this.contractsGrantsInvoiceDocumentMock.getAccountDetails().get(0);
        Assert.assertEquals((Object)originalAccountDetailInvoiceAmount, (Object)accountDetail.getTotalPreviouslyBilled());
        Assert.assertEquals((Object)originalAccountDetailInvoiceAmount.negated(), (Object)accountDetail.getCumulativeExpenditures());
        Assert.assertEquals((Object)originalAccountDetailInvoiceAmount.negated(), (Object)accountDetail.getInvoiceAmount());
        Assert.assertNull((Object)accountDetail.getInvoiceDocument());
    }

    @Test
    public void correctContractsGrantsInvoiceDocument_Milestone() {
        Mockito.when((Object)this.invoiceGeneralDetailMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        ArrayList<InvoiceMilestone> invoiceMilestones = new ArrayList<InvoiceMilestone>();
        InvoiceMilestone invoiceMilestone = InvoiceMilestoneFixture.INV_MLSTN_1.createInvoiceMilestone();
        invoiceMilestone.setDocumentNumber("1");
        invoiceMilestones.add(invoiceMilestone);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getInvoiceMilestones()).thenReturn(invoiceMilestones);
        KualiDecimal originalMilestoneAmount = invoiceMilestone.getMilestoneAmount();
        this.cut.correctContractsGrantsInvoiceDocument(this.contractsGrantsInvoiceDocumentMock);
        for (InvoiceAddressDetail invoiceAddressDetail : this.contractsGrantsInvoiceDocumentMock.getInvoiceAddressDetails()) {
            Assert.assertNull((Object)invoiceAddressDetail.getInitialTransmissionDate());
        }
        Assert.assertEquals((Object)originalMilestoneAmount.negated(), (Object)invoiceMilestone.getMilestoneAmount());
        Assert.assertEquals((Object)new KualiDecimal(-1.0), (Object)this.contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail().getTotalAmountBilledToDate());
    }

    @Test
    public void correctContractsGrantsInvoiceDocument_Bill() {
        Mockito.when((Object)this.invoiceGeneralDetailMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        ArrayList<InvoiceBill> invoiceBills = new ArrayList<InvoiceBill>();
        InvoiceBill invoiceBill = InvoiceBillFixture.INV_BILL_1.createInvoiceBill();
        invoiceBill.setDocumentNumber("1");
        invoiceBills.add(invoiceBill);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getInvoiceBills()).thenReturn(invoiceBills);
        KualiDecimal originalBillAmount = invoiceBill.getEstimatedAmount();
        this.cut.correctContractsGrantsInvoiceDocument(this.contractsGrantsInvoiceDocumentMock);
        for (InvoiceAddressDetail invoiceAddressDetail : this.contractsGrantsInvoiceDocumentMock.getInvoiceAddressDetails()) {
            Assert.assertNull((Object)invoiceAddressDetail.getInitialTransmissionDate());
        }
        Assert.assertEquals((Object)originalBillAmount.negated(), (Object)invoiceBill.getEstimatedAmount());
        Assert.assertEquals((Object)new KualiDecimal(-1.0), (Object)this.contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail().getTotalAmountBilledToDate());
    }

    @Test
    public void updateUnfinalizationToAwardAccount() {
        this.cut.updateUnfinalizationToAwardAccount(this.contractsGrantsInvoiceDocumentMock.getAccountDetails(), this.contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail().getProposalNumber());
        HashMap<String, String> mapKey = new HashMap<String, String>();
        mapKey.put("accountNumber", this.invoiceAccountDetail1.getAccountNumber());
        mapKey.put("chartOfAccountsCode", this.invoiceAccountDetail1.getChartOfAccountsCode());
        mapKey.put("proposalNumber", this.proposalNumber);
        ((ContractsAndGrantsModuleBillingService)Mockito.verify((Object)this.contractsAndGrantsModuleBillingSvcMock)).setFinalBilledToAwardAccount(mapKey, false);
        mapKey.put("accountNumber", this.invoiceAccountDetail2.getAccountNumber());
        mapKey.put("chartOfAccountsCode", this.invoiceAccountDetail2.getChartOfAccountsCode());
        ((ContractsAndGrantsModuleBillingService)Mockito.verify((Object)this.contractsAndGrantsModuleBillingSvcMock)).setFinalBilledToAwardAccount(mapKey, false);
    }

    @Test
    public void createSourceAccountingLinesByAward_ThreeAccountsZeroPreviouslyBilled() {
        ArrayList<InvoiceAccountDetail> invoiceAccountDetails = new ArrayList<InvoiceAccountDetail>();
        invoiceAccountDetails.add(this.setupInvoiceAccountDetail("BL", "0211905", KualiDecimal.ZERO));
        invoiceAccountDetails.add(this.setupInvoiceAccountDetail("BL", "0211906", KualiDecimal.ZERO));
        invoiceAccountDetails.add(this.setupInvoiceAccountDetail("BL", "0211907", KualiDecimal.ZERO));
        ArrayList<InvoiceDetailAccountObjectCode> invoiceDetailAccountObjectCodes = new ArrayList<InvoiceDetailAccountObjectCode>();
        invoiceDetailAccountObjectCodes.add(this.setupInvoiceDetailAccountObjectCode("0211905", "4100", "S&E", new KualiDecimal(25.0), KualiDecimal.ZERO));
        invoiceDetailAccountObjectCodes.add(this.setupInvoiceDetailAccountObjectCode("0211905", "2008", "SAL", new KualiDecimal(25.0), KualiDecimal.ZERO));
        invoiceDetailAccountObjectCodes.add(this.setupInvoiceDetailAccountObjectCode("0211906", "4100", "S&E", new KualiDecimal(50.0), KualiDecimal.ZERO));
        invoiceDetailAccountObjectCodes.add(this.setupInvoiceDetailAccountObjectCode("0211906", "2008", "SAL", new KualiDecimal(50.0), KualiDecimal.ZERO));
        invoiceDetailAccountObjectCodes.add(this.setupInvoiceDetailAccountObjectCode("0211907", "4100", "S&E", new KualiDecimal(125.0), KualiDecimal.ZERO));
        invoiceDetailAccountObjectCodes.add(this.setupInvoiceDetailAccountObjectCode("0211907", "2008", "SAL", new KualiDecimal(175.0), KualiDecimal.ZERO));
        ContractsGrantsInvoiceDocument cgInvoiceDocumentMock = this.setupContractsGrantsInvoiceDocumentMock("1", invoiceAccountDetails, new KualiDecimal(450.0), new KualiDecimal(300.0));
        Mockito.when((Object)cgInvoiceDocumentMock.getInvoiceDetailAccountObjectCodes()).thenReturn(invoiceDetailAccountObjectCodes);
        OrganizationAccountingDefault organizationAccountingDefault = new OrganizationAccountingDefault();
        organizationAccountingDefault.setDefaultInvoiceFinancialObjectCode("8118");
        HashMap<String, KualiDecimal> expectedAmounts = new HashMap<String, KualiDecimal>();
        expectedAmounts.put("0211905", new KualiDecimal(50.0));
        expectedAmounts.put("0211906", new KualiDecimal(100.0));
        expectedAmounts.put("0211907", new KualiDecimal(300.0));
        List sourceAccountingLines = this.cut.createSourceAccountingLinesByAward(cgInvoiceDocumentMock, organizationAccountingDefault);
        Assert.assertNotNull((Object)sourceAccountingLines);
        Assert.assertEquals((long)3L, (long)sourceAccountingLines.size());
        for (CustomerInvoiceDetail sourceAccountingLine : sourceAccountingLines) {
            Assert.assertEquals(expectedAmounts.get(sourceAccountingLine.getAccountNumber()), (Object)sourceAccountingLine.getAmount());
        }
    }

    private InvoiceDetailAccountObjectCode setupInvoiceDetailAccountObjectCode(String accountNumber, String financialObjectCode, String categoryCode, KualiDecimal currentExpenditures, KualiDecimal totalBilled) {
        InvoiceDetailAccountObjectCode invoiceDetailAccountObjectCode = new InvoiceDetailAccountObjectCode();
        invoiceDetailAccountObjectCode.setChartOfAccountsCode("BL");
        invoiceDetailAccountObjectCode.setAccountNumber(accountNumber);
        invoiceDetailAccountObjectCode.setFinancialObjectCode(financialObjectCode);
        invoiceDetailAccountObjectCode.setCategoryCode(categoryCode);
        invoiceDetailAccountObjectCode.setCurrentExpenditures(currentExpenditures);
        invoiceDetailAccountObjectCode.setTotalBilled(totalBilled);
        return invoiceDetailAccountObjectCode;
    }

    private InvoiceDetailAccountObjectCode setupInvoiceDetailAccountObjectCode() {
        InvoiceDetailAccountObjectCode invoiceDetailAccountObjectCode = new InvoiceDetailAccountObjectCode();
        invoiceDetailAccountObjectCode.setCurrentExpenditures(new KualiDecimal(100.0));
        return invoiceDetailAccountObjectCode;
    }

    private void setupPreviouslyBilledAmount(String accountNumber, List<KualiDecimal> billAmounts) {
        ArrayList<Bill> bills = new ArrayList<Bill>();
        for (KualiDecimal billAmount : billAmounts) {
            bills.add(this.setupBillMock("1", "BL", accountNumber, billAmount, true));
        }
        this.setupBusinessObjectServiceFindMatchingMocking("1", "BL", accountNumber, Bill.class, bills);
    }

    @Test
    public void createSourceAccountingLinesByAward_ThreeAccountsBillsPreviouslyBilled() {
        ArrayList<InvoiceAccountDetail> invoiceAccountDetails = new ArrayList<InvoiceAccountDetail>();
        invoiceAccountDetails.add(this.setupInvoiceAccountDetail("BL", "0211905", KualiDecimal.ZERO));
        invoiceAccountDetails.add(this.setupInvoiceAccountDetail("BL", "0211906", KualiDecimal.ZERO));
        invoiceAccountDetails.add(this.setupInvoiceAccountDetail("BL", "0211907", KualiDecimal.ZERO));
        ArrayList<InvoiceDetailAccountObjectCode> invoiceDetailAccountObjectCodes = new ArrayList<InvoiceDetailAccountObjectCode>();
        invoiceDetailAccountObjectCodes.add(this.setupInvoiceDetailAccountObjectCode("0211905", "4100", "S&E", new KualiDecimal(25.0), KualiDecimal.ZERO));
        invoiceDetailAccountObjectCodes.add(this.setupInvoiceDetailAccountObjectCode("0211905", "2008", "SAL", new KualiDecimal(25.0), KualiDecimal.ZERO));
        invoiceDetailAccountObjectCodes.add(this.setupInvoiceDetailAccountObjectCode("0211906", "4100", "S&E", new KualiDecimal(50.0), KualiDecimal.ZERO));
        invoiceDetailAccountObjectCodes.add(this.setupInvoiceDetailAccountObjectCode("0211906", "2008", "SAL", new KualiDecimal(50.0), KualiDecimal.ZERO));
        invoiceDetailAccountObjectCodes.add(this.setupInvoiceDetailAccountObjectCode("0211907", "4100", "S&E", new KualiDecimal(125.0), KualiDecimal.ZERO));
        invoiceDetailAccountObjectCodes.add(this.setupInvoiceDetailAccountObjectCode("0211907", "2008", "SAL", new KualiDecimal(175.0), KualiDecimal.ZERO));
        this.setupPreviouslyBilledAmount("0211905", Arrays.asList(new KualiDecimal(50.0), new KualiDecimal(100.0)));
        this.setupPreviouslyBilledAmount("0211906", Arrays.asList(new KualiDecimal(50.0), new KualiDecimal(50.0)));
        ContractsGrantsInvoiceDocument cgInvoiceDocumentMock = this.setupContractsGrantsInvoiceDocumentMock("1", invoiceAccountDetails, new KualiDecimal(0.0), new KualiDecimal(450.0));
        Mockito.when((Object)cgInvoiceDocumentMock.getInvoiceDetailAccountObjectCodes()).thenReturn(invoiceDetailAccountObjectCodes);
        OrganizationAccountingDefault organizationAccountingDefault = new OrganizationAccountingDefault();
        organizationAccountingDefault.setDefaultInvoiceFinancialObjectCode("8118");
        HashMap<String, KualiDecimal> expectedAmounts = new HashMap<String, KualiDecimal>();
        expectedAmounts.put("0211905", new KualiDecimal(-100.0));
        expectedAmounts.put("0211906", KualiDecimal.ZERO);
        expectedAmounts.put("0211907", new KualiDecimal(300.0));
        List sourceAccountingLines = this.cut.createSourceAccountingLinesByAward(cgInvoiceDocumentMock, organizationAccountingDefault);
        Assert.assertNotNull((Object)sourceAccountingLines);
        Assert.assertEquals((long)3L, (long)sourceAccountingLines.size());
        for (CustomerInvoiceDetail sourceAccountingLine : sourceAccountingLines) {
            Assert.assertEquals(expectedAmounts.get(sourceAccountingLine.getAccountNumber()), (Object)sourceAccountingLine.getAmount());
        }
    }

    @Test
    public void createSourceAccountingLinesByAward_ThreeAccountsBillsAndMonthlyPreviouslyBilled() {
        ArrayList<InvoiceAccountDetail> invoiceAccountDetails = new ArrayList<InvoiceAccountDetail>();
        invoiceAccountDetails.add(this.setupInvoiceAccountDetail("BL", "0211905", new KualiDecimal(50.0)));
        invoiceAccountDetails.add(this.setupInvoiceAccountDetail("BL", "0211906", new KualiDecimal(100.0)));
        invoiceAccountDetails.add(this.setupInvoiceAccountDetail("BL", "0211907", new KualiDecimal(300.0)));
        ArrayList<InvoiceDetailAccountObjectCode> invoiceDetailAccountObjectCodes = new ArrayList<InvoiceDetailAccountObjectCode>();
        invoiceDetailAccountObjectCodes.add(this.setupInvoiceDetailAccountObjectCode("0211905", "4100", "S&E", KualiDecimal.ZERO, new KualiDecimal(25.0)));
        invoiceDetailAccountObjectCodes.add(this.setupInvoiceDetailAccountObjectCode("0211905", "2008", "SAL", new KualiDecimal(200.0), new KualiDecimal(25.0)));
        invoiceDetailAccountObjectCodes.add(this.setupInvoiceDetailAccountObjectCode("0211906", "6000", "TRAV", new KualiDecimal(25.0), KualiDecimal.ZERO));
        invoiceDetailAccountObjectCodes.add(this.setupInvoiceDetailAccountObjectCode("0211906", "4100", "S&E", KualiDecimal.ZERO, new KualiDecimal(50.0)));
        invoiceDetailAccountObjectCodes.add(this.setupInvoiceDetailAccountObjectCode("0211906", "2008", "SAL", new KualiDecimal(25.0), new KualiDecimal(50.0)));
        invoiceDetailAccountObjectCodes.add(this.setupInvoiceDetailAccountObjectCode("0211907", "6000", "TRAV", new KualiDecimal(25.0), KualiDecimal.ZERO));
        invoiceDetailAccountObjectCodes.add(this.setupInvoiceDetailAccountObjectCode("0211907", "4100", "S&E", KualiDecimal.ZERO, new KualiDecimal(125.0)));
        invoiceDetailAccountObjectCodes.add(this.setupInvoiceDetailAccountObjectCode("0211907", "2008", "SAL", new KualiDecimal(25.0), new KualiDecimal(175.0)));
        this.setupPreviouslyBilledAmount("0211905", Arrays.asList(new KualiDecimal(50.0), new KualiDecimal(100.0)));
        this.setupPreviouslyBilledAmount("0211906", Arrays.asList(new KualiDecimal(50.0), new KualiDecimal(50.0)));
        ContractsGrantsInvoiceDocument cgInvoiceDocumentMock = this.setupContractsGrantsInvoiceDocumentMock("1", invoiceAccountDetails, new KualiDecimal(450.0), new KualiDecimal(300.0));
        Mockito.when((Object)cgInvoiceDocumentMock.getInvoiceDetailAccountObjectCodes()).thenReturn(invoiceDetailAccountObjectCodes);
        OrganizationAccountingDefault organizationAccountingDefault = new OrganizationAccountingDefault();
        organizationAccountingDefault.setDefaultInvoiceFinancialObjectCode("8118");
        HashMap<String, KualiDecimal> expectedAmounts = new HashMap<String, KualiDecimal>();
        expectedAmounts.put("0211905", new KualiDecimal(200.0));
        expectedAmounts.put("0211906", new KualiDecimal(50.0));
        expectedAmounts.put("0211907", new KualiDecimal(50.0));
        List sourceAccountingLines = this.cut.createSourceAccountingLinesByAward(cgInvoiceDocumentMock, organizationAccountingDefault);
        Assert.assertNotNull((Object)sourceAccountingLines);
        Assert.assertEquals((long)3L, (long)sourceAccountingLines.size());
        for (CustomerInvoiceDetail sourceAccountingLine : sourceAccountingLines) {
            Assert.assertEquals(expectedAmounts.get(sourceAccountingLine.getAccountNumber()), (Object)sourceAccountingLine.getAmount());
        }
    }

    @Test
    public void getAwardBilledToDateAmount_NoInvoices() {
        this.setupBusinessObjectServiceFindMatchingMocking("1", null, null, Milestone.class, Collections.emptyList());
        KualiDecimal awardBilledToDateAmount = this.cut.getAwardBilledToDateAmount("1");
        Assert.assertEquals((Object)KualiDecimal.ZERO, (Object)awardBilledToDateAmount);
    }

    @Test
    public void getAwardBilledToDateAmount_CostReimbursableMilestoneAndPredeterminedBillingInvoices() {
        ArrayList<ContractsGrantsInvoiceDocument> invoiceMocks = new ArrayList<ContractsGrantsInvoiceDocument>();
        invoiceMocks.add(this.setupInvoiceMock(ArConstants.BillingFrequencyValues.MILESTONE.getCode(), KualiDecimal.ZERO));
        invoiceMocks.add(this.setupInvoiceMock(ArConstants.BillingFrequencyValues.MILESTONE.getCode(), KualiDecimal.ZERO));
        invoiceMocks.add(this.setupInvoiceMock(ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode(), KualiDecimal.ZERO));
        invoiceMocks.add(this.setupInvoiceMock(ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode(), KualiDecimal.ZERO));
        invoiceMocks.add(this.setupInvoiceMock(ArConstants.BillingFrequencyValues.MONTHLY.getCode(), new KualiDecimal(500.0)));
        invoiceMocks.add(this.setupInvoiceMock(ArConstants.BillingFrequencyValues.MONTHLY.getCode(), new KualiDecimal(600.0)));
        ArrayList<Bill> priorBills = new ArrayList<Bill>();
        priorBills.add(this.setupBillMock("1", "BL", "0211905", new KualiDecimal(300.0), true));
        priorBills.add(this.setupBillMock("1", "BL", "0211906", new KualiDecimal(400.0), true));
        this.setupBusinessObjectServiceFindMatchingMocking("1", null, null, Bill.class, priorBills);
        ArrayList<Milestone> priorMilestones = new ArrayList<Milestone>();
        priorMilestones.add(this.setupMilestoneMock("1", "BL", "0211905", new KualiDecimal(100.0), true));
        priorMilestones.add(this.setupMilestoneMock("1", "BL", "0211906", new KualiDecimal(200.0), true));
        this.setupBusinessObjectServiceFindMatchingMocking("1", null, null, Milestone.class, priorMilestones);
        ContractsGrantsInvoiceDocument invoiceMockWithDocumentNumber = this.setupInvoiceMock(ArConstants.BillingFrequencyValues.MONTHLY.getCode(), new KualiDecimal(700.0));
        Mockito.when((Object)invoiceMockWithDocumentNumber.getDocumentNumber()).thenReturn((Object)"1");
        invoiceMocks.add(invoiceMockWithDocumentNumber);
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("invoiceGeneralDetail.proposalNumber", "1");
        fieldValues.put("documentHeader.workflowDocumentStatusCode", StringUtils.join((Iterable)this.financialSystemDocumentService.getSuccessfulDocumentStatuses(), (String)"|"));
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentDaoMock.getMatchingInvoicesByCollection(fieldValues)).thenReturn(invoiceMocks);
        KualiDecimal awardBilledToDateAmount = this.cut.getAwardBilledToDateAmount("1");
        Assert.assertEquals((Object)new KualiDecimal(2800.0), (Object)awardBilledToDateAmount);
    }

    private ContractsGrantsInvoiceDocument setupInvoiceMock(String billingFrequencyCode, KualiDecimal amount) {
        ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock = (ContractsGrantsInvoiceDocument)Mockito.mock(ContractsGrantsInvoiceDocument.class);
        InvoiceGeneralDetail invoiceGeneralDetail = new InvoiceGeneralDetail();
        invoiceGeneralDetail.setBillingFrequencyCode(billingFrequencyCode);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail()).thenReturn((Object)invoiceGeneralDetail);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getTotalInvoiceAmount()).thenReturn((Object)amount);
        return contractsGrantsInvoiceDocumentMock;
    }

    @Test
    public void getAwardBilledToDateAmountExcludingDocument_NoInvoices() {
        this.setupBusinessObjectServiceFindMatchingMocking("1", null, null, Milestone.class, Collections.emptyList());
        KualiDecimal awardBilledToDateAmount = this.cut.getAwardBilledToDateAmountExcludingDocument("1", "1");
        Assert.assertEquals((Object)KualiDecimal.ZERO, (Object)awardBilledToDateAmount);
    }

    @Test
    public void getAwardBilledToDateAmountExcludingDocument_CostReimbursableMilestoneAndPredeterminedBillingInvoices() {
        ArrayList<ContractsGrantsInvoiceDocument> invoiceMocks = new ArrayList<ContractsGrantsInvoiceDocument>();
        invoiceMocks.add(this.setupInvoiceMock(ArConstants.BillingFrequencyValues.MILESTONE.getCode(), KualiDecimal.ZERO));
        invoiceMocks.add(this.setupInvoiceMock(ArConstants.BillingFrequencyValues.MILESTONE.getCode(), KualiDecimal.ZERO));
        invoiceMocks.add(this.setupInvoiceMock(ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode(), KualiDecimal.ZERO));
        invoiceMocks.add(this.setupInvoiceMock(ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode(), KualiDecimal.ZERO));
        invoiceMocks.add(this.setupInvoiceMock(ArConstants.BillingFrequencyValues.MONTHLY.getCode(), new KualiDecimal(500.0)));
        invoiceMocks.add(this.setupInvoiceMock(ArConstants.BillingFrequencyValues.MONTHLY.getCode(), new KualiDecimal(600.0)));
        ArrayList<Bill> priorBills = new ArrayList<Bill>();
        priorBills.add(this.setupBillMock("1", "BL", "0211905", new KualiDecimal(300.0), true));
        priorBills.add(this.setupBillMock("1", "BL", "0211906", new KualiDecimal(400.0), true));
        this.setupBusinessObjectServiceFindMatchingMocking("1", null, null, Bill.class, priorBills);
        ArrayList<Milestone> priorMilestones = new ArrayList<Milestone>();
        priorMilestones.add(this.setupMilestoneMock("1", "BL", "0211905", new KualiDecimal(100.0), true));
        priorMilestones.add(this.setupMilestoneMock("1", "BL", "0211906", new KualiDecimal(200.0), true));
        this.setupBusinessObjectServiceFindMatchingMocking("1", null, null, Milestone.class, priorMilestones);
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("invoiceGeneralDetail.proposalNumber", "1");
        fieldValues.put("documentHeader.workflowDocumentStatusCode", StringUtils.join((Iterable)this.financialSystemDocumentService.getSuccessfulDocumentStatuses(), (String)"|"));
        fieldValues.put("documentNumber", SearchOperator.NOT + "1");
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentDaoMock.getMatchingInvoicesByCollection(fieldValues)).thenReturn(invoiceMocks);
        KualiDecimal awardBilledToDateAmount = this.cut.getAwardBilledToDateAmountExcludingDocument("1", "1");
        Assert.assertEquals((Object)new KualiDecimal(2100.0), (Object)awardBilledToDateAmount);
    }

    @Test
    public void getAwardBilledToDateAmountExcludingDocument_InvoicesWithNullAmounts_DoNotThrowException() {
        ArrayList<ContractsGrantsInvoiceDocument> invoiceMocks = new ArrayList<ContractsGrantsInvoiceDocument>();
        invoiceMocks.add(this.setupInvoiceMock(ArConstants.BillingFrequencyValues.MILESTONE.getCode(), null));
        invoiceMocks.add(this.setupInvoiceMock(ArConstants.BillingFrequencyValues.MILESTONE.getCode(), KualiDecimal.ZERO));
        invoiceMocks.add(this.setupInvoiceMock(ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode(), null));
        invoiceMocks.add(this.setupInvoiceMock(ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode(), KualiDecimal.ZERO));
        invoiceMocks.add(this.setupInvoiceMock(ArConstants.BillingFrequencyValues.MONTHLY.getCode(), null));
        invoiceMocks.add(this.setupInvoiceMock(ArConstants.BillingFrequencyValues.MONTHLY.getCode(), new KualiDecimal(600.0)));
        ArrayList<Bill> priorBills = new ArrayList<Bill>();
        priorBills.add(this.setupBillMock("1", "BL", "0211905", new KualiDecimal(300.0), true));
        priorBills.add(this.setupBillMock("1", "BL", "0211906", new KualiDecimal(400.0), true));
        this.setupBusinessObjectServiceFindMatchingMocking("1", null, null, Bill.class, priorBills);
        ArrayList<Milestone> priorMilestones = new ArrayList<Milestone>();
        priorMilestones.add(this.setupMilestoneMock("1", "BL", "0211905", new KualiDecimal(100.0), true));
        priorMilestones.add(this.setupMilestoneMock("1", "BL", "0211906", new KualiDecimal(200.0), true));
        this.setupBusinessObjectServiceFindMatchingMocking("1", null, null, Milestone.class, priorMilestones);
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("invoiceGeneralDetail.proposalNumber", "1");
        fieldValues.put("documentHeader.workflowDocumentStatusCode", StringUtils.join((Iterable)this.financialSystemDocumentService.getSuccessfulDocumentStatuses(), (String)"|"));
        fieldValues.put("documentNumber", SearchOperator.NOT + "1");
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentDaoMock.getMatchingInvoicesByCollection(fieldValues)).thenReturn(invoiceMocks);
        KualiDecimal awardBilledToDateAmount = this.cut.getAwardBilledToDateAmountExcludingDocument("1", "1");
        Assert.assertEquals((Object)new KualiDecimal(1600.0), (Object)awardBilledToDateAmount);
    }

    @Test
    public void recalculateTotalAmountBilledToDate_NoPriorBilled_OneInvoice() {
        this.contractsGrantsInvoiceDetail.setInvoiceAmount(new KualiDecimal(100.0));
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getTotalInvoiceAmount()).thenReturn((Object)new KualiDecimal(100.0));
        this.cut.recalculateTotalAmountBilledToDate(this.contractsGrantsInvoiceDocumentMock);
        Assert.assertEquals((Object)new KualiDecimal(100.0), (Object)this.contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail().getTotalAmountBilledToDate());
    }

    @Test
    public void recalculateTotalAmountBilledToDate_NoPriorBilled_TwoInvoices() {
        this.setupBusinessObjectServiceFindMatchingMocking("1", null, null, Milestone.class, Collections.emptyList());
        InvoiceGeneralDetail invoiceGeneralDetail = new InvoiceGeneralDetail();
        invoiceGeneralDetail.setProposalNumber("1");
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail()).thenReturn((Object)invoiceGeneralDetail);
        this.contractsGrantsInvoiceDetail.setInvoiceAmount(new KualiDecimal(100.0));
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getTotalInvoiceAmount()).thenReturn((Object)new KualiDecimal(100.0));
        ArrayList<InvoiceAccountDetail> invoiceAccountDetails = new ArrayList<InvoiceAccountDetail>();
        InvoiceAccountDetail invoiceAccountDetail = this.setupInvoiceAccountDetail("BL", "0211401", KualiDecimal.ZERO);
        invoiceAccountDetail.setInvoiceAmount(new KualiDecimal(100.0));
        invoiceAccountDetails.add(invoiceAccountDetail);
        ArrayList<ContractsGrantsInvoiceDocument> invoiceDocuments = new ArrayList<ContractsGrantsInvoiceDocument>();
        ContractsGrantsInvoiceDocument cgInvoiceDocumentMock = this.setupContractsGrantsInvoiceDocumentMock("1", invoiceAccountDetails, KualiDecimal.ZERO, new KualiDecimal(100.0));
        Mockito.when((Object)cgInvoiceDocumentMock.getTotalInvoiceAmount()).thenReturn((Object)new KualiDecimal(100.0));
        invoiceDocuments.add(cgInvoiceDocumentMock);
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("invoiceGeneralDetail.proposalNumber", "1");
        fieldValues.put("invoiceGeneralDetail.billingPeriod", null);
        String docNumberCriteriaString = SearchOperator.NOT + "1";
        fieldValues.put("documentNumber", docNumberCriteriaString);
        fieldValues.put("documentHeader.financialDocumentStatusCode", SearchOperator.NOT + "P" + SearchOperator.NOT + "A");
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentDaoMock.getMatchingInvoicesByCollection(fieldValues)).thenReturn(invoiceDocuments);
        this.cut.recalculateTotalAmountBilledToDate(this.contractsGrantsInvoiceDocumentMock);
        Assert.assertEquals((Object)new KualiDecimal(200.0), (Object)this.contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail().getTotalAmountBilledToDate());
    }

    @Test
    public void recalculateTotalAmountBilledToDate_PriorBilled_OneInvoice() {
        InvoiceGeneralDetail invoiceGeneralDetail = new InvoiceGeneralDetail();
        invoiceGeneralDetail.setProposalNumber("1");
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail()).thenReturn((Object)invoiceGeneralDetail);
        this.contractsGrantsInvoiceDetail.setInvoiceAmount(new KualiDecimal(450.0));
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getTotalInvoiceAmount()).thenReturn((Object)new KualiDecimal(100.0));
        this.cut.recalculateTotalAmountBilledToDate(this.contractsGrantsInvoiceDocumentMock);
        Assert.assertEquals((Object)new KualiDecimal(450.0), (Object)this.contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail().getTotalAmountBilledToDate());
    }

    @Test
    public void recalculateTotalAmountBilledToDate_PriorBilled_TwoInvoices() {
        InvoiceGeneralDetail invoiceGeneralDetail = new InvoiceGeneralDetail();
        invoiceGeneralDetail.setProposalNumber("1");
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail()).thenReturn((Object)invoiceGeneralDetail);
        this.contractsGrantsInvoiceDetail.setInvoiceAmount(new KualiDecimal(450.0));
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getTotalInvoiceAmount()).thenReturn((Object)new KualiDecimal(100.0));
        ArrayList<InvoiceAccountDetail> invoiceAccountDetails = new ArrayList<InvoiceAccountDetail>();
        InvoiceAccountDetail invoiceAccountDetail = this.setupInvoiceAccountDetail("BL", "0211401", KualiDecimal.ZERO);
        invoiceAccountDetail.setInvoiceAmount(new KualiDecimal(100.0));
        invoiceAccountDetails.add(invoiceAccountDetail);
        ArrayList<ContractsGrantsInvoiceDocument> invoiceDocuments = new ArrayList<ContractsGrantsInvoiceDocument>();
        ContractsGrantsInvoiceDocument cgInvoiceDocumentMock = this.setupContractsGrantsInvoiceDocumentMock("1", invoiceAccountDetails, KualiDecimal.ZERO, new KualiDecimal(100.0));
        Mockito.when((Object)cgInvoiceDocumentMock.getTotalInvoiceAmount()).thenReturn((Object)new KualiDecimal(100.0));
        invoiceDocuments.add(cgInvoiceDocumentMock);
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("invoiceGeneralDetail.proposalNumber", "1");
        fieldValues.put("invoiceGeneralDetail.billingPeriod", null);
        String docNumberCriteriaString = SearchOperator.NOT + "1";
        fieldValues.put("documentNumber", docNumberCriteriaString);
        fieldValues.put("documentHeader.financialDocumentStatusCode", SearchOperator.NOT + "P" + SearchOperator.NOT + "A");
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentDaoMock.getMatchingInvoicesByCollection(fieldValues)).thenReturn(invoiceDocuments);
        this.cut.recalculateTotalAmountBilledToDate(this.contractsGrantsInvoiceDocumentMock);
        Assert.assertEquals((Object)new KualiDecimal(550.0), (Object)this.contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail().getTotalAmountBilledToDate());
    }

    @Test
    public void recalculateTotalAmountBilledToDate_PriorBilledMilestoneAndMonthly_OneInvoice() {
        InvoiceGeneralDetail invoiceGeneralDetail = new InvoiceGeneralDetail();
        invoiceGeneralDetail.setProposalNumber("1");
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail()).thenReturn((Object)invoiceGeneralDetail);
        this.contractsGrantsInvoiceDetail.setInvoiceAmount(new KualiDecimal(450.0));
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getTotalInvoiceAmount()).thenReturn((Object)new KualiDecimal(450.0));
        ArrayList<InvoiceAccountDetail> invoiceAccountDetails = new ArrayList<InvoiceAccountDetail>();
        InvoiceAccountDetail invoiceAccountDetail = this.setupInvoiceAccountDetail("BL", "0211401", KualiDecimal.ZERO);
        invoiceAccountDetail.setInvoiceAmount(new KualiDecimal(100.0));
        invoiceAccountDetails.add(invoiceAccountDetail);
        ArrayList<ContractsGrantsInvoiceDocument> invoiceDocuments = new ArrayList<ContractsGrantsInvoiceDocument>();
        ContractsGrantsInvoiceDocument cgInvoiceDocumentMock = this.setupContractsGrantsInvoiceDocumentMock("1", invoiceAccountDetails, new KualiDecimal(350.0), new KualiDecimal(100.0));
        Mockito.when((Object)cgInvoiceDocumentMock.getTotalInvoiceAmount()).thenReturn((Object)new KualiDecimal(100.0));
        invoiceDocuments.add(cgInvoiceDocumentMock);
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("invoiceGeneralDetail.proposalNumber", "1");
        fieldValues.put("documentHeader.workflowDocumentStatusCode", StringUtils.join((Iterable)this.financialSystemDocumentService.getSuccessfulDocumentStatuses(), (String)"|"));
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentDaoMock.getMatchingInvoicesByCollection(fieldValues)).thenReturn(invoiceDocuments);
        this.cut.recalculateTotalAmountBilledToDate(this.contractsGrantsInvoiceDocumentMock);
        Assert.assertEquals((Object)new KualiDecimal(900.0), (Object)this.contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail().getTotalAmountBilledToDate());
    }

    @Test
    public void recalculateTotalAmountBilledToDate_PriorBilledMilestoneAndMonthly_TwoInvoices() {
        InvoiceGeneralDetail invoiceGeneralDetail = new InvoiceGeneralDetail();
        invoiceGeneralDetail.setProposalNumber("1");
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail()).thenReturn((Object)invoiceGeneralDetail);
        this.contractsGrantsInvoiceDetail.setInvoiceAmount(new KualiDecimal(450.0));
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getTotalInvoiceAmount()).thenReturn((Object)new KualiDecimal(450.0));
        ArrayList<InvoiceAccountDetail> invoiceAccountDetails = new ArrayList<InvoiceAccountDetail>();
        InvoiceAccountDetail invoiceAccountDetail = this.setupInvoiceAccountDetail("BL", "0211401", KualiDecimal.ZERO);
        invoiceAccountDetail.setInvoiceAmount(new KualiDecimal(100.0));
        invoiceAccountDetails.add(invoiceAccountDetail);
        ArrayList<ContractsGrantsInvoiceDocument> invoiceDocuments = new ArrayList<ContractsGrantsInvoiceDocument>();
        ContractsGrantsInvoiceDocument cgInvoiceDocumentMock = this.setupContractsGrantsInvoiceDocumentMock("1", invoiceAccountDetails, KualiDecimal.ZERO, new KualiDecimal(100.0));
        Mockito.when((Object)cgInvoiceDocumentMock.getTotalInvoiceAmount()).thenReturn((Object)new KualiDecimal(100.0));
        invoiceDocuments.add(cgInvoiceDocumentMock);
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("invoiceGeneralDetail.proposalNumber", "1");
        fieldValues.put("invoiceGeneralDetail.billingPeriod", null);
        String docNumberCriteriaString = SearchOperator.NOT + "1";
        fieldValues.put("documentNumber", docNumberCriteriaString);
        fieldValues.put("documentHeader.financialDocumentStatusCode", SearchOperator.NOT + "P" + SearchOperator.NOT + "A");
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentDaoMock.getMatchingInvoicesByCollection(fieldValues)).thenReturn(invoiceDocuments);
        ArrayList<InvoiceAccountDetail> invoiceAccountDetails2 = new ArrayList<InvoiceAccountDetail>();
        InvoiceAccountDetail invoiceAccountDetail2 = this.setupInvoiceAccountDetail("BL", "0211401", KualiDecimal.ZERO);
        invoiceAccountDetail2.setInvoiceAmount(new KualiDecimal(450.0));
        invoiceAccountDetails2.add(invoiceAccountDetail2);
        ArrayList<ContractsGrantsInvoiceDocument> invoiceDocuments2 = new ArrayList<ContractsGrantsInvoiceDocument>();
        ContractsGrantsInvoiceDocument cgInvoiceDocumentMock2 = this.setupContractsGrantsInvoiceDocumentMock("1", invoiceAccountDetails2, new KualiDecimal(350.0), new KualiDecimal(100.0));
        Mockito.when((Object)cgInvoiceDocumentMock2.getTotalInvoiceAmount()).thenReturn((Object)new KualiDecimal(100.0));
        invoiceDocuments2.add(cgInvoiceDocumentMock2);
        HashMap<String, String> fieldValues2 = new HashMap<String, String>();
        fieldValues2.put("invoiceGeneralDetail.proposalNumber", "1");
        fieldValues2.put("documentHeader.workflowDocumentStatusCode", StringUtils.join((Iterable)this.financialSystemDocumentService.getSuccessfulDocumentStatuses(), (String)"|"));
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentDaoMock.getMatchingInvoicesByCollection(fieldValues2)).thenReturn(invoiceDocuments2);
        this.cut.recalculateTotalAmountBilledToDate(this.contractsGrantsInvoiceDocumentMock);
        Assert.assertEquals((Object)new KualiDecimal(1000.0), (Object)this.contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail().getTotalAmountBilledToDate());
    }

    @Test
    public void recalculateObjectCodeByCategory() {
        this.contractsGrantsInvoiceDetail.setInvoiceAmount(new KualiDecimal(1000.0));
        KualiDecimal total = new KualiDecimal(1000.0);
        ArrayList<InvoiceDetailAccountObjectCode> invoiceDetailAccountObjectCodes = new ArrayList<InvoiceDetailAccountObjectCode>();
        invoiceDetailAccountObjectCodes.add(this.setupInvoiceDetailAccountObjectCode());
        invoiceDetailAccountObjectCodes.add(this.setupInvoiceDetailAccountObjectCode());
        invoiceDetailAccountObjectCodes.add(this.setupInvoiceDetailAccountObjectCode());
        this.cut.recalculateObjectCodeByCategory(this.contractsGrantsInvoiceDocumentMock, this.contractsGrantsInvoiceDetail, total, invoiceDetailAccountObjectCodes);
        Assert.assertEquals((Object)new KualiDecimal(333.34), (Object)((InvoiceDetailAccountObjectCode)invoiceDetailAccountObjectCodes.get(0)).getCurrentExpenditures());
        Assert.assertEquals((Object)new KualiDecimal(333.33), (Object)((InvoiceDetailAccountObjectCode)invoiceDetailAccountObjectCodes.get(1)).getCurrentExpenditures());
        Assert.assertEquals((Object)new KualiDecimal(333.33), (Object)((InvoiceDetailAccountObjectCode)invoiceDetailAccountObjectCodes.get(2)).getCurrentExpenditures());
    }
}

