/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.sql.Date;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.runner.RunWith;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.krad.service.DocumentHeaderService;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsCollectionActivityInvoiceDetail;
import org.kuali.kfs.module.ar.document.ContractsGrantsCollectionActivityDocument;
import org.kuali.kfs.module.ar.document.validation.impl.ContractsGrantsCollectionActivityDocumentRule;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={KRADServiceLocatorWeb.class, ContractsGrantsCollectionActivityDocumentRule.class})
@Execution(value=ExecutionMode.SAME_THREAD)
public class ContractsGrantsCollectionActivityDocumentRuleTest {
    @Mock
    private DataDictionaryService dataDictionarySvcMock;
    private ContractsGrantsCollectionActivityDocumentRule cut;
    private ContractsGrantsCollectionActivityDocument contractsGrantsCollectionActivityDocument;
    private static final String ACTIVITY_CODE = "LSTS";

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        PowerMockito.mockStatic(KRADServiceLocatorWeb.class, (Class[])new Class[0]);
        DocumentHeaderService docHeaderSvcMock = (DocumentHeaderService)Mockito.mock(DocumentHeaderService.class);
        Mockito.when((Object)KRADServiceLocatorWeb.getDocumentHeaderService()).thenReturn((Object)docHeaderSvcMock);
        Class<FinancialSystemDocumentHeader> clazz = FinancialSystemDocumentHeader.class;
        Mockito.when((Object)docHeaderSvcMock.getDocumentHeaderBaseClass()).thenReturn(clazz);
        this.contractsGrantsCollectionActivityDocument = new ContractsGrantsCollectionActivityDocument();
        this.contractsGrantsCollectionActivityDocument.getDocumentHeader().setDocumentDescription("Testing document");
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeLabel(ContractsGrantsCollectionActivityDocument.class, "proposalNumber")).thenReturn((Object)"Proposal Number");
        this.cut = (ContractsGrantsCollectionActivityDocumentRule)PowerMockito.spy((Object)new ContractsGrantsCollectionActivityDocumentRule());
        PowerMockito.doReturn((Object)this.dataDictionarySvcMock).when((Object)this.cut, "getDataDictionaryService", new Object[0]);
    }

    @Test
    public void testValidateCollectionActivityDocument_Valid_True() {
        this.contractsGrantsCollectionActivityDocument.setProposalNumber("11");
        this.contractsGrantsCollectionActivityDocument.setActivityCode(ACTIVITY_CODE);
        this.contractsGrantsCollectionActivityDocument.setActivityDate(new Date(System.currentTimeMillis()));
        this.contractsGrantsCollectionActivityDocument.setActivityText("testing activity comment");
        ArrayList<ContractsGrantsCollectionActivityInvoiceDetail> invoiceDetails = new ArrayList<ContractsGrantsCollectionActivityInvoiceDetail>();
        ContractsGrantsCollectionActivityInvoiceDetail invoiceDetail = new ContractsGrantsCollectionActivityInvoiceDetail();
        invoiceDetails.add(invoiceDetail);
        this.contractsGrantsCollectionActivityDocument.setInvoiceDetails(invoiceDetails);
        boolean result = this.cut.validateCollectionActivityDocument(this.contractsGrantsCollectionActivityDocument);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testValidateCollectionActivityDocument_Invalid_False() {
        boolean result = this.cut.validateCollectionActivityDocument(this.contractsGrantsCollectionActivityDocument);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testValidateCollectionActivityDocument_missingProposalNumber_False() {
        this.contractsGrantsCollectionActivityDocument.setActivityCode(ACTIVITY_CODE);
        this.contractsGrantsCollectionActivityDocument.setActivityDate(new Date(System.currentTimeMillis()));
        this.contractsGrantsCollectionActivityDocument.setActivityText("testing activity comment");
        ArrayList<ContractsGrantsCollectionActivityInvoiceDetail> invoiceDetails = new ArrayList<ContractsGrantsCollectionActivityInvoiceDetail>();
        ContractsGrantsCollectionActivityInvoiceDetail invoiceDetail = new ContractsGrantsCollectionActivityInvoiceDetail();
        invoiceDetails.add(invoiceDetail);
        this.contractsGrantsCollectionActivityDocument.setInvoiceDetails(invoiceDetails);
        boolean result = this.cut.validateCollectionActivityDocument(this.contractsGrantsCollectionActivityDocument);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testValidateCollectionActivityDocument__missingInvoiceDetails_False() {
        this.contractsGrantsCollectionActivityDocument.setProposalNumber("11");
        this.contractsGrantsCollectionActivityDocument.setActivityCode(ACTIVITY_CODE);
        this.contractsGrantsCollectionActivityDocument.setActivityDate(new Date(System.currentTimeMillis()));
        this.contractsGrantsCollectionActivityDocument.setActivityText("testing activity comment");
        boolean result = this.cut.validateCollectionActivityDocument(this.contractsGrantsCollectionActivityDocument);
        Assert.assertFalse((boolean)result);
    }
}

