/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.businessobject.InvoiceAddressDetail;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.validation.impl.ContractsGrantsInvoiceDocumentValidation;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@Execution(value=ExecutionMode.SAME_THREAD)
public class ContractsGrantsInvoiceDocumentValidationTest {
    private ContractsGrantsInvoiceDocumentValidation cut;
    @Mock
    private ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock;
    @Mock
    private InvoiceAddressDetail invoiceAddressDetailMock;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        GlobalVariables.getMessageMap().clearErrorMessages();
        Mockito.when((Object)this.invoiceAddressDetailMock.getCustomerAddressTypeCode()).thenReturn((Object)"P");
        Mockito.when((Object)this.invoiceAddressDetailMock.getInvoiceTransmissionMethodCode()).thenReturn((Object)"EMAIL");
        Mockito.when((Object)this.invoiceAddressDetailMock.getCustomerEmailAddress()).thenReturn((Object)"fake@email.com");
        Mockito.when((Object)this.invoiceAddressDetailMock.getCustomerInvoiceTemplateCode()).thenReturn((Object)"STD");
        ArrayList<InvoiceAddressDetail> invoiceAddressDetails = new ArrayList<InvoiceAddressDetail>();
        invoiceAddressDetails.add(this.invoiceAddressDetailMock);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getInvoiceAddressDetails()).thenReturn(invoiceAddressDetails);
        this.cut = new ContractsGrantsInvoiceDocumentValidation();
        this.cut.setContractsGrantsInvoiceDocument(this.contractsGrantsInvoiceDocumentMock);
    }

    @Test
    public void validate_HasAddressDetailsEmail_VALID() {
        Assert.assertTrue((boolean)this.cut.validate(null));
    }

    @Test
    public void validate_NoAddressDetails_VALID() {
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getInvoiceAddressDetails()).thenReturn((Object)Collections.EMPTY_LIST);
        Assert.assertTrue((boolean)this.cut.validate(null));
    }

    @Test
    public void validate_NoEmailAddress_INVALID() {
        Mockito.when((Object)this.invoiceAddressDetailMock.getCustomerEmailAddress()).thenReturn(null);
        Assert.assertFalse((boolean)this.cut.validate(null));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("document.invoiceAddressDetails[0].customerEmailAddress");
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assert.assertEquals((Object)"error.document.contractsGrantsInvoice.email.address.required", (Object)errorMessage.getErrorKey());
        Assert.assertEquals((long)0L, (long)errorMessage.getMessageParameters().length);
    }

    @Test
    public void validate_NoTransmissionCode_INVALID() {
        Mockito.when((Object)this.invoiceAddressDetailMock.getInvoiceTransmissionMethodCode()).thenReturn(null);
        Assert.assertFalse((boolean)this.cut.validate(null));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("document.invoiceAddressDetails[0].invoiceTransmissionMethodCode");
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assert.assertEquals((Object)"error.document.contractsGrantsInvoice.transmission.code.required", (Object)errorMessage.getErrorKey());
        Assert.assertEquals((long)0L, (long)errorMessage.getMessageParameters().length);
    }

    @Test
    public void validate_NoTemplateCode_INVALID() {
        Mockito.when((Object)this.invoiceAddressDetailMock.getCustomerInvoiceTemplateCode()).thenReturn(null);
        Assert.assertFalse((boolean)this.cut.validate(null));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("document.invoiceAddressDetails[0].customerInvoiceTemplateCode");
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assert.assertEquals((Object)"error.document.contractsGrantsInvoice.template.code.required", (Object)errorMessage.getErrorKey());
        Assert.assertEquals((long)0L, (long)errorMessage.getMessageParameters().length);
    }

    @Test
    public void validate_NoEmailAddress_CorrectionDoc_VALID() {
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.isCorrectionDocument()).thenReturn((Object)true);
        Mockito.when((Object)this.invoiceAddressDetailMock.getCustomerEmailAddress()).thenReturn(null);
        Assert.assertTrue((boolean)this.cut.validate(null));
    }

    @Test
    public void validate_NoTransmissionCode_CorrectionDoc_VALID() {
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.isCorrectionDocument()).thenReturn((Object)true);
        Mockito.when((Object)this.invoiceAddressDetailMock.getInvoiceTransmissionMethodCode()).thenReturn(null);
        Assert.assertTrue((boolean)this.cut.validate(null));
    }

    @Test
    public void validate_NoTemplateCode_CorrectionDoc_VALID() {
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.isCorrectionDocument()).thenReturn((Object)true);
        Mockito.when((Object)this.invoiceAddressDetailMock.getCustomerInvoiceTemplateCode()).thenReturn(null);
        Assert.assertTrue((boolean)this.cut.validate(null));
    }
}

