/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.sql.Date;
import java.time.LocalDate;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.module.ar.businessobject.Customer;
import org.kuali.kfs.module.ar.businessobject.CustomerAddress;
import org.kuali.kfs.module.ar.document.validation.impl.CustomerRule;

@Execution(value=ExecutionMode.SAME_THREAD)
public class CustomerRuleTest {
    private static final String CUSTOMER_ADDRESS_NAME = "Address Name";
    private static final String CUSTOMER_ADDRESS_COUNTRY_CODE_US = "US";
    private static final String CUSTOMER_ADDRESS_COUNTRY_CODE_RO = "RO";
    private static final String CUSTOMER_ADDRESS_STATE_CODE = "NY";
    private static final String CUSTOMER_ADDRESS_ZIP_CODE = "14850";
    private CustomerRule cut;
    private Customer customer;
    private CustomerAddress customerAddress;

    @Before
    public void setUp() {
        this.cut = new CustomerRule();
        this.customer = new Customer();
        this.customerAddress = new CustomerAddress();
    }

    @Test
    public void checkCustomerHasAddress_HasAddress() {
        this.customer.getCustomerAddresses().add(this.customerAddress);
        boolean result = this.cut.checkCustomerHasAddress(this.customer);
        Assert.assertTrue((String)"When customer has an address checkCustomerHasAddress should return true. ", (boolean)result);
    }

    @Test
    public void checkCustomerHasAddress_NoAddress() {
        this.customer.getCustomerAddresses().clear();
        boolean result = this.cut.checkCustomerHasAddress(this.customer);
        Assert.assertFalse((String)"When customer does not have an address checkCustomerHasAddress should return false. ", (boolean)result);
    }

    @Test
    public void checkAddressIsValid_CountryUS_StateAndZipCodeSet() {
        this.customerAddress.setCustomerAddressName(CUSTOMER_ADDRESS_NAME);
        this.customerAddress.setCustomerCountryCode(CUSTOMER_ADDRESS_COUNTRY_CODE_US);
        this.customerAddress.setCustomerStateCode(CUSTOMER_ADDRESS_STATE_CODE);
        this.customerAddress.setCustomerZipCode(CUSTOMER_ADDRESS_ZIP_CODE);
        boolean result = this.cut.checkAddressIsValid(this.customerAddress);
        Assert.assertTrue((String)"When customer address has country code US and state code and zip code are not empty checkAddressIsValid should return true. ", (boolean)result);
    }

    @Test
    public void testCheckAddressIsValid_CountryUS_StateAndZipCodeEmpty() {
        this.customerAddress.setCustomerAddressName(CUSTOMER_ADDRESS_NAME);
        this.customerAddress.setCustomerCountryCode(CUSTOMER_ADDRESS_COUNTRY_CODE_US);
        this.customerAddress.setCustomerStateCode("");
        this.customerAddress.setCustomerZipCode("");
        boolean result = this.cut.checkAddressIsValid(this.customerAddress);
        Assert.assertFalse((String)"When customer address has country code US and state code and zip code are empty checkAddressIsValid should return false. ", (boolean)result);
    }

    @Test
    public void checkAddressIsValid_CountryNonUS_InternationalProvinceNameAndMailCodeEmpty() {
        this.customerAddress.setCustomerAddressName(CUSTOMER_ADDRESS_NAME);
        this.customerAddress.setCustomerCountryCode(CUSTOMER_ADDRESS_COUNTRY_CODE_RO);
        this.customerAddress.setCustomerAddressInternationalProvinceName("");
        this.customerAddress.setCustomerZipCode("");
        boolean result = this.cut.checkAddressIsValid(this.customerAddress);
        Assert.assertTrue((String)"When customer address has country code RO and province and International Mail Code are empty checkAddressIsValid should return true; province and international mail code are never required. ", (boolean)result);
    }

    @Test
    public void checkAddresses_OnePrimaryAddress() {
        this.customerAddress.setCustomerAddressTypeCode("P");
        this.customer.getCustomerAddresses().add(this.customerAddress);
        boolean result = this.cut.checkAddresses(this.customer);
        Assert.assertTrue((String)"When customer has one primary address checkAddresses should return true. ", (boolean)result);
    }

    @Test
    public void checkAddresses_HasMore_MoreThanOnePrimaryAddress() {
        this.customerAddress.setCustomerAddressTypeCode("P");
        this.customer.getCustomerAddresses().add(this.customerAddress);
        this.customer.getCustomerAddresses().add(this.customerAddress);
        boolean result = this.cut.checkAddresses(this.customer);
        Assert.assertFalse((String)"When customer has more than one primary address checkAddresses should return false. ", (boolean)result);
    }

    @Test
    public void checkAddresses_HasNone_NoPrimaryAddress() {
        this.customerAddress.setCustomerAddressTypeCode("A");
        this.customer.getCustomerAddresses().add(this.customerAddress);
        boolean result = this.cut.checkAddresses(this.customer);
        Assert.assertFalse((String)"When customer has no primary address checkAddresses should return false. ", (boolean)result);
    }

    @Test
    public void checkEndDateIsValid_Today_Invalid() {
        Date endDate = Date.valueOf(LocalDate.now());
        Assert.assertFalse((boolean)this.cut.checkEndDateIsValid(endDate, false));
    }

    @Test
    public void checkEndDateIsValid_Today_Valid() {
        Date endDate = Date.valueOf(LocalDate.now());
        Assert.assertTrue((boolean)this.cut.checkEndDateIsValid(endDate, true));
    }

    @Test
    public void checkEndDateIsValid_Tomorrow_Valid() {
        Date endDate = Date.valueOf(LocalDate.now().plusDays(1L));
        Assert.assertTrue((boolean)this.cut.checkEndDateIsValid(endDate, false));
    }
}

