/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.rules.ExpectedException;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.businessobject.FinalBilledIndicatorEntry;
import org.kuali.kfs.module.ar.businessobject.InvoiceGeneralDetail;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.FinalBilledIndicatorDocument;
import org.kuali.kfs.module.ar.document.validation.impl.FinalBilledIndicatorValidation;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@Execution(value=ExecutionMode.SAME_THREAD)
public class FinalBilledIndicatorValidationTest {
    @Mock
    private DocumentService documentSvcMock;
    @Mock
    private FinalBilledIndicatorDocument finalBilledIndicatorDocumentMock;
    private FinalBilledIndicatorEntry finalBilledIndicatorEntry;
    private List<FinalBilledIndicatorEntry> finalBilledIndicatorEntries;
    private InvoiceGeneralDetail invoiceGeneralDetail;
    @Mock
    private WorkflowDocument workflowDocumentMock;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setUp() throws WorkflowException {
        MockitoAnnotations.initMocks((Object)this);
        FinalBilledIndicatorValidation.setDocumentService((DocumentService)this.documentSvcMock);
        GlobalVariables.getMessageMap().clearErrorMessages();
        this.setupDocumentAndBusinessObjectMocks();
    }

    private void setupDocumentAndBusinessObjectMocks() throws WorkflowException {
        this.finalBilledIndicatorEntries = new ArrayList<FinalBilledIndicatorEntry>();
        this.finalBilledIndicatorEntry = new FinalBilledIndicatorEntry();
        this.finalBilledIndicatorEntry.setInvoiceDocumentNumber("1");
        this.finalBilledIndicatorEntries.add(this.finalBilledIndicatorEntry);
        Mockito.when((Object)this.finalBilledIndicatorDocumentMock.getInvoiceEntries()).thenReturn(this.finalBilledIndicatorEntries);
        Mockito.when((Object)this.workflowDocumentMock.getDocumentTypeName()).thenReturn((Object)"CINV");
        Mockito.when((Object)this.workflowDocumentMock.isFinal()).thenReturn((Object)true);
        DocumentHeader documentHeaderMock = (DocumentHeader)Mockito.mock(DocumentHeader.class);
        Mockito.when((Object)documentHeaderMock.getWorkflowDocument()).thenReturn((Object)this.workflowDocumentMock);
        this.invoiceGeneralDetail = new InvoiceGeneralDetail();
        this.invoiceGeneralDetail.setFinalBillIndicator(true);
        ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock = (ContractsGrantsInvoiceDocument)Mockito.mock(ContractsGrantsInvoiceDocument.class);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getDocumentHeader()).thenReturn((Object)documentHeaderMock);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail()).thenReturn((Object)this.invoiceGeneralDetail);
        Mockito.when((Object)this.documentSvcMock.documentExists("1")).thenReturn((Object)true);
        Mockito.when((Object)this.documentSvcMock.getByDocumentHeaderId("1")).thenReturn((Object)contractsGrantsInvoiceDocumentMock);
    }

    @Test
    public void validateDocument() {
        Assert.assertTrue((boolean)FinalBilledIndicatorValidation.validateDocument((Document)this.finalBilledIndicatorDocumentMock));
    }

    @Test
    public void validateDocument_NoFinalBilledEntries() {
        Mockito.when((Object)this.finalBilledIndicatorDocumentMock.getInvoiceEntries()).thenReturn(Collections.emptyList());
        Assert.assertFalse((boolean)FinalBilledIndicatorValidation.validateDocument((Document)this.finalBilledIndicatorDocumentMock));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        Map errorMessages = GlobalVariables.getMessageMap().getErrorMessages();
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        List finalBilledIndicatorErrorMessages = (List)errorMessages.get("document.invoiceEntries");
        Assert.assertEquals((long)1L, (long)finalBilledIndicatorErrorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)finalBilledIndicatorErrorMessages.get(0);
        Assert.assertEquals((Object)"error.final.billed.indicator.no.invoice", (Object)errorMessage.getErrorKey());
        Assert.assertEquals((long)0L, (long)errorMessage.getMessageParameters().length);
    }

    @Test
    public void validateDocument_NullEntry() {
        this.finalBilledIndicatorEntries.add(null);
        Assert.assertFalse((boolean)FinalBilledIndicatorValidation.validateDocument((Document)this.finalBilledIndicatorDocumentMock));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        Map errorMessages = GlobalVariables.getMessageMap().getErrorMessages();
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        List finalBilledIndicatorErrorMessages = (List)errorMessages.get("document.invoiceEntries");
        Assert.assertEquals((long)1L, (long)finalBilledIndicatorErrorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)finalBilledIndicatorErrorMessages.get(0);
        Assert.assertEquals((Object)"error.final.billed.indicator.no.invoice", (Object)errorMessage.getErrorKey());
        Assert.assertEquals((long)0L, (long)errorMessage.getMessageParameters().length);
    }

    @Test
    public void validateDocument_NoInvoiceNumber() {
        this.finalBilledIndicatorEntry.setInvoiceDocumentNumber(null);
        Assert.assertFalse((boolean)FinalBilledIndicatorValidation.validateDocument((Document)this.finalBilledIndicatorDocumentMock));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        Map errorMessages = GlobalVariables.getMessageMap().getErrorMessages();
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        List finalBilledIndicatorErrorMessages = (List)errorMessages.get("document.invoiceEntries");
        Assert.assertEquals((long)1L, (long)finalBilledIndicatorErrorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)finalBilledIndicatorErrorMessages.get(0);
        Assert.assertEquals((Object)"error.final.billed.indicator.no.invoice", (Object)errorMessage.getErrorKey());
        Assert.assertEquals((long)0L, (long)errorMessage.getMessageParameters().length);
    }

    @Test
    public void validateDocument_MissingDocument() {
        this.finalBilledIndicatorEntry.setInvoiceDocumentNumber("2");
        Assert.assertFalse((boolean)FinalBilledIndicatorValidation.validateDocument((Document)this.finalBilledIndicatorDocumentMock));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        Map errorMessages = GlobalVariables.getMessageMap().getErrorMessages();
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        List finalBilledIndicatorErrorMessages = (List)errorMessages.get("document.invoiceEntries");
        Assert.assertEquals((long)1L, (long)finalBilledIndicatorErrorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)finalBilledIndicatorErrorMessages.get(0);
        Assert.assertEquals((Object)"error.final.billed.indicator.invalid.invoice", (Object)errorMessage.getErrorKey());
        Assert.assertEquals((long)0L, (long)errorMessage.getMessageParameters().length);
    }

    @Test
    public void validateDocument_InvalidDocumentType() {
        Mockito.when((Object)this.workflowDocumentMock.getDocumentTypeName()).thenReturn((Object)"LCR");
        Assert.assertFalse((boolean)FinalBilledIndicatorValidation.validateDocument((Document)this.finalBilledIndicatorDocumentMock));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        Map errorMessages = GlobalVariables.getMessageMap().getErrorMessages();
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        List finalBilledIndicatorErrorMessages = (List)errorMessages.get("document.invoiceEntries");
        Assert.assertEquals((long)1L, (long)finalBilledIndicatorErrorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)finalBilledIndicatorErrorMessages.get(0);
        Assert.assertEquals((Object)"error.final.billed.indicator.invalid.invoice", (Object)errorMessage.getErrorKey());
        Assert.assertEquals((long)0L, (long)errorMessage.getMessageParameters().length);
    }

    @Test
    public void validateDocument_WorkflowException() throws WorkflowException {
        Mockito.when((Object)this.documentSvcMock.documentExists("2")).thenReturn((Object)true);
        Mockito.when((Object)this.documentSvcMock.getByDocumentHeaderId("1")).thenThrow(new Throwable[]{new WorkflowException("test exception")});
        this.expectedException.expect(RuntimeException.class);
        this.expectedException.expectMessage("problem during FinalBilledIndicatorValidation.validContractsGrantsInvoiceValidation()");
        this.expectedException.expectCause(IsInstanceOf.instanceOf(WorkflowException.class));
        Assert.assertFalse((boolean)FinalBilledIndicatorValidation.validateDocument((Document)this.finalBilledIndicatorDocumentMock));
    }

    @Test
    public void validateDocument_DocumentEnroute() {
        Mockito.when((Object)this.workflowDocumentMock.isFinal()).thenReturn((Object)false);
        Mockito.when((Object)this.workflowDocumentMock.isEnroute()).thenReturn((Object)true);
        Assert.assertFalse((boolean)FinalBilledIndicatorValidation.validateDocument((Document)this.finalBilledIndicatorDocumentMock));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        Map errorMessages = GlobalVariables.getMessageMap().getErrorMessages();
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        List finalBilledIndicatorErrorMessages = (List)errorMessages.get("document.invoiceEntries");
        Assert.assertEquals((long)1L, (long)finalBilledIndicatorErrorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)finalBilledIndicatorErrorMessages.get(0);
        Assert.assertEquals((Object)"error.final.billed.indicator.invoice.not.final", (Object)errorMessage.getErrorKey());
        Assert.assertEquals((long)0L, (long)errorMessage.getMessageParameters().length);
    }

    @Test
    public void validateDocument_NotMarkedFinal() {
        this.invoiceGeneralDetail.setFinalBillIndicator(false);
        Assert.assertFalse((boolean)FinalBilledIndicatorValidation.validateDocument((Document)this.finalBilledIndicatorDocumentMock));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        Map errorMessages = GlobalVariables.getMessageMap().getErrorMessages();
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        List finalBilledIndicatorErrorMessages = (List)errorMessages.get("document.invoiceEntries");
        Assert.assertEquals((long)1L, (long)finalBilledIndicatorErrorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)finalBilledIndicatorErrorMessages.get(0);
        Assert.assertEquals((Object)"error.final.billed.indicator.invoice.not.marked.final.bill", (Object)errorMessage.getErrorKey());
        Assert.assertEquals((long)0L, (long)errorMessage.getMessageParameters().length);
    }
}

