/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.authorization;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.module.ar.businessobject.CashControlDetail;
import org.kuali.kfs.module.ar.document.CashControlDocument;
import org.kuali.kfs.module.ar.document.PaymentApplicationDocument;
import org.kuali.kfs.module.ar.document.authorization.CashControlDocumentPresentationController;
import org.kuali.kfs.sys.businessobject.ElectronicPaymentClaim;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.document.authorization.FinancialSystemTransactionalDocumentPresentationControllerBase;
import org.kuali.kfs.sys.service.BankService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.impl.document.WorkflowDocumentImpl;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@Execution(value=ExecutionMode.SAME_THREAD)
public class CashControlDocumentPresentationControllerTest {
    private CashControlDocumentPresentationController cut;
    @Mock
    private BankService bankSvcMock;
    @Mock
    private CashControlDocument cashControlDocMock;
    @Mock
    private WorkflowDocument cashControlWorkflowDocMock;
    @Mock
    private WorkflowDocumentImpl payAppWorkflowDocMock;
    @Mock
    private WorkflowDocumentImpl anotherPayAppWorkflowDocMock;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        DocumentHeader cashControlDocHeaderMock = (DocumentHeader)Mockito.mock(DocumentHeader.class);
        Mockito.when((Object)cashControlDocHeaderMock.getWorkflowDocument()).thenReturn((Object)this.cashControlWorkflowDocMock);
        Mockito.when((Object)this.cashControlDocMock.getDocumentHeader()).thenReturn((Object)cashControlDocHeaderMock);
        List<CashControlDetail> cashControlDetails = Arrays.asList(this.buildCashControlDetailMock(this.payAppWorkflowDocMock), this.buildCashControlDetailMock(this.anotherPayAppWorkflowDocMock));
        Mockito.when((Object)this.cashControlDocMock.getCashControlDetails()).thenReturn(cashControlDetails);
        this.cut = new CashControlDocumentPresentationController();
        FinancialSystemTransactionalDocumentPresentationControllerBase.setBankService((BankService)this.bankSvcMock);
    }

    private CashControlDetail buildCashControlDetailMock(WorkflowDocumentImpl payAppWorkflowDocMock) {
        DocumentHeader payAppDocHeaderMock = (DocumentHeader)Mockito.mock(DocumentHeader.class);
        Mockito.when((Object)payAppDocHeaderMock.getWorkflowDocument()).thenReturn((Object)payAppWorkflowDocMock);
        PaymentApplicationDocument paymentApplicationDocMock = (PaymentApplicationDocument)Mockito.mock(PaymentApplicationDocument.class);
        Mockito.when((Object)paymentApplicationDocMock.getDocumentHeader()).thenReturn((Object)payAppDocHeaderMock);
        CashControlDetail cashControlDetailMock = (CashControlDetail)Mockito.mock(CashControlDetail.class);
        Mockito.when((Object)cashControlDetailMock.getReferenceFinancialDocument()).thenReturn((Object)paymentApplicationDocMock);
        return cashControlDetailMock;
    }

    @After
    public void tearDown() {
        FinancialSystemTransactionalDocumentPresentationControllerBase.setBankService(null);
    }

    @Test
    public void canApprove_NoAppDocs_True() {
        Mockito.when((Object)this.cashControlDocMock.getCashControlDetails()).thenReturn(new ArrayList());
        Assert.assertFalse((boolean)this.cut.canApprove((Document)this.cashControlDocMock));
    }

    @Test
    public void canApprove_ApprovedAppDocs_True() {
        Mockito.when((Object)this.payAppWorkflowDocMock.isApproved()).thenReturn((Object)true);
        Mockito.when((Object)this.anotherPayAppWorkflowDocMock.isApproved()).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.cut.canApprove((Document)this.cashControlDocMock));
    }

    @Test
    public void canApprove_ProcessedAppDocs_True() {
        Mockito.when((Object)this.payAppWorkflowDocMock.isProcessed()).thenReturn((Object)true);
        Mockito.when((Object)this.anotherPayAppWorkflowDocMock.isProcessed()).thenReturn((Object)true);
        ((WorkflowDocumentImpl)Mockito.doCallRealMethod().when((Object)this.payAppWorkflowDocMock)).isApproved();
        ((WorkflowDocumentImpl)Mockito.doCallRealMethod().when((Object)this.anotherPayAppWorkflowDocMock)).isApproved();
        Assert.assertTrue((boolean)this.cut.canApprove((Document)this.cashControlDocMock));
    }

    @Test
    public void canApprove_FinalAppDocs_True() {
        Mockito.when((Object)this.payAppWorkflowDocMock.isFinal()).thenReturn((Object)true);
        Mockito.when((Object)this.anotherPayAppWorkflowDocMock.isFinal()).thenReturn((Object)true);
        ((WorkflowDocumentImpl)Mockito.doCallRealMethod().when((Object)this.payAppWorkflowDocMock)).isApproved();
        ((WorkflowDocumentImpl)Mockito.doCallRealMethod().when((Object)this.anotherPayAppWorkflowDocMock)).isApproved();
        Assert.assertTrue((boolean)this.cut.canApprove((Document)this.cashControlDocMock));
    }

    @Test
    public void canApprove_CanceledAppDocs_True() {
        Mockito.when((Object)this.payAppWorkflowDocMock.isCanceled()).thenReturn((Object)true);
        Mockito.when((Object)this.anotherPayAppWorkflowDocMock.isCanceled()).thenReturn((Object)true);
        Assert.assertFalse((boolean)this.cut.canApprove((Document)this.cashControlDocMock));
    }

    @Test
    public void canApprove_DisapprovedAppDocs_True() {
        Mockito.when((Object)this.payAppWorkflowDocMock.isDisapproved()).thenReturn((Object)true);
        Mockito.when((Object)this.anotherPayAppWorkflowDocMock.isDisapproved()).thenReturn((Object)true);
        Assert.assertFalse((boolean)this.cut.canApprove((Document)this.cashControlDocMock));
    }

    @Test
    public void canApprove_ApprovedAndCanceledAppDocs_True() {
        Mockito.when((Object)this.payAppWorkflowDocMock.isApproved()).thenReturn((Object)true);
        Mockito.when((Object)this.anotherPayAppWorkflowDocMock.isCanceled()).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.cut.canApprove((Document)this.cashControlDocMock));
    }

    @Test
    public void canApprove_ApprovedAndDisapprovedAppDocs_True() {
        Mockito.when((Object)this.payAppWorkflowDocMock.isApproved()).thenReturn((Object)true);
        Mockito.when((Object)this.anotherPayAppWorkflowDocMock.isDisapproved()).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.cut.canApprove((Document)this.cashControlDocMock));
    }

    @Test
    public void canApprove_CanceledAndDisapprovedAppDocs_False() {
        Mockito.when((Object)this.payAppWorkflowDocMock.isCanceled()).thenReturn((Object)true);
        Mockito.when((Object)this.anotherPayAppWorkflowDocMock.isDisapproved()).thenReturn((Object)true);
        Assert.assertFalse((boolean)this.cut.canApprove((Document)this.cashControlDocMock));
    }

    @Test
    public void getEditModes_Initiated_NoClaims() {
        Mockito.when((Object)this.cashControlWorkflowDocMock.isInitiated()).thenReturn((Object)true);
        Set editModes = this.cut.getEditModes((Document)this.cashControlDocMock);
        Assert.assertEquals((long)5L, (long)editModes.size());
        Assert.assertTrue((boolean)editModes.contains("amountTotaling"));
        Assert.assertTrue((boolean)editModes.contains("editPaymentMedium"));
        Assert.assertTrue((boolean)editModes.contains("editDetails"));
        Assert.assertTrue((boolean)editModes.contains("editRefDocNbr"));
        Assert.assertTrue((boolean)editModes.contains("editBankCode"));
    }

    @Test
    public void getEditModes_Saved_NoClaims() {
        Mockito.when((Object)this.cashControlWorkflowDocMock.isSaved()).thenReturn((Object)true);
        Set editModes = this.cut.getEditModes((Document)this.cashControlDocMock);
        Assert.assertEquals((long)5L, (long)editModes.size());
        Assert.assertTrue((boolean)editModes.contains("amountTotaling"));
        Assert.assertTrue((boolean)editModes.contains("editPaymentMedium"));
        Assert.assertTrue((boolean)editModes.contains("editDetails"));
        Assert.assertTrue((boolean)editModes.contains("editRefDocNbr"));
        Assert.assertTrue((boolean)editModes.contains("editBankCode"));
    }

    @Test
    public void getEditModes_CompletionRequested_NoClaims() {
        Mockito.when((Object)this.cashControlWorkflowDocMock.isCompletionRequested()).thenReturn((Object)true);
        Set editModes = this.cut.getEditModes((Document)this.cashControlDocMock);
        Assert.assertEquals((long)5L, (long)editModes.size());
        Assert.assertTrue((boolean)editModes.contains("amountTotaling"));
        Assert.assertTrue((boolean)editModes.contains("editPaymentMedium"));
        Assert.assertTrue((boolean)editModes.contains("editDetails"));
        Assert.assertTrue((boolean)editModes.contains("editRefDocNbr"));
        Assert.assertTrue((boolean)editModes.contains("editBankCode"));
    }

    @Test
    public void getEditModes_Initiated_NoClaims_BankSpecEnabled() {
        Mockito.when((Object)this.bankSvcMock.isBankSpecificationEnabled()).thenReturn((Object)true);
        Mockito.when((Object)this.cashControlWorkflowDocMock.isInitiated()).thenReturn((Object)true);
        Set editModes = this.cut.getEditModes((Document)this.cashControlDocMock);
        Assert.assertEquals((long)6L, (long)editModes.size());
        Assert.assertTrue((boolean)editModes.contains("amountTotaling"));
        Assert.assertTrue((boolean)editModes.contains("editPaymentMedium"));
        Assert.assertTrue((boolean)editModes.contains("editDetails"));
        Assert.assertTrue((boolean)editModes.contains("editRefDocNbr"));
        Assert.assertTrue((boolean)editModes.contains("editBankCode"));
        Assert.assertTrue((boolean)editModes.contains("showBankCode"));
    }

    @Test
    public void getEditModes_Saved_NoClaims_BankSpecEnabled() {
        Mockito.when((Object)this.bankSvcMock.isBankSpecificationEnabled()).thenReturn((Object)true);
        Mockito.when((Object)this.cashControlWorkflowDocMock.isSaved()).thenReturn((Object)true);
        Set editModes = this.cut.getEditModes((Document)this.cashControlDocMock);
        Assert.assertEquals((long)6L, (long)editModes.size());
        Assert.assertTrue((boolean)editModes.contains("amountTotaling"));
        Assert.assertTrue((boolean)editModes.contains("editPaymentMedium"));
        Assert.assertTrue((boolean)editModes.contains("editDetails"));
        Assert.assertTrue((boolean)editModes.contains("editRefDocNbr"));
        Assert.assertTrue((boolean)editModes.contains("editBankCode"));
        Assert.assertTrue((boolean)editModes.contains("showBankCode"));
    }

    @Test
    public void getEditModes_CompletionRequested_NoClaims_BankSpecEnabled() {
        Mockito.when((Object)this.bankSvcMock.isBankSpecificationEnabled()).thenReturn((Object)true);
        Mockito.when((Object)this.cashControlWorkflowDocMock.isCompletionRequested()).thenReturn((Object)true);
        Set editModes = this.cut.getEditModes((Document)this.cashControlDocMock);
        Assert.assertEquals((long)6L, (long)editModes.size());
        Assert.assertTrue((boolean)editModes.contains("amountTotaling"));
        Assert.assertTrue((boolean)editModes.contains("editPaymentMedium"));
        Assert.assertTrue((boolean)editModes.contains("editDetails"));
        Assert.assertTrue((boolean)editModes.contains("editRefDocNbr"));
        Assert.assertTrue((boolean)editModes.contains("editBankCode"));
        Assert.assertTrue((boolean)editModes.contains("showBankCode"));
    }

    @Test
    public void getEditModes_Initiated_HasClaims_NoBankCode() {
        List<ElectronicPaymentClaim> electronicPaymentClaims = Collections.singletonList(new ElectronicPaymentClaim());
        Mockito.when((Object)this.cashControlDocMock.getElectronicPaymentClaims()).thenReturn(electronicPaymentClaims);
        Mockito.when((Object)this.cashControlWorkflowDocMock.isInitiated()).thenReturn((Object)true);
        Set editModes = this.cut.getEditModes((Document)this.cashControlDocMock);
        Assert.assertEquals((long)1L, (long)editModes.size());
        Assert.assertTrue((boolean)editModes.contains("amountTotaling"));
    }

    @Test
    public void getEditModes_Saved_HasClaims_NoBankCode() {
        List<ElectronicPaymentClaim> electronicPaymentClaims = Collections.singletonList(new ElectronicPaymentClaim());
        Mockito.when((Object)this.cashControlDocMock.getElectronicPaymentClaims()).thenReturn(electronicPaymentClaims);
        Mockito.when((Object)this.cashControlWorkflowDocMock.isSaved()).thenReturn((Object)true);
        Set editModes = this.cut.getEditModes((Document)this.cashControlDocMock);
        Assert.assertEquals((long)1L, (long)editModes.size());
        Assert.assertTrue((boolean)editModes.contains("amountTotaling"));
    }

    @Test
    public void getEditModes_CompletionRequested_HasClaims_NoBankCode() {
        List<ElectronicPaymentClaim> electronicPaymentClaims = Collections.singletonList(new ElectronicPaymentClaim());
        Mockito.when((Object)this.cashControlDocMock.getElectronicPaymentClaims()).thenReturn(electronicPaymentClaims);
        Mockito.when((Object)this.cashControlWorkflowDocMock.isCompletionRequested()).thenReturn((Object)true);
        Set editModes = this.cut.getEditModes((Document)this.cashControlDocMock);
        Assert.assertEquals((long)1L, (long)editModes.size());
        Assert.assertTrue((boolean)editModes.contains("amountTotaling"));
    }

    @Test
    public void getEditModes_Initiated_HasClaims_WithBankCode() {
        List<ElectronicPaymentClaim> electronicPaymentClaims = Collections.singletonList(new ElectronicPaymentClaim());
        Mockito.when((Object)this.cashControlDocMock.getElectronicPaymentClaims()).thenReturn(electronicPaymentClaims);
        Mockito.when((Object)this.cashControlDocMock.getBankCode()).thenReturn((Object)"BANK");
        Mockito.when((Object)this.cashControlWorkflowDocMock.isInitiated()).thenReturn((Object)true);
        Set editModes = this.cut.getEditModes((Document)this.cashControlDocMock);
        Assert.assertEquals((long)2L, (long)editModes.size());
        Assert.assertTrue((boolean)editModes.contains("amountTotaling"));
        Assert.assertTrue((boolean)editModes.contains("showBankCode"));
    }

    @Test
    public void getEditModes_Saved_HasClaims_WithBankCode() {
        List<ElectronicPaymentClaim> electronicPaymentClaims = Collections.singletonList(new ElectronicPaymentClaim());
        Mockito.when((Object)this.cashControlDocMock.getElectronicPaymentClaims()).thenReturn(electronicPaymentClaims);
        Mockito.when((Object)this.cashControlDocMock.getBankCode()).thenReturn((Object)"BANK");
        Mockito.when((Object)this.cashControlWorkflowDocMock.isSaved()).thenReturn((Object)true);
        Set editModes = this.cut.getEditModes((Document)this.cashControlDocMock);
        Assert.assertEquals((long)2L, (long)editModes.size());
        Assert.assertTrue((boolean)editModes.contains("amountTotaling"));
        Assert.assertTrue((boolean)editModes.contains("showBankCode"));
    }

    @Test
    public void getEditModes_CompletionRequested_HasClaims_WithBankCode() {
        List<ElectronicPaymentClaim> electronicPaymentClaims = Collections.singletonList(new ElectronicPaymentClaim());
        Mockito.when((Object)this.cashControlDocMock.getElectronicPaymentClaims()).thenReturn(electronicPaymentClaims);
        Mockito.when((Object)this.cashControlDocMock.getBankCode()).thenReturn((Object)"BANK");
        Mockito.when((Object)this.cashControlWorkflowDocMock.isCompletionRequested()).thenReturn((Object)true);
        Set editModes = this.cut.getEditModes((Document)this.cashControlDocMock);
        Assert.assertEquals((long)2L, (long)editModes.size());
        Assert.assertTrue((boolean)editModes.contains("amountTotaling"));
        Assert.assertTrue((boolean)editModes.contains("showBankCode"));
    }

    @Test
    public void getEditModes_Enroute_PaymentMediumCash() {
        Mockito.when((Object)this.cashControlDocMock.getCustomerPaymentMediumCode()).thenReturn((Object)"CA");
        Mockito.when((Object)this.cashControlWorkflowDocMock.isEnroute()).thenReturn((Object)true);
        Set editModes = this.cut.getEditModes((Document)this.cashControlDocMock);
        Assert.assertEquals((long)2L, (long)editModes.size());
        Assert.assertTrue((boolean)editModes.contains("amountTotaling"));
        Assert.assertTrue((boolean)editModes.contains("editPaymentAppDoc"));
    }

    @Test
    public void getEditModes_Enroute_PaymentMediumNonCash_GLPEsEmpty() {
        Mockito.when((Object)this.cashControlWorkflowDocMock.isEnroute()).thenReturn((Object)true);
        Set editModes = this.cut.getEditModes((Document)this.cashControlDocMock);
        Assert.assertEquals((long)1L, (long)editModes.size());
        Assert.assertTrue((boolean)editModes.contains("amountTotaling"));
    }

    @Test
    public void getEditModes_Enroute_PaymentMediumNonCash_GLPEsNotEmpty() {
        List<GeneralLedgerPendingEntry> generalLedgerPendingEntries = Collections.singletonList(new GeneralLedgerPendingEntry());
        Mockito.when((Object)this.cashControlDocMock.getGeneralLedgerPendingEntries()).thenReturn(generalLedgerPendingEntries);
        Mockito.when((Object)this.cashControlWorkflowDocMock.isEnroute()).thenReturn((Object)true);
        Set editModes = this.cut.getEditModes((Document)this.cashControlDocMock);
        Assert.assertEquals((long)2L, (long)editModes.size());
        Assert.assertTrue((boolean)editModes.contains("amountTotaling"));
        Assert.assertTrue((boolean)editModes.contains("editPaymentAppDoc"));
    }

    @Test
    public void getEditModes_Enroute_ApprovalRequested_PaymentMediumCash() {
        Mockito.when((Object)this.cashControlDocMock.getCustomerPaymentMediumCode()).thenReturn((Object)"CA");
        Mockito.when((Object)this.cashControlWorkflowDocMock.isEnroute()).thenReturn((Object)true);
        Mockito.when((Object)this.cashControlWorkflowDocMock.isApprovalRequested()).thenReturn((Object)true);
        Set editModes = this.cut.getEditModes((Document)this.cashControlDocMock);
        Assert.assertEquals((long)4L, (long)editModes.size());
        Assert.assertTrue((boolean)editModes.contains("amountTotaling"));
        Assert.assertTrue((boolean)editModes.contains("editPaymentAppDoc"));
        Assert.assertTrue((boolean)editModes.contains("editPaymentMedium"));
        Assert.assertTrue((boolean)editModes.contains("editRefDocNbr"));
    }

    @Test
    public void getEditModes_Enroute_ApprovalRequested_PaymentMediumNonCash_GLPEsEmpty_NonPosted_ApprovedAndDisapprovedApps() {
        Mockito.when((Object)this.payAppWorkflowDocMock.isApproved()).thenReturn((Object)true);
        Mockito.when((Object)this.anotherPayAppWorkflowDocMock.isDisapproved()).thenReturn((Object)true);
        Mockito.when((Object)this.cashControlWorkflowDocMock.isEnroute()).thenReturn((Object)true);
        Mockito.when((Object)this.cashControlWorkflowDocMock.isApprovalRequested()).thenReturn((Object)true);
        Set editModes = this.cut.getEditModes((Document)this.cashControlDocMock);
        Assert.assertEquals((long)3L, (long)editModes.size());
        Assert.assertTrue((boolean)editModes.contains("amountTotaling"));
        Assert.assertTrue((boolean)editModes.contains("editPaymentMedium"));
        Assert.assertTrue((boolean)editModes.contains("showGenerateButton"));
    }

    @Test
    public void getEditModes_Enroute_ApprovalRequested_PaymentMediumNonCash_GLPEsEmpty_NonPosted_EnrouteApp() {
        Mockito.when((Object)this.payAppWorkflowDocMock.isEnroute()).thenReturn((Object)true);
        Mockito.when((Object)this.cashControlWorkflowDocMock.isEnroute()).thenReturn((Object)true);
        Mockito.when((Object)this.cashControlWorkflowDocMock.isApprovalRequested()).thenReturn((Object)true);
        Set editModes = this.cut.getEditModes((Document)this.cashControlDocMock);
        Assert.assertEquals((long)2L, (long)editModes.size());
        Assert.assertTrue((boolean)editModes.contains("amountTotaling"));
        Assert.assertTrue((boolean)editModes.contains("editPaymentMedium"));
    }

    @Test
    public void getEditModes_Enroute_ApprovalRequested_PaymentMediumNonCash_GLPEsEmpty_Posted() {
        Mockito.when((Object)this.cashControlDocMock.getGeneralLedgerEntriesPostedCount()).thenReturn((Object)1);
        Mockito.when((Object)this.cashControlWorkflowDocMock.isEnroute()).thenReturn((Object)true);
        Mockito.when((Object)this.cashControlWorkflowDocMock.isApprovalRequested()).thenReturn((Object)true);
        Set editModes = this.cut.getEditModes((Document)this.cashControlDocMock);
        Assert.assertEquals((long)1L, (long)editModes.size());
        Assert.assertTrue((boolean)editModes.contains("amountTotaling"));
    }
}

