/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.CustomerCreditMemoDetail;
import org.kuali.kfs.module.ar.document.CustomerCreditMemoDocument;
import org.kuali.kfs.module.ar.document.service.CustomerCreditMemoDocumentService;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDocumentTestUtil;
import org.kuali.kfs.module.ar.fixture.CustomerInvoiceDetailFixture;
import org.kuali.kfs.module.ar.fixture.CustomerInvoiceDocumentFixture;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.rice.core.api.util.type.KualiDecimal;

@ConfigureContext(session=UserNameFixture.khuntley)
public class CustomerCreditMemoDocumentServiceTest
extends KualiTestBase {
    private CustomerCreditMemoDocumentService service;
    private CustomerCreditMemoDocument document;
    private List<CustomerCreditMemoDetail> details;
    private KualiDecimal testAmount;

    protected void setUp() throws Exception {
        super.setUp();
        String documentNumber = CustomerInvoiceDocumentTestUtil.submitNewCustomerInvoiceDocument(CustomerInvoiceDocumentFixture.BASE_CIDOC_WITH_CUSTOMER, new CustomerInvoiceDetailFixture[]{CustomerInvoiceDetailFixture.CUSTOMER_INVOICE_DETAIL_CHART_RECEIVABLE, CustomerInvoiceDetailFixture.CUSTOMER_INVOICE_DETAIL_CHART_RECEIVABLE});
        this.document = new CustomerCreditMemoDocument();
        this.document.setFinancialDocumentReferenceInvoiceNumber(documentNumber);
        this.document.getInvoice();
        this.details = new ArrayList<CustomerCreditMemoDetail>();
        CustomerCreditMemoDetail detail1 = new CustomerCreditMemoDetail();
        detail1.setFinancialDocumentReferenceInvoiceNumber(documentNumber);
        detail1.setCreditMemoItemQuantity(new BigDecimal(0.5));
        detail1.setReferenceInvoiceItemNumber(Integer.valueOf(1));
        CustomerCreditMemoDetail detail2 = new CustomerCreditMemoDetail();
        detail2.setFinancialDocumentReferenceInvoiceNumber(documentNumber);
        detail2.setReferenceInvoiceItemNumber(Integer.valueOf(2));
        this.details.add(detail1);
        this.details.add(detail2);
        this.document.setCreditMemoDetails(this.details);
        this.testAmount = new KualiDecimal(0.5);
        this.service = (CustomerCreditMemoDocumentService)SpringContext.getBean(CustomerCreditMemoDocumentService.class);
    }

    protected void tearDown() throws Exception {
        this.document = null;
        this.details = null;
        this.service = null;
        super.tearDown();
    }

    public void testRecalculateCustomerCreditMemoDocument() {
        this.service.recalculateCustomerCreditMemoDocument(this.document, false);
        this.details = this.document.getCreditMemoDetails();
        for (CustomerCreditMemoDetail crmDetail : this.details) {
            if (crmDetail.getReferenceInvoiceItemNumber().equals(1)) {
                CustomerCreditMemoDocumentServiceTest.assertEquals((Object)crmDetail.getCreditMemoItemTotalAmount(), (Object)this.testAmount);
                CustomerCreditMemoDocumentServiceTest.assertEquals((Object)crmDetail.getCreditMemoItemTaxAmount(), (Object)KualiDecimal.ZERO);
                CustomerCreditMemoDocumentServiceTest.assertEquals((Object)crmDetail.getCreditMemoLineTotalAmount(), (Object)this.testAmount);
                CustomerCreditMemoDocumentServiceTest.assertTrue((boolean)crmDetail.getDuplicateCreditMemoItemTotalAmount().equals((Object)this.testAmount));
                continue;
            }
            CustomerCreditMemoDocumentServiceTest.assertTrue((boolean)ObjectUtils.isNull((Object)crmDetail.getCreditMemoItemQuantity()));
            CustomerCreditMemoDocumentServiceTest.assertTrue((boolean)ObjectUtils.isNull((Object)crmDetail.getCreditMemoItemTotalAmount()));
            CustomerCreditMemoDocumentServiceTest.assertFalse((boolean)crmDetail.getCreditMemoItemTaxAmount().isPositive());
            CustomerCreditMemoDocumentServiceTest.assertFalse((boolean)crmDetail.getCreditMemoLineTotalAmount().isPositive());
            CustomerCreditMemoDocumentServiceTest.assertTrue((boolean)ObjectUtils.isNull((Object)crmDetail.getDuplicateCreditMemoItemTotalAmount()));
        }
        CustomerCreditMemoDocumentServiceTest.assertEquals((Object)this.document.getCrmTotalItemAmount(), (Object)this.testAmount);
        CustomerCreditMemoDocumentServiceTest.assertEquals((Object)this.document.getCrmTotalTaxAmount(), (Object)KualiDecimal.ZERO);
        CustomerCreditMemoDocumentServiceTest.assertEquals((Object)this.document.getCrmTotalAmount(), (Object)this.testAmount);
    }
}

