/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.service;

import java.sql.Date;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.coa.businessobject.AccountingPeriod;
import org.kuali.kfs.coa.service.AccountingPeriodService;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.businessobject.Award;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.batch.service.impl.VerifyBillingFrequencyServiceImpl;
import org.kuali.kfs.module.ar.businessobject.BillingFrequency;
import org.kuali.kfs.module.ar.businessobject.BillingPeriod;
import org.kuali.kfs.module.ar.fixture.ARAwardMockFixture;
import org.kuali.kfs.module.ar.fixture.BillingFrequencyFixture;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@Execution(value=ExecutionMode.SAME_THREAD)
public class VerifyBillingFrequencyServiceTest {
    private VerifyBillingFrequencyServiceImpl cut;
    @Mock
    private AccountingPeriodService accountingPeriodSvcMock;
    @Mock
    private DateTimeService dateTimeSvcMock;
    @Mock
    private AccountingPeriod accountingPeriodMock_2009_12;
    @Mock
    private AccountingPeriod accountingPeriodMock_2010_12;
    @Mock
    private AccountingPeriod accountingPeriodMock_2011_06;
    @Mock
    private AccountingPeriod accountingPeriodMock_2011_09;
    @Mock
    private AccountingPeriod accountingPeriodMock_2011_12;
    @Mock
    private AccountingPeriod accountingPeriodMock_2012_01;
    @Mock
    private AccountingPeriod accountingPeriodMock_2012_02;
    @Mock
    private AccountingPeriod accountingPeriodMock_2012_03;
    @Mock
    private AccountingPeriod accountingPeriodMock_2012_04;
    @Mock
    private AccountingPeriod accountingPeriodMock_2012_05;
    @Mock
    private AccountingPeriod accountingPeriodMock_2012_06;
    @Mock
    private AccountingPeriod accountingPeriodMock_2012_07;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.setupMockFiscalPeriod(this.accountingPeriodMock_2009_12, "12", 2009, "2009-06-30");
        this.setupMockFiscalPeriod(this.accountingPeriodMock_2010_12, "12", 2010, "2010-06-30");
        this.setupMockFiscalPeriod(this.accountingPeriodMock_2011_06, "06", 2011, "2010-12-31");
        this.setupMockFiscalPeriod(this.accountingPeriodMock_2011_09, "09", 2011, "2011-03-31");
        this.setupMockFiscalPeriod(this.accountingPeriodMock_2011_12, "12", 2011, "2011-06-30");
        this.setupMockFiscalPeriod(this.accountingPeriodMock_2012_01, "01", 2012, "2011-07-31");
        this.setupMockFiscalPeriod(this.accountingPeriodMock_2012_02, "02", 2012, "2011-08-31");
        this.setupMockFiscalPeriod(this.accountingPeriodMock_2012_03, "03", 2012, "2011-09-30");
        this.setupMockFiscalPeriod(this.accountingPeriodMock_2012_04, "04", 2012, "2011-10-31");
        this.setupMockFiscalPeriod(this.accountingPeriodMock_2012_05, "05", 2012, "2011-11-30");
        this.setupMockFiscalPeriod(this.accountingPeriodMock_2012_06, "06", 2012, "2011-12-31");
        this.setupMockFiscalPeriod(this.accountingPeriodMock_2012_07, "07", 2012, "2012-01-31");
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(Date.valueOf("2010-06-30"))).thenReturn((Object)this.accountingPeriodMock_2010_12);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(Date.valueOf("2011-06-30"))).thenReturn((Object)this.accountingPeriodMock_2011_12);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(Date.valueOf("2011-07-01"))).thenReturn((Object)this.accountingPeriodMock_2012_01);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(Date.valueOf("2011-07-20"))).thenReturn((Object)this.accountingPeriodMock_2012_01);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(Date.valueOf("2011-08-20"))).thenReturn((Object)this.accountingPeriodMock_2012_02);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(Date.valueOf("2011-09-30"))).thenReturn((Object)this.accountingPeriodMock_2012_03);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(Date.valueOf("2011-10-31"))).thenReturn((Object)this.accountingPeriodMock_2012_04);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(Date.valueOf("2011-11-01"))).thenReturn((Object)this.accountingPeriodMock_2012_05);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(Date.valueOf("2012-01-01"))).thenReturn((Object)this.accountingPeriodMock_2012_07);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByPeriod("12", Integer.valueOf(2009))).thenReturn((Object)this.accountingPeriodMock_2009_12);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByPeriod("06", Integer.valueOf(2011))).thenReturn((Object)this.accountingPeriodMock_2011_06);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByPeriod("09", Integer.valueOf(2011))).thenReturn((Object)this.accountingPeriodMock_2011_09);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByPeriod("12", Integer.valueOf(2011))).thenReturn((Object)this.accountingPeriodMock_2011_12);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByPeriod("01", Integer.valueOf(2012))).thenReturn((Object)this.accountingPeriodMock_2012_01);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByPeriod("02", Integer.valueOf(2012))).thenReturn((Object)this.accountingPeriodMock_2012_02);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByPeriod("03", Integer.valueOf(2012))).thenReturn((Object)this.accountingPeriodMock_2012_03);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByPeriod("04", Integer.valueOf(2012))).thenReturn((Object)this.accountingPeriodMock_2012_04);
        Mockito.when((Object)this.accountingPeriodSvcMock.getByPeriod("06", Integer.valueOf(2012))).thenReturn((Object)this.accountingPeriodMock_2012_06);
        this.cut = new VerifyBillingFrequencyServiceImpl();
        this.cut.setAccountingPeriodService(this.accountingPeriodSvcMock);
        this.cut.setDateTimeService(this.dateTimeSvcMock);
    }

    private void setupMockFiscalPeriod(AccountingPeriod accountingPeriodMock, String fiscalPeriodCode, int fiscalYear, String fiscalPeriodEndDate) {
        Mockito.when((Object)accountingPeriodMock.getUniversityFiscalPeriodCode()).thenReturn((Object)fiscalPeriodCode);
        Mockito.when((Object)accountingPeriodMock.getUniversityFiscalYear()).thenReturn((Object)fiscalYear);
        Mockito.when((Object)accountingPeriodMock.getUniversityFiscalPeriodEndDate()).thenReturn((Object)Date.valueOf(fiscalPeriodEndDate));
    }

    @Test
    public void calculateIfWithinGracePeriod_MonthlyNullLastBilledDate() {
        Date today = Date.valueOf("2011-10-31");
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentSqlDate()).thenReturn((Object)today);
        ContractsAndGrantsBillingAward award = ARAwardMockFixture.CG_AWARD_MONTHLY_BILLED_DATE_NULL.createAwardMockWithLastBillingDate();
        BillingPeriod billingPeriod = this.cut.getStartDateAndEndDateOfPreviousBillingPeriod(award, this.accountingPeriodMock_2012_04);
        Assert.assertEquals((Object)Date.valueOf("2011-01-01"), (Object)billingPeriod.getStartDate());
        Assert.assertEquals((Object)Date.valueOf("2011-09-30"), (Object)billingPeriod.getEndDate());
        boolean withinGracePeriod = this.cut.calculateIfWithinGracePeriod(today, billingPeriod, award.getLastBilledDate(), (BillingFrequency)award.getBillingFrequency());
        Assert.assertTrue((boolean)withinGracePeriod);
    }

    @Test
    public void calculateIfWithinGracePeriod_MilestoneNullLastBilledDate() {
        Date today = Date.valueOf("2011-10-31");
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentSqlDate()).thenReturn((Object)today);
        ContractsAndGrantsBillingAward award = ARAwardMockFixture.CG_AWARD_MILESTONE_BILLED_DATE_NULL.createAwardMockWithLastBillingDate();
        BillingPeriod billingPeriod = this.cut.getStartDateAndEndDateOfPreviousBillingPeriod(award, this.accountingPeriodMock_2012_04);
        Assert.assertEquals((Object)Date.valueOf("2011-01-01"), (Object)billingPeriod.getStartDate());
        Assert.assertEquals((Object)Date.valueOf("2011-09-30"), (Object)billingPeriod.getEndDate());
        boolean withinGracePeriod = this.cut.calculateIfWithinGracePeriod(today, billingPeriod, award.getLastBilledDate(), (BillingFrequency)award.getBillingFrequency());
        Assert.assertTrue((boolean)withinGracePeriod);
    }

    @Test
    public void calculateIfWithinGracePeriod_PredeterminedBillingNullLastBilledDate() {
        Date today = Date.valueOf("2011-10-31");
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentSqlDate()).thenReturn((Object)today);
        ContractsAndGrantsBillingAward award = ARAwardMockFixture.CG_AWARD_PREDETERMINED_BILLED_DATE_NULL.createAwardMockWithLastBillingDate();
        BillingPeriod billingPeriod = this.cut.getStartDateAndEndDateOfPreviousBillingPeriod(award, this.accountingPeriodMock_2012_04);
        Assert.assertEquals((Object)Date.valueOf("2011-01-01"), (Object)billingPeriod.getStartDate());
        Assert.assertEquals((Object)Date.valueOf("2011-09-30"), (Object)billingPeriod.getEndDate());
        boolean withinGracePeriod = this.cut.calculateIfWithinGracePeriod(today, billingPeriod, award.getLastBilledDate(), (BillingFrequency)award.getBillingFrequency());
        Assert.assertTrue((boolean)withinGracePeriod);
    }

    @Test
    public void calculateIfWithinGracePeriod_QuarterlyNullLastBilledDate() {
        Date today = Date.valueOf("2011-10-31");
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentSqlDate()).thenReturn((Object)today);
        ContractsAndGrantsBillingAward award = ARAwardMockFixture.CG_AWARD_QUAR_BILLED_DATE_NULL.createAwardMockWithLastBillingDate();
        BillingPeriod billingPeriod = this.cut.getStartDateAndEndDateOfPreviousBillingPeriod(award, this.accountingPeriodMock_2012_04);
        Assert.assertEquals((Object)Date.valueOf("2011-01-01"), (Object)billingPeriod.getStartDate());
        Assert.assertEquals((Object)Date.valueOf("2011-09-30"), (Object)billingPeriod.getEndDate());
        boolean withinGracePeriod = this.cut.calculateIfWithinGracePeriod(today, billingPeriod, award.getLastBilledDate(), (BillingFrequency)award.getBillingFrequency());
        Assert.assertTrue((boolean)withinGracePeriod);
    }

    @Test
    public void calculateIfWithinGracePeriod_SemiAnnualNullLastBilledDate() {
        Date today = Date.valueOf("2011-10-31");
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentSqlDate()).thenReturn((Object)today);
        ContractsAndGrantsBillingAward award = ARAwardMockFixture.CG_AWARD_SEMI_ANN_BILLED_DATE_NULL.createAwardMockWithLastBillingDate();
        BillingPeriod billingPeriod = this.cut.getStartDateAndEndDateOfPreviousBillingPeriod(award, this.accountingPeriodMock_2012_04);
        Assert.assertEquals((Object)Date.valueOf("2011-01-01"), (Object)billingPeriod.getStartDate());
        Assert.assertEquals((Object)Date.valueOf("2011-06-30"), (Object)billingPeriod.getEndDate());
        boolean withinGracePeriod = this.cut.calculateIfWithinGracePeriod(today, billingPeriod, award.getLastBilledDate(), (BillingFrequency)award.getBillingFrequency());
        Assert.assertTrue((boolean)withinGracePeriod);
    }

    @Test
    public void calculateIfWithinGracePeriod_AnnualNullLastBilledDate() {
        Date today = Date.valueOf("2011-10-31");
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentSqlDate()).thenReturn((Object)today);
        ContractsAndGrantsBillingAward award = ARAwardMockFixture.CG_AWARD_ANNUAL_BILLED_DATE_NULL.createAwardMockWithLastBillingDate();
        BillingPeriod billingPeriod = this.cut.getStartDateAndEndDateOfPreviousBillingPeriod(award, this.accountingPeriodMock_2012_04);
        Assert.assertEquals((Object)Date.valueOf("2011-01-01"), (Object)billingPeriod.getStartDate());
        Assert.assertEquals((Object)Date.valueOf("2011-06-30"), (Object)billingPeriod.getEndDate());
        boolean withinGracePeriod = this.cut.calculateIfWithinGracePeriod(today, billingPeriod, award.getLastBilledDate(), (BillingFrequency)award.getBillingFrequency());
        Assert.assertTrue((boolean)withinGracePeriod);
    }

    @Test
    public void calculateIfWithinGracePeriod_MonthValidLastBilledDate() {
        Date today = Date.valueOf("2011-11-01");
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentSqlDate()).thenReturn((Object)today);
        ContractsAndGrantsBillingAward award = ARAwardMockFixture.CG_AWARD_MONTHLY_BILLED_DATE_VALID.createAwardMockWithLastBillingDate();
        BillingPeriod billingPeriod = this.cut.getStartDateAndEndDateOfPreviousBillingPeriod(award, this.accountingPeriodMock_2012_05);
        Assert.assertEquals((Object)Date.valueOf("2011-09-01"), (Object)billingPeriod.getStartDate());
        Assert.assertEquals((Object)Date.valueOf("2011-10-31"), (Object)billingPeriod.getEndDate());
        boolean withinGracePeriod = this.cut.calculateIfWithinGracePeriod(today, billingPeriod, award.getLastBilledDate(), (BillingFrequency)award.getBillingFrequency());
        Assert.assertTrue((boolean)withinGracePeriod);
    }

    @Test
    public void calculateIfWithinGracePeriod_MilestoneValidLastBilledDate() {
        Date today = Date.valueOf("2011-11-01");
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentSqlDate()).thenReturn((Object)today);
        ContractsAndGrantsBillingAward award = ARAwardMockFixture.CG_AWARD_MILESTONE_BILLED_DATE_VALID.createAwardMockWithLastBillingDate();
        BillingPeriod billingPeriod = this.cut.getStartDateAndEndDateOfPreviousBillingPeriod(award, this.accountingPeriodMock_2012_05);
        Assert.assertEquals((Object)Date.valueOf("2011-09-01"), (Object)billingPeriod.getStartDate());
        Assert.assertEquals((Object)Date.valueOf("2011-10-31"), (Object)billingPeriod.getEndDate());
        boolean withinGracePeriod = this.cut.calculateIfWithinGracePeriod(today, billingPeriod, award.getLastBilledDate(), (BillingFrequency)award.getBillingFrequency());
        Assert.assertTrue((boolean)withinGracePeriod);
    }

    @Test
    public void calculateIfWithinGracePeriod_PredeterminedValidLastBilledDate() {
        Date today = Date.valueOf("2011-11-01");
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentSqlDate()).thenReturn((Object)today);
        ContractsAndGrantsBillingAward award = ARAwardMockFixture.CG_AWARD_PREDETERMINED_BILLED_DATE_VALID.createAwardMockWithLastBillingDate();
        BillingPeriod billingPeriod = this.cut.getStartDateAndEndDateOfPreviousBillingPeriod(award, this.accountingPeriodMock_2012_05);
        Assert.assertEquals((Object)Date.valueOf("2011-09-01"), (Object)billingPeriod.getStartDate());
        Assert.assertEquals((Object)Date.valueOf("2011-10-31"), (Object)billingPeriod.getEndDate());
        boolean withinGracePeriod = this.cut.calculateIfWithinGracePeriod(today, billingPeriod, award.getLastBilledDate(), (BillingFrequency)award.getBillingFrequency());
        Assert.assertTrue((boolean)withinGracePeriod);
    }

    @Test
    public void calculateIfWithinGracePeriod_QuarterlyValidLastBilledDate() {
        Date today = Date.valueOf("2011-11-01");
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentSqlDate()).thenReturn((Object)today);
        ContractsAndGrantsBillingAward award = ARAwardMockFixture.CG_AWARD_QUAR_BILLED_DATE_VALID.createAwardMockWithLastBillingDate();
        BillingPeriod billingPeriod = this.cut.getStartDateAndEndDateOfPreviousBillingPeriod(award, this.accountingPeriodMock_2012_05);
        Assert.assertEquals((Object)Date.valueOf("2011-04-01"), (Object)billingPeriod.getStartDate());
        Assert.assertEquals((Object)Date.valueOf("2011-09-30"), (Object)billingPeriod.getEndDate());
        boolean withinGracePeriod = this.cut.calculateIfWithinGracePeriod(today, billingPeriod, award.getLastBilledDate(), (BillingFrequency)award.getBillingFrequency());
        Assert.assertTrue((boolean)withinGracePeriod);
    }

    @Test
    public void calculateIfWithinGracePeriod_SemiAnnualBillingValidLastBilledDate() {
        Date today = Date.valueOf("2012-01-01");
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentSqlDate()).thenReturn((Object)today);
        ContractsAndGrantsBillingAward award = ARAwardMockFixture.CG_AWARD_SEMI_ANN_BILLED_DATE_VALID.createAwardMockWithLastBillingDate();
        BillingPeriod billingPeriod = this.cut.getStartDateAndEndDateOfPreviousBillingPeriod(award, this.accountingPeriodMock_2012_07);
        Assert.assertEquals((Object)Date.valueOf("2011-01-01"), (Object)billingPeriod.getStartDate());
        Assert.assertEquals((Object)Date.valueOf("2011-12-31"), (Object)billingPeriod.getEndDate());
        boolean withinGracePeriod = this.cut.calculateIfWithinGracePeriod(today, billingPeriod, award.getLastBilledDate(), (BillingFrequency)award.getBillingFrequency());
        Assert.assertTrue((boolean)withinGracePeriod);
    }

    @Test
    public void calculateIfWithinGracePeriod_AnnualBillingValidLastBilledDate() {
        Date today = Date.valueOf("2011-07-01");
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentSqlDate()).thenReturn((Object)today);
        ContractsAndGrantsBillingAward award = ARAwardMockFixture.CG_AWARD_ANNUAL_BILLED_DATE_VALID.createAwardMockWithLastBillingDate();
        BillingPeriod billingPeriod = this.cut.getStartDateAndEndDateOfPreviousBillingPeriod(award, this.accountingPeriodMock_2012_01);
        Assert.assertEquals((Object)Date.valueOf("2009-07-01"), (Object)billingPeriod.getStartDate());
        Assert.assertEquals((Object)Date.valueOf("2011-06-30"), (Object)billingPeriod.getEndDate());
        boolean withinGracePeriod = this.cut.calculateIfWithinGracePeriod(today, billingPeriod, award.getLastBilledDate(), (BillingFrequency)award.getBillingFrequency());
        Assert.assertTrue((boolean)withinGracePeriod);
    }

    @Test
    public void getStartDateAndEndDateOfPreviousBillingPeriod_LOCBillingNullLastBilledDate() {
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentSqlDate()).thenReturn((Object)Date.valueOf("2011-10-31"));
        ContractsAndGrantsBillingAward award = ARAwardMockFixture.CG_AWARD_LOCB_BILLED_DATE_NULL.createAwardMockWithLastBillingDate();
        BillingPeriod billingPeriod = this.cut.getStartDateAndEndDateOfPreviousBillingPeriod(award, this.accountingPeriodMock_2012_04);
        Assert.assertEquals((Object)Date.valueOf("2011-01-01"), (Object)billingPeriod.getStartDate());
    }

    @Test
    public void getStartDateAndEndDateOfPreviousBillingPeriod_LOCBillingValidLastBilledDate() {
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentSqlDate()).thenReturn((Object)Date.valueOf("2011-12-15"));
        ContractsAndGrantsBillingAward award = ARAwardMockFixture.CG_AWARD_LOCB_BILLED_DATE_VALID.createAwardMockWithLastBillingDate();
        BillingPeriod billingPeriod = this.cut.getStartDateAndEndDateOfPreviousBillingPeriod(award, this.accountingPeriodMock_2012_06);
        Assert.assertEquals((Object)Date.valueOf("2010-12-13"), (Object)billingPeriod.getStartDate());
    }

    @Test
    public void validateBillingFrequency_Predetermined_billingInFirstAwardMonth_Valid() {
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentSqlDate()).thenReturn((Object)Date.valueOf("2011-07-20"));
        ContractsAndGrantsBillingAward award = (ContractsAndGrantsBillingAward)Mockito.mock(Award.class);
        Mockito.when((Object)award.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        Mockito.when((Object)award.getBillingFrequency()).thenReturn((Object)BillingFrequencyFixture.BILL_FREQ_PDBS.createBillingFrequency());
        Mockito.when((Object)award.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-07-01"));
        Mockito.when((Object)award.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2011-12-30"));
        Mockito.when((Object)award.getLastBilledDate()).thenReturn(null);
        Assert.assertTrue((boolean)this.cut.validateBillingFrequency(award));
    }

    @Test
    public void validateBillingFrequency_Predetermined_billingInFirstAwardMonth_notWithinGracePeriod_Invalid() {
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentSqlDate()).thenReturn((Object)Date.valueOf("2011-07-20"));
        ContractsAndGrantsBillingAward award = (ContractsAndGrantsBillingAward)Mockito.mock(Award.class);
        Mockito.when((Object)award.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        BillingFrequency billingFrequency = BillingFrequencyFixture.BILL_FREQ_PDBS.createBillingFrequency();
        billingFrequency.setGracePeriodDays(Integer.valueOf(32));
        Mockito.when((Object)award.getBillingFrequency()).thenReturn((Object)billingFrequency);
        Mockito.when((Object)award.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-07-01"));
        Mockito.when((Object)award.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2011-12-30"));
        Mockito.when((Object)award.getLastBilledDate()).thenReturn(null);
        Assert.assertFalse((boolean)this.cut.validateBillingFrequency(award));
    }

    @Test
    public void validateBillingFrequency_Predetermined_billingInSecondAwardMonth_WithoutPreviousBill_Valid() {
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentSqlDate()).thenReturn((Object)Date.valueOf("2011-08-20"));
        ContractsAndGrantsBillingAward award = (ContractsAndGrantsBillingAward)Mockito.mock(Award.class);
        Mockito.when((Object)award.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        Mockito.when((Object)award.getBillingFrequency()).thenReturn((Object)BillingFrequencyFixture.BILL_FREQ_PDBS.createBillingFrequency());
        Mockito.when((Object)award.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-07-01"));
        Mockito.when((Object)award.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2011-12-30"));
        Mockito.when((Object)award.getLastBilledDate()).thenReturn(null);
        Assert.assertTrue((boolean)this.cut.validateBillingFrequency(award));
    }

    @Test
    public void validateBillingFrequency_Predetermined_billingInSecondAwardMonth_WithPreviousBillValid() {
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentSqlDate()).thenReturn((Object)Date.valueOf("2011-08-20"));
        ContractsAndGrantsBillingAward award = (ContractsAndGrantsBillingAward)Mockito.mock(Award.class);
        Mockito.when((Object)award.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        Mockito.when((Object)award.getBillingFrequency()).thenReturn((Object)BillingFrequencyFixture.BILL_FREQ_PDBS.createBillingFrequency());
        Mockito.when((Object)award.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-07-01"));
        Mockito.when((Object)award.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2011-12-30"));
        Mockito.when((Object)award.getLastBilledDate()).thenReturn((Object)Date.valueOf("2011-07-20"));
        Assert.assertTrue((boolean)this.cut.validateBillingFrequency(award));
    }

    @Test
    public void validateBillingFrequency_Predetermined_billingInSecondAwardMonth_notWithinGracePeriod_Invalid() {
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentSqlDate()).thenReturn((Object)Date.valueOf("2011-08-20"));
        ContractsAndGrantsBillingAward award = (ContractsAndGrantsBillingAward)Mockito.mock(Award.class);
        Mockito.when((Object)award.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        BillingFrequency billingFrequency = BillingFrequencyFixture.BILL_FREQ_PDBS.createBillingFrequency();
        billingFrequency.setGracePeriodDays(Integer.valueOf(32));
        Mockito.when((Object)award.getBillingFrequency()).thenReturn((Object)billingFrequency);
        Mockito.when((Object)award.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-07-01"));
        Mockito.when((Object)award.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2011-12-30"));
        Mockito.when((Object)award.getLastBilledDate()).thenReturn((Object)Date.valueOf("2011-07-20"));
        Assert.assertFalse((boolean)this.cut.validateBillingFrequency(award));
    }

    @Test
    public void validateBillingFrequency_Milestone_billingInFirstAwardMonth_Valid() {
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentSqlDate()).thenReturn((Object)Date.valueOf("2011-07-20"));
        ContractsAndGrantsBillingAward award = (ContractsAndGrantsBillingAward)Mockito.mock(Award.class);
        Mockito.when((Object)award.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        Mockito.when((Object)award.getBillingFrequency()).thenReturn((Object)BillingFrequencyFixture.BILL_FREQ_MS.createBillingFrequency());
        Mockito.when((Object)award.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-07-01"));
        Mockito.when((Object)award.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2011-12-30"));
        Mockito.when((Object)award.getLastBilledDate()).thenReturn(null);
        Assert.assertTrue((boolean)this.cut.validateBillingFrequency(award));
    }

    @Test
    public void validateBillingFrequency_Milestone_billingInFirstAwardMonth_notWithinGracePeriod_Invalid() {
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentSqlDate()).thenReturn((Object)Date.valueOf("2011-07-20"));
        ContractsAndGrantsBillingAward award = (ContractsAndGrantsBillingAward)Mockito.mock(Award.class);
        Mockito.when((Object)award.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        BillingFrequency billingFrequency = BillingFrequencyFixture.BILL_FREQ_MS.createBillingFrequency();
        billingFrequency.setGracePeriodDays(Integer.valueOf(32));
        Mockito.when((Object)award.getBillingFrequency()).thenReturn((Object)billingFrequency);
        Mockito.when((Object)award.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-07-01"));
        Mockito.when((Object)award.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2011-12-30"));
        Mockito.when((Object)award.getLastBilledDate()).thenReturn(null);
        Assert.assertFalse((boolean)this.cut.validateBillingFrequency(award));
    }

    @Test
    public void validateBillingFrequency_Milestone_billingInSecondAwardMonth_WithoutPreviousBill_Valid() {
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentSqlDate()).thenReturn((Object)Date.valueOf("2011-08-20"));
        ContractsAndGrantsBillingAward award = (ContractsAndGrantsBillingAward)Mockito.mock(Award.class);
        Mockito.when((Object)award.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        Mockito.when((Object)award.getBillingFrequency()).thenReturn((Object)BillingFrequencyFixture.BILL_FREQ_MS.createBillingFrequency());
        Mockito.when((Object)award.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-07-01"));
        Mockito.when((Object)award.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2011-12-30"));
        Mockito.when((Object)award.getLastBilledDate()).thenReturn(null);
        Assert.assertTrue((boolean)this.cut.validateBillingFrequency(award));
    }

    @Test
    public void validateBillingFrequency_Milestone_billingInSecondAwardMonth_WithPreviousBillValid() {
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentSqlDate()).thenReturn((Object)Date.valueOf("2011-08-20"));
        ContractsAndGrantsBillingAward award = (ContractsAndGrantsBillingAward)Mockito.mock(Award.class);
        Mockito.when((Object)award.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        Mockito.when((Object)award.getBillingFrequency()).thenReturn((Object)BillingFrequencyFixture.BILL_FREQ_MS.createBillingFrequency());
        Mockito.when((Object)award.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-07-01"));
        Mockito.when((Object)award.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2011-12-30"));
        Mockito.when((Object)award.getLastBilledDate()).thenReturn((Object)Date.valueOf("2011-07-20"));
        Assert.assertTrue((boolean)this.cut.validateBillingFrequency(award));
    }

    @Test
    public void validateBillingFrequency_Milestone_billingInSecondAwardMonth_notWithinGracePeriod_Invalid() {
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentSqlDate()).thenReturn((Object)Date.valueOf("2011-08-20"));
        ContractsAndGrantsBillingAward award = (ContractsAndGrantsBillingAward)Mockito.mock(Award.class);
        Mockito.when((Object)award.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        BillingFrequency billingFrequency = BillingFrequencyFixture.BILL_FREQ_MS.createBillingFrequency();
        billingFrequency.setGracePeriodDays(Integer.valueOf(32));
        Mockito.when((Object)award.getBillingFrequency()).thenReturn((Object)billingFrequency);
        Mockito.when((Object)award.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-07-01"));
        Mockito.when((Object)award.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2011-12-30"));
        Mockito.when((Object)award.getLastBilledDate()).thenReturn((Object)Date.valueOf("2011-07-20"));
        Assert.assertFalse((boolean)this.cut.validateBillingFrequency(award));
    }

    @Test
    public void validateBillingFrequency_Monthly_billingInFirstAwardMonth_Invalid() {
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentSqlDate()).thenReturn((Object)Date.valueOf("2011-07-20"));
        ContractsAndGrantsBillingAward award = (ContractsAndGrantsBillingAward)Mockito.mock(Award.class);
        Mockito.when((Object)award.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MONTHLY.getCode());
        Mockito.when((Object)award.getBillingFrequency()).thenReturn((Object)BillingFrequencyFixture.BILL_FREQ_MON.createBillingFrequency());
        Mockito.when((Object)award.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-07-01"));
        Mockito.when((Object)award.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2011-12-30"));
        Mockito.when((Object)award.getLastBilledDate()).thenReturn(null);
        Assert.assertFalse((boolean)this.cut.validateBillingFrequency(award));
    }

    @Test
    public void validateBillingFrequency_Monthly_billingInFirstAwardMonth_notWithinGracePeriod_Invalid() {
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentSqlDate()).thenReturn((Object)Date.valueOf("2011-07-20"));
        ContractsAndGrantsBillingAward award = (ContractsAndGrantsBillingAward)Mockito.mock(Award.class);
        Mockito.when((Object)award.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MONTHLY.getCode());
        BillingFrequency billingFrequency = BillingFrequencyFixture.BILL_FREQ_MON.createBillingFrequency();
        billingFrequency.setGracePeriodDays(Integer.valueOf(32));
        Mockito.when((Object)award.getBillingFrequency()).thenReturn((Object)billingFrequency);
        Mockito.when((Object)award.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-07-01"));
        Mockito.when((Object)award.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2011-12-30"));
        Mockito.when((Object)award.getLastBilledDate()).thenReturn(null);
        Assert.assertFalse((boolean)this.cut.validateBillingFrequency(award));
    }

    @Test
    public void validateBillingFrequency_Monthly_billingInSecondAwardMonth_WithoutPreviousBill_Valid() {
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentSqlDate()).thenReturn((Object)Date.valueOf("2011-08-20"));
        ContractsAndGrantsBillingAward award = (ContractsAndGrantsBillingAward)Mockito.mock(Award.class);
        Mockito.when((Object)award.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MONTHLY.getCode());
        Mockito.when((Object)award.getBillingFrequency()).thenReturn((Object)BillingFrequencyFixture.BILL_FREQ_MON.createBillingFrequency());
        Mockito.when((Object)award.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-07-01"));
        Mockito.when((Object)award.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2011-12-30"));
        Mockito.when((Object)award.getLastBilledDate()).thenReturn(null);
        Assert.assertTrue((boolean)this.cut.validateBillingFrequency(award));
    }

    @Test
    public void validateBillingFrequency_Monthly_billingInSecondAwardMonth_WithPreviousBillValid() {
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentSqlDate()).thenReturn((Object)Date.valueOf("2011-08-20"));
        ContractsAndGrantsBillingAward award = (ContractsAndGrantsBillingAward)Mockito.mock(Award.class);
        Mockito.when((Object)award.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MONTHLY.getCode());
        Mockito.when((Object)award.getBillingFrequency()).thenReturn((Object)BillingFrequencyFixture.BILL_FREQ_MON.createBillingFrequency());
        Mockito.when((Object)award.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-07-01"));
        Mockito.when((Object)award.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2011-12-30"));
        Mockito.when((Object)award.getLastBilledDate()).thenReturn((Object)Date.valueOf("2011-07-20"));
        Assert.assertTrue((boolean)this.cut.validateBillingFrequency(award));
    }

    @Test
    public void validateBillingFrequency_Monthly_billingInSecondAwardMonth_notWithinGracePeriod_Invalid() {
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentSqlDate()).thenReturn((Object)Date.valueOf("2011-08-20"));
        ContractsAndGrantsBillingAward award = (ContractsAndGrantsBillingAward)Mockito.mock(Award.class);
        Mockito.when((Object)award.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MONTHLY.getCode());
        BillingFrequency billingFrequency = BillingFrequencyFixture.BILL_FREQ_MON.createBillingFrequency();
        billingFrequency.setGracePeriodDays(Integer.valueOf(32));
        Mockito.when((Object)award.getBillingFrequency()).thenReturn((Object)billingFrequency);
        Mockito.when((Object)award.getAwardBeginningDate()).thenReturn((Object)Date.valueOf("2011-07-01"));
        Mockito.when((Object)award.getAwardEndingDate()).thenReturn((Object)Date.valueOf("2011-12-30"));
        Mockito.when((Object)award.getLastBilledDate()).thenReturn((Object)Date.valueOf("2011-07-20"));
        Assert.assertFalse((boolean)this.cut.validateBillingFrequency(award));
    }
}

