/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.service.impl;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.dataaccess.CustomerInvoiceDocumentDao;
import org.kuali.kfs.module.ar.document.service.impl.CustomerInvoiceDocumentServiceImpl;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@Execution(value=ExecutionMode.SAME_THREAD)
public class CustomerInvoiceDocumentServiceImplTest {
    private CustomerInvoiceDocumentServiceImpl cut;
    @Mock
    private CustomerInvoiceDocument customerInvoiceDocumentMock;
    @Mock
    private CustomerInvoiceDocumentDao customerInvoiceDocumentDaoMock;
    @Mock
    private DocumentService documentSvcMock;
    @Mock
    private Document documentMock;
    @Mock
    private DocumentHeader documentHeaderMock;
    @Mock
    private WorkflowDocument workflowDocumentMock;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.cut = new CustomerInvoiceDocumentServiceImpl();
        this.cut.setCustomerInvoiceDocumentDao(this.customerInvoiceDocumentDaoMock);
        this.cut.setDocumentService(this.documentSvcMock);
    }

    @Test
    public void checkIfInvoiceNumberIsFinal_BlankInvoiceNumber() {
        Assert.assertFalse((boolean)this.cut.checkIfInvoiceNumberIsFinal(""));
    }

    @Test
    public void checkIfInvoiceNumberIsFinal_BadInvoiceNumber() {
        Mockito.when((Object)this.customerInvoiceDocumentDaoMock.getInvoiceByInvoiceDocumentNumber("DOES_NOT_EXIST")).thenReturn(null);
        Assert.assertFalse((boolean)this.cut.checkIfInvoiceNumberIsFinal("DOES_NOT_EXIST"));
    }

    @Test
    public void checkIfInvoiceNumberIsFinal_WorkflowExceptionOnGetByDocumentHeaderId() throws WorkflowException {
        Mockito.when((Object)this.customerInvoiceDocumentDaoMock.getInvoiceByInvoiceDocumentNumber("1000")).thenReturn((Object)this.customerInvoiceDocumentMock);
        Mockito.when((Object)this.documentSvcMock.getByDocumentHeaderId("1000")).thenThrow(WorkflowException.class);
        Assert.assertFalse((boolean)this.cut.checkIfInvoiceNumberIsFinal("1000"));
    }

    @Test
    public void checkIfInvoiceNumberIsFinal_NullDocument() throws WorkflowException {
        Mockito.when((Object)this.customerInvoiceDocumentDaoMock.getInvoiceByInvoiceDocumentNumber("1001")).thenReturn((Object)this.customerInvoiceDocumentMock);
        Mockito.when((Object)this.documentSvcMock.getByDocumentHeaderId("1001")).thenReturn(null);
        Assert.assertFalse((boolean)this.cut.checkIfInvoiceNumberIsFinal("1001"));
    }

    @Test
    public void checkIfInvoiceNumberIsFinal_NullDocumentHeader() throws WorkflowException {
        Mockito.when((Object)this.customerInvoiceDocumentDaoMock.getInvoiceByInvoiceDocumentNumber("1002")).thenReturn((Object)this.customerInvoiceDocumentMock);
        Mockito.when((Object)this.documentSvcMock.getByDocumentHeaderId("1002")).thenReturn((Object)this.documentMock);
        Assert.assertFalse((boolean)this.cut.checkIfInvoiceNumberIsFinal("1002"));
    }

    @Test
    public void checkIfInvoiceNumberIsFinal_NullWorkflowDocument() throws WorkflowException {
        Mockito.when((Object)this.customerInvoiceDocumentDaoMock.getInvoiceByInvoiceDocumentNumber("1003")).thenReturn((Object)this.customerInvoiceDocumentMock);
        Mockito.when((Object)this.documentMock.getDocumentHeader()).thenReturn((Object)this.documentHeaderMock);
        Mockito.when((Object)this.documentSvcMock.getByDocumentHeaderId("1003")).thenReturn((Object)this.documentMock);
        Assert.assertFalse((boolean)this.cut.checkIfInvoiceNumberIsFinal("1003"));
    }

    @Test
    public void checkIfInvoiceNumberIsFinal_Enroute() throws WorkflowException {
        Mockito.when((Object)this.customerInvoiceDocumentDaoMock.getInvoiceByInvoiceDocumentNumber("1004")).thenReturn((Object)this.customerInvoiceDocumentMock);
        Mockito.when((Object)this.workflowDocumentMock.isEnroute()).thenReturn((Object)true);
        Mockito.when((Object)this.documentHeaderMock.getWorkflowDocument()).thenReturn((Object)this.workflowDocumentMock);
        Mockito.when((Object)this.documentMock.getDocumentHeader()).thenReturn((Object)this.documentHeaderMock);
        Mockito.when((Object)this.documentSvcMock.getByDocumentHeaderId("1004")).thenReturn((Object)this.documentMock);
        Assert.assertFalse((boolean)this.cut.checkIfInvoiceNumberIsFinal("1004"));
    }

    @Test
    public void checkIfInvoiceNumberIsFinal_Approved() throws WorkflowException {
        Mockito.when((Object)this.customerInvoiceDocumentDaoMock.getInvoiceByInvoiceDocumentNumber("1005")).thenReturn((Object)this.customerInvoiceDocumentMock);
        Mockito.when((Object)this.workflowDocumentMock.isApproved()).thenReturn((Object)true);
        Mockito.when((Object)this.documentHeaderMock.getWorkflowDocument()).thenReturn((Object)this.workflowDocumentMock);
        Mockito.when((Object)this.documentMock.getDocumentHeader()).thenReturn((Object)this.documentHeaderMock);
        Mockito.when((Object)this.documentSvcMock.getByDocumentHeaderId("1005")).thenReturn((Object)this.documentMock);
        Assert.assertTrue((boolean)this.cut.checkIfInvoiceNumberIsFinal("1005"));
    }

    @Test
    public void checkIfInvoiceNumberIsFinal_Processed() throws WorkflowException {
        Mockito.when((Object)this.customerInvoiceDocumentDaoMock.getInvoiceByInvoiceDocumentNumber("1006")).thenReturn((Object)this.customerInvoiceDocumentMock);
        Mockito.when((Object)this.workflowDocumentMock.isProcessed()).thenReturn((Object)true);
        Mockito.when((Object)this.documentHeaderMock.getWorkflowDocument()).thenReturn((Object)this.workflowDocumentMock);
        Mockito.when((Object)this.documentMock.getDocumentHeader()).thenReturn((Object)this.documentHeaderMock);
        Mockito.when((Object)this.documentSvcMock.getByDocumentHeaderId("1006")).thenReturn((Object)this.documentMock);
        Assert.assertTrue((boolean)this.cut.checkIfInvoiceNumberIsFinal("1006"));
    }
}

