/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.batch;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.sql.Date;
import java.time.LocalDate;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.rules.ExpectedException;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.service.AccountService;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.batch.MilestoneScheduleCsvInputFileType;
import org.kuali.kfs.module.ar.batch.vo.MilestoneScheduleCsvHeaders;
import org.kuali.kfs.module.ar.businessobject.Milestone;
import org.kuali.kfs.module.ar.businessobject.MilestoneSchedule;
import org.kuali.kfs.sys.exception.ParseException;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.core.impl.datetime.DateTimeServiceImpl;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;

@Execution(value=ExecutionMode.SAME_THREAD)
public class MilestoneScheduleCsvInputFileTypeTest {
    private static final String CSV_SAMPLE_DIRECTORY = "org/kuali/kfs/module/ar/batch/sample/";
    private MilestoneScheduleCsvInputFileType cut;
    private Milestone milestone;
    @Mock
    private AccountService accountSvcMock;
    @Spy
    private DateTimeServiceImpl dateTimeSvcSpy;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setUp() throws NoSuchFieldException, IllegalAccessException {
        MockitoAnnotations.initMocks((Object)this);
        GlobalVariables.getMessageMap().clearErrorMessages();
        this.milestone = this.setupMilestone("1", Date.valueOf(LocalDate.now().minusDays(1L)), true, "1", "milestone 1", new KualiDecimal(100.0), Date.valueOf(LocalDate.now()));
        this.setupDateFormats();
        this.cut = new MilestoneScheduleCsvInputFileType();
        this.cut.setAccountService(this.accountSvcMock);
        this.cut.setCsvEnumClass(MilestoneScheduleCsvHeaders.class);
        this.cut.setDateTimeService((DateTimeService)this.dateTimeSvcSpy);
    }

    private void setupDateFormats() throws NoSuchFieldException, IllegalAccessException {
        Field field = DateTimeServiceImpl.class.getDeclaredField("stringToDateFormats");
        field.setAccessible(true);
        field.set(this.dateTimeSvcSpy, new String[]{"MM/dd/yy", "MM/dd/yyyy", "MM-dd-yy", "MM-dd-yyyy", "MMddyy", "yyyy", "yyyy-MM-dd"});
    }

    @Test
    public void convertParsedObjectToVO_MultipleSchedules_MultipleMilestones() {
        Milestone expectedMilestone1 = this.setupMilestone("1", Date.valueOf(LocalDate.now().minusDays(1L)), true, "1", "milestone 1", new KualiDecimal(100.0), Date.valueOf(LocalDate.now()));
        Milestone expectedMilestone2 = this.setupMilestone("1", Date.valueOf(LocalDate.now().plusMonths(1L)), true, "2", "milestone 2", new KualiDecimal(50.0), Date.valueOf(LocalDate.now()));
        Milestone expectedMilestone3 = this.setupMilestone("2", Date.valueOf(LocalDate.now().minusDays(1L)), true, "1", "milestone 1", new KualiDecimal(200.0), Date.valueOf(LocalDate.now()));
        LinkedList<Milestone> expectedMilestones1 = new LinkedList<Milestone>();
        expectedMilestones1.add(expectedMilestone1);
        expectedMilestones1.add(expectedMilestone2);
        LinkedList<Milestone> expectedMilestones2 = new LinkedList<Milestone>();
        expectedMilestones2.add(expectedMilestone3);
        MilestoneSchedule expectedMilestoneSchedule1 = new MilestoneSchedule.MilestoneScheduleBuilder().setProposalNumber("1").setChartOfAccountsCode("BL").setAccountNumber("1031400").addMilestone(expectedMilestone1).addMilestone(expectedMilestone2).build();
        MilestoneSchedule expectedMilestoneSchedule2 = new MilestoneSchedule.MilestoneScheduleBuilder().setProposalNumber("2").setChartOfAccountsCode("BL").setAccountNumber("1031400").addMilestone(expectedMilestone3).build();
        LinkedList<MilestoneSchedule> expectedMilestoneSchedules = new LinkedList<MilestoneSchedule>();
        expectedMilestoneSchedules.add(expectedMilestoneSchedule1);
        expectedMilestoneSchedules.add(expectedMilestoneSchedule2);
        LinkedList<Map<String, String>> parsedContent = new LinkedList<Map<String, String>>();
        parsedContent.add(this.setupContentRow(expectedMilestone1));
        parsedContent.add(this.setupContentRow(expectedMilestone2));
        parsedContent.add(this.setupContentRow(expectedMilestone3));
        List actualMilestoneSchedules = (List)this.cut.convertParsedObjectToVO(parsedContent);
        Assert.assertEquals((Object)actualMilestoneSchedules, expectedMilestoneSchedules);
        MilestoneSchedule actualMilestoneSchedule1 = (MilestoneSchedule)actualMilestoneSchedules.get(actualMilestoneSchedules.indexOf(expectedMilestoneSchedule1));
        MilestoneSchedule actualMilestoneSchedule2 = (MilestoneSchedule)actualMilestoneSchedules.get(actualMilestoneSchedules.indexOf(expectedMilestoneSchedule2));
        List actualMilestoneSchedule1Milestones = actualMilestoneSchedule1.getMilestones();
        Assert.assertEquals(expectedMilestones1, (Object)actualMilestoneSchedule1Milestones);
        for (Milestone actualMilestone : actualMilestoneSchedule1Milestones) {
            Assert.assertTrue((boolean)actualMilestone.isNewCollectionRecord());
        }
        List actualMilestoneSchedule2Milestones = actualMilestoneSchedule2.getMilestones();
        Assert.assertEquals(expectedMilestones2, (Object)actualMilestoneSchedule2Milestones);
        for (Milestone actualMilestone : actualMilestoneSchedule2Milestones) {
            Assert.assertTrue((boolean)actualMilestone.isNewCollectionRecord());
        }
    }

    private Milestone setupMilestone(String proposalNumber, Date milestoneExpectedCompletionDate, boolean active, String milestoneNumber, String milestoneDescription, KualiDecimal milestoneAmount, Date milestoneActualCompletionDate) {
        return new Milestone.MilestoneBuilder().setProposalNumber(proposalNumber).setChartOfAccountsCode("BL").setAccountNumber("1031400").setMilestoneExpectedCompletionDate(milestoneExpectedCompletionDate).setActive(active).setMilestoneNumber(milestoneNumber).setMilestoneDescription(milestoneDescription).setMilestoneAmount(milestoneAmount).setMilestoneActualCompletionDate(milestoneActualCompletionDate).build();
    }

    private Map<String, String> setupContentRow(Milestone milestone) {
        LinkedHashMap<String, String> contentRow = new LinkedHashMap<String, String>();
        contentRow.put("proposalNumber", milestone.getProposalNumber());
        contentRow.put("chartOfAccountsCode", milestone.getChartOfAccountsCode());
        contentRow.put("accountNumber", milestone.getAccountNumber());
        contentRow.put("milestoneNumber", milestone.getMilestoneNumber());
        contentRow.put("milestoneDescription", milestone.getMilestoneDescription());
        KualiDecimal milestoneAmount = milestone.getMilestoneAmount();
        if (milestoneAmount == null) {
            contentRow.put("milestoneAmount", "");
        } else {
            contentRow.put("milestoneAmount", milestone.getMilestoneAmount().toString());
        }
        Date milestoneExpectedCompletionDate = milestone.getMilestoneExpectedCompletionDate();
        if (milestoneExpectedCompletionDate == null) {
            contentRow.put("milestoneExpectedCompletionDate", "");
        } else {
            contentRow.put("milestoneExpectedCompletionDate", milestone.getMilestoneExpectedCompletionDate().toString());
        }
        Date milestoneActualCompletionDate = milestone.getMilestoneActualCompletionDate();
        if (milestoneActualCompletionDate == null) {
            contentRow.put("milestoneActualCompletionDate", "");
        } else {
            contentRow.put("milestoneActualCompletionDate", milestone.getMilestoneActualCompletionDate().toString());
        }
        contentRow.put("active", String.valueOf(milestone.isActive()));
        return contentRow;
    }

    @Test
    public void convertParsedObjectToVO_InvalidDateFormat_AddsMessageToGlobalErrors() {
        LinkedList<Map<String, String>> parsedContent = new LinkedList<Map<String, String>>();
        Map<String, String> contentRow = this.setupContentRow(this.milestone);
        contentRow.put("milestoneExpectedCompletionDate", "10_30_2018");
        parsedContent.add(contentRow);
        Assert.assertNull((Object)this.cut.convertParsedObjectToVO(parsedContent));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("GLOBAL_ERRORS");
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assert.assertEquals((Object)"error.batchUpload.parse", (Object)errorMessage.getErrorKey());
        Assert.assertEquals((long)1L, (long)errorMessage.getMessageParameters().length);
        Assert.assertEquals((Object)"Date or date/time string '10_30_2018' could not be converted using any of the accepted formats: MM/dd/yy (error offset=2),MM/dd/yyyy (error offset=2),MM-dd-yy (error offset=2),MM-dd-yyyy (error offset=2),MMddyy (error offset=2),yyyy (error offset=2),yyyy-MM-dd (error offset=2)", (Object)errorMessage.getMessageParameters()[0]);
    }

    @Test
    public void convertParsedObjectToVO_MissingProposalNumber_AddsMessageToGlobalErrors() {
        this.milestone.setProposalNumber("");
        LinkedList<Map<String, String>> parsedContent = new LinkedList<Map<String, String>>();
        parsedContent.add(this.setupContentRow(this.milestone));
        Assert.assertNull((Object)this.cut.convertParsedObjectToVO(parsedContent));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("GLOBAL_ERRORS");
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assert.assertEquals((Object)"error.batchUpload.parse", (Object)errorMessage.getErrorKey());
        Assert.assertEquals((long)1L, (long)errorMessage.getMessageParameters().length);
        Assert.assertEquals((Object)"Proposal Number is required.", (Object)errorMessage.getMessageParameters()[0]);
    }

    @Test
    public void convertParsedObjectToVO_MissingChartOfAccountsCode_AddsMessageToGlobalErrors() {
        this.milestone.setChartOfAccountsCode("");
        LinkedList<Map<String, String>> parsedContent = new LinkedList<Map<String, String>>();
        parsedContent.add(this.setupContentRow(this.milestone));
        Assert.assertNull((Object)this.cut.convertParsedObjectToVO(parsedContent));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("GLOBAL_ERRORS");
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assert.assertEquals((Object)"error.batchUpload.parse", (Object)errorMessage.getErrorKey());
        Assert.assertEquals((long)1L, (long)errorMessage.getMessageParameters().length);
        Assert.assertEquals((Object)"Chart of Accounts Code is required.", (Object)errorMessage.getMessageParameters()[0]);
    }

    @Test
    public void convertParsedObjectToVO_MissingAccountNumber_AddsMessageToGlobalErrors() {
        this.milestone.setAccountNumber("");
        LinkedList<Map<String, String>> parsedContent = new LinkedList<Map<String, String>>();
        parsedContent.add(this.setupContentRow(this.milestone));
        Assert.assertNull((Object)this.cut.convertParsedObjectToVO(parsedContent));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("GLOBAL_ERRORS");
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assert.assertEquals((Object)"error.batchUpload.parse", (Object)errorMessage.getErrorKey());
        Assert.assertEquals((long)1L, (long)errorMessage.getMessageParameters().length);
        Assert.assertEquals((Object)"Account Number is required.", (Object)errorMessage.getMessageParameters()[0]);
    }

    @Test
    public void convertParsedObjectToVO_MissingMilestoneNumber_AddsMessageToGlobalErrors() {
        this.milestone.setMilestoneNumber("");
        LinkedList<Map<String, String>> parsedContent = new LinkedList<Map<String, String>>();
        parsedContent.add(this.setupContentRow(this.milestone));
        Assert.assertNull((Object)this.cut.convertParsedObjectToVO(parsedContent));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("GLOBAL_ERRORS");
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assert.assertEquals((Object)"error.batchUpload.parse", (Object)errorMessage.getErrorKey());
        Assert.assertEquals((long)1L, (long)errorMessage.getMessageParameters().length);
        Assert.assertEquals((Object)"Milestone Number is required.", (Object)errorMessage.getMessageParameters()[0]);
    }

    @Test
    public void convertParsedObjectToVO_MissingMilestoneExpectedCompletionDate_AddsMessageToGlobalErrors() {
        this.milestone.setMilestoneExpectedCompletionDate(null);
        LinkedList<Map<String, String>> parsedContent = new LinkedList<Map<String, String>>();
        parsedContent.add(this.setupContentRow(this.milestone));
        Assert.assertNull((Object)this.cut.convertParsedObjectToVO(parsedContent));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("GLOBAL_ERRORS");
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assert.assertEquals((Object)"error.batchUpload.parse", (Object)errorMessage.getErrorKey());
        Assert.assertEquals((long)1L, (long)errorMessage.getMessageParameters().length);
        Assert.assertEquals((Object)"Milestone Expected Completion Date is required.", (Object)errorMessage.getMessageParameters()[0]);
    }

    @Test
    public void parse_incorrectNumberOfHeaders_throwsParseException() throws IOException {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("org/kuali/kfs/module/ar/batch/sample/MilestoneScheduleUpload-incorrectNumberOfHeaders.csv");
        Assert.assertNotNull((Object)inputStream);
        byte[] fileByteContent = IOUtils.toByteArray((InputStream)inputStream);
        this.expectedException.expect(ParseException.class);
        this.expectedException.expectMessage("CSV Batch Input File contains incorrect number of headers");
        List milestoneSchedules = (List)this.cut.parse(fileByteContent);
        Assert.assertNull((Object)milestoneSchedules);
    }

    @Test
    public void parse_incorrectHeaders_throwsParseException() throws IOException {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("org/kuali/kfs/module/ar/batch/sample/MilestoneScheduleUpload-incorrectHeaders.csv");
        Assert.assertNotNull((Object)inputStream);
        byte[] fileByteContent = IOUtils.toByteArray((InputStream)inputStream);
        this.expectedException.expect(ParseException.class);
        this.expectedException.expectMessage("CSV Batch Input File contains incorrect number of headers");
        List milestoneSchedules = (List)this.cut.parse(fileByteContent);
        Assert.assertNull((Object)milestoneSchedules);
    }

    @Test
    public void parse_incorrectHeaderOrder_throwsParseException() throws IOException {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("org/kuali/kfs/module/ar/batch/sample/MilestoneScheduleUpload-incorrectHeaderOrder.csv");
        Assert.assertNotNull((Object)inputStream);
        byte[] fileByteContent = IOUtils.toByteArray((InputStream)inputStream);
        this.expectedException.expect(ParseException.class);
        this.expectedException.expectMessage("CSV Batch Input File headers are different");
        List milestoneSchedules = (List)this.cut.parse(fileByteContent);
        Assert.assertNull((Object)milestoneSchedules);
    }

    @Test
    public void parse_detailLineDoesNotMatchHeaders_throwsParseException() throws IOException {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("org/kuali/kfs/module/ar/batch/sample/MilestoneScheduleUpload-invalid-detailLineDoesNotMatchHeaders.csv");
        Assert.assertNotNull((Object)inputStream);
        byte[] fileByteContent = IOUtils.toByteArray((InputStream)inputStream);
        this.expectedException.expect(ParseException.class);
        this.expectedException.expectMessage("line 13 layout does not match the header");
        List milestoneSchedules = (List)this.cut.parse(fileByteContent);
        Assert.assertNull((Object)milestoneSchedules);
    }

    @Test
    public void parse_validFile() throws IOException {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("org/kuali/kfs/module/ar/batch/sample/MilestoneScheduleUpload-valid.csv");
        Assert.assertNotNull((Object)inputStream);
        byte[] fileByteContent = IOUtils.toByteArray((InputStream)inputStream);
        List milestoneSchedules = (List)this.cut.parse(fileByteContent);
        Assert.assertEquals((long)1L, (long)milestoneSchedules.size());
        MilestoneSchedule milestoneSchedule = (MilestoneSchedule)milestoneSchedules.get(0);
        Assert.assertEquals((Object)"80075", (Object)milestoneSchedule.getProposalNumber());
        Assert.assertEquals((Object)"BL", (Object)milestoneSchedule.getChartOfAccountsCode());
        Assert.assertEquals((Object)"1031400", (Object)milestoneSchedule.getAccountNumber());
        Assert.assertEquals((long)1L, (long)milestoneSchedule.getMilestones().size());
        Milestone milestone = (Milestone)milestoneSchedule.getMilestones().get(0);
        Assert.assertEquals((Object)"80075", (Object)milestone.getProposalNumber());
        Assert.assertEquals((Object)"BL", (Object)milestone.getChartOfAccountsCode());
        Assert.assertEquals((Object)"1031400", (Object)milestone.getAccountNumber());
        Assert.assertEquals((Object)"1", (Object)milestone.getMilestoneNumber());
        Assert.assertEquals((Object)"milestone 1", (Object)milestone.getMilestoneDescription());
        Assert.assertEquals((Object)new KualiDecimal(100.0), (Object)milestone.getMilestoneAmount());
        Assert.assertEquals((Object)Date.valueOf("2018-10-30"), (Object)milestone.getMilestoneExpectedCompletionDate());
        Assert.assertNull((Object)milestone.getMilestoneActualCompletionDate());
        Assert.assertTrue((boolean)milestone.isActive());
        Assert.assertTrue((boolean)milestone.isNewCollectionRecord());
    }

    @Test
    public void parse_validFile_withoutOptionalFields() throws IOException {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("org/kuali/kfs/module/ar/batch/sample/MilestoneScheduleUpload-valid-withoutOptionalFields.csv");
        Assert.assertNotNull((Object)inputStream);
        byte[] fileByteContent = IOUtils.toByteArray((InputStream)inputStream);
        List milestoneSchedules = (List)this.cut.parse(fileByteContent);
        Assert.assertEquals((long)1L, (long)milestoneSchedules.size());
        MilestoneSchedule milestoneSchedule = (MilestoneSchedule)milestoneSchedules.get(0);
        Assert.assertEquals((Object)"80075", (Object)milestoneSchedule.getProposalNumber());
        Assert.assertEquals((Object)"BL", (Object)milestoneSchedule.getChartOfAccountsCode());
        Assert.assertEquals((Object)"1031400", (Object)milestoneSchedule.getAccountNumber());
        Assert.assertEquals((long)1L, (long)milestoneSchedule.getMilestones().size());
        Milestone milestone = (Milestone)milestoneSchedule.getMilestones().get(0);
        Assert.assertEquals((Object)"80075", (Object)milestone.getProposalNumber());
        Assert.assertEquals((Object)"BL", (Object)milestone.getChartOfAccountsCode());
        Assert.assertEquals((Object)"1031400", (Object)milestone.getAccountNumber());
        Assert.assertEquals((Object)"1", (Object)milestone.getMilestoneNumber());
        Assert.assertEquals((Object)"", (Object)milestone.getMilestoneDescription());
        Assert.assertNull((Object)milestone.getMilestoneAmount());
        Assert.assertEquals((Object)Date.valueOf("2018-10-30"), (Object)milestone.getMilestoneExpectedCompletionDate());
        Assert.assertNull((Object)milestone.getMilestoneActualCompletionDate());
        Assert.assertTrue((boolean)milestone.isActive());
        Assert.assertTrue((boolean)milestone.isNewCollectionRecord());
    }

    @Test
    public void parse_validFileWithMultipleActiveFormats() throws IOException {
        Milestone expectedMilestone1 = this.setupMilestone("80075", Date.valueOf("2018-10-30"), true, "1", "milestone 1", new KualiDecimal(100.0), null);
        Milestone expectedMilestone2 = this.setupMilestone("80075", Date.valueOf("2018-10-30"), true, "2", "milestone 2", new KualiDecimal(100.0), null);
        Milestone expectedMilestone3 = this.setupMilestone("80075", Date.valueOf("2018-10-30"), true, "3", "milestone 3", new KualiDecimal(100.0), null);
        Milestone expectedMilestone4 = this.setupMilestone("80075", Date.valueOf("2018-10-30"), true, "4", "milestone 4", new KualiDecimal(100.0), null);
        Milestone expectedMilestone5 = this.setupMilestone("80075", Date.valueOf("2018-10-30"), true, "5", "milestone 5", new KualiDecimal(100.0), null);
        Milestone expectedMilestone6 = this.setupMilestone("80075", Date.valueOf("2018-10-30"), true, "6", "milestone 6", new KualiDecimal(100.0), null);
        Milestone expectedMilestone7 = this.setupMilestone("80075", Date.valueOf("2018-10-30"), true, "7", "milestone 7", new KualiDecimal(100.0), null);
        Milestone expectedMilestone8 = this.setupMilestone("80075", Date.valueOf("2018-10-30"), true, "8", "milestone 8", new KualiDecimal(100.0), null);
        Milestone expectedMilestone9 = this.setupMilestone("80075", Date.valueOf("2018-10-30"), true, "9", "milestone 9", new KualiDecimal(100.0), null);
        Milestone expectedMilestone10 = this.setupMilestone("80075", Date.valueOf("2018-10-30"), true, "10", "milestone 10", new KualiDecimal(100.0), null);
        Milestone expectedMilestone11 = this.setupMilestone("80075", Date.valueOf("2018-10-30"), true, "11", "milestone 11", new KualiDecimal(100.0), null);
        Milestone expectedMilestone12 = this.setupMilestone("80075", Date.valueOf("2018-10-30"), true, "12", "milestone 12", new KualiDecimal(100.0), null);
        Milestone expectedMilestone13 = this.setupMilestone("80075", Date.valueOf("2018-10-30"), false, "13", "milestone 13", new KualiDecimal(100.0), null);
        Milestone expectedMilestone14 = this.setupMilestone("80075", Date.valueOf("2018-10-30"), false, "14", "milestone 14", new KualiDecimal(100.0), null);
        Milestone expectedMilestone15 = this.setupMilestone("80075", Date.valueOf("2018-10-30"), false, "15", "milestone 15", new KualiDecimal(100.0), null);
        Milestone expectedMilestone16 = this.setupMilestone("80075", Date.valueOf("2018-10-30"), false, "16", "milestone 16", new KualiDecimal(100.0), null);
        Milestone expectedMilestone17 = this.setupMilestone("80075", Date.valueOf("2018-10-30"), false, "17", "milestone 17", new KualiDecimal(100.0), null);
        Milestone expectedMilestone18 = this.setupMilestone("80075", Date.valueOf("2018-10-30"), false, "18", "milestone 18", new KualiDecimal(100.0), null);
        Milestone expectedMilestone19 = this.setupMilestone("80075", Date.valueOf("2018-10-30"), false, "19", "milestone 19", new KualiDecimal(100.0), null);
        Milestone expectedMilestone20 = this.setupMilestone("80075", Date.valueOf("2018-10-30"), false, "20", "milestone 20", new KualiDecimal(100.0), null);
        Milestone expectedMilestone21 = this.setupMilestone("80075", Date.valueOf("2018-10-30"), false, "21", "milestone 21", new KualiDecimal(100.0), null);
        Milestone expectedMilestone22 = this.setupMilestone("80075", Date.valueOf("2018-10-30"), false, "22", "milestone 22", new KualiDecimal(100.0), null);
        Milestone expectedMilestone23 = this.setupMilestone("80075", Date.valueOf("2018-10-30"), false, "23", "milestone 23", new KualiDecimal(100.0), null);
        Milestone expectedMilestone24 = this.setupMilestone("80075", Date.valueOf("2018-10-30"), false, "24", "milestone 24", new KualiDecimal(100.0), null);
        Milestone expectedMilestone25 = this.setupMilestone("80075", Date.valueOf("2018-10-30"), false, "25", "milestone 25", new KualiDecimal(100.0), null);
        LinkedList<Milestone> expectedMilestones = new LinkedList<Milestone>();
        expectedMilestones.add(expectedMilestone1);
        expectedMilestones.add(expectedMilestone2);
        expectedMilestones.add(expectedMilestone3);
        expectedMilestones.add(expectedMilestone4);
        expectedMilestones.add(expectedMilestone5);
        expectedMilestones.add(expectedMilestone6);
        expectedMilestones.add(expectedMilestone7);
        expectedMilestones.add(expectedMilestone8);
        expectedMilestones.add(expectedMilestone9);
        expectedMilestones.add(expectedMilestone10);
        expectedMilestones.add(expectedMilestone11);
        expectedMilestones.add(expectedMilestone12);
        expectedMilestones.add(expectedMilestone13);
        expectedMilestones.add(expectedMilestone14);
        expectedMilestones.add(expectedMilestone15);
        expectedMilestones.add(expectedMilestone16);
        expectedMilestones.add(expectedMilestone17);
        expectedMilestones.add(expectedMilestone18);
        expectedMilestones.add(expectedMilestone19);
        expectedMilestones.add(expectedMilestone20);
        expectedMilestones.add(expectedMilestone21);
        expectedMilestones.add(expectedMilestone22);
        expectedMilestones.add(expectedMilestone23);
        expectedMilestones.add(expectedMilestone24);
        expectedMilestones.add(expectedMilestone25);
        MilestoneSchedule expectedMilestoneSchedule = new MilestoneSchedule.MilestoneScheduleBuilder().setProposalNumber("80075").setChartOfAccountsCode("BL").setAccountNumber("1031400").addMilestone(expectedMilestone1).addMilestone(expectedMilestone2).addMilestone(expectedMilestone3).addMilestone(expectedMilestone4).addMilestone(expectedMilestone5).addMilestone(expectedMilestone6).addMilestone(expectedMilestone7).addMilestone(expectedMilestone8).addMilestone(expectedMilestone9).addMilestone(expectedMilestone10).addMilestone(expectedMilestone11).addMilestone(expectedMilestone12).addMilestone(expectedMilestone13).addMilestone(expectedMilestone14).addMilestone(expectedMilestone15).addMilestone(expectedMilestone16).addMilestone(expectedMilestone17).addMilestone(expectedMilestone18).addMilestone(expectedMilestone19).addMilestone(expectedMilestone20).addMilestone(expectedMilestone21).addMilestone(expectedMilestone22).addMilestone(expectedMilestone23).addMilestone(expectedMilestone24).addMilestone(expectedMilestone25).build();
        LinkedList<MilestoneSchedule> expectedMilestoneSchedules = new LinkedList<MilestoneSchedule>();
        expectedMilestoneSchedules.add(expectedMilestoneSchedule);
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("org/kuali/kfs/module/ar/batch/sample/MilestoneScheduleUpload-valid-multipleActiveFormats.csv");
        Assert.assertNotNull((Object)inputStream);
        byte[] fileByteContent = IOUtils.toByteArray((InputStream)inputStream);
        List actualMilestoneSchedules = (List)this.cut.parse(fileByteContent);
        Assert.assertEquals(expectedMilestoneSchedules, (Object)actualMilestoneSchedules);
        MilestoneSchedule actualMilestoneSchedule = (MilestoneSchedule)actualMilestoneSchedules.get(actualMilestoneSchedules.indexOf(expectedMilestoneSchedule));
        Assert.assertEquals((Object)expectedMilestoneSchedule, (Object)actualMilestoneSchedule);
        List actualMilestoneScheduleMilestones = actualMilestoneSchedule.getMilestones();
        Assert.assertEquals(expectedMilestones, (Object)actualMilestoneScheduleMilestones);
        for (Milestone actualMilestone : actualMilestoneScheduleMilestones) {
            Assert.assertTrue((boolean)actualMilestone.isNewCollectionRecord());
        }
    }

    @Test
    public void parse_missingChartValue_accountsCannotCrossCharts_validFile() throws IOException {
        Account accountMock = (Account)Mockito.mock(Account.class);
        Mockito.when((Object)accountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)this.accountSvcMock.getUniqueAccountForAccountNumber("1031400")).thenReturn((Object)accountMock);
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("org/kuali/kfs/module/ar/batch/sample/MilestoneScheduleUpload-no-chart-value-accounts-cannot-cross-charts-valid.csv");
        Assert.assertNotNull((Object)inputStream);
        byte[] fileByteContent = IOUtils.toByteArray((InputStream)inputStream);
        List milestoneSchedules = (List)this.cut.parse(fileByteContent);
        Assert.assertEquals((long)1L, (long)milestoneSchedules.size());
        MilestoneSchedule milestoneSchedule = (MilestoneSchedule)milestoneSchedules.get(0);
        Assert.assertEquals((Object)"80075", (Object)milestoneSchedule.getProposalNumber());
        Assert.assertEquals((Object)"BL", (Object)milestoneSchedule.getChartOfAccountsCode());
        Assert.assertEquals((Object)"1031400", (Object)milestoneSchedule.getAccountNumber());
        Assert.assertEquals((long)1L, (long)milestoneSchedule.getMilestones().size());
        Milestone milestone = (Milestone)milestoneSchedule.getMilestones().get(0);
        Assert.assertEquals((Object)"80075", (Object)milestone.getProposalNumber());
        Assert.assertEquals((Object)"BL", (Object)milestone.getChartOfAccountsCode());
        Assert.assertEquals((Object)"1031400", (Object)milestone.getAccountNumber());
        Assert.assertEquals((Object)"1", (Object)milestone.getMilestoneNumber());
        Assert.assertEquals((Object)"milestone 1", (Object)milestone.getMilestoneDescription());
        Assert.assertEquals((Object)Date.valueOf("2018-10-30"), (Object)milestone.getMilestoneExpectedCompletionDate());
        Assert.assertEquals((Object)new KualiDecimal(100.0), (Object)milestone.getMilestoneAmount());
        Assert.assertTrue((boolean)milestone.isActive());
        Assert.assertTrue((boolean)milestone.isNewCollectionRecord());
    }

    @Test
    public void parse_missingChartColumn_accountsCannotCrossCharts_validFile() throws IOException {
        Account accountMock = (Account)Mockito.mock(Account.class);
        Mockito.when((Object)accountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)this.accountSvcMock.getUniqueAccountForAccountNumber("1031400")).thenReturn((Object)accountMock);
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("org/kuali/kfs/module/ar/batch/sample/MilestoneScheduleUpload-no-chart-column-accounts-cannot-cross-charts-valid.csv");
        Assert.assertNotNull((Object)inputStream);
        byte[] fileByteContent = IOUtils.toByteArray((InputStream)inputStream);
        List milestoneSchedules = (List)this.cut.parse(fileByteContent);
        Assert.assertEquals((long)1L, (long)milestoneSchedules.size());
        MilestoneSchedule milestoneSchedule = (MilestoneSchedule)milestoneSchedules.get(0);
        Assert.assertEquals((Object)"80075", (Object)milestoneSchedule.getProposalNumber());
        Assert.assertEquals((Object)"BL", (Object)milestoneSchedule.getChartOfAccountsCode());
        Assert.assertEquals((Object)"1031400", (Object)milestoneSchedule.getAccountNumber());
        Assert.assertEquals((long)1L, (long)milestoneSchedule.getMilestones().size());
        Milestone milestone = (Milestone)milestoneSchedule.getMilestones().get(0);
        Assert.assertEquals((Object)"80075", (Object)milestone.getProposalNumber());
        Assert.assertEquals((Object)"BL", (Object)milestone.getChartOfAccountsCode());
        Assert.assertEquals((Object)"1031400", (Object)milestone.getAccountNumber());
        Assert.assertEquals((Object)"1", (Object)milestone.getMilestoneNumber());
        Assert.assertEquals((Object)"milestone 1", (Object)milestone.getMilestoneDescription());
        Assert.assertEquals((Object)Date.valueOf("2018-10-30"), (Object)milestone.getMilestoneExpectedCompletionDate());
        Assert.assertEquals((Object)new KualiDecimal(100.0), (Object)milestone.getMilestoneAmount());
        Assert.assertTrue((boolean)milestone.isActive());
        Assert.assertTrue((boolean)milestone.isNewCollectionRecord());
    }

    @Test
    public void parse_validFileWithMultipleDateFormats() throws IOException {
        Milestone expectedMilestone1 = this.setupMilestone("80075", Date.valueOf("2018-10-30"), true, "1", "milestone 1", new KualiDecimal(100.0), null);
        Milestone expectedMilestone2 = this.setupMilestone("80075", Date.valueOf("2018-10-30"), true, "2", "milestone 2", new KualiDecimal(100.0), null);
        Milestone expectedMilestone3 = this.setupMilestone("80075", Date.valueOf("2018-10-30"), true, "3", "milestone 3", new KualiDecimal(100.0), null);
        Milestone expectedMilestone4 = this.setupMilestone("80075", Date.valueOf("2018-10-30"), true, "4", "milestone 4", new KualiDecimal(100.0), null);
        Milestone expectedMilestone5 = this.setupMilestone("80075", Date.valueOf("2018-10-30"), true, "5", "milestone 5", new KualiDecimal(100.0), null);
        Milestone expectedMilestone6 = this.setupMilestone("80075", Date.valueOf("2018-01-01"), true, "6", "milestone 6", new KualiDecimal(100.0), null);
        Milestone expectedMilestone7 = this.setupMilestone("80075", Date.valueOf("2018-10-30"), true, "7", "milestone 7", new KualiDecimal(100.0), null);
        LinkedList<Milestone> expectedMilestones = new LinkedList<Milestone>();
        expectedMilestones.add(expectedMilestone1);
        expectedMilestones.add(expectedMilestone2);
        expectedMilestones.add(expectedMilestone3);
        expectedMilestones.add(expectedMilestone4);
        expectedMilestones.add(expectedMilestone5);
        expectedMilestones.add(expectedMilestone6);
        expectedMilestones.add(expectedMilestone7);
        MilestoneSchedule expectedMilestoneSchedule = new MilestoneSchedule.MilestoneScheduleBuilder().setProposalNumber("80075").setChartOfAccountsCode("BL").setAccountNumber("1031400").addMilestone(expectedMilestone1).addMilestone(expectedMilestone2).addMilestone(expectedMilestone3).addMilestone(expectedMilestone4).addMilestone(expectedMilestone5).addMilestone(expectedMilestone6).addMilestone(expectedMilestone7).build();
        LinkedList<MilestoneSchedule> expectedMilestoneSchedules = new LinkedList<MilestoneSchedule>();
        expectedMilestoneSchedules.add(expectedMilestoneSchedule);
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("org/kuali/kfs/module/ar/batch/sample/MilestoneScheduleUpload-valid-multipleDateFormats.csv");
        Assert.assertNotNull((Object)inputStream);
        byte[] fileByteContent = IOUtils.toByteArray((InputStream)inputStream);
        List actualMilestoneSchedules = (List)this.cut.parse(fileByteContent);
        Assert.assertEquals(expectedMilestoneSchedules, (Object)actualMilestoneSchedules);
        MilestoneSchedule actualMilestoneSchedule = (MilestoneSchedule)actualMilestoneSchedules.get(actualMilestoneSchedules.indexOf(expectedMilestoneSchedule));
        Assert.assertEquals((Object)expectedMilestoneSchedule, (Object)actualMilestoneSchedule);
        List actualMilestoneScheduleMilestones = actualMilestoneSchedule.getMilestones();
        Assert.assertEquals(expectedMilestones, (Object)actualMilestoneScheduleMilestones);
        for (Milestone actualMilestone : actualMilestoneScheduleMilestones) {
            Assert.assertTrue((boolean)actualMilestone.isNewCollectionRecord());
        }
    }
}

