/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.kfs.module.ar.businessobject.CustomerAddress;
import org.kuali.kfs.module.ar.businessobject.CustomerAddressEmail;

public class CustomerAddressTest {
    private CustomerAddress cut = new CustomerAddress();

    @Test
    public void getCustomerAddressEmailsAsString_noEmails() {
        String customerAddressEmails = this.cut.getCustomerAddressEmailsAsString();
        Assert.assertEquals((Object)"", (Object)customerAddressEmails);
    }

    @Test
    public void getCustomerAddressEmailsAsString_oneEmail() {
        ArrayList<CustomerAddressEmail> customerAddressEmails = new ArrayList<CustomerAddressEmail>();
        customerAddressEmails.add(this.createCustomerAddressEmail("test@kuali.co", true));
        this.cut.setCustomerAddressEmails(customerAddressEmails);
        String customerAddressEmailsAsString = this.cut.getCustomerAddressEmailsAsString();
        Assert.assertEquals((Object)"test@kuali.co", (Object)customerAddressEmailsAsString);
    }

    private CustomerAddressEmail createCustomerAddressEmail(String emailAddress, boolean active) {
        CustomerAddressEmail customerAddressEmail = new CustomerAddressEmail();
        customerAddressEmail.setCustomerEmailAddress(emailAddress);
        customerAddressEmail.setActive(active);
        return customerAddressEmail;
    }

    @Test
    public void getCustomerAddressEmailsAsString_multipleEmails() {
        ArrayList<CustomerAddressEmail> customerAddressEmails = new ArrayList<CustomerAddressEmail>();
        customerAddressEmails.add(this.createCustomerAddressEmail("test@kuali.co", true));
        customerAddressEmails.add(this.createCustomerAddressEmail("test@kuali.org", true));
        customerAddressEmails.add(this.createCustomerAddressEmail("hedgehog@kuali.co", true));
        this.cut.setCustomerAddressEmails(customerAddressEmails);
        String customerAddressEmailsAsString = this.cut.getCustomerAddressEmailsAsString();
        Assert.assertEquals((Object)"test@kuali.co, test@kuali.org, hedgehog@kuali.co", (Object)customerAddressEmailsAsString);
    }

    @Test
    public void getCustomerAddressEmailsAsString_multipleEmails_someInactive() {
        ArrayList<CustomerAddressEmail> customerAddressEmails = new ArrayList<CustomerAddressEmail>();
        customerAddressEmails.add(this.createCustomerAddressEmail("test@kuali.co", false));
        customerAddressEmails.add(this.createCustomerAddressEmail("test@kuali.org", false));
        customerAddressEmails.add(this.createCustomerAddressEmail("hedgehog@kuali.co", true));
        this.cut.setCustomerAddressEmails(customerAddressEmails);
        String customerAddressEmailsAsString = this.cut.getCustomerAddressEmailsAsString();
        Assert.assertEquals((Object)"hedgehog@kuali.co", (Object)customerAddressEmailsAsString);
    }

    @Test
    public void getCustomerAddressEmailsAsString_multipleEmails_tooLong() {
        ArrayList<CustomerAddressEmail> customerAddressEmails = new ArrayList<CustomerAddressEmail>();
        customerAddressEmails.add(this.createCustomerAddressEmail("test1@kuali.co", true));
        customerAddressEmails.add(this.createCustomerAddressEmail("test1@kuali.org", true));
        customerAddressEmails.add(this.createCustomerAddressEmail("hedgehog1@kuali.co", true));
        customerAddressEmails.add(this.createCustomerAddressEmail("test2@kuali.co", true));
        customerAddressEmails.add(this.createCustomerAddressEmail("test2@kuali.org", true));
        customerAddressEmails.add(this.createCustomerAddressEmail("hedgehog2@kuali.co", true));
        customerAddressEmails.add(this.createCustomerAddressEmail("test3@kuali.co", true));
        customerAddressEmails.add(this.createCustomerAddressEmail("test3@kuali.org", true));
        customerAddressEmails.add(this.createCustomerAddressEmail("hedgehog3@kuali.co", true));
        customerAddressEmails.add(this.createCustomerAddressEmail("test4@kuali.co", true));
        customerAddressEmails.add(this.createCustomerAddressEmail("test4@kuali.org", true));
        customerAddressEmails.add(this.createCustomerAddressEmail("hedgehog4@kuali.co", true));
        customerAddressEmails.add(this.createCustomerAddressEmail("test5@kuali.co", true));
        customerAddressEmails.add(this.createCustomerAddressEmail("test5@kuali.org", true));
        customerAddressEmails.add(this.createCustomerAddressEmail("hedgehog5@kuali.co", true));
        customerAddressEmails.add(this.createCustomerAddressEmail("test6@kuali.co", true));
        customerAddressEmails.add(this.createCustomerAddressEmail("test6@kuali.org", true));
        customerAddressEmails.add(this.createCustomerAddressEmail("hedgehog6@kuali.co", true));
        customerAddressEmails.add(this.createCustomerAddressEmail("test7@kuali.co", true));
        customerAddressEmails.add(this.createCustomerAddressEmail("test7@kuali.org", true));
        customerAddressEmails.add(this.createCustomerAddressEmail("hedgehog7@kuali.co", true));
        customerAddressEmails.add(this.createCustomerAddressEmail("test8@kuali.co", true));
        customerAddressEmails.add(this.createCustomerAddressEmail("test8@kuali.org", true));
        customerAddressEmails.add(this.createCustomerAddressEmail("hedgehog8@kuali.co", true));
        customerAddressEmails.add(this.createCustomerAddressEmail("test9@kuali.co", true));
        customerAddressEmails.add(this.createCustomerAddressEmail("test9@kuali.org", true));
        customerAddressEmails.add(this.createCustomerAddressEmail("hedgehog9@kuali.co", true));
        customerAddressEmails.add(this.createCustomerAddressEmail("test10@kuali.co", true));
        customerAddressEmails.add(this.createCustomerAddressEmail("test10@kuali.org", true));
        customerAddressEmails.add(this.createCustomerAddressEmail("hedgehog10@kuali.co", true));
        customerAddressEmails.add(this.createCustomerAddressEmail("test11@kuali.co", true));
        customerAddressEmails.add(this.createCustomerAddressEmail("test11@kuali.org", true));
        customerAddressEmails.add(this.createCustomerAddressEmail("hedgehog11@kuali.co", true));
        customerAddressEmails.add(this.createCustomerAddressEmail("test12@kuali.co", true));
        customerAddressEmails.add(this.createCustomerAddressEmail("test12@kuali.org", true));
        customerAddressEmails.add(this.createCustomerAddressEmail("hedgehog12@kuali.co", true));
        this.cut.setCustomerAddressEmails(customerAddressEmails);
        String customerAddressEmailsAsString = this.cut.getCustomerAddressEmailsAsString();
        Assert.assertEquals((Object)"test1@kuali.co, test1@kuali.org, hedgehog1@kuali.co, test2@kuali.co, test2@kuali.org, hedgehog2@kuali.co, test3@kuali.co, test3@kuali.org, hedgehog3@kuali.co, test4@kuali.co, test4@kuali.org, hedgehog4@kuali.co, test5@kuali.co, test5@kuali.org, hedgehog5@kuali.co, test6@kuali.co, test6@kuali.org, hedgehog6@kuali.co, test7@kuali.co, test7@kuali.org, hedgehog7@kuali.co, test8@kuali.co, test8@kuali.org, hedgehog8@kuali.co, test9@kuali.co, test9@kuali.org, hedgehog9@kuali.co, test10@kuali.co, test10@kuali.org, hedgehog10@kuali.co, test11@kuali.co, test11@kuali.org, hedgehog11@kuali.co, test12@kuali.co", (Object)customerAddressEmailsAsString);
    }
}

