/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject.actions;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.datadictionary.Action;
import org.kuali.kfs.datadictionary.ActionType;
import org.kuali.kfs.datadictionary.legacy.BusinessObjectDictionaryService;
import org.kuali.kfs.kns.datadictionary.BusinessObjectEntry;
import org.kuali.kfs.kns.datadictionary.LookupDefinition;
import org.kuali.kfs.kns.service.BusinessObjectMetaDataService;
import org.kuali.kfs.krad.bo.BusinessObjectBase;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.kfs.module.ar.businessobject.Customer;
import org.kuali.kfs.module.ar.businessobject.CustomerOpenItemReportDetail;
import org.kuali.kfs.module.ar.businessobject.actions.CustomerActionsProvider;
import org.kuali.kfs.module.ar.businessobject.admin.CustomerAdminService;
import org.kuali.rice.kim.api.identity.Person;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@Execution(value=ExecutionMode.SAME_THREAD)
public class CustomerActionsProviderTest {
    private CustomerActionsProvider cut = new CustomerActionsProvider();
    @Mock
    private CustomerAdminService customerAdminServiceMock;
    @Mock
    private BusinessObjectDictionaryService businessObjectDictionaryServiceMock;
    @Mock
    private BusinessObjectMetaDataService businessObjectMetaDataServiceMock;
    @Mock
    private LookupDefinition lookupDefinitionMock;
    @Mock
    private BusinessObjectEntry businessObjectEntryMock;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        this.cut.setBusinessObjectDictionaryService(this.businessObjectDictionaryServiceMock);
        this.cut.setBusinessObjectMetaDataService(this.businessObjectMetaDataServiceMock);
        Mockito.when((Object)this.businessObjectDictionaryServiceMock.getBusinessObjectAdminService((Class)ArgumentMatchers.eq(Customer.class))).thenReturn((Object)this.customerAdminServiceMock);
        Mockito.when((Object)this.businessObjectDictionaryServiceMock.getLookupDefinition((Class)ArgumentMatchers.any())).thenReturn((Object)this.lookupDefinitionMock);
        Mockito.when((Object)this.businessObjectDictionaryServiceMock.getBusinessObjectEntry((String)ArgumentMatchers.any())).thenReturn((Object)this.businessObjectEntryMock);
    }

    @Test
    public void getActionLinks_reportAllowed_includesReport() {
        Person user = (Person)Mockito.mock(Person.class);
        Customer customer = new Customer();
        customer.setCustomerNumber("1234");
        customer.setCustomerName("Ada Lovelace");
        Mockito.when((Object)this.customerAdminServiceMock.allowsReport((Person)ArgumentMatchers.eq((Object)user))).thenReturn((Object)true);
        List actions = this.cut.getActionLinks((BusinessObjectBase)customer, user);
        Action expected = new Action("Report", "GET", CustomerActionsProviderTest.generateExpectedUrl());
        boolean expectedReportActionExists = actions.stream().anyMatch(action -> action.equals((Object)expected));
        Assert.assertTrue((boolean)expectedReportActionExists);
    }

    private static String generateExpectedUrl() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("businessObjectClassName", CustomerOpenItemReportDetail.class.getName());
        params.put("returnLocation", "");
        params.put("lookupableImplServiceName", "arCustomerOpenItemReportLookupable");
        params.put("methodToCall", "search");
        params.put("customerNumber", "1234");
        params.put("reportName", "Customer History Report");
        params.put("customerName", "Ada Lovelace");
        params.put("docFormKey", "88888888");
        return UrlFactory.parameterizeUrl((String)"arCustomerOpenItemReportLookup.do", params);
    }

    @Test
    public void getActionLinks_reportDenied_omitsReport() {
        Person user = (Person)Mockito.mock(Person.class);
        Customer customer = new Customer();
        Mockito.when((Object)this.customerAdminServiceMock.allowsReport((Person)ArgumentMatchers.eq((Object)user))).thenReturn((Object)false);
        List actions = this.cut.getActionLinks((BusinessObjectBase)customer, user);
        boolean hasReportAction = actions.stream().anyMatch(action -> action.getLabel().equals("Report"));
        Assert.assertFalse((boolean)hasReportAction);
    }

    @Test
    public void getActionLinks_supportsSuperEditAction() {
        Person user = (Person)Mockito.mock(Person.class);
        Customer customer = new Customer();
        Mockito.when((Object)this.businessObjectMetaDataServiceMock.listPrimaryKeyFieldNames((Class)ArgumentMatchers.any())).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.businessObjectEntryMock.supportsAction(ActionType.EDIT)).thenReturn((Object)true);
        Mockito.when((Object)this.customerAdminServiceMock.allowsEdit((BusinessObjectBase)ArgumentMatchers.eq((Object)customer), (Person)ArgumentMatchers.eq((Object)user))).thenReturn((Object)true);
        List actions = this.cut.getActionLinks((BusinessObjectBase)customer, user);
        boolean hasEditAction = actions.stream().anyMatch(action -> action.getLabel().equals("Edit"));
        Assert.assertTrue((boolean)hasEditAction);
    }

    @Test
    public void getActionLinks_supportsSuperCopyAction() {
        Person user = (Person)Mockito.mock(Person.class);
        Customer customer = new Customer();
        Mockito.when((Object)this.businessObjectMetaDataServiceMock.listPrimaryKeyFieldNames((Class)ArgumentMatchers.any())).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.businessObjectEntryMock.supportsAction(ActionType.COPY)).thenReturn((Object)true);
        Mockito.when((Object)this.customerAdminServiceMock.allowsCopy((BusinessObjectBase)ArgumentMatchers.eq((Object)customer), (Person)ArgumentMatchers.eq((Object)user))).thenReturn((Object)true);
        List actions = this.cut.getActionLinks((BusinessObjectBase)customer, user);
        boolean hasEditAction = actions.stream().anyMatch(action -> action.getLabel().equals("Copy"));
        Assert.assertTrue((boolean)hasEditAction);
    }
}

