/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject.actions;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.datadictionary.Action;
import org.kuali.kfs.datadictionary.ActionType;
import org.kuali.kfs.datadictionary.BusinessObjectAdminService;
import org.kuali.kfs.datadictionary.legacy.BusinessObjectDictionaryService;
import org.kuali.kfs.kns.datadictionary.BusinessObjectEntry;
import org.kuali.kfs.kns.datadictionary.LookupDefinition;
import org.kuali.kfs.kns.inquiry.KualiInquirableImpl;
import org.kuali.kfs.kns.lookup.HtmlData;
import org.kuali.kfs.kns.service.BusinessObjectAuthorizationService;
import org.kuali.kfs.kns.service.BusinessObjectMetaDataService;
import org.kuali.kfs.krad.bo.BusinessObjectBase;
import org.kuali.kfs.krad.datadictionary.AttributeDefinition;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.service.ModuleService;
import org.kuali.kfs.module.ar.businessobject.InvoiceTemplate;
import org.kuali.kfs.module.ar.businessobject.actions.TemplateActionsProvider;
import org.kuali.kfs.sys.FinancialSystemModuleConfiguration;
import org.kuali.rice.kim.api.identity.Person;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@Execution(value=ExecutionMode.SAME_THREAD)
public class TemplateActionsProviderTest {
    private TemplateActionsProvider cut = new TemplateActionsProvider();
    @Mock
    private BusinessObjectAdminService businessObjectAdminServiceMock;
    @Mock
    private BusinessObjectAuthorizationService businessObjectAuthorizationServiceMock;
    @Mock
    private BusinessObjectDictionaryService businessObjectDictionaryServiceMock;
    @Mock
    private BusinessObjectMetaDataService businessObjectMetaDataServiceMock;
    @Mock
    private KualiModuleService kualiModuleSvcMock;
    @Mock
    private FinancialSystemModuleConfiguration moduleConfigMock;
    @Mock
    private LookupDefinition lookupDefinitionMock;
    @Mock
    private BusinessObjectEntry businessObjectEntryMock;
    @Mock
    private ModuleService moduleSvcMock;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.businessObjectDictionaryServiceMock.getInquirableClass((Class)ArgumentMatchers.any())).thenReturn(KualiInquirableImpl.class);
        Mockito.when((Object)this.businessObjectDictionaryServiceMock.getBusinessObjectAdminService((Class)ArgumentMatchers.any(Class.class))).thenReturn((Object)this.businessObjectAdminServiceMock);
        Mockito.when((Object)this.businessObjectDictionaryServiceMock.getLookupDefinition((Class)ArgumentMatchers.any())).thenReturn((Object)this.lookupDefinitionMock);
        Mockito.when((Object)this.businessObjectDictionaryServiceMock.getBusinessObjectEntry((String)ArgumentMatchers.any())).thenReturn((Object)this.businessObjectEntryMock);
        Mockito.when((Object)this.businessObjectEntryMock.getAttributeDefinition(ArgumentMatchers.anyString())).thenReturn((Object)new AttributeDefinition());
        Mockito.when((Object)this.kualiModuleSvcMock.getModuleServiceByNamespaceCode("KFS-AR")).thenReturn((Object)this.moduleSvcMock);
        Mockito.when((Object)this.moduleSvcMock.getModuleConfiguration()).thenReturn((Object)this.moduleConfigMock);
        HashMap<String, String> templateFileDirectories = new HashMap<String, String>();
        templateFileDirectories.put("templates.directory", "src/test/resources/org/kuali/kfs/module/ar/templates");
        Mockito.when((Object)this.moduleConfigMock.getTemplateFileDirectories()).thenReturn(templateFileDirectories);
        HtmlData.AnchorHtmlData anchorData = new HtmlData.AnchorHtmlData();
        anchorData.setHref("inquiry.do");
        this.cut.setBusinessObjectAuthorizationService(this.businessObjectAuthorizationServiceMock);
        this.cut.setBusinessObjectDictionaryService(this.businessObjectDictionaryServiceMock);
        this.cut.setBusinessObjectMetaDataService(this.businessObjectMetaDataServiceMock);
        this.cut.setKualiModuleService(this.kualiModuleSvcMock);
        this.cut.setBaseUrl("arAccountsReceivableInvoiceTemplateUpload.do");
        this.cut.setTemplateCodeKey("invoiceTemplateCode");
    }

    @Test
    public void getActionLinks_canEditAndCopy_fileMissing_includesEditCopyAndUpload() {
        List<String> pkNames = Collections.singletonList("invoiceTemplateCode");
        Mockito.when((Object)this.businessObjectMetaDataServiceMock.listPrimaryKeyFieldNames((Class)ArgumentMatchers.any())).thenReturn(pkNames);
        InvoiceTemplate invoiceTemplate = new InvoiceTemplate();
        invoiceTemplate.setInvoiceTemplateCode("IT");
        invoiceTemplate.setFilename("missing");
        Mockito.when((Object)this.businessObjectAdminServiceMock.allowsEdit((BusinessObjectBase)ArgumentMatchers.any(), (Person)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.when((Object)this.businessObjectEntryMock.supportsAction(ActionType.EDIT)).thenReturn((Object)true);
        Mockito.when((Object)this.businessObjectAdminServiceMock.allowsCopy((BusinessObjectBase)ArgumentMatchers.any(), (Person)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.when((Object)this.businessObjectEntryMock.supportsAction(ActionType.COPY)).thenReturn((Object)true);
        List actions = this.cut.getActionLinks((BusinessObjectBase)invoiceTemplate, (Person)Mockito.mock(Person.class));
        Assert.assertEquals((long)3L, (long)actions.size());
        Action editAction = (Action)actions.get(0);
        Action expectedEditAction = new Action("Edit", "GET", "kr/maintenance.do?businessObjectClassName=org.kuali.kfs.module.ar.businessobject.InvoiceTemplate&methodToCall=edit&invoiceTemplateCode=IT");
        Assert.assertEquals((Object)expectedEditAction, (Object)editAction);
        Action copyAction = (Action)actions.get(1);
        Action expectedCopyAction = new Action("Copy", "GET", "kr/maintenance.do?businessObjectClassName=org.kuali.kfs.module.ar.businessobject.InvoiceTemplate&methodToCall=copy&invoiceTemplateCode=IT");
        Assert.assertEquals((Object)expectedCopyAction, (Object)copyAction);
        Action uploadAction = (Action)actions.get(2);
        Action expectedUploadAction = new Action("Upload", "GET", "arAccountsReceivableInvoiceTemplateUpload.do?methodToCall=start&invoiceTemplateCode=IT");
        Assert.assertEquals((Object)expectedUploadAction, (Object)uploadAction);
    }

    @Test
    public void getActionLinks_canEditAndCopy_fileExists_includesEditCopyUploadAndDownload() {
        List<String> pkNames = Collections.singletonList("invoiceTemplateCode");
        Mockito.when((Object)this.businessObjectMetaDataServiceMock.listPrimaryKeyFieldNames((Class)ArgumentMatchers.any())).thenReturn(pkNames);
        InvoiceTemplate invoiceTemplate = new InvoiceTemplate();
        invoiceTemplate.setInvoiceTemplateCode("IT");
        invoiceTemplate.setFilename("dummyTemplate");
        Mockito.when((Object)this.businessObjectAdminServiceMock.allowsEdit((BusinessObjectBase)ArgumentMatchers.any(), (Person)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.when((Object)this.businessObjectEntryMock.supportsAction(ActionType.EDIT)).thenReturn((Object)true);
        Mockito.when((Object)this.businessObjectAdminServiceMock.allowsCopy((BusinessObjectBase)ArgumentMatchers.any(), (Person)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.when((Object)this.businessObjectEntryMock.supportsAction(ActionType.COPY)).thenReturn((Object)true);
        List actions = this.cut.getActionLinks((BusinessObjectBase)invoiceTemplate, (Person)Mockito.mock(Person.class));
        Assert.assertEquals((long)4L, (long)actions.size());
        Action editAction = (Action)actions.get(0);
        Action expectedEditAction = new Action("Edit", "GET", "kr/maintenance.do?businessObjectClassName=org.kuali.kfs.module.ar.businessobject.InvoiceTemplate&methodToCall=edit&invoiceTemplateCode=IT");
        Assert.assertEquals((Object)expectedEditAction, (Object)editAction);
        Action copyAction = (Action)actions.get(1);
        Action expectedCopyAction = new Action("Copy", "GET", "kr/maintenance.do?businessObjectClassName=org.kuali.kfs.module.ar.businessobject.InvoiceTemplate&methodToCall=copy&invoiceTemplateCode=IT");
        Assert.assertEquals((Object)expectedCopyAction, (Object)copyAction);
        Action uploadAction = (Action)actions.get(2);
        Action expectedUploadAction = new Action("Upload", "GET", "arAccountsReceivableInvoiceTemplateUpload.do?methodToCall=start&invoiceTemplateCode=IT");
        Assert.assertEquals((Object)expectedUploadAction, (Object)uploadAction);
        Action downloadAction = (Action)actions.get(2);
        Action expectedDownloadAction = new Action("Upload", "GET", "arAccountsReceivableInvoiceTemplateUpload.do?methodToCall=start&invoiceTemplateCode=IT");
        Assert.assertEquals((Object)expectedDownloadAction, (Object)downloadAction);
    }

    @Test
    public void getActionLinks_noPermissionToEditOrCopy_noLinks() {
        InvoiceTemplate invoiceTemplate = new InvoiceTemplate();
        invoiceTemplate.setInvoiceTemplateCode("IT");
        Mockito.when((Object)this.businessObjectAdminServiceMock.allowsEdit((BusinessObjectBase)ArgumentMatchers.any(), (Person)ArgumentMatchers.any())).thenReturn((Object)false);
        Mockito.when((Object)this.businessObjectAdminServiceMock.allowsCopy((BusinessObjectBase)ArgumentMatchers.any(), (Person)ArgumentMatchers.any())).thenReturn((Object)false);
        List actions = this.cut.getActionLinks((BusinessObjectBase)invoiceTemplate, (Person)Mockito.mock(Person.class));
        Assert.assertEquals((long)0L, (long)actions.size());
    }
}

