/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject.admin;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kuali.kfs.krad.bo.BusinessObjectBase;
import org.kuali.kfs.module.ar.businessobject.Customer;
import org.kuali.kfs.module.ar.businessobject.admin.CustomerAdminService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class CustomerAdminServiceTest {
    private CustomerAdminService cut = new CustomerAdminService();
    @Mock
    private PermissionService permissionServiceMock;
    @Mock
    private Person userMock;

    @BeforeEach
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        this.cut.setPermissionService(this.permissionServiceMock);
        Mockito.when((Object)this.userMock.getPrincipalId()).thenReturn((Object)"1234");
    }

    @Test
    public void allowsCopy_returnsFalse() {
        Customer customer = new Customer();
        Assertions.assertFalse((boolean)this.cut.allowsCopy((BusinessObjectBase)customer, this.userMock));
    }

    @Test
    public void allowsReport_permissionGranted_returnsTrue() {
        Mockito.when((Object)this.permissionServiceMock.isAuthorizedByTemplate((String)ArgumentMatchers.eq((Object)"1234"), (String)ArgumentMatchers.eq((Object)"KR-NS"), (String)ArgumentMatchers.eq((Object)"Use Screen"), ArgumentMatchers.anyMap(), ArgumentMatchers.anyMap())).thenReturn((Object)true);
        Assertions.assertTrue((boolean)this.cut.allowsReport(this.userMock));
    }

    @Test
    public void allowsReport_permissionDenied_returnsFalse() {
        Mockito.when((Object)this.permissionServiceMock.isAuthorizedByTemplate((String)ArgumentMatchers.eq((Object)"1234"), (String)ArgumentMatchers.eq((Object)"KR-NS"), (String)ArgumentMatchers.eq((Object)"Use Screen"), ArgumentMatchers.anyMap(), ArgumentMatchers.anyMap())).thenReturn((Object)false);
        Assertions.assertFalse((boolean)this.cut.allowsReport(this.userMock));
    }
}

