/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject.lookup;

import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.runner.RunWith;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.datadictionary.legacy.BusinessObjectDictionaryService;
import org.kuali.kfs.datadictionary.legacy.DataDictionaryService;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAgency;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAwardAccount;
import org.kuali.kfs.kns.datadictionary.BusinessObjectEntry;
import org.kuali.kfs.kns.service.BusinessObjectMetaDataService;
import org.kuali.kfs.kns.service.KNSServiceLocator;
import org.kuali.kfs.kns.util.FieldUtils;
import org.kuali.kfs.kns.web.struts.form.LookupForm;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.service.ModuleService;
import org.kuali.kfs.module.ar.businessobject.AccountsReceivableDocumentHeader;
import org.kuali.kfs.module.ar.businessobject.ContractsAndGrantsAgingReport;
import org.kuali.kfs.module.ar.businessobject.CustomerAgingReportDetail;
import org.kuali.kfs.module.ar.businessobject.InvoiceAddressDetail;
import org.kuali.kfs.module.ar.businessobject.InvoiceGeneralDetail;
import org.kuali.kfs.module.ar.businessobject.lookup.ContractsGrantsAgingReportLookupableHelperServiceImpl;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.CustomerCreditMemoDocumentService;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDocumentService;
import org.kuali.kfs.module.ar.fixture.ARAgencyMockFixture;
import org.kuali.kfs.module.ar.fixture.ARAwardAccountMockFixture;
import org.kuali.kfs.module.ar.fixture.ARAwardMockFixture;
import org.kuali.kfs.module.ar.report.service.ContractsGrantsAgingReportService;
import org.kuali.kfs.module.ar.report.service.CustomerAgingReportService;
import org.kuali.kfs.module.ar.web.struts.ContractsGrantsAgingReportForm;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={KNSServiceLocator.class})
@Execution(value=ExecutionMode.SAME_THREAD)
public class ContractsGrantsAgingReportLookupableHelperServiceImplTest {
    private static final String CUSTOMER_NUMBER = "ABB2";
    private static final String CUSTOMER_NAME = "WOODS CORPORATION";
    private ContractsGrantsAgingReportLookupableHelperServiceImpl cut;
    private Map<String, String> fieldValues;
    @Mock
    private BusinessObjectDictionaryService businessObjectDictionarySvcMock;
    @Mock
    private BusinessObjectMetaDataService businessObjectMetaDataSvcMock;
    @Mock
    private BusinessObjectService businessObjectSvcMock;
    @Mock
    private ContractsGrantsAgingReportService contractsGrantsAgingReportSvcMock;
    @Mock
    private CustomerAgingReportService customerAgingReportSvcMock;
    @Mock
    private CustomerCreditMemoDocumentService customerCreditMemoDocumentSvcMock;
    @Mock
    private CustomerInvoiceDocumentService customerInvoiceDocumentSvdMock;
    @Mock
    private DataDictionaryService dataDictionarySvcMock;
    @Mock
    private DateTimeService dateTimeSvcMock;
    @Mock
    private KualiModuleService kualiModuleSvcMock;
    @Mock
    private ModuleService moduleSvcMock;
    @Mock
    private ParameterService parameterSvcMock;
    private ContractsAndGrantsBillingAward awardMock;
    private ContractsAndGrantsBillingAgency agencyMock;
    private ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.setupAwardAndAgencyMocks();
        this.setupContractsGrantsInvoiceDocumentMock();
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy", Locale.US);
        java.util.Date today = new java.util.Date();
        String reportRunDate = dateFormat.format(today);
        Mockito.when((Object)this.dateTimeSvcMock.convertToDate(reportRunDate)).thenReturn((Object)today);
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentDate()).thenReturn((Object)Calendar.getInstance().getTime());
        this.setupFieldValues(reportRunDate);
        this.setupContractsGrantsAgingOpenInvoicesReportService();
        FieldUtils.setDataDictionaryService((DataDictionaryService)this.dataDictionarySvcMock);
        BusinessObjectEntry businessObjectEntryMock = (BusinessObjectEntry)Mockito.mock(BusinessObjectEntry.class);
        Mockito.when((Object)businessObjectEntryMock.hasLookupDefinition()).thenReturn((Object)false);
        PowerMockito.mockStatic(KNSServiceLocator.class, (Class[])new Class[0]);
        Mockito.when((Object)KNSServiceLocator.getBusinessObjectDictionaryService()).thenReturn((Object)this.businessObjectDictionarySvcMock);
        Mockito.when((Object)this.businessObjectDictionarySvcMock.getBusinessObjectEntry(ContractsAndGrantsAgingReport.class.getName())).thenReturn((Object)businessObjectEntryMock);
        Mockito.when((Object)this.businessObjectMetaDataSvcMock.isLookupable(ContractsAndGrantsAgingReport.class)).thenReturn((Object)true);
        Mockito.when((Object)this.parameterSvcMock.getParameterValueAsString(CustomerAgingReportDetail.class, "CUSTOMER_INVOICE_AGE")).thenReturn((Object)"120");
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("customerNumber", CUSTOMER_NUMBER);
        Mockito.when((Object)((ContractsAndGrantsBillingAgency)this.moduleSvcMock.getExternalizableBusinessObject(ContractsAndGrantsBillingAgency.class, args))).thenReturn((Object)this.agencyMock);
        Mockito.when((Object)this.kualiModuleSvcMock.getResponsibleModuleService(ContractsAndGrantsBillingAgency.class)).thenReturn((Object)this.moduleSvcMock);
        Mockito.when((Object)this.customerInvoiceDocumentSvdMock.getOpenAmountForCustomerInvoiceDocument((CustomerInvoiceDocument)this.contractsGrantsInvoiceDocumentMock)).thenReturn((Object)new KualiDecimal(800.0));
        this.cut = new ContractsGrantsAgingReportLookupableHelperServiceImpl();
        this.cut.setBusinessObjectDictionaryService(this.businessObjectDictionarySvcMock);
        this.cut.setBusinessObjectService(this.businessObjectSvcMock);
        this.cut.setBusinessObjectMetaDataService(this.businessObjectMetaDataSvcMock);
        this.cut.setContractsGrantsAgingReportService(this.contractsGrantsAgingReportSvcMock);
        this.cut.setCustomerAgingReportService(this.customerAgingReportSvcMock);
        this.cut.setCustomerCreditMemoDocumentService(this.customerCreditMemoDocumentSvcMock);
        this.cut.setCustomerInvoiceDocumentService(this.customerInvoiceDocumentSvdMock);
        this.cut.setDataDictionaryService(this.dataDictionarySvcMock);
        this.cut.setDateTimeService(this.dateTimeSvcMock);
        this.cut.setModuleService(this.kualiModuleSvcMock);
        this.cut.setParameterService(this.parameterSvcMock);
        this.cut.setBusinessObjectClass(ContractsAndGrantsAgingReport.class);
        this.cut.afterPropertiesSet();
    }

    private void setupFieldValues(String reportRunDate) {
        this.fieldValues = new LinkedHashMap<String, String>();
        this.fieldValues.put("backLocation", null);
        this.fieldValues.put("reportRunDate", reportRunDate);
        this.fieldValues.put("docFormKey", null);
        this.fieldValues.put("businessObjectClassName", ContractsAndGrantsAgingReport.class.getName());
    }

    private void setupAwardAndAgencyMocks() {
        this.awardMock = ARAwardMockFixture.CG_AWARD_MONTHLY_BILLED_DATE_NULL.createAwardMock();
        ContractsAndGrantsBillingAwardAccount awardAccountMock = ARAwardAccountMockFixture.AWD_ACCT_1.createAwardAccountMock();
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks.add(awardAccountMock);
        Mockito.when((Object)this.awardMock.getActiveAwardAccounts()).thenReturn(awardAccountMocks);
        this.agencyMock = ARAgencyMockFixture.CG_AGENCY1.createAgencyMock();
        Mockito.when((Object)this.awardMock.getAgency()).thenReturn((Object)this.agencyMock);
        String agencyNumber = this.agencyMock.getAgencyNumber();
        Mockito.when((Object)this.awardMock.getAgencyNumber()).thenReturn((Object)agencyNumber);
    }

    private void setupContractsGrantsInvoiceDocumentMock() {
        this.contractsGrantsInvoiceDocumentMock = (ContractsGrantsInvoiceDocument)Mockito.mock(ContractsGrantsInvoiceDocument.class);
        FinancialSystemDocumentHeader documentHeader = new FinancialSystemDocumentHeader();
        documentHeader.setFinancialDocumentStatusCode("A");
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getFinancialSystemDocumentHeader()).thenReturn((Object)documentHeader);
        AccountsReceivableDocumentHeader accountsReceivableDocumentHeader = new AccountsReceivableDocumentHeader();
        accountsReceivableDocumentHeader.setCustomerNumber(CUSTOMER_NUMBER);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getAccountsReceivableDocumentHeader()).thenReturn((Object)accountsReceivableDocumentHeader);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getDocumentHeader()).thenReturn((Object)documentHeader);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getBillingDate()).thenReturn((Object)Date.valueOf(LocalDate.now()));
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.isOpenInvoiceIndicator()).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getCustomerName()).thenReturn((Object)CUSTOMER_NAME);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getTotalDollarAmount()).thenReturn((Object)new KualiDecimal(1000.0));
        InvoiceGeneralDetail invoiceGeneralDetailMock = (InvoiceGeneralDetail)Mockito.mock(InvoiceGeneralDetail.class);
        Mockito.when((Object)invoiceGeneralDetailMock.getAward()).thenReturn((Object)this.awardMock);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail()).thenReturn((Object)invoiceGeneralDetailMock);
        ArrayList<InvoiceAddressDetail> invoiceAddressDetails = new ArrayList<InvoiceAddressDetail>();
        InvoiceAddressDetail invoiceAddressDetail = new InvoiceAddressDetail();
        invoiceAddressDetail.setCustomerInvoiceTemplateCode("STD");
        invoiceAddressDetail.setInvoiceTransmissionMethodCode("MAIL");
        invoiceAddressDetails.add(invoiceAddressDetail);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getInvoiceAddressDetails()).thenReturn(invoiceAddressDetails);
    }

    private void setupContractsGrantsAgingOpenInvoicesReportService() throws ParseException {
        ArrayList<ContractsGrantsInvoiceDocument> contractsGrantsInvoiceDocuments = new ArrayList<ContractsGrantsInvoiceDocument>();
        contractsGrantsInvoiceDocuments.add(this.contractsGrantsInvoiceDocumentMock);
        LinkedHashMap<String, ArrayList<ContractsGrantsInvoiceDocument>> invoiceMap = new LinkedHashMap<String, ArrayList<ContractsGrantsInvoiceDocument>>();
        invoiceMap.put("ABB2-WOODS CORPORATION", contractsGrantsInvoiceDocuments);
        Mockito.when((Object)this.contractsGrantsAgingReportSvcMock.filterContractsGrantsAgingReport((Map)ArgumentMatchers.eq(this.fieldValues), (Date)ArgumentMatchers.eq(null), (Date)ArgumentMatchers.any(Date.class))).thenReturn(invoiceMap);
    }

    @Test
    public void getSearchResults() {
        KualiDecimal test0to30total = new KualiDecimal("0.00");
        KualiDecimal test31to60total = new KualiDecimal("0.00");
        KualiDecimal test61to90total = new KualiDecimal("0.00");
        KualiDecimal test91toSYSPRtotal = new KualiDecimal("0.00");
        KualiDecimal testSYSPRplus1orMoretotal = new KualiDecimal("0.00");
        List searchResults = this.cut.getSearchResults(this.fieldValues);
        Assert.assertNotNull((String)"search results not null", (Object)searchResults);
        for (Object result : searchResults) {
            ContractsAndGrantsAgingReport detail = (ContractsAndGrantsAgingReport)result;
            test0to30total = (KualiDecimal)test0to30total.add((AbstractKualiDecimal)detail.getUnpaidBalance0to30());
            test31to60total = (KualiDecimal)test31to60total.add((AbstractKualiDecimal)detail.getUnpaidBalance31to60());
            test61to90total = (KualiDecimal)test61to90total.add((AbstractKualiDecimal)detail.getUnpaidBalance61to90());
            test91toSYSPRtotal = (KualiDecimal)test91toSYSPRtotal.add((AbstractKualiDecimal)detail.getUnpaidBalance91toSYSPR());
            testSYSPRplus1orMoretotal = (KualiDecimal)testSYSPRplus1orMoretotal.add((AbstractKualiDecimal)detail.getUnpaidBalanceSYSPRplus1orMore());
        }
        Assert.assertEquals((Object)this.cut.getTotal0to30(), (Object)test0to30total);
        Assert.assertEquals((Object)this.cut.getTotal31to60(), (Object)test31to60total);
        Assert.assertEquals((Object)this.cut.getTotal61to90(), (Object)test61to90total);
        Assert.assertEquals((Object)this.cut.getTotal91toSYSPR(), (Object)test91toSYSPRtotal);
        Assert.assertEquals((Object)this.cut.getTotalSYSPRplus1orMore(), (Object)testSYSPRplus1orMoretotal);
        Assert.assertEquals((long)1L, (long)searchResults.size());
        ContractsAndGrantsAgingReport contractsAndGrantsAgingReport = (ContractsAndGrantsAgingReport)searchResults.get(0);
        Assert.assertEquals((Object)"Processing Organization", (Object)contractsAndGrantsAgingReport.getReportOption());
        Assert.assertEquals((Object)CUSTOMER_NAME, (Object)contractsAndGrantsAgingReport.getCustomerName());
        Assert.assertEquals((Object)CUSTOMER_NUMBER, (Object)contractsAndGrantsAgingReport.getCustomerNumber());
        Assert.assertEquals((Object)"US AIR FORCE", (Object)contractsAndGrantsAgingReport.getReportingName());
        Assert.assertEquals((Object)this.agencyMock.getAgencyNumber(), (Object)contractsAndGrantsAgingReport.getAgencyNumber());
        Assert.assertEquals((Object)new KualiDecimal(800.0), (Object)contractsAndGrantsAgingReport.getUnpaidBalance0to30());
        Assert.assertEquals((Object)new KualiDecimal(0.0), (Object)contractsAndGrantsAgingReport.getUnpaidBalance31to60());
        Assert.assertEquals((Object)new KualiDecimal(0.0), (Object)contractsAndGrantsAgingReport.getUnpaidBalance61to90());
        Assert.assertEquals((Object)new KualiDecimal(0.0), (Object)contractsAndGrantsAgingReport.getUnpaidBalance91toSYSPR());
        Assert.assertEquals((Object)new KualiDecimal(0.0), (Object)contractsAndGrantsAgingReport.getUnpaidBalanceSYSPRplus1orMore());
        Assert.assertEquals((Object)new KualiDecimal(800.0), (Object)contractsAndGrantsAgingReport.getTotalOpenInvoices());
        Assert.assertEquals((Object)new KualiDecimal(0.0), (Object)contractsAndGrantsAgingReport.getTotalCredits());
        Assert.assertEquals((Object)new KualiDecimal(0.0), (Object)contractsAndGrantsAgingReport.getTotalWriteOff());
        Assert.assertEquals((Object)"KFS-AR", (Object)contractsAndGrantsAgingReport.getUserLookupRoleNamespaceCode());
        Assert.assertEquals((Object)"CGB Collector", (Object)contractsAndGrantsAgingReport.getUserLookupRoleName());
    }

    @Test
    public void getSearchResults_NoInvoicesFound() {
        List searchResults = this.cut.getSearchResults(Collections.emptyMap());
        Assert.assertNotNull((String)"search results not null", (Object)searchResults);
        Assert.assertEquals((long)0L, (long)searchResults.size());
    }

    @Test
    public void performLookup() {
        ContractsGrantsAgingReportForm contractsGrantsAgingReportForm = new ContractsGrantsAgingReportForm();
        contractsGrantsAgingReportForm.setFieldsForLookup(this.fieldValues);
        Collection lookupResults = this.cut.performLookup((LookupForm)contractsGrantsAgingReportForm, new ArrayList(), false);
        Assert.assertNotNull((String)"lookup list not null", (Object)lookupResults);
        Assert.assertEquals((long)1L, (long)lookupResults.size());
        ContractsAndGrantsAgingReport contractsAndGrantsAgingReport = (ContractsAndGrantsAgingReport)lookupResults.iterator().next();
        Assert.assertEquals((Object)"Processing Organization", (Object)contractsAndGrantsAgingReport.getReportOption());
        Assert.assertEquals((Object)CUSTOMER_NAME, (Object)contractsAndGrantsAgingReport.getCustomerName());
        Assert.assertEquals((Object)CUSTOMER_NUMBER, (Object)contractsAndGrantsAgingReport.getCustomerNumber());
        Assert.assertEquals((Object)"US AIR FORCE", (Object)contractsAndGrantsAgingReport.getReportingName());
        Assert.assertEquals((Object)this.agencyMock.getAgencyNumber(), (Object)contractsAndGrantsAgingReport.getAgencyNumber());
        Assert.assertEquals((Object)new KualiDecimal(800.0), (Object)contractsAndGrantsAgingReport.getUnpaidBalance0to30());
        Assert.assertEquals((Object)new KualiDecimal(0.0), (Object)contractsAndGrantsAgingReport.getUnpaidBalance31to60());
        Assert.assertEquals((Object)new KualiDecimal(0.0), (Object)contractsAndGrantsAgingReport.getUnpaidBalance61to90());
        Assert.assertEquals((Object)new KualiDecimal(0.0), (Object)contractsAndGrantsAgingReport.getUnpaidBalance91toSYSPR());
        Assert.assertEquals((Object)new KualiDecimal(0.0), (Object)contractsAndGrantsAgingReport.getUnpaidBalanceSYSPRplus1orMore());
        Assert.assertEquals((Object)new KualiDecimal(800.0), (Object)contractsAndGrantsAgingReport.getTotalOpenInvoices());
        Assert.assertEquals((Object)new KualiDecimal(0.0), (Object)contractsAndGrantsAgingReport.getTotalCredits());
        Assert.assertEquals((Object)new KualiDecimal(0.0), (Object)contractsAndGrantsAgingReport.getTotalWriteOff());
        Assert.assertEquals((Object)"KFS-AR", (Object)contractsAndGrantsAgingReport.getUserLookupRoleNamespaceCode());
        Assert.assertEquals((Object)"CGB Collector", (Object)contractsAndGrantsAgingReport.getUserLookupRoleName());
    }

    @Test
    public void performLookup_NoInvoicesFound() {
        ContractsGrantsAgingReportForm contractsGrantsAgingReportForm = new ContractsGrantsAgingReportForm();
        contractsGrantsAgingReportForm.setFieldsForLookup(Collections.emptyMap());
        Collection lookupResults = this.cut.performLookup((LookupForm)contractsGrantsAgingReportForm, new ArrayList(), false);
        Assert.assertNotNull((String)"lookup list not null", (Object)lookupResults);
        Assert.assertEquals((long)0L, (long)lookupResults.size());
    }
}

