/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.runner.RunWith;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentHeaderService;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.module.ar.businessobject.CashControlDetail;
import org.kuali.kfs.module.ar.document.CashControlDocument;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.kuali.kfs.sys.businessobject.UniversityDate;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.BankService;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={KRADServiceLocatorWeb.class, SpringContext.class})
@Execution(value=ExecutionMode.SAME_THREAD)
public class CashControlDocumentTest {
    private static final KualiDecimal AMOUNT_100 = new KualiDecimal(100);
    private static final KualiDecimal AMOUNT_300 = new KualiDecimal(300);
    private CashControlDocument cut;
    @Mock
    private BankService bankSvcMock;
    @Mock
    private BusinessObjectService businessObjectSvcMock;
    @Mock
    private UniversityDateService universityDateSvcMock;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        PowerMockito.mockStatic(KRADServiceLocatorWeb.class, (Class[])new Class[0]);
        DocumentHeaderService docHeaderSvcMock = (DocumentHeaderService)Mockito.mock(DocumentHeaderService.class);
        Mockito.when((Object)KRADServiceLocatorWeb.getDocumentHeaderService()).thenReturn((Object)docHeaderSvcMock);
        Class<FinancialSystemDocumentHeader> clazz = FinancialSystemDocumentHeader.class;
        Mockito.when((Object)docHeaderSvcMock.getDocumentHeaderBaseClass()).thenReturn(clazz);
        Mockito.when((Object)this.universityDateSvcMock.getCurrentUniversityDate()).thenReturn((Object)new UniversityDate());
        PowerMockito.mockStatic(SpringContext.class, (Class[])new Class[0]);
        Mockito.when((Object)((UniversityDateService)SpringContext.getBean(UniversityDateService.class))).thenReturn((Object)this.universityDateSvcMock);
        Mockito.when((Object)((BankService)SpringContext.getBean(BankService.class))).thenReturn((Object)this.bankSvcMock);
        this.cut = new CashControlDocument();
        this.cut.setBusinessObjectService(this.businessObjectSvcMock);
    }

    @Test
    public void cancelCashControlDetail_singleDetail() {
        ArrayList<CashControlDetail> cashControlDetails = new ArrayList<CashControlDetail>();
        cashControlDetails.add(this.setupCashControlDetail(AMOUNT_100));
        this.cut.setCashControlDetails(cashControlDetails);
        this.cut.setCashControlTotalAmount(AMOUNT_100);
        this.cut.cancelCashControlDetail(0);
        List updatedCashControlDetails = this.cut.getCashControlDetails();
        Assert.assertEquals((long)1L, (long)updatedCashControlDetails.size());
        Assert.assertEquals((Object)KualiDecimal.ZERO, (Object)((CashControlDetail)updatedCashControlDetails.get(0)).getFinancialDocumentLineAmount());
        Assert.assertEquals((Object)KualiDecimal.ZERO, (Object)this.cut.getCashControlTotalAmount());
    }

    private CashControlDetail setupCashControlDetail(KualiDecimal amount) {
        CashControlDetail cashControlDetail = new CashControlDetail();
        cashControlDetail.setFinancialDocumentLineAmount(amount);
        return cashControlDetail;
    }

    @Test
    public void cancelCashControlDetail_firstDetail() {
        ArrayList<CashControlDetail> cashControlDetails = new ArrayList<CashControlDetail>();
        cashControlDetails.add(this.setupCashControlDetail(AMOUNT_100));
        cashControlDetails.add(this.setupCashControlDetail(AMOUNT_300));
        this.cut.setCashControlDetails(cashControlDetails);
        this.cut.setCashControlTotalAmount((KualiDecimal)AMOUNT_100.add((AbstractKualiDecimal)AMOUNT_300));
        this.cut.cancelCashControlDetail(0);
        List updatedCashControlDetails = this.cut.getCashControlDetails();
        Assert.assertEquals((long)2L, (long)updatedCashControlDetails.size());
        Assert.assertEquals((Object)KualiDecimal.ZERO, (Object)((CashControlDetail)updatedCashControlDetails.get(0)).getFinancialDocumentLineAmount());
        Assert.assertEquals((Object)AMOUNT_300, (Object)((CashControlDetail)updatedCashControlDetails.get(1)).getFinancialDocumentLineAmount());
        Assert.assertEquals((Object)AMOUNT_300, (Object)this.cut.getCashControlTotalAmount());
    }

    @Test
    public void cancelCashControlDetail_secondDetail() {
        ArrayList<CashControlDetail> cashControlDetails = new ArrayList<CashControlDetail>();
        cashControlDetails.add(this.setupCashControlDetail(AMOUNT_100));
        cashControlDetails.add(this.setupCashControlDetail(AMOUNT_300));
        this.cut.setCashControlDetails(cashControlDetails);
        this.cut.setCashControlTotalAmount((KualiDecimal)AMOUNT_100.add((AbstractKualiDecimal)AMOUNT_300));
        this.cut.cancelCashControlDetail(1);
        List updatedCashControlDetails = this.cut.getCashControlDetails();
        Assert.assertEquals((long)2L, (long)updatedCashControlDetails.size());
        Assert.assertEquals((Object)AMOUNT_100, (Object)((CashControlDetail)updatedCashControlDetails.get(0)).getFinancialDocumentLineAmount());
        Assert.assertEquals((Object)KualiDecimal.ZERO, (Object)((CashControlDetail)updatedCashControlDetails.get(1)).getFinancialDocumentLineAmount());
        Assert.assertEquals((Object)AMOUNT_100, (Object)this.cut.getCashControlTotalAmount());
    }
}

