/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.kfs.krad.service.DocumentHeaderService;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.module.ar.document.PaymentApplicationAdjustmentDocument;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={KRADServiceLocatorWeb.class})
public class PaymentApplicationAdjustmentDocumentTest {
    private PaymentApplicationAdjustmentDocument cut;

    @Before
    public void setUp() throws Exception {
        DocumentHeaderService docHeaderSvcMock = (DocumentHeaderService)Mockito.mock(DocumentHeaderService.class);
        Class<FinancialSystemDocumentHeader> clazz = FinancialSystemDocumentHeader.class;
        Mockito.when((Object)docHeaderSvcMock.getDocumentHeaderBaseClass()).thenReturn(clazz);
        PowerMockito.mockStatic(KRADServiceLocatorWeb.class, (Class[])new Class[0]);
        Mockito.when((Object)KRADServiceLocatorWeb.getDocumentHeaderService()).thenReturn((Object)docHeaderSvcMock);
        this.cut = new PaymentApplicationAdjustmentDocument();
    }

    @Test(expected=IllegalArgumentException.class)
    public void setter_illegalArg_null() {
        this.cut.setAdjusteeId(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void setter_illegalArg_empty() {
        this.cut.setAdjusteeId("");
    }

    @Test(expected=IllegalArgumentException.class)
    public void setter_illegalArg_blank() {
        this.cut.setAdjusteeId("    ");
    }

    @Test
    public void setter_validArg() {
        String adjusteeId = "ABC123";
        this.cut.setAdjusteeId("ABC123");
        Assert.assertEquals((Object)"ABC123", (Object)this.cut.getAdjusteeId());
    }
}

