/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.service;

import java.math.BigDecimal;
import org.kuali.kfs.module.ar.businessobject.CustomerCreditMemoDetail;
import org.kuali.kfs.module.ar.document.CustomerCreditMemoDocument;
import org.kuali.kfs.module.ar.document.service.CustomerCreditMemoDetailService;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDocumentIntegTestUtil;
import org.kuali.kfs.module.ar.fixture.CustomerInvoiceDetailFixture;
import org.kuali.kfs.module.ar.fixture.CustomerInvoiceDocumentFixture;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiIntegTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

@ConfigureContext(session=UserNameFixture.khuntley)
public class CustomerCreditMemoDetailServiceIntegTest
extends KualiIntegTestBase {
    private CustomerCreditMemoDetailService service;
    private CustomerCreditMemoDocument document;
    private CustomerCreditMemoDetail detail;
    private KualiDecimal testAmount;

    protected void setUp() throws Exception {
        super.setUp();
        this.service = (CustomerCreditMemoDetailService)SpringContext.getBean(CustomerCreditMemoDetailService.class);
        String documentNumber = CustomerInvoiceDocumentIntegTestUtil.submitNewCustomerInvoiceDocument(CustomerInvoiceDocumentFixture.BASE_CIDOC_WITH_CUSTOMER, new CustomerInvoiceDetailFixture[]{CustomerInvoiceDetailFixture.CUSTOMER_INVOICE_DETAIL_CHART_RECEIVABLE});
        this.document = new CustomerCreditMemoDocument();
        this.document.setFinancialDocumentReferenceInvoiceNumber(documentNumber);
        this.document.getInvoice();
        this.detail = new CustomerCreditMemoDetail();
        this.detail.setReferenceInvoiceItemNumber(Integer.valueOf(1));
        this.detail.setFinancialDocumentReferenceInvoiceNumber(documentNumber);
        this.testAmount = new KualiDecimal(0.5);
    }

    protected void tearDown() throws Exception {
        this.service = null;
        this.document = null;
        this.detail = null;
        this.testAmount = null;
        super.tearDown();
    }

    public void testRecalculateCustomerCreditMemoDetail_Quantity() {
        this.detail.setCreditMemoItemQuantity(new BigDecimal(0.5));
        CustomerCreditMemoDetailServiceIntegTest.assertEquals((Object)this.detail.getCreditMemoItemQuantity(), (Object)new BigDecimal(0.5));
        this.service.recalculateCustomerCreditMemoDetail(this.detail, this.document);
        CustomerCreditMemoDetailServiceIntegTest.assertEquals((int)0, (int)this.detail.getCreditMemoItemTotalAmount().compareTo((AbstractKualiDecimal)this.testAmount));
        CustomerCreditMemoDetailServiceIntegTest.assertEquals((Object)this.detail.getCreditMemoItemTaxAmount(), (Object)KualiDecimal.ZERO);
        CustomerCreditMemoDetailServiceIntegTest.assertEquals((Object)this.detail.getCreditMemoLineTotalAmount(), (Object)this.testAmount);
        CustomerCreditMemoDetailServiceIntegTest.assertFalse((boolean)this.detail.getCreditMemoItemTaxAmount().isPositive());
        CustomerCreditMemoDetailServiceIntegTest.assertEquals((Object)this.detail.getCreditMemoItemTotalAmount(), (Object)this.testAmount);
        CustomerCreditMemoDetailServiceIntegTest.assertEquals((Object)this.detail.getCreditMemoLineTotalAmount(), (Object)this.testAmount);
    }

    public void testRecalculateCustomerCreditMemoDetail_ItemAmount() {
        this.detail.setCreditMemoItemTotalAmount(this.testAmount);
        CustomerCreditMemoDetailServiceIntegTest.assertEquals((Object)this.detail.getCreditMemoItemTotalAmount(), (Object)this.testAmount);
        this.service.recalculateCustomerCreditMemoDetail(this.detail, this.document);
        CustomerCreditMemoDetailServiceIntegTest.assertEquals((int)0, (int)this.detail.getCreditMemoItemQuantity().compareTo(new BigDecimal(0.5)));
        CustomerCreditMemoDetailServiceIntegTest.assertEquals((Object)this.detail.getCreditMemoItemTaxAmount(), (Object)KualiDecimal.ZERO);
        CustomerCreditMemoDetailServiceIntegTest.assertEquals((Object)this.detail.getCreditMemoLineTotalAmount(), (Object)this.testAmount);
        CustomerCreditMemoDetailServiceIntegTest.assertFalse((boolean)this.detail.getCreditMemoItemTaxAmount().isPositive());
        CustomerCreditMemoDetailServiceIntegTest.assertEquals((Object)this.detail.getCreditMemoItemTotalAmount(), (Object)this.testAmount);
        CustomerCreditMemoDetailServiceIntegTest.assertEquals((Object)this.detail.getCreditMemoLineTotalAmount(), (Object)this.testAmount);
    }
}

