/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.service;

import java.util.HashMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.runner.RunWith;
import org.kuali.kfs.coa.service.AccountService;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceItemCode;
import org.kuali.kfs.module.ar.businessobject.OrganizationAccountingDefault;
import org.kuali.kfs.module.ar.document.service.impl.CustomerInvoiceDetailServiceImpl;
import org.kuali.kfs.module.ar.fixture.CustomerInvoiceItemCodeFixture;
import org.kuali.kfs.module.ar.fixture.OrganizationAccountingDefaultFixture;
import org.kuali.kfs.sys.context.SpringContext;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={SpringContext.class})
@Execution(value=ExecutionMode.SAME_THREAD)
public class CustomerInvoiceDetailServiceTest {
    private CustomerInvoiceDetailServiceImpl cut;
    @Mock
    private AccountService accountSvcMock;
    @Mock
    private BusinessObjectService businessObjectSvcMock;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        PowerMockito.mockStatic(SpringContext.class, (Class[])new Class[0]);
        Mockito.when((Object)((AccountService)SpringContext.getBean(AccountService.class))).thenReturn((Object)this.accountSvcMock);
        CustomerInvoiceItemCode customerInvoiceItemCode = CustomerInvoiceItemCodeFixture.BASE_CIIC.createCustomerInvoiceItemCode();
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("invoiceItemCode", customerInvoiceItemCode.getInvoiceItemCode());
        criteria.put("chartOfAccountsCode", customerInvoiceItemCode.getChartOfAccountsCode());
        criteria.put("organizationCode", customerInvoiceItemCode.getOrganizationCode());
        Mockito.when((Object)((CustomerInvoiceItemCode)this.businessObjectSvcMock.findByPrimaryKey(CustomerInvoiceItemCode.class, criteria))).thenReturn((Object)customerInvoiceItemCode);
        OrganizationAccountingDefault orgAcctDefault = OrganizationAccountingDefaultFixture.BASE_OAD.createOrganizationAccountingDefault();
        HashMap<String, Object> criteria2 = new HashMap<String, Object>();
        criteria2.put("universityFiscalYear", orgAcctDefault.getUniversityFiscalYear());
        criteria2.put("chartOfAccountsCode", orgAcctDefault.getChartOfAccountsCode());
        criteria2.put("organizationCode", orgAcctDefault.getOrganizationCode());
        Mockito.when((Object)((OrganizationAccountingDefault)this.businessObjectSvcMock.findByPrimaryKey(OrganizationAccountingDefault.class, criteria2))).thenReturn((Object)orgAcctDefault);
        this.cut = new CustomerInvoiceDetailServiceImpl();
        this.cut.setBusinessObjectService(this.businessObjectSvcMock);
    }

    @Test
    public void getCustomerInvoiceDetailFromCustomerInvoiceItemCode() {
        CustomerInvoiceDetail customerInvoiceDetail = this.cut.getCustomerInvoiceDetailFromCustomerInvoiceItemCode(CustomerInvoiceItemCodeFixture.BASE_CIIC.invoiceItemCode, CustomerInvoiceItemCodeFixture.BASE_CIIC.chartOfAccountsCode, CustomerInvoiceItemCodeFixture.BASE_CIIC.organizationCode);
        Assert.assertEquals((Object)CustomerInvoiceItemCodeFixture.BASE_CIIC.defaultInvoiceChartOfAccountsCode, (Object)customerInvoiceDetail.getChartOfAccountsCode());
        Assert.assertEquals((Object)CustomerInvoiceItemCodeFixture.BASE_CIIC.defaultInvoiceAccountNumber, (Object)customerInvoiceDetail.getAccountNumber());
        Assert.assertEquals((Object)CustomerInvoiceItemCodeFixture.BASE_CIIC.defaultInvoiceFinancialObjectCode, (Object)customerInvoiceDetail.getFinancialObjectCode());
    }

    @Test
    public void getCustomerInvoiceDetailFromOrganizationAccountingDefault() {
        CustomerInvoiceDetail customerInvoiceDetail = this.cut.getCustomerInvoiceDetailFromOrganizationAccountingDefault(OrganizationAccountingDefaultFixture.BASE_OAD.universityFiscalYear, OrganizationAccountingDefaultFixture.BASE_OAD.chartOfAccountsCode, OrganizationAccountingDefaultFixture.BASE_OAD.organizationCode);
        Assert.assertEquals((Object)OrganizationAccountingDefaultFixture.BASE_OAD.defaultInvoiceChartOfAccountsCode, (Object)customerInvoiceDetail.getChartOfAccountsCode());
        Assert.assertEquals((Object)OrganizationAccountingDefaultFixture.BASE_OAD.defaultInvoiceAccountNumber, (Object)customerInvoiceDetail.getAccountNumber());
        Assert.assertEquals((Object)OrganizationAccountingDefaultFixture.BASE_OAD.defaultInvoiceFinancialObjectCode, (Object)customerInvoiceDetail.getFinancialObjectCode());
    }
}

