/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kuali.kfs.coa.businessobject.AccountingPeriod;
import org.kuali.kfs.module.ar.businessobject.InvoicePaidApplied;
import org.kuali.kfs.module.ar.businessobject.NonAppliedHolding;
import org.kuali.kfs.module.ar.document.PaymentApplicationAdjustmentDocument;
import org.kuali.kfs.module.ar.document.service.impl.PaymentApplicationAdjustmentDocumentService;
import org.kuali.kfs.module.ar.rest.resource.requests.PaymentApplicationAdjustmentRequest;
import org.kuali.kfs.sys.businessobject.UniversityDate;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

class PaymentApplicationAdjustmentDocumentServiceTest {
    @Mock
    PaymentApplicationAdjustmentDocument appaDocMock;
    @Mock
    UniversityDateService universityDateServiceMock;
    PaymentApplicationAdjustmentDocumentService cut = new PaymentApplicationAdjustmentDocumentService();

    PaymentApplicationAdjustmentDocumentServiceTest() {
    }

    @BeforeEach
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void updateNonAppliedHoldings_matchingCustomerNumber_updatesAmount() {
        String matchingCustomerNumber = "123";
        NonAppliedHolding matchingNonAppliedHolding = new NonAppliedHolding();
        matchingNonAppliedHolding.setCustomerNumber("123");
        matchingNonAppliedHolding.setFinancialDocumentLineAmount(new KualiDecimal(1000));
        Mockito.when((Object)this.appaDocMock.getNonAppliedHoldings()).thenReturn(List.of(matchingNonAppliedHolding));
        PaymentApplicationAdjustmentRequest.NonAppliedHolding nonAppliedHolding = new PaymentApplicationAdjustmentRequest.NonAppliedHolding(new KualiDecimal(3000), "123");
        this.cut.updateNonAppliedHoldings(this.appaDocMock, List.of(nonAppliedHolding));
        Assertions.assertEquals((Object)nonAppliedHolding.getAmount(), (Object)matchingNonAppliedHolding.getFinancialDocumentLineAmount());
    }

    @Test
    public void updateNonAppliedHoldings_noMatchingCustomerNumber_doesNotUpdateAmount() {
        NonAppliedHolding matchingNonAppliedHolding = new NonAppliedHolding();
        matchingNonAppliedHolding.setCustomerNumber("999");
        matchingNonAppliedHolding.setFinancialDocumentLineAmount(new KualiDecimal(1000));
        List<NonAppliedHolding> holdings = List.of(matchingNonAppliedHolding);
        Mockito.when((Object)this.appaDocMock.getNonAppliedHoldings()).thenReturn(holdings);
        PaymentApplicationAdjustmentRequest.NonAppliedHolding nonAppliedHolding = new PaymentApplicationAdjustmentRequest.NonAppliedHolding(new KualiDecimal(3000), "888");
        this.cut.updateNonAppliedHoldings(this.appaDocMock, List.of(nonAppliedHolding));
        Assertions.assertEquals((Object)new KualiDecimal(1000), (Object)matchingNonAppliedHolding.getFinancialDocumentLineAmount());
    }

    @Test
    public void updateInvoicePaidApplieds_matchingInvoiceAndSequence_updatesAmount() {
        String documentNumber = "123";
        String refDocNumber = "456";
        int sequenceNumber = 10;
        InvoicePaidApplied matchingInvoicePaidApplied = new InvoicePaidApplied("123", "456", Integer.valueOf(10), new KualiDecimal(1000), Integer.valueOf(0), Integer.valueOf(2000), "A");
        Mockito.when((Object)this.appaDocMock.getInvoicePaidApplieds()).thenReturn(Arrays.asList(matchingInvoicePaidApplied));
        PaymentApplicationAdjustmentRequest.InvoiceApplicationDetail invoiceDetail = new PaymentApplicationAdjustmentRequest.InvoiceApplicationDetail(new KualiDecimal(2000), Integer.valueOf(10));
        PaymentApplicationAdjustmentRequest.InvoiceApplication invoiceApplication = new PaymentApplicationAdjustmentRequest.InvoiceApplication("A", "456", List.of(invoiceDetail));
        this.cut.updateInvoicePaidApplieds(this.appaDocMock, List.of(invoiceApplication));
        Assertions.assertEquals((Object)invoiceDetail.getAmountApplied(), (Object)matchingInvoicePaidApplied.getInvoiceItemAppliedAmount());
    }

    @Test
    public void updateInvoicePaidApplieds_noMatchingInvoice_createsNewInvoiceApplied() {
        String documentNumber = "123";
        String refDocNumber = "456";
        int sequenceNumber = 10;
        InvoicePaidApplied matchingInvoicePaidApplied = new InvoicePaidApplied("123", "456", Integer.valueOf(10), new KualiDecimal(1000), Integer.valueOf(0), Integer.valueOf(2000), "A");
        ArrayList<InvoicePaidApplied> invoicePaidApplieds = new ArrayList<InvoicePaidApplied>(List.of(matchingInvoicePaidApplied));
        Mockito.when((Object)this.appaDocMock.getInvoicePaidApplieds()).thenReturn(invoicePaidApplieds);
        Mockito.when((Object)this.appaDocMock.getDocumentNumber()).thenReturn((Object)"123");
        PaymentApplicationAdjustmentRequest.InvoiceApplicationDetail invoiceDetail = new PaymentApplicationAdjustmentRequest.InvoiceApplicationDetail(new KualiDecimal(2000), Integer.valueOf(11));
        PaymentApplicationAdjustmentRequest.InvoiceApplication invoiceApplication = new PaymentApplicationAdjustmentRequest.InvoiceApplication("A", "456", List.of(invoiceDetail));
        this.mockUniversityDateService();
        this.cut.setUniversityDateService(this.universityDateServiceMock);
        this.cut.updateInvoicePaidApplieds(this.appaDocMock, List.of(invoiceApplication));
        Assertions.assertEquals((Object)new KualiDecimal(1000), (Object)matchingInvoicePaidApplied.getInvoiceItemAppliedAmount());
        Assertions.assertEquals((int)2, (int)invoicePaidApplieds.size());
        InvoicePaidApplied newlyAddedInvoicePaidApplied = invoicePaidApplieds.stream().filter(invoicePaidApplied -> invoicePaidApplied.getInvoiceItemNumber().equals(invoiceDetail.getSequenceNumber())).findFirst().orElse(null);
        Assertions.assertEquals((Object)invoiceDetail.getAmountApplied(), (Object)newlyAddedInvoicePaidApplied.getInvoiceItemAppliedAmount());
        Assertions.assertEquals((Object)"123", (Object)newlyAddedInvoicePaidApplied.getDocumentNumber());
        Assertions.assertEquals((Object)"456", (Object)newlyAddedInvoicePaidApplied.getFinancialDocumentReferenceInvoiceNumber());
        Assertions.assertEquals((Integer)invoiceDetail.getSequenceNumber(), (Integer)newlyAddedInvoicePaidApplied.getInvoiceItemNumber());
        Assertions.assertEquals((Integer)this.universityDateServiceMock.getCurrentFiscalYear(), (Integer)newlyAddedInvoicePaidApplied.getUniversityFiscalYear());
        Assertions.assertEquals((Object)this.universityDateServiceMock.getCurrentUniversityDate().getAccountingPeriod().getUniversityFiscalPeriodCode(), (Object)newlyAddedInvoicePaidApplied.getUniversityFiscalPeriodCode());
    }

    @Test
    public void updateInvoicePaidApplieds_invoiceOmitted_deletesPaidApplied() {
        InvoicePaidApplied invoicePaidApplied = new InvoicePaidApplied("123", "456", Integer.valueOf(10), new KualiDecimal(1000), Integer.valueOf(0), Integer.valueOf(2000), "A");
        Mockito.when((Object)this.appaDocMock.getInvoicePaidApplieds()).thenReturn(new ArrayList<InvoicePaidApplied>(List.of(invoicePaidApplied)));
        this.cut.updateInvoicePaidApplieds(this.appaDocMock, Collections.emptyList());
        Assertions.assertTrue((boolean)this.appaDocMock.getInvoicePaidApplieds().isEmpty());
    }

    private void mockUniversityDateService() {
        Mockito.when((Object)this.universityDateServiceMock.getCurrentFiscalYear()).thenReturn((Object)1000);
        UniversityDate universityDateMock = (UniversityDate)Mockito.mock(UniversityDate.class);
        Mockito.when((Object)this.universityDateServiceMock.getCurrentUniversityDate()).thenReturn((Object)universityDateMock);
        AccountingPeriod accountingPeriodMock = (AccountingPeriod)Mockito.mock(AccountingPeriod.class);
        Mockito.when((Object)universityDateMock.getAccountingPeriod()).thenReturn((Object)accountingPeriodMock);
        Mockito.when((Object)accountingPeriodMock.getUniversityFiscalPeriodCode()).thenReturn((Object)"ABC");
    }
}

