/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.InvoiceAddressDetail;
import org.kuali.kfs.module.ar.businessobject.InvoiceGeneralDetail;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.validation.impl.ContractsGrantsInvoiceDocumentValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.sys.document.validation.event.AttributedRouteDocumentEvent;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

class ContractsGrantsInvoiceDocumentValidationTest {
    private static final String STD_INVOICE_TEMPLATE = "STD";
    private ContractsGrantsInvoiceDocumentValidation cut;
    @Mock
    private ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock;
    @Mock
    private InvoiceAddressDetail invoiceAddressDetailMock;
    @Mock
    private InvoiceGeneralDetail invoiceGeneralDetailMock;

    ContractsGrantsInvoiceDocumentValidationTest() {
    }

    @BeforeEach
    void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        GlobalVariables.getMessageMap().clearErrorMessages();
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getInvoiceAddressDetails()).thenReturn(Collections.singletonList(this.invoiceAddressDetailMock));
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail()).thenReturn((Object)this.invoiceGeneralDetailMock);
        this.cut = new ContractsGrantsInvoiceDocumentValidation();
        this.cut.setContractsGrantsInvoiceDocument(this.contractsGrantsInvoiceDocumentMock);
    }

    @Test
    void validate_HasOneTransmissionDetailToSend_HasTemplate_VALID() {
        Mockito.when((Object)this.invoiceAddressDetailMock.isSendIndicator()).thenReturn((Object)true);
        Mockito.when((Object)this.invoiceGeneralDetailMock.getCustomerInvoiceTemplateCode()).thenReturn((Object)STD_INVOICE_TEMPLATE);
        Assertions.assertTrue((boolean)this.cut.validate(null));
    }

    @Test
    void validate_HasOneTransmissionQueued_HasTemplate_VALID() {
        Mockito.when((Object)this.invoiceAddressDetailMock.isQueued()).thenReturn((Object)true);
        Mockito.when((Object)this.invoiceGeneralDetailMock.getCustomerInvoiceTemplateCode()).thenReturn((Object)STD_INVOICE_TEMPLATE);
        Assertions.assertTrue((boolean)this.cut.validate(null));
    }

    @Test
    void validate_HasOneTransmissionSent_HasTemplate_VALID() {
        Mockito.when((Object)this.invoiceAddressDetailMock.isSent()).thenReturn((Object)true);
        Mockito.when((Object)this.invoiceGeneralDetailMock.getCustomerInvoiceTemplateCode()).thenReturn((Object)STD_INVOICE_TEMPLATE);
        Assertions.assertTrue((boolean)this.cut.validate(null));
    }

    @Test
    void validate_HasNoneQueuedSentOrToSend_HasTemplate_INVALID() {
        Mockito.when((Object)this.invoiceGeneralDetailMock.getCustomerInvoiceTemplateCode()).thenReturn((Object)STD_INVOICE_TEMPLATE);
        Assertions.assertFalse((boolean)this.cut.validate(null));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("document.invoiceAddressDetails[0].sendIndicator");
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assertions.assertEquals((Object)"error.one.transmission.detail.queue.required", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)0, (int)errorMessage.getMessageParameters().length);
    }

    @Test
    void validate_HasNoneQueuedSentOrToSend_HasTemplate_CorrectionDoc_VALID() {
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.isCorrectionDocument()).thenReturn((Object)true);
        Mockito.when((Object)this.invoiceGeneralDetailMock.getCustomerInvoiceTemplateCode()).thenReturn((Object)STD_INVOICE_TEMPLATE);
        Assertions.assertTrue((boolean)this.cut.validate(null));
    }

    @Test
    void validate_HasOneTransmissionDetailToSend_NoTemplate_INVALID() {
        Mockito.when((Object)this.invoiceAddressDetailMock.isSendIndicator()).thenReturn((Object)true);
        Assertions.assertFalse((boolean)this.cut.validate(null));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("document.invoiceGeneralDetail.customerInvoiceTemplateCode");
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assertions.assertEquals((Object)"error.document.contractsGrantsInvoice.template.code.required", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)0, (int)errorMessage.getMessageParameters().length);
    }

    @Test
    void validate_HasOneTransmissionDetailToSend_NoTemplate_CorrectionDoc_VALID() {
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.isCorrectionDocument()).thenReturn((Object)true);
        Mockito.when((Object)this.invoiceAddressDetailMock.isSendIndicator()).thenReturn((Object)true);
        Assertions.assertTrue((boolean)this.cut.validate(null));
    }

    @Test
    void validate_RouteEvent_NoAccountingLines_VALID() {
        Mockito.when((Object)this.invoiceAddressDetailMock.isSendIndicator()).thenReturn((Object)true);
        Mockito.when((Object)this.invoiceGeneralDetailMock.getCustomerInvoiceTemplateCode()).thenReturn((Object)STD_INVOICE_TEMPLATE);
        Assertions.assertTrue((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedRouteDocumentEvent((Document)this.contractsGrantsInvoiceDocumentMock)));
    }

    @Test
    void validate_RouteEvent_NoIncomeObjectCode_INVALID() {
        Mockito.when((Object)this.invoiceAddressDetailMock.isSendIndicator()).thenReturn((Object)true);
        Mockito.when((Object)this.invoiceGeneralDetailMock.getCustomerInvoiceTemplateCode()).thenReturn((Object)STD_INVOICE_TEMPLATE);
        CustomerInvoiceDetail customerInvoiceDetail = new CustomerInvoiceDetail();
        customerInvoiceDetail.setAccountsReceivableObjectCode("8118");
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getSourceAccountingLines()).thenReturn(Collections.singletonList(customerInvoiceDetail));
        Assertions.assertFalse((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedRouteDocumentEvent((Document)this.contractsGrantsInvoiceDocumentMock)));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        GlobalVariables.getMessageMap().containsMessageKey("error.contracts.grants.invoice.submission.missing.cgbi.object.code");
    }

    @Test
    void validate_RouteEvent_NoReceivableObjectCode_INVALID() {
        Mockito.when((Object)this.invoiceAddressDetailMock.isSendIndicator()).thenReturn((Object)true);
        Mockito.when((Object)this.invoiceGeneralDetailMock.getCustomerInvoiceTemplateCode()).thenReturn((Object)STD_INVOICE_TEMPLATE);
        CustomerInvoiceDetail customerInvoiceDetail = new CustomerInvoiceDetail();
        customerInvoiceDetail.setFinancialObjectCode("5000");
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getSourceAccountingLines()).thenReturn(Collections.singletonList(customerInvoiceDetail));
        Assertions.assertFalse((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedRouteDocumentEvent((Document)this.contractsGrantsInvoiceDocumentMock)));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        GlobalVariables.getMessageMap().containsMessageKey("error.contracts.grants.invoice.submission.missing.cgbi.object.code");
    }

    @Test
    void validate_HasIncomeAndReceivableObjectCodes_VALID() {
        Mockito.when((Object)this.invoiceAddressDetailMock.isSendIndicator()).thenReturn((Object)true);
        Mockito.when((Object)this.invoiceGeneralDetailMock.getCustomerInvoiceTemplateCode()).thenReturn((Object)STD_INVOICE_TEMPLATE);
        CustomerInvoiceDetail customerInvoiceDetail = new CustomerInvoiceDetail();
        customerInvoiceDetail.setFinancialObjectCode("5000");
        customerInvoiceDetail.setAccountsReceivableObjectCode("8118");
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getSourceAccountingLines()).thenReturn(Collections.singletonList(customerInvoiceDetail));
        Assertions.assertTrue((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedRouteDocumentEvent((Document)this.contractsGrantsInvoiceDocumentMock)));
    }
}

