/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.businessobject.CustomerCreditMemoDetail;
import org.kuali.kfs.module.ar.document.CustomerCreditMemoDocument;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDocumentService;
import org.kuali.kfs.module.ar.document.validation.impl.CustomerCreditMemoDocumentRule;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

class CustomerCreditMemoDocumentRuleTest {
    private static final String INVOICE_DOCUMENT_NUMBER = "KLM0456";
    private static final String PRINCIPAL_ID = "khuntley";
    @Mock
    private BusinessObjectService businessObjectSvcMock;
    @Mock
    private CustomerInvoiceDocument customerInvoiceDocumentMock;
    @Mock
    private CustomerInvoiceDocumentService customerInvoiceDocumentSvcMock;
    private CustomerCreditMemoDocumentRule cutSpy;

    CustomerCreditMemoDocumentRuleTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.cutSpy = (CustomerCreditMemoDocumentRule)Mockito.spy((Object)new CustomerCreditMemoDocumentRule());
        UserSession userSessionMock = (UserSession)Mockito.mock(UserSession.class);
        Mockito.when((Object)userSessionMock.getPrincipalId()).thenReturn((Object)PRINCIPAL_ID);
        ((CustomerCreditMemoDocumentRule)Mockito.doReturn((Object)userSessionMock).when((Object)this.cutSpy)).getUserSession();
        GlobalVariables.getMessageMap().clearErrorMessages();
        this.cutSpy.setBusinessObjectService(this.businessObjectSvcMock);
        this.cutSpy.setCustomerInvoiceDocumentService(this.customerInvoiceDocumentSvcMock);
    }

    @Test
    void isQtyOrItemAmountEntered_EmptyString_True() {
        CustomerCreditMemoDetail detail = new CustomerCreditMemoDetail();
        Assertions.assertEquals((Object)"", (Object)this.cutSpy.isQtyOrItemAmountEntered(detail));
    }

    @Test
    void isQtyOrItemAmountEntered_OnlyQty_True() {
        CustomerCreditMemoDetail detail = new CustomerCreditMemoDetail();
        detail.setCreditMemoItemQuantity(new BigDecimal(1));
        Assertions.assertEquals((Object)"qty", (Object)this.cutSpy.isQtyOrItemAmountEntered(detail));
    }

    @Test
    void isQtyOrItemAmountEntered_OnlyAmount_True() {
        CustomerCreditMemoDetail detail = new CustomerCreditMemoDetail();
        detail.setCreditMemoItemTotalAmount(new KualiDecimal(1));
        Assertions.assertEquals((Object)"itemAmount", (Object)this.cutSpy.isQtyOrItemAmountEntered(detail));
    }

    @Test
    void isQtyOrItemAmountEntered_AmountAndQty_True() {
        CustomerCreditMemoDetail detail = new CustomerCreditMemoDetail();
        detail.setCreditMemoItemTotalAmount(new KualiDecimal(1));
        detail.setCreditMemoItemQuantity(new BigDecimal(1));
        Assertions.assertEquals((Object)"both", (Object)this.cutSpy.isQtyOrItemAmountEntered(detail));
    }

    @Test
    void isValueGreaterThanZero_Valid_True() {
        Assertions.assertTrue((boolean)this.cutSpy.isValueGreaterThanZero(BigDecimal.ONE));
    }

    @Test
    void isValueGreaterThanZero_Zero_False() {
        Assertions.assertFalse((boolean)this.cutSpy.isValueGreaterThanZero(BigDecimal.ZERO));
    }

    @Test
    void tisValueGreaterThanZero_ValidKualiDecimal_True() {
        Assertions.assertTrue((boolean)this.cutSpy.isValueGreaterThanZero(new KualiDecimal(1)));
    }

    @Test
    void isValueGreaterThanZero_ZeroKualiDecimal_False() {
        Assertions.assertFalse((boolean)this.cutSpy.isValueGreaterThanZero(KualiDecimal.ZERO));
    }

    @Test
    void isCustomerCreditMemoItemAmountLessThanEqualToInvoiceOpenItemAmount_AmountEqual_True() {
        CustomerCreditMemoDetail detail = new CustomerCreditMemoDetail();
        detail.setInvoiceOpenItemAmount(new KualiDecimal(2));
        detail.setCreditMemoItemTotalAmount(new KualiDecimal(2));
        Assertions.assertTrue((boolean)this.cutSpy.isCustomerCreditMemoItemAmountLessThanEqualToInvoiceOpenItemAmount(detail));
    }

    @Test
    void isCustomerCreditMemoItemAmountLessThanEqualToInvoiceOpenItemAmount_CreditMemoLessThanInvoice_True() {
        CustomerCreditMemoDetail detail = new CustomerCreditMemoDetail();
        detail.setInvoiceOpenItemAmount(new KualiDecimal(2));
        detail.setCreditMemoItemTotalAmount(new KualiDecimal(1));
        Assertions.assertTrue((boolean)this.cutSpy.isCustomerCreditMemoItemAmountLessThanEqualToInvoiceOpenItemAmount(detail));
    }

    @Test
    void isCustomerCreditMemoItemAmountLessThanEqualToInvoiceOpenItemAmount_CreditMemoGreaterThanInvoiceFalse() {
        CustomerCreditMemoDetail detail = new CustomerCreditMemoDetail();
        detail.setInvoiceOpenItemAmount(new KualiDecimal(1));
        detail.setCreditMemoItemTotalAmount(new KualiDecimal(2));
        Assertions.assertFalse((boolean)this.cutSpy.isCustomerCreditMemoItemAmountLessThanEqualToInvoiceOpenItemAmount(detail));
    }

    @Test
    void isCustomerCreditMemoQtyLessThanEqualToInvoiceOpenQty_QtyEqual_True() {
        CustomerCreditMemoDetail detail = new CustomerCreditMemoDetail();
        detail.setInvoiceOpenItemQuantity(new BigDecimal(2));
        detail.setCreditMemoItemQuantity(new BigDecimal(2));
        Assertions.assertTrue((boolean)this.cutSpy.isCustomerCreditMemoQtyLessThanEqualToInvoiceOpenQty(detail));
    }

    @Test
    void isCustomerCreditMemoQtyLessThanEqualToInvoiceOpenQty_CreditMemoLessThanInvoice_True() {
        CustomerCreditMemoDetail detail = new CustomerCreditMemoDetail();
        detail.setInvoiceOpenItemQuantity(new BigDecimal(2));
        detail.setCreditMemoItemQuantity(new BigDecimal(1));
        Assertions.assertTrue((boolean)this.cutSpy.isCustomerCreditMemoQtyLessThanEqualToInvoiceOpenQty(detail));
    }

    @Test
    void isCustomerCreditMemoQtyLessThanEqualToInvoiceOpenQty_CreditMemoGreaterThanInvoice_False() {
        CustomerCreditMemoDetail detail = new CustomerCreditMemoDetail();
        detail.setInvoiceOpenItemQuantity(new BigDecimal(1));
        detail.setCreditMemoItemQuantity(new BigDecimal(2));
        Assertions.assertFalse((boolean)this.cutSpy.isCustomerCreditMemoQtyLessThanEqualToInvoiceOpenQty(detail));
    }

    @Test
    void checkIfCustomerCreditMemoQtyAndCustomerCreditMemoItemAmountValid_ExactMatch_True() {
        CustomerCreditMemoDetail detail = new CustomerCreditMemoDetail();
        detail.setCreditMemoItemTotalAmount(new KualiDecimal(4));
        detail.setCreditMemoItemQuantity(new BigDecimal(2));
        Assertions.assertTrue((boolean)this.cutSpy.checkIfCustomerCreditMemoQtyAndCustomerCreditMemoItemAmountValid(detail, new BigDecimal(2)));
    }

    @Test
    void checkIfCustomerCreditMemoQtyAndCustomerCreditMemoItemAmountValid_FarOff_False() {
        CustomerCreditMemoDetail detail = new CustomerCreditMemoDetail();
        detail.setCreditMemoItemTotalAmount(new KualiDecimal(50));
        detail.setCreditMemoItemQuantity(new BigDecimal(10));
        Assertions.assertFalse((boolean)this.cutSpy.checkIfCustomerCreditMemoQtyAndCustomerCreditMemoItemAmountValid(detail, new BigDecimal(10)));
    }

    @Test
    void checkIfCustomerCreditMemoQtyAndCustomerCreditMemoItemAmountValid_JustAboveAllowedDeviation_False() {
        CustomerCreditMemoDetail detail = new CustomerCreditMemoDetail();
        detail.setCreditMemoItemTotalAmount(new KualiDecimal(50));
        detail.setCreditMemoItemQuantity(new BigDecimal(5.6));
        Assertions.assertFalse((boolean)this.cutSpy.checkIfCustomerCreditMemoQtyAndCustomerCreditMemoItemAmountValid(detail, new BigDecimal(10)));
    }

    @Test
    void checkIfCustomerCreditMemoQtyAndCustomerCreditMemoItemAmountValid_ExactlyAllowedDeviation_True() {
        CustomerCreditMemoDetail detail = new CustomerCreditMemoDetail();
        detail.setCreditMemoItemTotalAmount(new KualiDecimal(50));
        detail.setCreditMemoItemQuantity(new BigDecimal(5.5));
        Assertions.assertTrue((boolean)this.cutSpy.checkIfCustomerCreditMemoQtyAndCustomerCreditMemoItemAmountValid(detail, new BigDecimal(10)));
    }

    @Test
    void checkIfCustomerCreditMemoQtyAndCustomerCreditMemoItemAmountValid_JustBelowAllowedDeviation_True() {
        CustomerCreditMemoDetail detail = new CustomerCreditMemoDetail();
        detail.setCreditMemoItemTotalAmount(new KualiDecimal(50));
        detail.setCreditMemoItemQuantity(new BigDecimal(5.4));
        Assertions.assertTrue((boolean)this.cutSpy.checkIfCustomerCreditMemoQtyAndCustomerCreditMemoItemAmountValid(detail, new BigDecimal(10)));
    }

    @Test
    void checkIfCustomerCreditMemoQtyAndCustomerCreditMemoItemAmountZero_QuantityZero_False() {
        CustomerCreditMemoDetail detail = new CustomerCreditMemoDetail();
        detail.setCreditMemoItemTotalAmount(new KualiDecimal(0));
        detail.setCreditMemoItemQuantity(new BigDecimal(0));
        Assertions.assertFalse((boolean)this.cutSpy.checkIfCustomerCreditMemoQtyAndCustomerCreditMemoItemAmountValid(detail, new BigDecimal(10)));
    }

    @Test
    void checkIfInvoiceNumberIsFinal_blankInvoiceNumber_False() {
        Assertions.assertFalse((boolean)this.cutSpy.checkIfInvoiceNumberIsFinal(""));
    }

    @Test
    void checkIfInvoiceNumberIsFinal_invalidInvoiceNumber_False() {
        Mockito.when((Object)this.customerInvoiceDocumentSvcMock.getInvoiceByInvoiceDocumentNumber(INVOICE_DOCUMENT_NUMBER)).thenReturn(null);
        Assertions.assertFalse((boolean)this.cutSpy.checkIfInvoiceNumberIsFinal(INVOICE_DOCUMENT_NUMBER));
    }

    @Test
    void checkIfInvoiceNumberIsFinal_validInvoiceNumberFinal_True() {
        Mockito.when((Object)this.customerInvoiceDocumentSvcMock.getInvoiceByInvoiceDocumentNumber(INVOICE_DOCUMENT_NUMBER)).thenReturn((Object)this.customerInvoiceDocumentMock);
        Mockito.when((Object)this.customerInvoiceDocumentSvcMock.checkIfInvoiceNumberIsFinal(INVOICE_DOCUMENT_NUMBER)).thenReturn((Object)true);
        Assertions.assertTrue((boolean)this.cutSpy.checkIfInvoiceNumberIsFinal(INVOICE_DOCUMENT_NUMBER));
    }

    @Test
    void checkIfInvoiceNumberIsFinal_validInvoiceNumberNotFinal_False() {
        Mockito.when((Object)this.customerInvoiceDocumentSvcMock.getInvoiceByInvoiceDocumentNumber(INVOICE_DOCUMENT_NUMBER)).thenReturn((Object)this.customerInvoiceDocumentMock);
        Mockito.when((Object)this.customerInvoiceDocumentSvcMock.checkIfInvoiceNumberIsFinal(INVOICE_DOCUMENT_NUMBER)).thenReturn((Object)false);
        Assertions.assertFalse((boolean)this.cutSpy.checkIfInvoiceNumberIsFinal(INVOICE_DOCUMENT_NUMBER));
    }

    @Test
    void checkIfThereIsNoAnotherCRMInRouteForTheInvoice_NoOtherCRMsForInvoiceFound_True() {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("financialDocumentReferenceInvoiceNumber", INVOICE_DOCUMENT_NUMBER);
        Mockito.when((Object)this.businessObjectSvcMock.findMatching(CustomerCreditMemoDocument.class, fieldValues)).thenReturn(Collections.emptyList());
        Assertions.assertTrue((boolean)this.cutSpy.checkIfThereIsNoAnotherCRMInRouteForTheInvoice(INVOICE_DOCUMENT_NUMBER));
    }

    @Test
    void checkIfThereIsNoAnotherCRMInRouteForTheInvoice_OtherEnrouteCRMsForInvoiceFound_False() {
        ArrayList<CustomerCreditMemoDocument> mockCustomerCreditMemoDocuments = new ArrayList<CustomerCreditMemoDocument>();
        mockCustomerCreditMemoDocuments.add(this.createMockCustomerCreditMemoDocument("1000"));
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("financialDocumentReferenceInvoiceNumber", INVOICE_DOCUMENT_NUMBER);
        Mockito.when((Object)this.businessObjectSvcMock.findMatching(CustomerCreditMemoDocument.class, fieldValues)).thenReturn(mockCustomerCreditMemoDocuments);
        WorkflowDocument workflowDocumentMock = (WorkflowDocument)Mockito.mock(WorkflowDocument.class);
        Mockito.when((Object)workflowDocumentMock.isEnroute()).thenReturn((Object)true);
        ((CustomerCreditMemoDocumentRule)Mockito.doReturn((Object)workflowDocumentMock).when((Object)this.cutSpy)).loadWorkflowDocument(PRINCIPAL_ID, "1000");
        Assertions.assertFalse((boolean)this.cutSpy.checkIfThereIsNoAnotherCRMInRouteForTheInvoice(INVOICE_DOCUMENT_NUMBER));
    }

    @Test
    void checkIfThereIsNoAnotherCRMInRouteForTheInvoice_OtherNonEnrouteCRMsForInvoiceFound_True() {
        ArrayList<CustomerCreditMemoDocument> mockCustomerCreditMemoDocuments = new ArrayList<CustomerCreditMemoDocument>();
        mockCustomerCreditMemoDocuments.add(this.createMockCustomerCreditMemoDocument("1001"));
        mockCustomerCreditMemoDocuments.add(this.createMockCustomerCreditMemoDocument("1002"));
        mockCustomerCreditMemoDocuments.add(this.createMockCustomerCreditMemoDocument("1003"));
        mockCustomerCreditMemoDocuments.add(this.createMockCustomerCreditMemoDocument("1004"));
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("financialDocumentReferenceInvoiceNumber", INVOICE_DOCUMENT_NUMBER);
        Mockito.when((Object)this.businessObjectSvcMock.findMatching(CustomerCreditMemoDocument.class, fieldValues)).thenReturn(mockCustomerCreditMemoDocuments);
        WorkflowDocument approvedWorkflowDocumentMock = (WorkflowDocument)Mockito.mock(WorkflowDocument.class);
        Mockito.when((Object)approvedWorkflowDocumentMock.isApproved()).thenReturn((Object)true);
        WorkflowDocument processedWorkflowDocumentMock = (WorkflowDocument)Mockito.mock(WorkflowDocument.class);
        Mockito.when((Object)processedWorkflowDocumentMock.isProcessed()).thenReturn((Object)true);
        WorkflowDocument cancelledWorkflowDocumentMock = (WorkflowDocument)Mockito.mock(WorkflowDocument.class);
        Mockito.when((Object)cancelledWorkflowDocumentMock.isCanceled()).thenReturn((Object)true);
        WorkflowDocument disapprovedWorkflowDocumentMock = (WorkflowDocument)Mockito.mock(WorkflowDocument.class);
        Mockito.when((Object)disapprovedWorkflowDocumentMock.isDisapproved()).thenReturn((Object)true);
        ((CustomerCreditMemoDocumentRule)Mockito.doReturn((Object)approvedWorkflowDocumentMock).when((Object)this.cutSpy)).loadWorkflowDocument(PRINCIPAL_ID, "1001");
        ((CustomerCreditMemoDocumentRule)Mockito.doReturn((Object)processedWorkflowDocumentMock).when((Object)this.cutSpy)).loadWorkflowDocument(PRINCIPAL_ID, "1002");
        ((CustomerCreditMemoDocumentRule)Mockito.doReturn((Object)cancelledWorkflowDocumentMock).when((Object)this.cutSpy)).loadWorkflowDocument(PRINCIPAL_ID, "1003");
        ((CustomerCreditMemoDocumentRule)Mockito.doReturn((Object)disapprovedWorkflowDocumentMock).when((Object)this.cutSpy)).loadWorkflowDocument(PRINCIPAL_ID, "1004");
        Assertions.assertTrue((boolean)this.cutSpy.checkIfThereIsNoAnotherCRMInRouteForTheInvoice(INVOICE_DOCUMENT_NUMBER));
    }

    private CustomerCreditMemoDocument createMockCustomerCreditMemoDocument(String documentNumber) {
        CustomerCreditMemoDocument mockCustomerCreditMemoDocument1 = (CustomerCreditMemoDocument)Mockito.mock(CustomerCreditMemoDocument.class);
        Mockito.when((Object)mockCustomerCreditMemoDocument1.getDocumentNumber()).thenReturn((Object)documentNumber);
        return mockCustomerCreditMemoDocument1;
    }
}

