/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.module.ar.businessobject.AccountsReceivableDocumentHeader;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.CustomerAddressService;
import org.kuali.kfs.module.ar.document.validation.impl.CustomerInvoiceCustomerAddressValidation;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@Execution(value=ExecutionMode.SAME_THREAD)
public class CustomerInvoiceCustomerAddressValidationTest {
    private static final String VALID_CUSTOMER_NUMBER = "ABB2";
    private static final Integer VALID_ACTIVE_ADDRESS_IDENTIFIER = 1;
    private static final Integer VALID_INACTIVE_ADDRESS_IDENTIFIER = 10;
    private static final Integer INVALID_ADDRESS_IDENTIFIER = 99;
    private CustomerInvoiceCustomerAddressValidation cut;
    @Mock
    private CustomerAddressService customerAddressSvcMock;
    @Mock
    private CustomerInvoiceDocument customerInvoiceDocumentMock;
    @Mock
    private AccountsReceivableDocumentHeader accountsReceivableDocumentHeaderMock;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.accountsReceivableDocumentHeaderMock.getCustomerNumber()).thenReturn((Object)VALID_CUSTOMER_NUMBER);
        Mockito.when((Object)this.customerInvoiceDocumentMock.getAccountsReceivableDocumentHeader()).thenReturn((Object)this.accountsReceivableDocumentHeaderMock);
        Mockito.when((Object)this.customerAddressSvcMock.customerAddressExists(VALID_CUSTOMER_NUMBER, VALID_ACTIVE_ADDRESS_IDENTIFIER)).thenReturn((Object)true);
        Mockito.when((Object)this.customerAddressSvcMock.customerAddressExists(VALID_CUSTOMER_NUMBER, VALID_INACTIVE_ADDRESS_IDENTIFIER)).thenReturn((Object)true);
        Mockito.when((Object)this.customerAddressSvcMock.customerAddressExists(VALID_CUSTOMER_NUMBER, INVALID_ADDRESS_IDENTIFIER)).thenReturn((Object)false);
        Mockito.when((Object)this.customerAddressSvcMock.customerAddressActive(VALID_CUSTOMER_NUMBER, VALID_ACTIVE_ADDRESS_IDENTIFIER)).thenReturn((Object)true);
        Mockito.when((Object)this.customerAddressSvcMock.customerAddressActive(VALID_CUSTOMER_NUMBER, VALID_INACTIVE_ADDRESS_IDENTIFIER)).thenReturn((Object)false);
        this.cut = new CustomerInvoiceCustomerAddressValidation();
        this.cut.setCustomerInvoiceDocument(this.customerInvoiceDocumentMock);
        this.cut.setCustomerAddressService(this.customerAddressSvcMock);
    }

    @Test
    public void validate_ValidActiveBillToAddress_ValidActiveShipToAddress() {
        Mockito.when((Object)this.customerInvoiceDocumentMock.getCustomerBillToAddressIdentifier()).thenReturn((Object)VALID_ACTIVE_ADDRESS_IDENTIFIER);
        Mockito.when((Object)this.customerInvoiceDocumentMock.getCustomerShipToAddressIdentifier()).thenReturn((Object)VALID_ACTIVE_ADDRESS_IDENTIFIER);
        Assert.assertTrue((boolean)this.cut.validate(null));
    }

    @Test
    public void validate_ValidInactiveBillToAddress_ValidActiveShipToAddress() {
        Mockito.when((Object)this.customerInvoiceDocumentMock.getCustomerBillToAddressIdentifier()).thenReturn((Object)VALID_INACTIVE_ADDRESS_IDENTIFIER);
        Mockito.when((Object)this.customerInvoiceDocumentMock.getCustomerShipToAddressIdentifier()).thenReturn((Object)VALID_ACTIVE_ADDRESS_IDENTIFIER);
        Assert.assertFalse((boolean)this.cut.validate(null));
    }

    @Test
    public void validate_InvalidBillToAddress_ValidActiveShipToAddress() {
        Mockito.when((Object)this.customerInvoiceDocumentMock.getCustomerBillToAddressIdentifier()).thenReturn((Object)INVALID_ADDRESS_IDENTIFIER);
        Mockito.when((Object)this.customerInvoiceDocumentMock.getCustomerShipToAddressIdentifier()).thenReturn((Object)VALID_ACTIVE_ADDRESS_IDENTIFIER);
        Assert.assertFalse((boolean)this.cut.validate(null));
    }

    @Test
    public void validate_ValidActiveBillToAddress_ValidInactiveShipToAddress() {
        Mockito.when((Object)this.customerInvoiceDocumentMock.getCustomerBillToAddressIdentifier()).thenReturn((Object)VALID_ACTIVE_ADDRESS_IDENTIFIER);
        Mockito.when((Object)this.customerInvoiceDocumentMock.getCustomerShipToAddressIdentifier()).thenReturn((Object)VALID_INACTIVE_ADDRESS_IDENTIFIER);
        Assert.assertFalse((boolean)this.cut.validate(null));
    }

    @Test
    public void validate_ValidActiveBillToAddress_InvalidShipToAddress() {
        Mockito.when((Object)this.customerInvoiceDocumentMock.getCustomerBillToAddressIdentifier()).thenReturn((Object)VALID_ACTIVE_ADDRESS_IDENTIFIER);
        Mockito.when((Object)this.customerInvoiceDocumentMock.getCustomerShipToAddressIdentifier()).thenReturn((Object)INVALID_ADDRESS_IDENTIFIER);
        Assert.assertFalse((boolean)this.cut.validate(null));
    }

    @Test
    public void validate_ValidInactiveBillToAddress_ValidInactiveShipToAddress() {
        Mockito.when((Object)this.customerInvoiceDocumentMock.getCustomerBillToAddressIdentifier()).thenReturn((Object)VALID_INACTIVE_ADDRESS_IDENTIFIER);
        Mockito.when((Object)this.customerInvoiceDocumentMock.getCustomerShipToAddressIdentifier()).thenReturn((Object)VALID_INACTIVE_ADDRESS_IDENTIFIER);
        Assert.assertFalse((boolean)this.cut.validate(null));
    }

    @Test
    public void validate_ValidInactiveBillToAddress_InvalidShipToAddress() {
        Mockito.when((Object)this.customerInvoiceDocumentMock.getCustomerBillToAddressIdentifier()).thenReturn((Object)VALID_INACTIVE_ADDRESS_IDENTIFIER);
        Mockito.when((Object)this.customerInvoiceDocumentMock.getCustomerShipToAddressIdentifier()).thenReturn((Object)INVALID_ADDRESS_IDENTIFIER);
        Assert.assertFalse((boolean)this.cut.validate(null));
    }

    @Test
    public void validate_InvalidBillToAddress_InvalidShipToAddress() {
        Mockito.when((Object)this.customerInvoiceDocumentMock.getCustomerBillToAddressIdentifier()).thenReturn((Object)INVALID_ADDRESS_IDENTIFIER);
        Mockito.when((Object)this.customerInvoiceDocumentMock.getCustomerShipToAddressIdentifier()).thenReturn((Object)INVALID_ADDRESS_IDENTIFIER);
        Assert.assertFalse((boolean)this.cut.validate(null));
    }
}

