/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.businessobject.AccountsReceivableDocumentHeader;
import org.kuali.kfs.module.ar.businessobject.Customer;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.validation.impl.CustomerInvoiceCustomerNumberValidation;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@Execution(value=ExecutionMode.SAME_THREAD)
public class CustomerInvoiceCustomerNumberValidationTest {
    private CustomerInvoiceCustomerNumberValidation cut;
    @Mock
    private CustomerInvoiceDocument customerInvoiceDocMock;
    @Mock
    private AccountsReceivableDocumentHeader arDocHeaderMock;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.customerInvoiceDocMock.getAccountsReceivableDocumentHeader()).thenReturn((Object)this.arDocHeaderMock);
        this.cut = new CustomerInvoiceCustomerNumberValidation();
        this.cut.setCustomerInvoiceDocument(this.customerInvoiceDocMock);
    }

    @After
    public void tearDown() {
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    @Test
    public void validate_ValidCustomerNumber_True() {
        Customer customer = new Customer();
        customer.setActive(true);
        Mockito.when((Object)this.arDocHeaderMock.getCustomer()).thenReturn((Object)customer);
        Assert.assertTrue((boolean)this.cut.validate(null));
    }

    @Test
    public void validate_InvalidCustomerNumber_False() {
        Mockito.when((Object)this.arDocHeaderMock.getCustomer()).thenReturn(null);
        Assert.assertFalse((boolean)this.cut.validate(null));
        Assert.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("error.document.customerInvoiceDocument.invalidCustomerNumber"));
    }
}

