/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.runner.RunWith;
import org.kuali.kfs.coa.service.AccountService;
import org.kuali.kfs.krad.service.DocumentHeaderService;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.AccountsReceivableTaxService;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDetailService;
import org.kuali.kfs.module.ar.document.service.impl.CustomerInvoiceDetailServiceImpl;
import org.kuali.kfs.module.ar.document.validation.impl.CustomerInvoiceDetailDiscountGreaterThanParentValidation;
import org.kuali.kfs.module.ar.fixture.CustomerInvoiceDetailFixture;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.kuali.kfs.sys.context.SpringContext;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={KRADServiceLocatorWeb.class, SpringContext.class})
@Execution(value=ExecutionMode.SAME_THREAD)
public class CustomerInvoiceDetailDiscountGreaterThanParentValidationTest {
    private CustomerInvoiceDetailDiscountGreaterThanParentValidation cut;
    @Mock
    private AccountService accountSvcMock;
    @Mock
    private AccountsReceivableTaxService accountsReceivableTaxSvcMock;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        PowerMockito.mockStatic(KRADServiceLocatorWeb.class, (Class[])new Class[0]);
        DocumentHeaderService docHeaderSvcMock = (DocumentHeaderService)Mockito.mock(DocumentHeaderService.class);
        Mockito.when((Object)KRADServiceLocatorWeb.getDocumentHeaderService()).thenReturn((Object)docHeaderSvcMock);
        Class<FinancialSystemDocumentHeader> clazz = FinancialSystemDocumentHeader.class;
        Mockito.when((Object)docHeaderSvcMock.getDocumentHeaderBaseClass()).thenReturn(clazz);
        PowerMockito.mockStatic(SpringContext.class, (Class[])new Class[0]);
        Mockito.when((Object)((AccountService)SpringContext.getBean(AccountService.class))).thenReturn((Object)this.accountSvcMock);
        CustomerInvoiceDocument customerInvoiceDocument = new CustomerInvoiceDocument();
        CustomerInvoiceDetailServiceImpl customerInvoiceDetailService = new CustomerInvoiceDetailServiceImpl();
        customerInvoiceDetailService.setAccountsReceivableTaxService(this.accountsReceivableTaxSvcMock);
        this.cut = new CustomerInvoiceDetailDiscountGreaterThanParentValidation();
        this.cut.setCustomerInvoiceDetailService((CustomerInvoiceDetailService)customerInvoiceDetailService);
        this.cut.setCustomerInvoiceDocument(customerInvoiceDocument);
    }

    @Test
    public void testDiscountAmountNotGreaterThanParentAmount() {
        this.cut.setDiscountCustomerInvoiceDetail(CustomerInvoiceDetailFixture.CUSTOMER_INVOICE_DETAIL_DISCOUNT_WITH_POSITIVE_AMOUNT.createCustomerInvoiceDetail());
        this.cut.getDiscountCustomerInvoiceDetail().setParentDiscountCustomerInvoiceDetail(CustomerInvoiceDetailFixture.BASE_CUSTOMER_INVOICE_DETAIL.createCustomerInvoiceDetail());
        Assert.assertTrue((boolean)this.cut.validate(null));
    }

    @Test
    public void testDiscountAmountGreaterThanParentAmount() {
        this.cut.setDiscountCustomerInvoiceDetail(CustomerInvoiceDetailFixture.BASE_CUSTOMER_INVOICE_DETAIL.createCustomerInvoiceDetail());
        this.cut.getDiscountCustomerInvoiceDetail().setParentDiscountCustomerInvoiceDetail(CustomerInvoiceDetailFixture.CUSTOMER_INVOICE_DETAIL_DISCOUNT_WITH_POSITIVE_AMOUNT.createCustomerInvoiceDetail());
        Assert.assertFalse((boolean)this.cut.validate(null));
    }
}

